/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json.grep;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Iterator;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import lombok.Generated;
import org.meeuw.json.JsonIterator;
import org.meeuw.json.ParseEvent;
import org.meeuw.json.Util;
import org.meeuw.json.grep.matching.NeverPathMatcher;
import org.meeuw.json.grep.matching.PathMatcher;

public class Sed
implements Iterator<ParseEvent> {
    @Generated
    private static final Logger log = Logger.getLogger(Sed.class.getName());
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();
    private final PathMatcher matcher;
    final JsonIterator wrapped;

    public Sed(PathMatcher matcher, JsonParser jp) {
        this.matcher = matcher == null ? new NeverPathMatcher() : matcher;
        this.wrapped = new JsonIterator(jp, this.matcher.needsKeyCollection(), this.matcher.needsObjectCollection());
    }

    public String toString() {
        return new StringJoiner(", ", Sed.class.getSimpleName() + "[", "]").add("matcher=" + String.valueOf(this.matcher)).toString();
    }

    @Override
    public boolean hasNext() {
        return this.wrapped.hasNext();
    }

    public int toGenerator(JsonGenerator generator) throws IOException {
        int i = 0;
        while (this.hasNext()) {
            ParseEvent next = this.next();
            next.toGenerator(generator);
            ++i;
        }
        return i;
    }

    @Override
    public ParseEvent next() {
        ParseEvent event = this.wrapped.next();
        PathMatcher.MatchResult matches = this.matcher.matches(event);
        if (matches.getAsBoolean()) {
            return matches.getEvent();
        }
        return event;
    }

    public static OutputStream transform(OutputStream to, PathMatcher pathMatcher) throws IOException {
        PipedInputStream in = new PipedInputStream();
        final Future[] future = new Future[1];
        PipedOutputStream out = new PipedOutputStream(in){

            @Override
            public void close() throws IOException {
                super.close();
                try {
                    future[0].get();
                }
                catch (ExecutionException e) {
                    throw new IOException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException(e);
                }
            }
        };
        Callable<Void> callable = () -> {
            try (JsonGenerator generator = Util.getJsonFactory().createGenerator(to);
                 JsonParser parser = Util.getJsonParser((InputStream)in);){
                Sed sed = new Sed(pathMatcher, parser);
                int events = sed.toGenerator(generator);
                log.fine(() -> "Generated " + events + " events");
            }
            return null;
        };
        future[0] = EXECUTOR_SERVICE.submit(callable);
        return out;
    }
}

