/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json.grep.matching;

import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.meeuw.json.ParseEvent;
import org.meeuw.json.grep.matching.PathMatcher;
import org.meeuw.json.grep.matching.ScalarMatcher;

public class ScalarRegexpMatcher
extends ScalarMatcher {
    private final Pattern pattern;
    private final UnaryOperator<String> replacement;

    public ScalarRegexpMatcher(Pattern pattern, UnaryOperator<String> replacement) {
        this.pattern = pattern;
        this.replacement = replacement;
    }

    public ScalarRegexpMatcher(Pattern pattern, String replacement) {
        this(pattern, t -> replacement);
    }

    @Override
    protected PathMatcher.MatchResult matchesScalar(ParseEvent event) {
        Matcher matcher = this.pattern.matcher(event.getValue());
        if (matcher.matches()) {
            if (this.replacement != null) {
                String replaced = (String)this.replacement.apply(event.getValue());
                String v = matcher.replaceAll(replaced);
                return new PathMatcher.MatchResult(event.withValue(v), true);
            }
            return new PathMatcher.MatchResult(event, true);
        }
        return PathMatcher.MatchResult.NO;
    }

    public String toString() {
        return "value~" + String.valueOf(this.pattern);
    }
}

