/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json.grep.matching;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.meeuw.json.ArrayEntry;
import org.meeuw.json.PathEntry;
import org.meeuw.json.grep.matching.ArrayEntryMatch;
import org.meeuw.json.grep.matching.KeysMatcher;
import org.meeuw.json.grep.matching.KeysPattern;

public class SinglePathMatcher
extends KeysMatcher {
    private final KeysPattern[] pathPattern;
    private final boolean ignoreArrays;

    public SinglePathMatcher(KeysPattern ... pathPattern) {
        this(false, pathPattern);
    }

    public SinglePathMatcher(boolean ignoreArrays, KeysPattern ... pathPattern) {
        this.ignoreArrays = ignoreArrays;
        this.pathPattern = pathPattern;
    }

    @Override
    public boolean matches(List<PathEntry> path) {
        if (this.ignoreArrays) {
            List<PathEntry> withoutArrays = path.stream().filter(e -> !(e instanceof ArrayEntry)).collect(Collectors.toList());
            return this.matches(Arrays.asList(this.pathPattern), withoutArrays);
        }
        return this.matches(Arrays.asList(this.pathPattern), path);
    }

    private boolean matches(List<KeysPattern> patterns, List<PathEntry> entries) {
        if (patterns.size() > 0) {
            KeysPattern first = patterns.get(0);
            int matchCounts = first.matchCounts(entries);
            if (matchCounts >= 0) {
                for (int i = 0; i < matchCounts; ++i) {
                    if (i == entries.size() - 1) {
                        return patterns.size() == 1;
                    }
                    if (!this.matches(patterns.subList(1, patterns.size()), entries.subList(i + 1, entries.size()))) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return entries.size() == 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (KeysPattern p : this.pathPattern) {
            if (builder.length() > 0 && !(p instanceof ArrayEntryMatch)) {
                builder.append(".");
            }
            builder.append(p);
        }
        return builder.toString();
    }

    public KeysPattern[] getPatterns() {
        return this.pathPattern;
    }
}

