/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json.grep.matching;

import java.util.Arrays;
import org.meeuw.json.ParseEvent;
import org.meeuw.json.Path;
import org.meeuw.json.grep.matching.PathMatcher;
import org.meeuw.json.grep.matching.PathMatchers;
import org.meeuw.util.Predicate;
import org.meeuw.util.Predicates;

public class PathMatcherAndChain
implements PathMatcher {
    private final PathMatcher[] matchers;

    public PathMatcherAndChain(PathMatcher ... matchers) {
        this.matchers = matchers;
    }

    @Override
    public boolean matches(ParseEvent event, String value) {
        for (PathMatcher matcher : this.matchers) {
            if (matcher.matches(event, value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Predicate<Path> needsKeyCollection() {
        return Predicates.and(PathMatchers.needsKeyCollection(this.matchers));
    }

    @Override
    public Predicate<Path> needsObjectCollection() {
        return Predicates.and(PathMatchers.needsObjectCollection(this.matchers));
    }

    public PathMatcher[] getPatterns() {
        return this.matchers;
    }

    public String toString() {
        return String.valueOf(Arrays.asList(this.matchers));
    }
}

