/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json.grep.parsing;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.meeuw.json.grep.matching.AnyDepthMatcher;
import org.meeuw.json.grep.matching.ArrayEntryMatch;
import org.meeuw.json.grep.matching.ArrayIndexMatch;
import org.meeuw.json.grep.matching.JavascriptMatcher;
import org.meeuw.json.grep.matching.KeyPattern;
import org.meeuw.json.grep.matching.KeysPattern;
import org.meeuw.json.grep.matching.NeedsObjectObjectMatcher;
import org.meeuw.json.grep.matching.ObjectHasKeyMatcher;
import org.meeuw.json.grep.matching.ObjectMatcherNot;
import org.meeuw.json.grep.matching.PathMatcher;
import org.meeuw.json.grep.matching.PathMatcherAndChain;
import org.meeuw.json.grep.matching.PathMatcherOrChain;
import org.meeuw.json.grep.matching.PreciseMatch;
import org.meeuw.json.grep.matching.SinglePathMatcher;
import org.meeuw.json.grep.matching.ValueEqualsMatcher;
import org.meeuw.json.grep.matching.ValueRegexpMatcher;
import org.meeuw.json.grep.matching.Wildcard;

public class Parser {
    private Parser() {
    }

    public static PathMatcher parsePathMatcherChain(String arg) {
        return Parser.parsePathMatcherChain(arg, false, false);
    }

    public static PathMatcher parsePathMatcherChain(String arg, boolean ignoreArrays, boolean needsObject) {
        String[] split = arg.split(",");
        if (split.length == 1) {
            return Parser.parsePathMatcher(arg, ignoreArrays, needsObject);
        }
        ArrayList<PathMatcher> list = new ArrayList<PathMatcher>(split.length);
        for (String s : split) {
            list.add(Parser.parsePathMatcher(s, ignoreArrays, needsObject));
        }
        return new PathMatcherOrChain(list.toArray(new PathMatcher[list.size()]));
    }

    protected static PathMatcher parsePathMatcher(String arg, boolean ignoreArrays, boolean needsObject) {
        String[] split = arg.split("~", 2);
        if (split.length == 2) {
            return new PathMatcherAndChain(Parser.parseKeysMatcher(split[0], ignoreArrays), new ValueRegexpMatcher(Pattern.compile(split[1])));
        }
        split = arg.split("\\s+!\\s*contains\\s+", 2);
        if (split.length == 2) {
            return new PathMatcherAndChain(Parser.parseKeysMatcher(split[0], ignoreArrays), NeedsObjectObjectMatcher.get(new ObjectMatcherNot(new ObjectHasKeyMatcher(split[1])), needsObject));
        }
        split = arg.split("\\s+contains\\s+", 2);
        if (split.length == 2) {
            return new PathMatcherAndChain(Parser.parseKeysMatcher(split[0], ignoreArrays), NeedsObjectObjectMatcher.get(new ObjectHasKeyMatcher(split[1]), needsObject));
        }
        split = arg.split("\\s+function\\(", 2);
        if (split.length == 2) {
            return new PathMatcherAndChain(Parser.parseKeysMatcher(split[0], ignoreArrays), new JavascriptMatcher("function(" + split[1]));
        }
        split = arg.split("=", 2);
        if (split.length == 2) {
            return new PathMatcherAndChain(Parser.parseKeysMatcher(split[0], ignoreArrays), new ValueEqualsMatcher(split[1]));
        }
        return Parser.parseKeysMatcher(split[0], ignoreArrays);
    }

    public static SinglePathMatcher parseKeysMatcher(String arg, boolean ignoreArrays) {
        String[] split = arg.split("[\\.\\[]");
        ArrayList<KeysPattern> list = new ArrayList<KeysPattern>(split.length);
        boolean foundEmpty = false;
        for (String s : split) {
            if (s.isEmpty()) {
                if (foundEmpty) {
                    list.add(new AnyDepthMatcher());
                    foundEmpty = false;
                    continue;
                }
                foundEmpty = true;
                continue;
            }
            foundEmpty = false;
            list.add(Parser.parseKeyPattern(s));
        }
        return new SinglePathMatcher(ignoreArrays, list.toArray(new KeysPattern[list.size()]));
    }

    protected static KeyPattern parseKeyPattern(String arg) {
        if ("*".equals(arg)) {
            return new Wildcard();
        }
        if ("*]".equals(arg)) {
            return new ArrayEntryMatch();
        }
        if (arg.endsWith("]")) {
            return new ArrayIndexMatch(Integer.parseInt(arg.substring(0, arg.length() - 1)));
        }
        return new PreciseMatch(arg);
    }
}

