/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json.grep;

import com.fasterxml.jackson.core.JsonParser;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.meeuw.json.grep.Grep;
import org.meeuw.json.grep.GrepEvent;
import org.meeuw.json.grep.GrepMain;
import org.meeuw.json.grep.GrepMainRecord;

class GrepMainIterator
implements Iterator<GrepMainRecord> {
    private final GrepMain grepMain;
    private final Grep grep;
    private final GrepMainRecord next;
    private Boolean hasNext = null;
    private final StringBuilder builder = new StringBuilder();

    GrepMainIterator(GrepMain grepMain, JsonParser in) {
        this.grepMain = grepMain;
        this.grep = new Grep(grepMain.getMatcher(), in);
        this.grep.setRecordMatcher(grepMain.getRecordMatcher());
        this.next = new GrepMainRecord(grepMain.getSep());
    }

    @Override
    public boolean hasNext() {
        this.findNext();
        return this.hasNext;
    }

    @Override
    public GrepMainRecord next() {
        this.findNext();
        if (!this.hasNext.booleanValue()) {
            throw new NoSuchElementException();
        }
        this.hasNext = null;
        return this.next;
    }

    private void findNext() {
        if (this.hasNext == null) {
            this.next.fields.clear();
            block4: while (this.grep.hasNext()) {
                GrepEvent match = this.grep.next();
                switch (match.getType()) {
                    case VALUE: {
                        this.builder.setLength(0);
                        this.grepMain.outputFormat.toBuilder(this.builder, match);
                        break;
                    }
                    case RECORD: {
                        if (this.next.fields.size() <= 0) continue block4;
                        this.sort(this.next.fields);
                        this.hasNext = true;
                        return;
                    }
                }
                this.next.fields.add(new GrepMainRecord.Field(match.getWeight(), this.builder.toString()));
            }
            if (this.next.fields.size() > 0) {
                this.sort(this.next.fields);
                this.hasNext = true;
            } else {
                this.hasNext = false;
            }
        }
    }

    private List<GrepMainRecord.Field> sort(List<GrepMainRecord.Field> fields) {
        if (this.grepMain.recordMatcher != null && this.grepMain.sortFields) {
            Collections.sort(fields);
        }
        return fields;
    }
}

