/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json.grep;

import java.io.StringWriter;
import org.meeuw.json.ParseEvent;
import org.meeuw.json.Path;
import org.meeuw.json.Util;

public class GrepEvent {
    private final ParseEvent event;
    private final Type type;
    private final int weight;

    public GrepEvent(ParseEvent result, int weight) {
        this.event = result;
        this.type = Type.VALUE;
        this.weight = weight;
    }

    public GrepEvent(ParseEvent event, Type type, int weight) {
        this.event = event;
        this.type = type;
        this.weight = weight;
    }

    public Path getPath() {
        return this.event.getPath();
    }

    public String getValue() {
        switch (this.event.getToken()) {
            case END_OBJECT: {
                return "{...}";
            }
            case END_ARRAY: {
                return "[...]";
            }
        }
        return this.event.getValue();
    }

    public String getNode() {
        switch (this.event.getToken()) {
            case END_OBJECT: 
            case END_ARRAY: {
                StringWriter writer = new StringWriter();
                Util.write(this.event.getNode(), writer);
                return writer.toString();
            }
        }
        return this.event.getValue();
    }

    public Type getType() {
        return this.type;
    }

    public int getWeight() {
        return this.weight;
    }

    public String toString() {
        return this.getPath() + "=" + this.getValue();
    }

    public static enum Type {
        VALUE,
        RECORD;

    }
}

