/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json.grep.matching;

import java.util.function.Predicate;
import org.meeuw.json.ParseEvent;
import org.meeuw.json.Path;
import org.meeuw.json.grep.matching.PathMatcher;
import org.meeuw.json.grep.matching.PathMatchers;
import org.meeuw.util.Predicates;

public class PathMatcherOrChain
implements PathMatcher {
    private final PathMatcher[] matchers;

    public PathMatcherOrChain(PathMatcher ... matchers) {
        this.matchers = matchers;
    }

    @Override
    public int matchWeight(ParseEvent event, String value) {
        int count = 0;
        for (PathMatcher matcher : this.matchers) {
            ++count;
            if (!matcher.matches(event, value)) continue;
            return count;
        }
        return 0;
    }

    @Override
    public Predicate<Path> needsKeyCollection() {
        return Predicates.or(PathMatchers.needsKeyCollection(this.matchers));
    }

    @Override
    public Predicate<Path> needsObjectCollection() {
        return Predicates.or(PathMatchers.needsObjectCollection(this.matchers));
    }

    public PathMatcher[] getMatchers() {
        return this.matchers;
    }
}

