/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.meeuw.json.ArrayEntry;
import org.meeuw.json.KeyEntry;
import org.meeuw.json.ParseEvent;
import org.meeuw.json.Path;
import org.meeuw.json.PathEntry;

public class JsonIterator
implements Iterator<ParseEvent> {
    private final Path path = new Path();
    private ParseEvent next;
    private final JsonParser jp;
    private final Deque<List<String>> keys = new ArrayDeque<List<String>>();
    private final Deque<Object> objects = new ArrayDeque<Object>();
    private final Predicate<Path> needsKeyCollection;
    private final Predicate<Path> needsJsonCollection;

    public JsonIterator(JsonParser jp) {
        this(jp, p -> false, p -> false);
    }

    public JsonIterator(JsonParser jp, Predicate<Path> needsKeyCollection, Predicate<Path> needsJsonCollection) {
        this.jp = jp;
        this.needsKeyCollection = needsKeyCollection;
        this.needsJsonCollection = needsJsonCollection;
    }

    @Override
    public ParseEvent next() {
        this.findNext();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        ParseEvent result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public boolean hasNext() {
        this.findNext();
        return this.next != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void findNext() {
        if (this.next == null) {
            try {
                JsonToken token;
                while (this.next == null && (token = this.jp.nextToken()) != null) {
                    List<String> eventKeys = null;
                    Object eventObjects = null;
                    String text = this.jp.getText();
                    switch (token) {
                        case START_OBJECT: {
                            if (this.needsKeyCollection.test(this.path)) {
                                this.keys.add(new ArrayList());
                            }
                            if (!this.needsJsonCollection.test(this.path) && this.objects.isEmpty()) break;
                            this.objects.add(new LinkedHashMap());
                            break;
                        }
                        case START_ARRAY: {
                            if (!this.needsJsonCollection.test(this.path) && this.objects.isEmpty()) break;
                            this.objects.add(new ArrayList());
                            break;
                        }
                        case END_ARRAY: {
                            this.path.pollLast();
                            if (!this.needsJsonCollection.test(this.path)) break;
                            eventObjects = this.objects.peekLast();
                            break;
                        }
                        case FIELD_NAME: {
                            String fieldName = this.jp.getText();
                            if (this.needsKeyCollection.test(this.path)) {
                                this.keys.peekLast().add(fieldName);
                            }
                            this.path.add(new KeyEntry(fieldName));
                            break;
                        }
                        case END_OBJECT: {
                            if (this.needsKeyCollection.test(this.path)) {
                                eventKeys = this.keys.pollLast();
                            }
                            if (!this.needsJsonCollection.test(this.path)) break;
                            eventObjects = this.objects.peekLast();
                        }
                    }
                    this.next = new ParseEvent(token, new Path(this.path), text, eventKeys, eventObjects);
                    if (!this.objects.isEmpty()) {
                        switch (token) {
                            case VALUE_STRING: {
                                this.put(this.objects.peekLast(), this.path.peekLast().toString(), this.jp.getText());
                                break;
                            }
                            case VALUE_NUMBER_INT: 
                            case VALUE_NUMBER_FLOAT: {
                                this.put(this.objects.peekLast(), this.path.peekLast().toString(), this.jp.getNumberValue());
                                break;
                            }
                            case VALUE_TRUE: 
                            case VALUE_FALSE: {
                                this.put(this.objects.peekLast(), this.path.peekLast().toString(), this.jp.getBooleanValue());
                                break;
                            }
                            case VALUE_NULL: {
                                this.put(this.objects.peekLast(), this.path.peekLast().toString(), null);
                                break;
                            }
                            case END_ARRAY: 
                            case END_OBJECT: {
                                Object object = this.objects.pollLast();
                                Object e = this.objects.peekLast();
                                if (e == null) break;
                                this.put(e, this.path.peekLast().toString(), object);
                            }
                        }
                    }
                    switch (token) {
                        case START_ARRAY: {
                            this.path.add(new ArrayEntry());
                            break;
                        }
                        case END_ARRAY: 
                        case END_OBJECT: 
                        case VALUE_STRING: 
                        case VALUE_NUMBER_INT: 
                        case VALUE_NUMBER_FLOAT: 
                        case VALUE_TRUE: 
                        case VALUE_FALSE: 
                        case VALUE_NULL: {
                            PathEntry prev = this.path.peekLast();
                            if (!(prev instanceof ArrayEntry)) {
                                this.path.pollLast();
                                break;
                            }
                            this.path.addLast(((ArrayEntry)this.path.pollLast()).inc());
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void put(Object parent, String key, Object value) {
        if (parent instanceof Map) {
            ((Map)parent).put(key, value);
        } else {
            ((List)parent).add(value);
        }
    }
}

