/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json.grep;

import com.fasterxml.jackson.core.JsonParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.meeuw.json.JsonIterator;
import org.meeuw.json.ParseEvent;
import org.meeuw.json.grep.GrepEvent;
import org.meeuw.json.grep.matching.NeverPathMatcher;
import org.meeuw.json.grep.matching.PathMatcher;

public class Grep
implements Iterator<GrepEvent>,
Iterable<GrepEvent> {
    private final PathMatcher matcher;
    private PathMatcher recordMatcher = new NeverPathMatcher();
    final JsonIterator wrapped;
    private final List<GrepEvent> next = new ArrayList<GrepEvent>();

    public Grep(PathMatcher matcher, JsonParser jp) {
        this.matcher = matcher == null ? new NeverPathMatcher() : matcher;
        this.wrapped = new JsonIterator(jp, this.matcher.needsKeyCollection(), this.matcher.needsObjectCollection());
    }

    @Override
    public boolean hasNext() {
        this.findNext();
        return !this.next.isEmpty();
    }

    @Override
    public GrepEvent next() {
        this.findNext();
        if (this.next.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.next.remove(0);
    }

    @Override
    public void remove() {
        this.wrapped.remove();
    }

    protected void findNext() {
        if (this.next.isEmpty()) {
            while (this.wrapped.hasNext() && this.next.isEmpty()) {
                ParseEvent event = this.wrapped.next();
                switch (event.getToken()) {
                    case VALUE_STRING: 
                    case VALUE_NUMBER_INT: 
                    case VALUE_NUMBER_FLOAT: 
                    case VALUE_TRUE: 
                    case VALUE_FALSE: 
                    case VALUE_NULL: 
                    case END_ARRAY: 
                    case END_OBJECT: {
                        int weight;
                        int recordWeight;
                        String value = event.getValue();
                        if (this.recordMatcher != null && (recordWeight = this.recordMatcher.matchWeight(event, value)) > 0) {
                            this.next.add(new GrepEvent(event, GrepEvent.Type.RECORD, recordWeight));
                        }
                        if ((weight = this.matcher.matchWeight(event, value)) <= 0) break;
                        this.next.add(new GrepEvent(event, weight));
                    }
                }
            }
        }
    }

    public PathMatcher getRecordMatcher() {
        return this.recordMatcher;
    }

    public void setRecordMatcher(PathMatcher recordMatcher) {
        this.recordMatcher = recordMatcher;
    }

    public PathMatcher getMatcher() {
        return this.matcher;
    }

    @Override
    public Iterator<GrepEvent> iterator() {
        return this;
    }
}

