/*
 * Decompiled with CFR 0.152.
 */
package org.meeuw.json.grep.parsing;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.meeuw.json.grep.matching.AnyDepthMatcher;
import org.meeuw.json.grep.matching.ArrayEntryMatch;
import org.meeuw.json.grep.matching.ArrayIndexMatch;
import org.meeuw.json.grep.matching.JavascriptMatcher;
import org.meeuw.json.grep.matching.KeysPattern;
import org.meeuw.json.grep.matching.NeedsObjectObjectMatcher;
import org.meeuw.json.grep.matching.ObjectHasKeyMatcher;
import org.meeuw.json.grep.matching.ObjectMatcherNot;
import org.meeuw.json.grep.matching.PathMatcher;
import org.meeuw.json.grep.matching.PathMatcherAndChain;
import org.meeuw.json.grep.matching.PathMatcherOrChain;
import org.meeuw.json.grep.matching.PreciseMatch;
import org.meeuw.json.grep.matching.RegexpKeyMatch;
import org.meeuw.json.grep.matching.SinglePathMatcher;
import org.meeuw.json.grep.matching.ValueEqualsMatcher;
import org.meeuw.json.grep.matching.ValueRegexpMatcher;
import org.meeuw.json.grep.matching.Wildcard;

public class Parser {
    private Parser() {
    }

    public static PathMatcher parsePathMatcherChain(String arg) {
        return Parser.parsePathMatcherChain(arg, false, false, null);
    }

    public static PathMatcher parsePathMatcherChain(String arg, boolean ignoreArrays, boolean needsObject, String recordPrefix) {
        String[] split = arg.split(",");
        for (int i = 0; i < split.length; ++i) {
            if (!split[i].startsWith(".") || recordPrefix == null) continue;
            split[i] = recordPrefix + split[i];
        }
        if (split.length == 1) {
            return Parser.parsePathMatcher(arg, ignoreArrays, needsObject);
        }
        ArrayList<PathMatcher> list = new ArrayList<PathMatcher>(split.length);
        for (String s : split) {
            list.add(Parser.parsePathMatcher(s, ignoreArrays, needsObject));
        }
        return new PathMatcherOrChain(list.toArray(new PathMatcher[list.size()]));
    }

    protected static PathMatcher parsePathMatcher(String arg, boolean ignoreArrays, boolean needsObject) {
        String[] split = arg.split("~", 2);
        if (split.length == 2) {
            return new PathMatcherAndChain(Parser.parseKeysMatcher(split[0], ignoreArrays), new ValueRegexpMatcher(Pattern.compile(split[1])));
        }
        split = arg.split("\\s+!\\s*contains\\s+", 2);
        if (split.length == 2) {
            return new PathMatcherAndChain(Parser.parseKeysMatcher(split[0], ignoreArrays), NeedsObjectObjectMatcher.get(new ObjectMatcherNot(new ObjectHasKeyMatcher(split[1])), needsObject));
        }
        split = arg.split("\\s+contains\\s+", 2);
        if (split.length == 2) {
            return new PathMatcherAndChain(Parser.parseKeysMatcher(split[0], ignoreArrays), NeedsObjectObjectMatcher.get(new ObjectHasKeyMatcher(split[1]), needsObject));
        }
        split = arg.split("\\s+function\\(", 2);
        if (split.length == 2) {
            return new PathMatcherAndChain(Parser.parseKeysMatcher(split[0], ignoreArrays), new JavascriptMatcher("function(" + split[1]));
        }
        split = arg.split("=", 2);
        if (split.length == 2) {
            return new PathMatcherAndChain(Parser.parseKeysMatcher(split[0], ignoreArrays), new ValueEqualsMatcher(split[1]));
        }
        return Parser.parseKeysMatcher(split[0], ignoreArrays);
    }

    public static SinglePathMatcher parseKeysMatcher(String arg, boolean ignoreArrays) {
        String[] split = arg.split("\\.");
        ArrayList<KeysPattern> list = new ArrayList<KeysPattern>(split.length);
        boolean foundEmpty = false;
        for (String s : split) {
            if (s.isEmpty()) {
                if (foundEmpty) {
                    list.add(new AnyDepthMatcher());
                    foundEmpty = false;
                    continue;
                }
                foundEmpty = true;
                continue;
            }
            foundEmpty = false;
            Parser.parseKeyPattern(list, s);
        }
        return new SinglePathMatcher(ignoreArrays, list.toArray(new KeysPattern[list.size()]));
    }

    protected static void parseKeyPattern(List<KeysPattern> list, String arg) {
        if (arg.startsWith("/") && arg.endsWith("/")) {
            list.add(new RegexpKeyMatch(Pattern.compile(arg.substring(1, arg.length() - 1))));
            return;
        }
        for (String s : arg.split("\\[")) {
            if ("*".equals(s)) {
                list.add(new Wildcard());
                continue;
            }
            if ("*]".equals(s)) {
                list.add(new ArrayEntryMatch());
                continue;
            }
            if (s.endsWith("]")) {
                list.add(new ArrayIndexMatch(Integer.parseInt(s.substring(0, s.length() - 1))));
                continue;
            }
            if (s.length() <= 0) continue;
            list.add(new PreciseMatch(s));
        }
    }
}

