/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.store.lmdb;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mb.pie.api.Logger;
import mb.pie.api.Store;
import mb.pie.api.StoreReadTxn;
import mb.pie.api.StoreWriteTxn;
import mb.pie.store.lmdb.LMDBStoreTxn;
import org.agrona.DirectBuffer;
import org.jetbrains.annotations.NotNull;
import org.lmdbjava.BufferProxy;
import org.lmdbjava.Dbi;
import org.lmdbjava.DbiFlags;
import org.lmdbjava.DirectBufferProxy;
import org.lmdbjava.Env;
import org.lmdbjava.EnvFlags;
import org.lmdbjava.Txn;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u001c\u0010\n\u001a\u0010\u0012\b\u0012\u00060\fj\u0002`\r0\u000bj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\b\u0012\u00060\fj\u0002`\r0\u000bj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\b\u0012\u00060\fj\u0002`\r0\u000bj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\b\u0012\u00060\fj\u0002`\r0\u0012j\u0002`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\b\u0012\u00060\fj\u0002`\r0\u000bj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0010\u0012\b\u0012\u00060\fj\u0002`\r0\u000bj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\b\u0012\u00060\fj\u0002`\r0\u000bj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0010\u0012\b\u0012\u00060\fj\u0002`\r0\u000bj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0010\u0012\b\u0012\u00060\fj\u0002`\r0\u000bj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0010\u0012\b\u0012\u00060\fj\u0002`\r0\u000bj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lmb/pie/store/lmdb/LMDBStore;", "Lmb/pie/api/Store;", "logger", "Lmb/pie/api/Logger;", "envDir", "Ljava/io/File;", "maxDbSize", "", "maxReaders", "(Lmb/pie/api/Logger;Ljava/io/File;II)V", "callReqs", "Lorg/lmdbjava/Dbi;", "Lorg/agrona/DirectBuffer;", "Lmb/pie/store/lmdb/Buf;", "Lmb/pie/store/lmdb/DbiB;", "callersOf", "callersOfValues", "env", "Lorg/lmdbjava/Env;", "Lmb/pie/store/lmdb/EnvB;", "generatorOf", "output", "pathGens", "pathReqs", "requireesOf", "requireesOfValues", "close", "", "readTxn", "Lmb/pie/api/StoreReadTxn;", "sync", "toString", "", "writeTxn", "Lmb/pie/api/StoreWriteTxn;", "pie.store.lmdb"})
public final class LMDBStore
implements Store {
    private final Env<DirectBuffer> env;
    private final Dbi<DirectBuffer> output;
    private final Dbi<DirectBuffer> callReqs;
    private final Dbi<DirectBuffer> callersOf;
    private final Dbi<DirectBuffer> callersOfValues;
    private final Dbi<DirectBuffer> pathReqs;
    private final Dbi<DirectBuffer> requireesOf;
    private final Dbi<DirectBuffer> requireesOfValues;
    private final Dbi<DirectBuffer> pathGens;
    private final Dbi<DirectBuffer> generatorOf;
    private final Logger logger;

    public void close() {
        this.env.close();
    }

    @NotNull
    public StoreReadTxn readTxn() {
        Txn txn;
        Txn txn2 = txn = this.env.txnRead();
        Intrinsics.checkExpressionValueIsNotNull((Object)txn2, (String)"txn");
        return new LMDBStoreTxn(this.env, (Txn<DirectBuffer>)txn2, false, this.logger, this.output, this.callReqs, this.callersOf, this.callersOfValues, this.pathReqs, this.requireesOf, this.requireesOfValues, this.pathGens, this.generatorOf);
    }

    @NotNull
    public StoreWriteTxn writeTxn() {
        Txn txn;
        Txn txn2 = txn = this.env.txnWrite();
        Intrinsics.checkExpressionValueIsNotNull((Object)txn2, (String)"txn");
        return new LMDBStoreTxn(this.env, (Txn<DirectBuffer>)txn2, true, this.logger, this.output, this.callReqs, this.callersOf, this.callersOfValues, this.pathReqs, this.requireesOf, this.requireesOfValues, this.pathGens, this.generatorOf);
    }

    public void sync() {
        this.env.sync(false);
    }

    @NotNull
    public String toString() {
        return "LMDBStore";
    }

    public LMDBStore(@NotNull Logger logger, @NotNull File envDir, int maxDbSize, int maxReaders) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)envDir, (String)"envDir");
        this.logger = logger;
        envDir.mkdirs();
        Env env = Env.create((BufferProxy)DirectBufferProxy.PROXY_DB).setMapSize((long)maxDbSize).setMaxReaders(maxReaders).setMaxDbs(9).open(envDir, new EnvFlags[]{EnvFlags.MDB_NOSYNC, EnvFlags.MDB_NOMETASYNC});
        Intrinsics.checkExpressionValueIsNotNull((Object)env, (String)"Env.create(DirectBufferP\u2026 EnvFlags.MDB_NOMETASYNC)");
        this.env = env;
        Dbi dbi = this.env.openDbi("output", new DbiFlags[]{DbiFlags.MDB_CREATE});
        Intrinsics.checkExpressionValueIsNotNull((Object)dbi, (String)"env.openDbi(\"output\", DbiFlags.MDB_CREATE)");
        this.output = dbi;
        Dbi dbi2 = this.env.openDbi("taskReqs", new DbiFlags[]{DbiFlags.MDB_CREATE});
        Intrinsics.checkExpressionValueIsNotNull((Object)dbi2, (String)"env.openDbi(\"taskReqs\", DbiFlags.MDB_CREATE)");
        this.callReqs = dbi2;
        Dbi dbi3 = this.env.openDbi("callersOf", new DbiFlags[]{DbiFlags.MDB_CREATE, DbiFlags.MDB_DUPSORT});
        Intrinsics.checkExpressionValueIsNotNull((Object)dbi3, (String)"env.openDbi(\"callersOf\",\u2026TE, DbiFlags.MDB_DUPSORT)");
        this.callersOf = dbi3;
        Dbi dbi4 = this.env.openDbi("callersOfValues", new DbiFlags[]{DbiFlags.MDB_CREATE});
        Intrinsics.checkExpressionValueIsNotNull((Object)dbi4, (String)"env.openDbi(\"callersOfVa\u2026es\", DbiFlags.MDB_CREATE)");
        this.callersOfValues = dbi4;
        Dbi dbi5 = this.env.openDbi("pathReqs", new DbiFlags[]{DbiFlags.MDB_CREATE});
        Intrinsics.checkExpressionValueIsNotNull((Object)dbi5, (String)"env.openDbi(\"pathReqs\", DbiFlags.MDB_CREATE)");
        this.pathReqs = dbi5;
        Dbi dbi6 = this.env.openDbi("requireesOf", new DbiFlags[]{DbiFlags.MDB_CREATE, DbiFlags.MDB_DUPSORT});
        Intrinsics.checkExpressionValueIsNotNull((Object)dbi6, (String)"env.openDbi(\"requireesOf\u2026TE, DbiFlags.MDB_DUPSORT)");
        this.requireesOf = dbi6;
        Dbi dbi7 = this.env.openDbi("requireesOfValues", new DbiFlags[]{DbiFlags.MDB_CREATE});
        Intrinsics.checkExpressionValueIsNotNull((Object)dbi7, (String)"env.openDbi(\"requireesOf\u2026es\", DbiFlags.MDB_CREATE)");
        this.requireesOfValues = dbi7;
        Dbi dbi8 = this.env.openDbi("pathGens", new DbiFlags[]{DbiFlags.MDB_CREATE});
        Intrinsics.checkExpressionValueIsNotNull((Object)dbi8, (String)"env.openDbi(\"pathGens\", DbiFlags.MDB_CREATE)");
        this.pathGens = dbi8;
        Dbi dbi9 = this.env.openDbi("generatorOf", new DbiFlags[]{DbiFlags.MDB_CREATE});
        Intrinsics.checkExpressionValueIsNotNull((Object)dbi9, (String)"env.openDbi(\"generatorOf\", DbiFlags.MDB_CREATE)");
        this.generatorOf = dbi9;
    }
}

