/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.laboratory;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.util.FontUtil;
import org.meteoinfo.global.util.GlobalUtil;
import org.meteoinfo.laboratory.StackWindow;
import org.meteoinfo.laboratory.gui.FrmMain;
import org.meteoinfo.laboratory.gui.MyPythonInterpreter;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.InteractiveConsole;

public class MeteoInfoLab {
    public static void disableAccessWarnings() {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field field = unsafeClass.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Object unsafe = field.get(null);
            Method putObjectVolatile = unsafeClass.getDeclaredMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class);
            Method staticFieldOffset = unsafeClass.getDeclaredMethod("staticFieldOffset", Field.class);
            Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field loggerField = loggerClass.getDeclaredField("logger");
            Long offset = (Long)staticFieldOffset.invoke(unsafe, loggerField);
            putObjectVolatile.invoke(unsafe, loggerClass, offset, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        MeteoInfoLab.disableAccessWarnings();
        if (args.length >= 1 && args[0].equalsIgnoreCase("-r")) {
            String fontPath = GlobalUtil.getAppPath(FrmMain.class) + File.separator + "fonts";
            List fontFns = GlobalUtil.getFiles((String)fontPath, (String)".ttc");
            for (String fontFn : fontFns) {
                System.out.println("Register: " + fontFn);
                FontUtil.registerFont((String)fontFn);
            }
            args = (String[])DataConvert.resizeArray((Object)args, (int)(args.length - 1));
        }
        if (args.length >= 1) {
            String fn;
            if (args[0].equalsIgnoreCase("-i")) {
                MeteoInfoLab.runInteractive();
            } else if (args[0].equalsIgnoreCase("-b")) {
                if (args.length == 1) {
                    System.out.println("Script file name is needed!");
                    System.exit(0);
                } else {
                    fn = args[1];
                    if (new File(fn).isFile()) {
                        System.setProperty("java.awt.headless", "true");
                        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        System.out.println("Headless mode: " + ge.isHeadless());
                        MeteoInfoLab.runScript(args, fn, 1);
                    } else {
                        System.out.println("The script file does not exist!");
                        System.exit(0);
                    }
                }
            } else if (args[0].equalsIgnoreCase("-eng")) {
                MeteoInfoLab.runApplication(true);
            } else {
                fn = args[0];
                if (new File(fn).isFile()) {
                    MeteoInfoLab.runScript(args, fn, 0);
                } else {
                    System.out.println("The script file does not exist!");
                    System.exit(0);
                }
            }
        } else {
            MeteoInfoLab.runApplication();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runScript(String[] args, String fn, int idx) {
        String miPath;
        String toolboxPath;
        String path;
        FontUtil.registerWeatherFont();
        System.out.println("Running Jython script...");
        PySystemState state = new PySystemState();
        if (args.length > idx + 1) {
            for (int i = idx + 1; i < args.length; ++i) {
                state.argv.append((PyObject)Py.newStringOrUnicode((String)args[i]));
            }
        }
        MyPythonInterpreter interp = new MyPythonInterpreter(null, state);
        boolean isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
        if (isDebug) {
            path = "D:/MyProgram/java/MeteoInfoDev/MeteoInfo/MeteoInfoLab/pylib";
            toolboxPath = "D:/MyProgram/java/MeteoInfoDev/toolbox";
            miPath = "D:/MyProgram/Distribution/Java/MeteoInfo/MeteoInfo";
        } else {
            miPath = GlobalUtil.getAppPath(FrmMain.class);
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("windows") && miPath.substring(0, 1).equals("/")) {
                miPath = miPath.substring(1);
            }
            path = miPath + File.separator + "pylib";
            toolboxPath = miPath + "/toolbox";
        }
        try {
            interp.exec("import sys");
            interp.exec("import os");
            interp.exec("import datetime");
            interp.exec("sys.path.append('" + path + "')");
            interp.exec("from milab import *");
            if (!isDebug) {
                interp.exec("sys.path.append('" + toolboxPath + "')");
            }
            interp.exec("mipylib.plotlib.miplot.batchmode = True");
            interp.exec("mipylib.plotlib.miplot.isinteractive = False");
            interp.exec("mipylib.migl.mifolder = '" + miPath + "'");
            System.out.println("mipylib is loaded...");
            interp.execfile(fn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    private static void runInteractive() {
        String startPath = System.getProperty("user.dir");
        String miPath = GlobalUtil.getAppPath(FrmMain.class);
        String path = miPath + File.separator + "pylib";
        String toolboxPath = miPath + "/toolbox";
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("windows") && miPath.substring(0, 1).equals("/")) {
            miPath = miPath.substring(1);
        }
        InteractiveConsole console = new InteractiveConsole();
        try {
            console.exec("import sys");
            console.exec("import os");
            console.exec("import datetime");
            console.exec("sys.path.append('" + path + "')");
            console.exec("from milab import *");
            console.exec("sys.path.append('" + toolboxPath + "')");
            console.exec("mipylib.plotlib.miplot.isinteractive = True");
            console.exec("mipylib.migl.mifolder = '" + miPath + "'");
            console.exec("mipylib.migl.currentfolder = '" + startPath + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        console.interact();
    }

    private static void runApplication() {
        MeteoInfoLab.runApplication(false);
    }

    private static void runApplication(final boolean isEng) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MeteoInfoLab.class.getName()).log(Level.SEVERE, null, ex);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
                if (isEng) {
                    Locale.setDefault(Locale.ENGLISH);
                }
                StackWindow sw = null;
                if (!isDebug) {
                    StackWindow handler = sw = new StackWindow("Show Exception Stack", 600, 400);
                    Thread.setDefaultUncaughtExceptionHandler(handler);
                    System.setOut(sw.printStream);
                    System.setErr(sw.printStream);
                }
                FontUtil.registerWeatherFont();
                FrmMain frame = new FrmMain();
                frame.setDefaultCloseOperation(0);
                frame.setVisible(true);
                if (sw != null) {
                    sw.setLocationRelativeTo(frame);
                }
            }
        });
    }
}

