/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.laboratory.gui;

import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.intern.CDockable;
import com.l2fprod.common.swing.JFontChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.parsers.ParserConfigurationException;
import org.meteoinfo.global.colors.ColorMap;
import org.meteoinfo.global.colors.ColorUtil;
import org.meteoinfo.global.util.GlobalUtil;
import org.meteoinfo.laboratory.Options;
import org.meteoinfo.laboratory.application.AppCollection;
import org.meteoinfo.laboratory.application.Application;
import org.meteoinfo.laboratory.event.ConsoleExecEvent;
import org.meteoinfo.laboratory.event.CurrentPathChangedEvent;
import org.meteoinfo.laboratory.event.IConsoleExecListener;
import org.meteoinfo.laboratory.event.ICurrentPathChangedListener;
import org.meteoinfo.laboratory.gui.ConsoleDockable;
import org.meteoinfo.laboratory.gui.CustomWindowFactory;
import org.meteoinfo.laboratory.gui.EditorDockable;
import org.meteoinfo.laboratory.gui.FigureDockable;
import org.meteoinfo.laboratory.gui.FileDockable;
import org.meteoinfo.laboratory.gui.FrmAbout;
import org.meteoinfo.laboratory.gui.FrmAppsManager;
import org.meteoinfo.laboratory.gui.PythonInteractiveInterpreter;
import org.meteoinfo.laboratory.gui.TextEditor;
import org.meteoinfo.laboratory.gui.VariableDockable;
import org.meteoinfo.legend.LayersLegend;
import org.meteoinfo.map.MapView;
import org.meteoinfo.plugin.IApplication;
import org.meteoinfo.plugin.IPlugin;
import org.meteoinfo.ui.ColorListCellRender;
import org.python.core.PyInstance;
import org.python.core.PyJavaType;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.util.PythonInterpreter;
import org.xml.sax.SAXException;

public class FrmMain
extends JFrame
implements IApplication {
    private final EditorDockable editorDock;
    private final ConsoleDockable consoleDock;
    private final FigureDockable figuresDock;
    private final VariableDockable variableDock;
    private final FileDockable fileDock;
    private String startupPath;
    private Options options = new Options();
    private AppCollection apps = new AppCollection();
    private List<String> loadObjects = new ArrayList<String>();
    private CControl cControl1;
    private JButton jButton_CurrentFolder;
    private JButton jButton_NewFile;
    private JButton jButton_OpenFile;
    private JButton jButton_Redo;
    private JButton jButton_RunScript;
    private JButton jButton_SaveAs;
    private JButton jButton_SaveFile;
    private JButton jButton_Undo;
    private JComboBox jComboBox_CurrentFolder;
    private JLabel jLabel1;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem_About;
    private JMenuItem jMenuItem_AppsManager;
    private JMenuItem jMenuItem_CloseAllFiles;
    private JMenuItem jMenuItem_ColorDialog;
    private JMenuItem jMenuItem_ColorMaps;
    private JMenuItem jMenuItem_Copy;
    private JMenuItem jMenuItem_Cut;
    private JMenuItem jMenuItem_Exit;
    private JMenuItem jMenuItem_NewFile;
    private JMenuItem jMenuItem_OpenFile;
    private JMenuItem jMenuItem_Paste;
    private JMenuItem jMenuItem_SaveAs;
    private JMenuItem jMenuItem_SaveFile;
    private JMenuItem jMenuItem_SetFont;
    private JMenu jMenu_Apps;
    private JMenu jMenu_Editor;
    private JMenu jMenu_File;
    private JMenu jMenu_Help;
    private JMenu jMenu_Options;
    private JPanel jPanel_Status;
    private JPanel jPanel_Toolbar;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JToolBar jToolBar_CurrentFolder;
    private JToolBar jToolBar_Editor;

    public FrmMain() {
        String appConfFn;
        this.initComponents();
        boolean isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
        this.startupPath = isDebug ? System.getProperty("user.dir") : GlobalUtil.getAppPath(FrmMain.class);
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("/images/MeteoLab_32.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setIconImage(image);
        this.loadConfigureFile();
        this.setLocation(this.options.getMainFormLocation());
        this.setSize(this.options.getMainFormSize());
        this.jComboBox_CurrentFolder.removeAllItems();
        for (String cf : this.options.getRecentFolders()) {
            if (!new File(cf).isDirectory()) continue;
            this.jComboBox_CurrentFolder.addItem(cf);
        }
        String cf = this.options.getCurrentFolder();
        if (cf != null) {
            if (!new File(cf).isDirectory()) {
                cf = this.startupPath;
                this.options.setCurrentFolder(cf);
            }
            if (!this.options.getRecentFolders().contains(cf)) {
                this.jComboBox_CurrentFolder.addItem(cf);
            }
            this.jComboBox_CurrentFolder.setSelectedItem(cf);
        }
        CControl control = new CControl((JFrame)this);
        this.add((Component)control.getContentArea());
        control.putProperty(ScreenDockStation.WINDOW_FACTORY, (Object)new CustomWindowFactory());
        CGrid grid = new CGrid(control);
        this.editorDock = new EditorDockable(this, "Editor", "Editor", new CAction[0]);
        this.editorDock.setTextFont(this.options.getTextFont());
        this.consoleDock = new ConsoleDockable(this, this.startupPath, "Console", "Console", new CAction[0]);
        this.editorDock.setInterp((PythonInterpreter)this.consoleDock.getInterpreter());
        this.editorDock.addNewTextEditor("New file");
        this.editorDock.openFiles(this.options.getOpenedFiles());
        String toolboxPath = this.startupPath + File.separator + "toolbox";
        if (isDebug) {
            toolboxPath = "D:/MyProgram/Java/MeteoInfoDev/toolbox";
        }
        if (new File(appConfFn = toolboxPath + File.separator + "apps.xml").exists()) {
            try {
                this.apps.setPluginPath(toolboxPath);
                this.apps.loadConfigFile(appConfFn);
                if (this.apps.size() > 0) {
                    for (Application app : this.apps) {
                        if (!app.isLoad()) continue;
                        this.loadApplication(app);
                    }
                }
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ParserConfigurationException | SAXException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        final PythonInteractiveInterpreter interp = this.consoleDock.getInterpreter();
        PyStringMap locals = (PyStringMap)interp.getLocals();
        PyList items = locals.items();
        for (Object a : items) {
            PyTuple at = (PyTuple)a;
            String name = at.__getitem__(0).toString();
            this.loadObjects.add(name);
        }
        interp.addConsoleExecListener(new IConsoleExecListener(){

            @Override
            public void consoleExecEvent(ConsoleExecEvent event) {
                PyStringMap locals = (PyStringMap)interp.getLocals();
                PyList items = locals.items();
                ArrayList<Object[]> vars = new ArrayList<Object[]>();
                for (Object a : items) {
                    String value;
                    String className;
                    PyTuple at = (PyTuple)a;
                    String name = at.__getitem__(0).toString();
                    if (FrmMain.this.loadObjects.contains(name)) continue;
                    PyObject var = at.__getitem__(1);
                    if (var instanceof PyInstance) {
                        switch (className = ((PyInstance)var).instclass.__name__) {
                            case "DimArray": 
                            case "MIArray": {
                                value = var.__len__() <= 10 ? var.__str__().toString() : "";
                                vars.add(new Object[]{name, className, var.__getattr__("sizestr"), value});
                                break;
                            }
                            default: {
                                vars.add(new Object[]{name, className, "", ""});
                                break;
                            }
                        }
                        continue;
                    }
                    if (var instanceof PyType || var instanceof PyJavaType) continue;
                    className = var.getClass().getSimpleName();
                    value = "";
                    String size = "";
                    boolean isAdd = true;
                    switch (className) {
                        case "PyInteger": 
                        case "PyFloat": 
                        case "PyString": {
                            value = var.toString();
                            size = "1";
                            break;
                        }
                        case "PyList": 
                        case "PyTuple": {
                            if (var.__len__() <= 10) {
                                value = var.toString();
                            }
                            size = String.valueOf(var.__len__());
                            break;
                        }
                        case "PyObjectDerived": {
                            switch (className = var.getType().getName()) {
                                case "DimArray": 
                                case "MIArray": {
                                    value = var.__len__() <= 10 ? var.__str__().toString() : "";
                                    size = var.__getattr__("shape").toString();
                                }
                            }
                            break;
                        }
                        default: {
                            isAdd = false;
                        }
                    }
                    if (!isAdd) continue;
                    vars.add(new Object[]{name, className, size, value});
                }
                if (FrmMain.this.variableDock != null) {
                    FrmMain.this.variableDock.getVariableExplorer().updateVariables(vars);
                }
            }
        });
        this.figuresDock = new FigureDockable(this, "Figures", "Figures", new CAction[0]);
        this.variableDock = new VariableDockable("Variables", "Variable explorer", new CAction[0]);
        this.fileDock = new FileDockable("Files", "File explorer", new CAction[0]);
        if (cf != null) {
            this.fileDock.setPath(new File(cf));
        }
        this.fileDock.getFileExplorer().addCurrentPathChangedListener(new ICurrentPathChangedListener(){

            @Override
            public void currentPathChangedEvent(CurrentPathChangedEvent event) {
                FrmMain.this.setCurrentPath(FrmMain.this.fileDock.getFileExplorer().getPath().getAbsolutePath());
            }
        });
        this.fileDock.getFileExplorer().getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() == 2 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0 && ((JTable)e.getSource()).getValueAt(row, 2).toString().equals("py")) {
                    File file = new File(FrmMain.this.fileDock.getFileExplorer().getPath().getAbsoluteFile() + File.separator + ((JTable)e.getSource()).getValueAt(row, 0).toString());
                    FrmMain.this.editorDock.openFile(file);
                }
            }
        });
        grid.add(0.0, 0.0, 5.0, 5.0, new CDockable[]{this.editorDock});
        grid.add(0.0, 5.0, 5.0, 5.0, new CDockable[]{this.consoleDock});
        grid.add(5.0, 0.0, 5.0, 5.0, new CDockable[]{this.variableDock});
        grid.add(5.0, 0.0, 5.0, 5.0, new CDockable[]{this.fileDock});
        grid.add(5.0, 5.0, 5.0, 5.0, new CDockable[]{this.figuresDock});
        control.getContentArea().deploy(grid);
    }

    public AppCollection getApplications() {
        return this.apps;
    }

    public String getStartupPath() {
        return this.startupPath;
    }

    public Options getOptions() {
        return this.options;
    }

    public void loadApplication(Application plugin) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            PythonInteractiveInterpreter interp = this.getConsoleDockable().getInterpreter();
            String path = plugin.getPath();
            interp.exec("import " + path);
            interp.exec("from " + path + ".loadApp import LoadApp");
            PyObject loadClass = interp.get("LoadApp");
            PyObject loadObj = loadClass.__call__();
            IPlugin instance = (IPlugin)loadObj.__tojava__(IPlugin.class);
            instance.setApplication((IApplication)this);
            instance.setName(plugin.getName());
            plugin.setPluginObject(instance);
            plugin.setLoad(true);
            instance.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void unloadApplication(Application plugin) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (plugin.getPluginObject() != null) {
            plugin.getPluginObject().unload();
            plugin.setPluginObject(null);
            plugin.setLoad(false);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void initComponents() {
        this.cControl1 = new CControl();
        this.jPanel_Toolbar = new JPanel();
        this.jToolBar_Editor = new JToolBar();
        this.jButton_NewFile = new JButton();
        this.jButton_OpenFile = new JButton();
        this.jButton_SaveFile = new JButton();
        this.jButton_SaveAs = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButton_Undo = new JButton();
        this.jButton_Redo = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButton_RunScript = new JButton();
        this.jToolBar_CurrentFolder = new JToolBar();
        this.jLabel1 = new JLabel();
        this.jComboBox_CurrentFolder = new JComboBox();
        this.jButton_CurrentFolder = new JButton();
        this.jPanel_Status = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu_File = new JMenu();
        this.jMenuItem_NewFile = new JMenuItem();
        this.jMenuItem_OpenFile = new JMenuItem();
        this.jMenuItem_SaveFile = new JMenuItem();
        this.jMenuItem_SaveAs = new JMenuItem();
        this.jMenuItem_CloseAllFiles = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItem_Exit = new JMenuItem();
        this.jMenu_Editor = new JMenu();
        this.jMenuItem_Cut = new JMenuItem();
        this.jMenuItem_Copy = new JMenuItem();
        this.jMenuItem_Paste = new JMenuItem();
        this.jMenu_Options = new JMenu();
        this.jMenuItem_SetFont = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItem_ColorMaps = new JMenuItem();
        this.jMenuItem_ColorDialog = new JMenuItem();
        this.jMenu_Apps = new JMenu();
        this.jMenuItem_AppsManager = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.jMenu_Help = new JMenu();
        this.jMenuItem_About = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("MeteoInfoLab");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FrmMain.this.formWindowClosing(evt);
            }
        });
        this.jPanel_Toolbar.setLayout(new BorderLayout());
        this.jToolBar_Editor.setRollover(true);
        this.jToolBar_Editor.setPreferredSize(new Dimension(250, 25));
        this.jButton_NewFile.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_NewFile.Image.png")));
        this.jButton_NewFile.setToolTipText("New File");
        this.jButton_NewFile.setFocusable(false);
        this.jButton_NewFile.setHorizontalTextPosition(0);
        this.jButton_NewFile.setVerticalTextPosition(3);
        this.jButton_NewFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_NewFileActionPerformed(evt);
            }
        });
        this.jToolBar_Editor.add(this.jButton_NewFile);
        this.jButton_OpenFile.setIcon(new ImageIcon(this.getClass().getResource("/images/Folder_1_16x16x8.png")));
        this.jButton_OpenFile.setToolTipText("Open File");
        this.jButton_OpenFile.setFocusable(false);
        this.jButton_OpenFile.setHorizontalTextPosition(0);
        this.jButton_OpenFile.setVerticalTextPosition(3);
        this.jButton_OpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_OpenFileActionPerformed(evt);
            }
        });
        this.jToolBar_Editor.add(this.jButton_OpenFile);
        this.jButton_SaveFile.setIcon(new ImageIcon(this.getClass().getResource("/images/Disk_1_16x16x8.png")));
        this.jButton_SaveFile.setToolTipText("Save File");
        this.jButton_SaveFile.setFocusable(false);
        this.jButton_SaveFile.setHorizontalTextPosition(0);
        this.jButton_SaveFile.setVerticalTextPosition(3);
        this.jButton_SaveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_SaveFileActionPerformed(evt);
            }
        });
        this.jToolBar_Editor.add(this.jButton_SaveFile);
        this.jButton_SaveAs.setIcon(new ImageIcon(this.getClass().getResource("/images/save_16.png")));
        this.jButton_SaveAs.setToolTipText("Save As");
        this.jButton_SaveAs.setFocusable(false);
        this.jButton_SaveAs.setHorizontalTextPosition(0);
        this.jButton_SaveAs.setVerticalTextPosition(3);
        this.jButton_SaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_SaveAsActionPerformed(evt);
            }
        });
        this.jToolBar_Editor.add(this.jButton_SaveAs);
        this.jToolBar_Editor.add(this.jSeparator1);
        this.jButton_Undo.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Undo.Image.png")));
        this.jButton_Undo.setToolTipText("Undo");
        this.jButton_Undo.setFocusable(false);
        this.jButton_Undo.setHorizontalTextPosition(0);
        this.jButton_Undo.setVerticalTextPosition(3);
        this.jButton_Undo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_UndoActionPerformed(evt);
            }
        });
        this.jToolBar_Editor.add(this.jButton_Undo);
        this.jButton_Redo.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Redo.Image.png")));
        this.jButton_Redo.setToolTipText("Redo");
        this.jButton_Redo.setFocusable(false);
        this.jButton_Redo.setHorizontalTextPosition(0);
        this.jButton_Redo.setVerticalTextPosition(3);
        this.jButton_Redo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_RedoActionPerformed(evt);
            }
        });
        this.jToolBar_Editor.add(this.jButton_Redo);
        this.jToolBar_Editor.add(this.jSeparator2);
        this.jButton_RunScript.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_RunScript.Image.png")));
        this.jButton_RunScript.setToolTipText("Run Script");
        this.jButton_RunScript.setFocusable(false);
        this.jButton_RunScript.setHorizontalTextPosition(0);
        this.jButton_RunScript.setVerticalTextPosition(3);
        this.jButton_RunScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_RunScriptActionPerformed(evt);
            }
        });
        this.jToolBar_Editor.add(this.jButton_RunScript);
        this.jPanel_Toolbar.add((Component)this.jToolBar_Editor, "Before");
        this.jToolBar_CurrentFolder.setRollover(true);
        this.jLabel1.setText("Current Folder:");
        this.jToolBar_CurrentFolder.add(this.jLabel1);
        this.jComboBox_CurrentFolder.setEditable(true);
        this.jComboBox_CurrentFolder.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_CurrentFolder.setPreferredSize(new Dimension(400, 21));
        this.jComboBox_CurrentFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jComboBox_CurrentFolderActionPerformed(evt);
            }
        });
        this.jToolBar_CurrentFolder.add(this.jComboBox_CurrentFolder);
        this.jButton_CurrentFolder.setIcon(new ImageIcon(this.getClass().getResource("/images/folder.png")));
        this.jButton_CurrentFolder.setFocusable(false);
        this.jButton_CurrentFolder.setHorizontalTextPosition(0);
        this.jButton_CurrentFolder.setVerticalTextPosition(3);
        this.jButton_CurrentFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jButton_CurrentFolderActionPerformed(evt);
            }
        });
        this.jToolBar_CurrentFolder.add(this.jButton_CurrentFolder);
        this.jPanel_Toolbar.add((Component)this.jToolBar_CurrentFolder, "After");
        this.getContentPane().add((Component)this.jPanel_Toolbar, "North");
        this.jPanel_Status.setPreferredSize(new Dimension(588, 25));
        GroupLayout jPanel_StatusLayout = new GroupLayout(this.jPanel_Status);
        this.jPanel_Status.setLayout(jPanel_StatusLayout);
        jPanel_StatusLayout.setHorizontalGroup(jPanel_StatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 777, Short.MAX_VALUE));
        jPanel_StatusLayout.setVerticalGroup(jPanel_StatusLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 25, Short.MAX_VALUE));
        this.getContentPane().add((Component)this.jPanel_Status, "Last");
        this.jMenu_File.setText("File");
        this.jMenuItem_NewFile.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.jMenuItem_NewFile.setText("New");
        this.jMenuItem_NewFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_NewFileActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenuItem_NewFile);
        this.jMenuItem_OpenFile.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItem_OpenFile.setText("Open ...");
        this.jMenuItem_OpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_OpenFileActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenuItem_OpenFile);
        this.jMenuItem_SaveFile.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItem_SaveFile.setText("Save");
        this.jMenuItem_SaveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_SaveFileActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenuItem_SaveFile);
        this.jMenuItem_SaveAs.setText("Save As ...");
        this.jMenuItem_SaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_SaveAsActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenuItem_SaveAs);
        this.jMenuItem_CloseAllFiles.setText("Close All Files");
        this.jMenuItem_CloseAllFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_CloseAllFilesActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenuItem_CloseAllFiles);
        this.jMenu_File.add(this.jSeparator3);
        this.jMenuItem_Exit.setText("Exit");
        this.jMenuItem_Exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_ExitActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenuItem_Exit);
        this.jMenuBar1.add(this.jMenu_File);
        this.jMenu_Editor.setMnemonic('E');
        this.jMenu_Editor.setText("Edit");
        this.jMenuItem_Cut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.jMenuItem_Cut.setIcon(new ImageIcon(this.getClass().getResource("/images/TSMI_EditCut.Image.png")));
        this.jMenuItem_Cut.setText("Cut");
        this.jMenuItem_Cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_CutActionPerformed(evt);
            }
        });
        this.jMenu_Editor.add(this.jMenuItem_Cut);
        this.jMenuItem_Copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.jMenuItem_Copy.setIcon(new ImageIcon(this.getClass().getResource("/images/menuEditCopy.Image.png")));
        this.jMenuItem_Copy.setText("Copy");
        this.jMenuItem_Copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_CopyActionPerformed(evt);
            }
        });
        this.jMenu_Editor.add(this.jMenuItem_Copy);
        this.jMenuItem_Paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.jMenuItem_Paste.setIcon(new ImageIcon(this.getClass().getResource("/images/pasteToolStripButton.Image.png")));
        this.jMenuItem_Paste.setText("Paste");
        this.jMenuItem_Paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_PasteActionPerformed(evt);
            }
        });
        this.jMenu_Editor.add(this.jMenuItem_Paste);
        this.jMenuBar1.add(this.jMenu_Editor);
        this.jMenu_Options.setMnemonic('O');
        this.jMenu_Options.setText("Options");
        this.jMenuItem_SetFont.setIcon(new ImageIcon(this.getClass().getResource("/images/miSetFont.Image.png")));
        this.jMenuItem_SetFont.setText("Set Font");
        this.jMenuItem_SetFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_SetFontActionPerformed(evt);
            }
        });
        this.jMenu_Options.add(this.jMenuItem_SetFont);
        this.jMenu_Options.add(this.jSeparator4);
        this.jMenuItem_ColorMaps.setText("Color Maps");
        this.jMenuItem_ColorMaps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_ColorMapsActionPerformed(evt);
            }
        });
        this.jMenu_Options.add(this.jMenuItem_ColorMaps);
        this.jMenuItem_ColorDialog.setText("Color Dialog");
        this.jMenuItem_ColorDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_ColorDialogActionPerformed(evt);
            }
        });
        this.jMenu_Options.add(this.jMenuItem_ColorDialog);
        this.jMenuBar1.add(this.jMenu_Options);
        this.jMenu_Apps.setText("Apps");
        this.jMenuItem_AppsManager.setIcon(new ImageIcon(this.getClass().getResource("/images/plugin_edit_green.png")));
        this.jMenuItem_AppsManager.setText("Application Manager");
        this.jMenuItem_AppsManager.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_AppsManagerActionPerformed(evt);
            }
        });
        this.jMenu_Apps.add(this.jMenuItem_AppsManager);
        this.jMenu_Apps.add(this.jSeparator5);
        this.jMenuBar1.add(this.jMenu_Apps);
        this.jMenu_Help.setText("Help");
        this.jMenuItem_About.setText("About");
        this.jMenuItem_About.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMain.this.jMenuItem_AboutActionPerformed(evt);
            }
        });
        this.jMenu_Help.add(this.jMenuItem_About);
        this.jMenuBar1.add(this.jMenu_Help);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void jButton_NewFileActionPerformed(ActionEvent evt) {
        this.editorDock.addNewTextEditor("New file");
    }

    private void jButton_OpenFileActionPerformed(ActionEvent evt) {
        this.editorDock.doOpen_Jython();
    }

    private void jButton_SaveFileActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.editorDock.getActiveTextEditor();
        if (textEditor != null) {
            this.editorDock.doSave(textEditor);
        }
    }

    private void jButton_UndoActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.editorDock.getActiveTextEditor();
        textEditor.getTextArea().undoLastAction();
    }

    private void jButton_RedoActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.editorDock.getActiveTextEditor();
        textEditor.getTextArea().redoLastAction();
    }

    private void jButton_RunScriptActionPerformed(ActionEvent evt) {
        TextEditor te = this.editorDock.getActiveTextEditor();
        if (!te.getFileName().isEmpty() && te.getTextArea().isDirty()) {
            te.saveFile(te.getFile());
        }
        if (te.getFileName().isEmpty()) {
            String code = te.getTextArea().getText();
            try {
                this.consoleDock.runPythonScript(code);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.consoleDock.execfile(te.getFileName());
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.formClose();
    }

    private void formClose() {
        this.saveConfigureFile();
        boolean isDispose = true;
        for (int i = 0; i < this.editorDock.getTabbedPane().getTabCount(); ++i) {
            TextEditor textEditor = (TextEditor)this.editorDock.getTabbedPane().getComponentAt(i);
            if (textEditor == null) continue;
            boolean ifClose = true;
            if (textEditor.getTextArea().isDirty()) {
                int result;
                String fName = textEditor.getFileName();
                if (fName.isEmpty()) {
                    fName = "New file";
                }
                if ((result = JOptionPane.showConfirmDialog(null, MessageFormat.format("Save changes to \"{0}\"", fName), "Save?", 1)) == 0) {
                    if (!this.editorDock.doSave(textEditor)) {
                        ifClose = false;
                    }
                } else if (result == 2) {
                    ifClose = false;
                }
            }
            if (ifClose) continue;
            isDispose = false;
            break;
        }
        if (isDispose) {
            System.exit(0);
        }
    }

    private void jButton_SaveAsActionPerformed(ActionEvent evt) {
        TextEditor editor = this.editorDock.getActiveTextEditor();
        if (editor != null) {
            this.editorDock.doSaveAs_Jython(editor);
        }
    }

    private void jMenuItem_SetFontActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.editorDock.getActiveTextEditor();
        Font tFont = JFontChooser.showDialog((Component)this, null, (Font)textEditor.getTextArea().getFont());
        if (tFont != null) {
            this.editorDock.setTextFont(tFont);
            this.options.setTextFont(tFont);
        }
    }

    private void jMenuItem_CutActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.editorDock.getActiveTextEditor();
        textEditor.getTextArea().cut();
    }

    private void jMenuItem_CopyActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.editorDock.getActiveTextEditor();
        textEditor.getTextArea().copy();
    }

    private void jMenuItem_PasteActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.editorDock.getActiveTextEditor();
        textEditor.getTextArea().paste();
    }

    private void jMenuItem_AboutActionPerformed(ActionEvent evt) {
        FrmAbout frmAbout = new FrmAbout((Frame)this, false);
        frmAbout.setLocationRelativeTo(this);
        frmAbout.setVisible(true);
    }

    private void jComboBox_CurrentFolderActionPerformed(ActionEvent evt) {
        String path;
        if (this.fileDock == null) {
            return;
        }
        if (this.jComboBox_CurrentFolder.getItemCount() > 0 && new File(path = this.jComboBox_CurrentFolder.getSelectedItem().toString()).isDirectory()) {
            this.fileDock.setPath(new File(path));
        }
    }

    private void jButton_CurrentFolderActionPerformed(ActionEvent evt) {
        JFileChooser aDlg = new JFileChooser();
        File pathDir = new File(this.jComboBox_CurrentFolder.getSelectedItem().toString());
        if (pathDir.isDirectory()) {
            aDlg.setCurrentDirectory(pathDir);
        }
        aDlg.setFileSelectionMode(1);
        if (0 == aDlg.showOpenDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            String path = aFile.getAbsolutePath();
            this.setCurrentPath(path);
            this.fileDock.setPath(new File(this.options.getCurrentFolder()));
        }
    }

    private void jMenuItem_ExitActionPerformed(ActionEvent evt) {
        this.formClose();
    }

    private void jMenuItem_CloseAllFilesActionPerformed(ActionEvent evt) {
        this.editorDock.closeAllFiles();
    }

    private void jMenuItem_ColorMapsActionPerformed(ActionEvent evt) {
        try {
            ColorMap[] colorTables = ColorUtil.getColorTables();
            ColorListCellRender render = new ColorListCellRender();
            render.setPreferredSize(new Dimension(62, 21));
            Object[][] elements = new Object[colorTables.length][2];
            for (int i = 0; i < colorTables.length; ++i) {
                elements[i][0] = colorTables[i];
                elements[i][1] = String.valueOf(i);
            }
            final JList jlist = new JList((E[])elements);
            jlist.setCellRenderer(render);
            jlist.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int idx;
                    if (e.getKeyCode() == 40 && (idx = jlist.getSelectedIndex()) >= 0) {
                        if (++idx == jlist.getModel().getSize() - 1) {
                            idx = 0;
                        }
                        jlist.setSelectedIndex(idx);
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            JDialog colorMapDialog = new JDialog((Frame)this, false);
            colorMapDialog.setTitle("Color Map");
            colorMapDialog.setFocusableWindowState(false);
            colorMapDialog.add(new JScrollPane(jlist));
            colorMapDialog.setSize(this.getWidth() / 2, this.getHeight() * 2 / 3);
            colorMapDialog.setLocationRelativeTo(this);
            colorMapDialog.setVisible(true);
        }
        catch (IOException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jMenuItem_AppsManagerActionPerformed(ActionEvent evt) {
        FrmAppsManager frm = new FrmAppsManager(this, true);
        frm.setLocationRelativeTo(this);
        frm.setVisible(true);
    }

    private void jMenuItem_ColorDialogActionPerformed(ActionEvent evt) {
        JDialog colorMapDialog = new JDialog((Frame)this, false);
        colorMapDialog.setTitle("Color Dialog");
        colorMapDialog.setFocusableWindowState(false);
        colorMapDialog.add(new JColorChooser(Color.black));
        colorMapDialog.setSize(600, 400);
        colorMapDialog.setLocationRelativeTo(this);
        colorMapDialog.setVisible(true);
    }

    private void jMenuItem_NewFileActionPerformed(ActionEvent evt) {
        this.jButton_NewFile.doClick();
    }

    private void jMenuItem_OpenFileActionPerformed(ActionEvent evt) {
        this.jButton_OpenFile.doClick();
    }

    private void jMenuItem_SaveFileActionPerformed(ActionEvent evt) {
        this.jButton_SaveFile.doClick();
    }

    private void jMenuItem_SaveAsActionPerformed(ActionEvent evt) {
        this.jButton_SaveAs.doClick();
    }

    public FigureDockable getFigureDock() {
        return this.figuresDock;
    }

    public String getCurrentFolder() {
        return this.options.getCurrentFolder();
    }

    public ConsoleDockable getConsoleDockable() {
        return this.consoleDock;
    }

    public final void loadConfigureFile() {
        String fn = this.startupPath + File.separator + "milconfig.xml";
        if (new File(fn).exists()) {
            try {
                this.options.loadConfigFile(fn);
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public final void saveConfigureFile() {
        String fn = this.options.getFileName();
        try {
            ArrayList<String> cfolders = new ArrayList<String>();
            for (int i = 0; i < 15 && i < this.jComboBox_CurrentFolder.getItemCount(); ++i) {
                cfolders.add(this.jComboBox_CurrentFolder.getItemAt(i).toString());
            }
            this.options.setRecentFolders(cfolders);
            List<String> ofiles = this.editorDock.getOpenedFiles();
            this.options.setOpenedFiles(ofiles);
            this.options.setMainFormLocation(this.getLocation());
            this.options.setMainFormSize(this.getSize());
            this.options.saveConfigFile(fn);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setCurrentPath(String path) {
        this.options.setCurrentFolder(path);
        ArrayList<String> paths = new ArrayList<String>();
        if (this.jComboBox_CurrentFolder.getItemCount() > 15) {
            this.jComboBox_CurrentFolder.removeItemAt(0);
        }
        for (int i = 0; i < this.jComboBox_CurrentFolder.getItemCount(); ++i) {
            paths.add(this.jComboBox_CurrentFolder.getItemAt(i).toString());
        }
        if (!paths.contains(path)) {
            this.jComboBox_CurrentFolder.addItem(path);
        }
        this.jComboBox_CurrentFolder.setSelectedItem(path);
        PythonInteractiveInterpreter interp = this.consoleDock.getInterpreter();
        try {
            path = path.replace("\\", "/");
            interp.exec("mipylib.migl.currentfolder = '" + path + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MapView getMapView() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public LayersLegend getMapDocument() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JMenuBar getMainMenuBar() {
        return this.jMenuBar1;
    }

    public JMenu getPluginMenu() {
        return this.jMenu_Apps;
    }

    public JPanel getToolBarPanel() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JButton getCurrentTool() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setCurrentTool(JButton value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JProgressBar getProgressBar() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JLabel getProgressBarLabel() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void openProjectFile(String fileName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void delVariables() {
        PythonInteractiveInterpreter interp = this.consoleDock.getInterpreter();
        PyStringMap locals = (PyStringMap)interp.getLocals();
        PyList items = locals.items();
        for (Object a : items) {
            PyTuple at = (PyTuple)a;
            String name = at.__getitem__(0).toString();
            if (this.loadObjects.contains(name)) continue;
            locals.__delitem__(name);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmMain frame = new FrmMain();
                frame.setDefaultCloseOperation(0);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }
}

