/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.laboratory.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.meteoinfo.laboratory.event.CurrentPathChangedEvent;
import org.meteoinfo.laboratory.event.ICurrentPathChangedListener;
import org.meteoinfo.table.IconRenderer;
import org.meteoinfo.table.IconText;

public class FileExplorer
extends JPanel
implements MouseListener {
    private final EventListenerList listeners = new EventListenerList();
    private final JTable jtFile;
    private final DefaultTableModel dtmFile;
    private File path;
    private String currentPath;
    private int currentIndex;
    private boolean init = false;

    public FileExplorer(File path) {
        super(new BorderLayout());
        this.path = path;
        this.setForeground(Color.white);
        this.dtmFile = new LocalTableModel();
        this.dtmFile.addColumn("Name");
        this.dtmFile.addColumn("Size");
        this.dtmFile.addColumn("File Type");
        this.dtmFile.addColumn("Date Modified");
        this.jtFile = new JTable(this.dtmFile);
        this.jtFile.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new IconRenderer());
        this.jtFile.setShowGrid(false);
        this.jtFile.addMouseListener(this);
        this.add((Component)new JScrollPane(this.jtFile), "Center");
        if (path != null) {
            this.listFiles(path);
        }
        this.init = true;
    }

    public File getPath() {
        return this.path;
    }

    public void setPath(File path) {
        this.path = path;
        this.listFiles(path);
        this.fireCurrentPathChangedEvent();
    }

    public JTable getTable() {
        return this.jtFile;
    }

    public void addCurrentPathChangedListener(ICurrentPathChangedListener listener) {
        this.listeners.add(ICurrentPathChangedListener.class, listener);
    }

    public void removeCurrentPathChangedListener(ICurrentPathChangedListener listener) {
        this.listeners.remove(ICurrentPathChangedListener.class, listener);
    }

    public void fireCurrentPathChangedEvent() {
        this.fireCurrentPathChangedEvent(new CurrentPathChangedEvent(this));
    }

    private void fireCurrentPathChangedEvent(CurrentPathChangedEvent event) {
        Object[] ls = this.listeners.getListenerList();
        for (int i = 0; i < ls.length; i += 2) {
            if (ls[i] != ICurrentPathChangedListener.class) continue;
            ((ICurrentPathChangedListener)ls[i + 1]).currentPathChangedEvent(event);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            int row = ((JTable)e.getSource()).getSelectedRow();
            if (((JTable)e.getSource()).getValueAt(row, 2).toString().equals("Folder")) {
                File newPath = new File(this.currentPath + "/" + ((JTable)e.getSource()).getValueAt(row, 0).toString());
                if (!newPath.exists()) {
                    newPath = new File(this.currentPath + ((JTable)e.getSource()).getValueAt(row, 0).toString());
                }
                if (newPath.isDirectory()) {
                    this.listFiles(newPath);
                    this.fireCurrentPathChangedEvent();
                }
            } else if (((JTable)e.getSource()).getValueAt(row, 0).toString().equals("") && ((JTable)e.getSource()).getValueAt(row, 2).toString().equals("")) {
                File newPath = new File(this.currentPath).getParentFile();
                this.listFiles(newPath);
                this.fireCurrentPathChangedEvent();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public boolean listFiles() {
        return this.listFiles(this.path);
    }

    public boolean listFiles(File path) {
        String name;
        if (!path.isDirectory()) {
            JOptionPane.showMessageDialog(this, "The file not exists!");
            return false;
        }
        this.path = path;
        this.currentPath = path.getAbsolutePath();
        this.init = false;
        this.dtmFile.setRowCount(0);
        if (path.getParent() != null) {
            URL imgURL = this.getClass().getResource("/images/previous.png");
            ImageIcon icon = new ImageIcon(imgURL);
            this.dtmFile.addRow(new Object[]{new IconText(icon, ""), "", "", ""});
        }
        URL folderURL = this.getClass().getResource("/images/folder.png");
        ImageIcon folderIcon = new ImageIcon(folderURL);
        URL fileURL = this.getClass().getResource("/images/TSB_NewFile.Image.png");
        ImageIcon fileIcon = new ImageIcon(fileURL);
        Object[] files = path.listFiles();
        Arrays.sort(files);
        for (Object file : files) {
            name = ((File)file).getName();
            if (!((File)file).isDirectory()) continue;
            this.dtmFile.addRow(new Object[]{new IconText(folderIcon, name), "", "Folder", ""});
        }
        for (Object file : files) {
            name = ((File)file).getName();
            if (!((File)file).isFile()) continue;
            if (name.lastIndexOf(".") != -1) {
                this.dtmFile.addRow(new Object[]{new IconText(fileIcon, name), this.sizeFormat(((File)file).length()), name.substring(name.lastIndexOf(".") + 1), new SimpleDateFormat("yyyy/M/d hh:mm").format(new Date(((File)file).lastModified()))});
                continue;
            }
            this.dtmFile.addRow(new Object[]{new IconText(fileIcon, name), this.sizeFormat(((File)file).length()), "", new SimpleDateFormat("yyyy/M/d hh:mm").format(new Date(((File)file).lastModified()))});
        }
        return true;
    }

    private String sizeFormat(long length) {
        if (length < 1024L) {
            return String.valueOf(length);
        }
        long kb = length / 1024L;
        if (kb < 1024L) {
            return String.valueOf(kb) + "kb";
        }
        return String.valueOf(length / 1024L / 1024L) + "kb";
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame("Test");
        jf.setSize(300, 400);
        jf.setDefaultCloseOperation(3);
        Dimension di = Toolkit.getDefaultToolkit().getScreenSize();
        jf.setLocation((int)(di.getWidth() - (double)jf.getWidth()) / 2, (int)(di.getHeight() - (double)jf.getHeight()) / 2);
        jf.add(new FileExplorer(new File(System.getProperty("user.dir"))));
        jf.setVisible(true);
    }

    class LocalTableModel
    extends DefaultTableModel {
        LocalTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

