/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.laboratory.gui;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.fife.ui.rsyntaxtextarea.TextEditorPane;
import org.meteoinfo.global.GenericFileFilter;
import org.meteoinfo.laboratory.codecomplete.JIntrospect;
import org.meteoinfo.laboratory.gui.EncodingUtil;
import org.meteoinfo.laboratory.gui.FrmMain;
import org.meteoinfo.laboratory.gui.JTextAreaPrintStream;
import org.meteoinfo.laboratory.gui.JTextAreaWriter;
import org.meteoinfo.laboratory.gui.MITextEditorPane;
import org.meteoinfo.laboratory.gui.TextEditor;
import org.meteoinfo.ui.ButtonTabComponent;
import org.python.util.PythonInterpreter;

public class EditorDockable
extends DefaultSingleCDockable {
    private final FrmMain parent;
    private final JTabbedPane tabbedPanel;
    private Font textFont;
    private PythonInterpreter interp;

    public EditorDockable(FrmMain parent, String id, String title, CAction ... actions) {
        super(id, title, actions);
        this.parent = parent;
        this.tabbedPanel = new JTabbedPane();
        this.tabbedPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTabbedPane sourceTabbedPane = (JTabbedPane)e.getSource();
                TextEditor te = (TextEditor)sourceTabbedPane.getSelectedComponent();
                if (te != null) {
                    EditorDockable.this.setTitleText("Editor - " + te.getFileName());
                }
            }
        });
        this.getContentPane().add(this.tabbedPanel);
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPanel;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
        for (Component tab : this.tabbedPanel.getComponents()) {
            if (!(tab instanceof TextEditor)) continue;
            ((TextEditor)tab).setTextFont(this.textFont);
        }
    }

    public void setInterp(PythonInterpreter value) {
        this.interp = value;
    }

    public final TextEditor addNewTextEditor(String title) {
        final TextEditor tab = new TextEditor(this.tabbedPanel, title);
        this.tabbedPanel.add((Component)tab, title);
        this.tabbedPanel.setSelectedComponent(tab);
        final MITextEditorPane textArea = (MITextEditorPane)tab.getTextArea();
        tab.setTextFont(this.textFont);
        textArea.setSyntaxEditingStyle("text/python");
        textArea.discardAllEdits();
        JPopupMenu popup = textArea.getPopupMenu();
        JMenuItem evaluate = new JMenuItem("Evaluate Selection");
        evaluate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EditorDockable.this.runCodeLines(textArea);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(EditorDockable.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        popup.insert(evaluate, 0);
        popup.insert(new JPopupMenu.Separator(), 1);
        tab.getTextArea().setDirty(false);
        tab.setTitle(title);
        JIntrospect nameComplete = new JIntrospect(this.interp);
        textArea.setNameCompletion(nameComplete);
        ButtonTabComponent btc = new ButtonTabComponent(this.tabbedPanel);
        ButtonTabComponent.TabButton button = btc.getTabButton();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorDockable.this.closeFile(tab);
            }
        });
        this.tabbedPanel.setTabComponentAt(this.tabbedPanel.indexOfComponent(tab), (Component)btc);
        return tab;
    }

    public TextEditor getActiveTextEditor() {
        if (this.tabbedPanel.getTabCount() == 0) {
            return null;
        }
        return (TextEditor)this.tabbedPanel.getSelectedComponent();
    }

    public void setActiveTextEditor(TextEditor te) {
        this.tabbedPanel.setSelectedComponent(te);
        this.setTitleText("Editor - " + te.getFileName());
    }

    private TextEditorPane getActiveTextArea() {
        TextEditor textEditor = this.getActiveTextEditor();
        if (textEditor != null) {
            return textEditor.getTextArea();
        }
        return null;
    }

    public void closeFile() {
        this.closeFile(this.getActiveTextEditor());
    }

    private void closeFile(TextEditor textEditor) {
        if (textEditor != null) {
            boolean ifClose = true;
            if (textEditor.getTextArea().isDirty()) {
                int result;
                String fName = textEditor.getFileName();
                if (fName.isEmpty()) {
                    fName = "New file";
                }
                if ((result = JOptionPane.showConfirmDialog(null, MessageFormat.format("Save changes to \"{0}\"", fName), "Save?", 1)) == 0) {
                    if (!this.doSave(textEditor)) {
                        ifClose = false;
                    }
                } else if (result == 2) {
                    ifClose = false;
                }
            }
            if (ifClose) {
                this.removeTextEditor(textEditor);
            }
        }
    }

    public void closeAllFiles() {
        while (this.tabbedPanel.getTabCount() > 0) {
            this.closeFile();
        }
    }

    public boolean doSave(TextEditor editor) {
        if (editor.getFileName().isEmpty()) {
            return this.doSaveAs_Jython(editor);
        }
        editor.saveFile(editor.getFile());
        return true;
    }

    public boolean doSaveAs_Jython(TextEditor editor) {
        JFileChooser aDlg = new JFileChooser();
        String[] fileExts = new String[]{"py"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Python File (*.py)");
        aDlg.setFileFilter((FileFilter)mapFileFilter);
        if (editor.getFile() != null) {
            aDlg.setSelectedFile(editor.getFile());
        } else {
            File dir = new File(System.getProperty("user.dir"));
            if (dir.isDirectory()) {
                aDlg.setCurrentDirectory(dir);
            }
        }
        if (aDlg.showSaveDialog(this.parent) == 0) {
            int overwrite;
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
            String fileName = file.getAbsolutePath();
            if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                fileName = fileName + "." + extent;
            }
            if ((file = new File(fileName)).exists() && (overwrite = JOptionPane.showConfirmDialog(null, "File exists! Overwrite it?", "Confirm", 0)) == 1) {
                return false;
            }
            editor.saveFile(file);
            this.setTitleText(editor.getFileName());
            return true;
        }
        return false;
    }

    private void removeTextEditor(TextEditor editor) {
        this.tabbedPanel.remove(editor);
    }

    public void doOpen_Jython() {
        JFileChooser aDlg = new JFileChooser();
        aDlg.setMultiSelectionEnabled(true);
        aDlg.setAcceptAllFileFilterUsed(false);
        File dir = new File(System.getProperty("user.dir"));
        if (dir.isDirectory()) {
            aDlg.setCurrentDirectory(dir);
        }
        String[] fileExts = new String[]{"py"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Jython File (*.py)");
        aDlg.setFileFilter((FileFilter)mapFileFilter);
        if (0 == aDlg.showOpenDialog(this.parent)) {
            File[] files = aDlg.getSelectedFiles();
            System.setProperty("user.dir", files[0].getParent());
            this.openFiles(files);
        }
    }

    public void openFiles(List<String> fileNames) {
        ArrayList<File> files = new ArrayList<File>();
        for (String fn : fileNames) {
            File file = new File(fn);
            if (!file.exists()) continue;
            files.add(file);
        }
        if (files.size() > 0) {
            File[] fs = new File[files.size()];
            for (int i = 0; i < files.size(); ++i) {
                fs[i] = (File)files.get(i);
            }
            this.openFiles(fs);
        }
    }

    public void openFiles(File[] files) {
        TextEditor textEditor;
        if (this.tabbedPanel.getTabCount() == 1 && (textEditor = this.getActiveTextEditor()).getTextArea().getDocument().getLength() == 0 && textEditor.getFileName().isEmpty()) {
            this.removeTextEditor(textEditor);
        }
        for (File file : files) {
            boolean isExist = false;
            for (int i = 0; i < this.tabbedPanel.getTabCount(); ++i) {
                TextEditor te = (TextEditor)this.tabbedPanel.getComponentAt(i);
                if (!file.getAbsolutePath().equals(te.getFileName())) continue;
                isExist = true;
                this.setActiveTextEditor(te);
                break;
            }
            if (isExist) continue;
            TextEditor editor = this.addNewTextEditor(file.getName());
            editor.openFile(file);
            this.setTitleText(editor.getFileName());
        }
    }

    public void openFile(File file) {
        TextEditor textEditor;
        if (this.tabbedPanel.getTabCount() == 1 && (textEditor = this.getActiveTextEditor()).getTextArea().getDocument().getLength() == 0 && textEditor.getFileName().isEmpty()) {
            this.removeTextEditor(textEditor);
        }
        boolean isExist = false;
        for (int i = 0; i < this.tabbedPanel.getTabCount(); ++i) {
            TextEditor te = (TextEditor)this.tabbedPanel.getComponentAt(i);
            if (!file.getAbsolutePath().equals(te.getFileName())) continue;
            isExist = true;
            this.setActiveTextEditor(te);
            break;
        }
        if (!isExist) {
            TextEditor editor = this.addNewTextEditor(file.getName());
            editor.openFile(file);
            this.parent.getOptions().addRecentFile(file.getAbsolutePath());
            this.setTitleText(editor.getFileName());
        }
    }

    public List<String> getOpenedFiles() {
        ArrayList<String> fns = new ArrayList<String>();
        for (int i = 0; i < this.tabbedPanel.getTabCount(); ++i) {
            TextEditor te = (TextEditor)this.tabbedPanel.getComponentAt(i);
            fns.add(te.getFileName());
        }
        return fns;
    }

    private void runCodeLines(MITextEditorPane textArea) throws InterruptedException {
        String code = textArea.getSelectedText();
        this.parent.getConsoleDockable().run(code);
    }

    public void runPythonScript(final JTextArea jTextArea_Output) {
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){
            PrintStream oout = System.out;
            PrintStream oerr = System.err;

            @Override
            protected String doInBackground() throws Exception {
                JTextAreaWriter writer = new JTextAreaWriter(jTextArea_Output);
                JTextAreaPrintStream printStream = new JTextAreaPrintStream((OutputStream)System.out, jTextArea_Output);
                jTextArea_Output.setText("");
                PythonInterpreter interp = new PythonInterpreter();
                interp.setOut((Writer)writer);
                interp.setErr((Writer)writer);
                System.setOut(printStream);
                System.setErr(printStream);
                try {
                    interp.exec("import sys");
                    interp.set("milapp", (Object)EditorDockable.this.parent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                TextEditorPane textArea = EditorDockable.this.getActiveTextArea();
                String code = textArea.getText();
                String encoding = EncodingUtil.findEncoding(code);
                if (encoding != null) {
                    try {
                        interp.execfile((InputStream)new ByteArrayInputStream(code.getBytes(encoding)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        interp.execfile((InputStream)new ByteArrayInputStream(code.getBytes()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return "";
            }

            @Override
            protected void done() {
                System.setOut(this.oout);
                System.setErr(this.oerr);
            }
        };
        worker.execute();
    }
}

