/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.laboratory.codecomplete;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.meteoinfo.laboratory.codecomplete.CodeBlock;
import org.meteoinfo.laboratory.codecomplete.FieldCompletion;
import org.meteoinfo.laboratory.codecomplete.JIntrospect;
import org.meteoinfo.laboratory.codecomplete.TokenScanner;
import org.meteoinfo.laboratory.codecomplete.VariableDeclaration;
import org.python.util.PythonInterpreter;

public class JythonSourceCompletionProvider
extends DefaultCompletionProvider {
    private static final char[] KEYWORD_DEF = new char[]{'d', 'e', 'f'};
    private PythonInterpreter interp = new PythonInterpreter();

    public JythonSourceCompletionProvider() {
        this.setParameterizedCompletionParams('(', ", ", ')');
        this.setAutoActivationRules(false, ".");
    }

    public void setInterp(PythonInterpreter value) {
        this.interp = value;
    }

    private CodeBlock createAst(JTextComponent comp) {
        CodeBlock ast = new CodeBlock(0);
        RSyntaxTextArea textArea = (RSyntaxTextArea)comp;
        TokenScanner scanner = new TokenScanner(textArea);
        this.parseCodeBlock(scanner, ast);
        return ast;
    }

    private String getSegment() {
        return this.seg.toString();
    }

    protected List<Completion> getCompletionsImpl(JTextComponent comp) {
        this.completions.clear();
        CodeBlock ast = this.createAst(comp);
        int dot = comp.getCaretPosition();
        this.recursivelyAddLocalVars(this.completions, ast, dot);
        String text = this.getSegment();
        if (!text.startsWith("import ") && !text.startsWith("from ")) {
            text = this.getAlreadyEnteredText(comp);
        }
        JIntrospect nameComplete = new JIntrospect(this.interp);
        try {
            List<String> list = nameComplete.getAutoCompleteList(text);
            if (list != null) {
                for (String str : list) {
                    this.completions.add(new FieldCompletion((CompletionProvider)this, str));
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(JythonSourceCompletionProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.completions;
    }

    protected boolean isValidChar(char ch) {
        return Character.isJavaIdentifierPart(ch) || ch == '.';
    }

    private void parseCodeBlock(TokenScanner scanner, CodeBlock block) {
        Token t = scanner.next();
        while (t != null) {
            if (t.isRightCurly()) {
                block.setEndOffset(t.getOffset());
                return;
            }
            if (t.isLeftCurly()) {
                CodeBlock child = block.addChildCodeBlock(t.getOffset());
                this.parseCodeBlock(scanner, child);
            } else if (t.is(6, KEYWORD_DEF) && (t = scanner.next()) != null) {
                VariableDeclaration varDec = new VariableDeclaration(t.getLexeme(), t.getOffset());
                block.addVariable(varDec);
            }
            t = scanner.next();
        }
    }

    private void recursivelyAddLocalVars(List<Completion> completions, CodeBlock block, int dot) {
        VariableDeclaration dec;
        int decOffs;
        int i;
        if (!block.contains(dot)) {
            return;
        }
        for (i = 0; i < block.getVariableDeclarationCount() && (decOffs = (dec = block.getVariableDeclaration(i)).getOffset()) < dot; ++i) {
            BasicCompletion c = new BasicCompletion((CompletionProvider)this, dec.getName());
            completions.add((Completion)c);
        }
        for (i = 0; i < block.getChildCodeBlockCount(); ++i) {
            CodeBlock child = block.getChildCodeBlock(i);
            if (!child.contains(dot)) continue;
            this.recursivelyAddLocalVars(completions, child, dot);
            return;
        }
    }
}

