/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.laboratory.gui;

import com.bulenkov.darcula.DarculaLaf;
import com.l2fprod.common.swing.JFontChooser;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.meteoinfo.laboratory.gui.FrmMain;
import org.meteoinfo.laboratory.gui.TextEditor;

public class FrmSetting
extends JDialog {
    private FrmMain parent;
    private JButton jButton_Apply;
    private JButton jButton_Font;
    private JComboBox<String> jComboBox_LookFeel;
    private JLabel jLabel_Font;
    private JLabel jLabel_LookFeel;
    private JPanel jPanel_Appearance;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextField_Font;

    public FrmSetting(Frame parent, boolean modal) {
        super(parent, modal);
        UIManager.LookAndFeelInfo[] lnfs;
        this.parent = (FrmMain)parent;
        this.initComponents();
        for (UIManager.LookAndFeelInfo lnf : lnfs = UIManager.getInstalledLookAndFeels()) {
            this.jComboBox_LookFeel.addItem(lnf.getName());
        }
        this.jComboBox_LookFeel.addItem("Darcula");
        this.jComboBox_LookFeel.setSelectedItem(UIManager.getLookAndFeel().getName());
        TextEditor textEditor = this.parent.getEditorDock().getActiveTextEditor();
        Font font = textEditor.getTextArea().getFont();
        this.jTextField_Font.setText(font.getFontName() + "  " + String.valueOf(font.getSize()));
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel_Appearance = new JPanel();
        this.jLabel_LookFeel = new JLabel();
        this.jComboBox_LookFeel = new JComboBox();
        this.jButton_Apply = new JButton();
        this.jLabel_Font = new JLabel();
        this.jTextField_Font = new JTextField();
        this.jButton_Font = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Setting");
        this.jLabel_LookFeel.setText("Look&Feel:");
        this.jComboBox_LookFeel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSetting.this.jComboBox_LookFeelActionPerformed(evt);
            }
        });
        this.jButton_Apply.setText("Apply");
        this.jButton_Apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSetting.this.jButton_ApplyActionPerformed(evt);
            }
        });
        this.jLabel_Font.setText("Font:");
        this.jTextField_Font.setEditable(false);
        this.jButton_Font.setText("...");
        this.jButton_Font.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSetting.this.jButton_FontActionPerformed(evt);
            }
        });
        GroupLayout jPanel_AppearanceLayout = new GroupLayout(this.jPanel_Appearance);
        this.jPanel_Appearance.setLayout(jPanel_AppearanceLayout);
        jPanel_AppearanceLayout.setHorizontalGroup(jPanel_AppearanceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_AppearanceLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jButton_Apply, -2, 78, -2).addGap(22, 22, 22)).addGroup(jPanel_AppearanceLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_AppearanceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_LookFeel).addComponent(this.jLabel_Font)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 14, Short.MAX_VALUE).addGroup(jPanel_AppearanceLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, jPanel_AppearanceLayout.createSequentialGroup().addComponent(this.jTextField_Font).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_Font, -2, 30, -2)).addComponent(this.jComboBox_LookFeel, -2, 221, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel_AppearanceLayout.setVerticalGroup(jPanel_AppearanceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_AppearanceLayout.createSequentialGroup().addGap(14, 14, 14).addGroup(jPanel_AppearanceLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_LookFeel).addComponent(this.jComboBox_LookFeel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_AppearanceLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_Font).addComponent(this.jTextField_Font, -2, -1, -2).addComponent(this.jButton_Font)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 43, Short.MAX_VALUE).addComponent(this.jButton_Apply).addGap(17, 17, 17)));
        this.jTabbedPane1.addTab("Appearance", this.jPanel_Appearance);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, GroupLayout.Alignment.TRAILING));
        this.pack();
    }

    private void jButton_ApplyActionPerformed(ActionEvent evt) {
        String laf = this.jComboBox_LookFeel.getSelectedItem().toString();
        String lafName = UIManager.getLookAndFeel().getClass().getName();
        switch (laf) {
            case "CDE/Motif": {
                lafName = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
                break;
            }
            case "Metal": {
                lafName = "javax.swing.plaf.metal.MetalLookAndFeel";
                break;
            }
            case "Windows": {
                lafName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
                break;
            }
            case "Windows Classic": {
                lafName = "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel";
                break;
            }
            case "Nimbus": {
                lafName = "javax.swing.plaf.nimbus.NimbusLookAndFeel";
                break;
            }
            case "Mac": {
                lafName = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
                break;
            }
            case "GTK": {
                lafName = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
                break;
            }
            case "Darcula": {
                lafName = "Darcula";
                break;
            }
            default: {
                lafName = "javax.swing.plaf.nimbus.NimbusLookAndFeel";
            }
        }
        try {
            JFrame.setDefaultLookAndFeelDecorated(true);
            if (lafName.equals("Darcula")) {
                DarculaLaf darcula = new DarculaLaf();
                UIManager.setLookAndFeel((LookAndFeel)darcula);
                this.changeStyleViaThemeXml("dark");
            } else {
                UIManager.setLookAndFeel(lafName);
                this.changeStyleViaThemeXml("default");
            }
            SwingUtilities.updateComponentTreeUI(this);
            SwingUtilities.updateComponentTreeUI(this.parent);
            this.parent.getOptions().setLookFeel(laf);
            this.parent.getConsoleDockable().setLookFeel(laf);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmSetting.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmSetting.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmSetting.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmSetting.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jComboBox_LookFeelActionPerformed(ActionEvent evt) {
    }

    private void jButton_FontActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.parent.getEditorDock().getActiveTextEditor();
        Font tFont = JFontChooser.showDialog((Component)this, null, (Font)textEditor.getTextArea().getFont());
        if (tFont != null) {
            this.parent.getEditorDock().setTextFont(tFont);
            this.parent.getConsoleDockable().getConsole().setFont(tFont);
            this.parent.getOptions().setTextFont(tFont);
            this.jTextField_Font.setText(tFont.getFontName() + "  " + String.valueOf(tFont.getSize()));
        }
    }

    private void changeStyleViaThemeXml(String themeName) {
        try {
            Theme theme = Theme.load((InputStream)this.getClass().getResourceAsStream("/org/fife/ui/rsyntaxtextarea/themes/" + themeName + ".xml"));
            for (TextEditor textEditor : this.parent.getEditorDock().getAllTextEditor()) {
                theme.apply((RSyntaxTextArea)textEditor.getTextArea());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmSetting.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmSetting.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmSetting.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmSetting.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmSetting dialog = new FrmSetting((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

