/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.meteoinfo.layout;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author yaqiang
 */
public class FrmPageSet extends javax.swing.JDialog {

    // <editor-fold desc="Variables">
    //private PrinterSettings m_PrinterSetting = new PrinterSettings();
    private MapLayout _mapLayout = null;
    private PaperSize _paperSize = new PaperSize();
    private boolean _landscape = true;
    private boolean _isCustom = false;
    private List<PaperSize> _paperSizeList = new ArrayList<PaperSize>();
    private boolean _isLoading = false;

    // </editor-fold>
    // <editor-fold desc="Constructor">
    /**
     * Creates new form FrmPageSet
     */
    public FrmPageSet(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jComboBox_PageSize = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jTextField_Height = new javax.swing.JTextField();
        jTextField_Width = new javax.swing.JTextField();
        jComboBox_WidthUnit = new javax.swing.JComboBox();
        jComboBox_HeightUnit = new javax.swing.JComboBox();
        jLabel4 = new javax.swing.JLabel();
        jRadioButton_Protrait = new javax.swing.JRadioButton();
        jRadioButton_Landscape = new javax.swing.JRadioButton();
        jButton_OK = new javax.swing.JButton();
        jButton_Cancel = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Page Set");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Page"));

        jLabel1.setText("Page Size:");

        jComboBox_PageSize.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox_PageSize.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox_PageSizeActionPerformed(evt);
            }
        });

        jLabel2.setText("Width:");

        jLabel3.setText("Height:");

        jTextField_Height.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextField_HeightActionPerformed(evt);
            }
        });

        jTextField_Width.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextField_WidthActionPerformed(evt);
            }
        });

        jComboBox_WidthUnit.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jComboBox_HeightUnit.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jLabel4.setText("Orientation:");

        buttonGroup1.add(jRadioButton_Protrait);
        jRadioButton_Protrait.setText("Portrait");
        jRadioButton_Protrait.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton_ProtraitActionPerformed(evt);
            }
        });

        buttonGroup1.add(jRadioButton_Landscape);
        jRadioButton_Landscape.setText("Landscape");
        jRadioButton_Landscape.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton_LandscapeActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLabel1)
                            .addComponent(jLabel2)
                            .addComponent(jLabel3))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jComboBox_PageSize, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 214, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jTextField_Width, javax.swing.GroupLayout.PREFERRED_SIZE, 91, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jTextField_Height, javax.swing.GroupLayout.PREFERRED_SIZE, 91, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                    .addComponent(jComboBox_HeightUnit, 0, 89, Short.MAX_VALUE)
                                    .addComponent(jComboBox_WidthUnit, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
                        .addGap(0, 4, Short.MAX_VALUE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jLabel4)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jRadioButton_Protrait)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jRadioButton_Landscape)))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jComboBox_PageSize, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(jTextField_Width, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBox_WidthUnit, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(jTextField_Height, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBox_HeightUnit, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(32, 32, 32)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(jRadioButton_Protrait)
                    .addComponent(jRadioButton_Landscape))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jButton_OK.setText("OK");
        jButton_OK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_OKActionPerformed(evt);
            }
        });

        jButton_Cancel.setText("Cancel");
        jButton_Cancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_CancelActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(101, 101, 101)
                        .addComponent(jButton_OK, javax.swing.GroupLayout.PREFERRED_SIZE, 82, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(44, 44, 44)
                        .addComponent(jButton_Cancel)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButton_OK)
                    .addComponent(jButton_Cancel))
                .addContainerGap(24, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        // TODO add your handling code here:
        _isLoading = true;

        PaperSize aPS = new PaperSize("A4", 827, 1169);
        _paperSizeList.add(aPS);
        aPS = new PaperSize("Letter", 850, 1100);
        _paperSizeList.add(aPS);
        aPS = new PaperSize("A5", 583, 827);
        _paperSizeList.add(aPS);
        aPS = new PaperSize("Custom", 500, 800);
        if (_paperSize.getName().equals("Custom")) {
            _isCustom = true;
            aPS.setWidth(_paperSize.getWidth());
            aPS.setHeight(_paperSize.getHeight());
        }
        _paperSizeList.add(aPS);

        this.jComboBox_PageSize.removeAllItems();
        for (PaperSize ps : _paperSizeList) {
            this.jComboBox_PageSize.addItem(ps.getName());
        }
        this.jComboBox_PageSize.setSelectedItem(_paperSize.getName());
        if (this.jComboBox_PageSize.getSelectedIndex() == -1) {
            this.jComboBox_PageSize.setSelectedIndex(1);
        }

        //Gets the paper orientation
        if (_landscape) {
            this.jRadioButton_Landscape.setSelected(true);
        } else {
            this.jRadioButton_Protrait.setSelected(true);
        }
        
        //Set width and height text
        if (_landscape) {
            this.jTextField_Width.setText(String.valueOf(_paperSize.getHeight() / 100.0));
            this.jTextField_Height.setText(String.valueOf(_paperSize.getWidth() / 100.0));
        } else {
            this.jTextField_Width.setText(String.valueOf(_paperSize.getWidth() / 100.0));
            this.jTextField_Height.setText(String.valueOf(_paperSize.getHeight() / 100.0));
        }

        //Set units
        this.jComboBox_WidthUnit.removeAllItems();
        this.jComboBox_WidthUnit.addItem("Inches");
        this.jComboBox_WidthUnit.setSelectedIndex(0);
        this.jComboBox_HeightUnit.removeAllItems();
        this.jComboBox_HeightUnit.addItem("Inches");
        this.jComboBox_HeightUnit.setSelectedIndex(0);

        _isLoading = false;
    }//GEN-LAST:event_formWindowOpened

    private void jComboBox_PageSizeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox_PageSizeActionPerformed
        // TODO add your handling code here:
        if (!_isLoading) {
            _paperSize = _paperSizeList.get(this.jComboBox_PageSize.getSelectedIndex());
            updatePaperSize();
        }
    }//GEN-LAST:event_jComboBox_PageSizeActionPerformed

    private void jRadioButton_ProtraitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton_ProtraitActionPerformed
        // TODO add your handling code here:
        _landscape = !this.jRadioButton_Protrait.isSelected();
        updatePaperSize();
    }//GEN-LAST:event_jRadioButton_ProtraitActionPerformed

    private void jRadioButton_LandscapeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton_LandscapeActionPerformed
        // TODO add your handling code here:
        _landscape = this.jRadioButton_Landscape.isSelected();
        updatePaperSize();
    }//GEN-LAST:event_jRadioButton_LandscapeActionPerformed

    private void jTextField_WidthActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField_WidthActionPerformed
        // TODO add your handling code here:
        if (_isCustom) {
            this.jComboBox_PageSize.setSelectedIndex(this.jComboBox_PageSize.getItemCount() - 1);
        }
    }//GEN-LAST:event_jTextField_WidthActionPerformed

    private void jTextField_HeightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField_HeightActionPerformed
        // TODO add your handling code here:
        if (_isCustom) {
            this.jComboBox_PageSize.setSelectedIndex(this.jComboBox_PageSize.getItemCount() - 1);
        }
    }//GEN-LAST:event_jTextField_HeightActionPerformed

    private void jButton_OKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_OKActionPerformed
        // TODO add your handling code here:
        if (_paperSize.getName().equals("Custom")) {
            if (_landscape) {
                _paperSize.setWidth((int) (Float.parseFloat(this.jTextField_Height.getText()) * 100));
                _paperSize.setHeight((int) (Float.parseFloat(this.jTextField_Width.getText()) * 100));
            } else {
                _paperSize.setWidth((int) (Float.parseFloat(this.jTextField_Width.getText()) * 100));
                _paperSize.setHeight((int) (Float.parseFloat(this.jTextField_Height.getText()) * 100));
            }
        } 
        
        _mapLayout.setPaperSize(_paperSize);
        _mapLayout.setLandscape(_landscape);
        _mapLayout.paintGraphics();

        //this.dispose();
    }//GEN-LAST:event_jButton_OKActionPerformed

    private void jButton_CancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_CancelActionPerformed
        // TODO add your handling code here:
        this.dispose();
    }//GEN-LAST:event_jButton_CancelActionPerformed

    // </editor-fold>
    // <editor-fold desc="Get Set Methods">
    /**
     * Set map layout
     * @param ml Map layout
     */
    public void setMapLayout(MapLayout ml){
        _mapLayout = ml;
    }
    
    /**
     * Get paper size
     *
     * @return Paper size
     */
    public PaperSize getPaperSize() {
        return _paperSize;
    }

    /**
     * Set paper size
     *
     * @param ps Paper size
     */
    public void setPaperSize(PaperSize ps) {
        _paperSize = ps;
    }

    /**
     * Get if is landscape
     *
     * @return Boolean
     */
    public boolean isLandscape() {
        return _landscape;
    }

    /**
     * Set if is landscape
     *
     * @param istrue Boolean
     */
    public void setLandscape(boolean istrue) {
        _landscape = istrue;
    }
    // </editor-fold>

    // <editor-fold desc="Methods">
    private void updatePaperSize() {
        _isCustom = false;

        if (this.jComboBox_PageSize.getSelectedIndex() == -1) {
            this.jComboBox_PageSize.setSelectedIndex(0);
        }
        if (_landscape) {
            this.jTextField_Width.setText(String.valueOf(_paperSize.getHeight() / 100.0));
            this.jTextField_Height.setText(String.valueOf(_paperSize.getWidth() / 100.0));
        } else {
            this.jTextField_Width.setText(String.valueOf(_paperSize.getWidth() / 100.0));
            this.jTextField_Height.setText(String.valueOf(_paperSize.getHeight() / 100.0));
        }

        _isCustom = true;
    }
    // </editor-fold>

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(FrmPageSet.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(FrmPageSet.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(FrmPageSet.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(FrmPageSet.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the dialog */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                FrmPageSet dialog = new FrmPageSet(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    @Override
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButton_Cancel;
    private javax.swing.JButton jButton_OK;
    private javax.swing.JComboBox jComboBox_HeightUnit;
    private javax.swing.JComboBox jComboBox_PageSize;
    private javax.swing.JComboBox jComboBox_WidthUnit;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JRadioButton jRadioButton_Landscape;
    private javax.swing.JRadioButton jRadioButton_Protrait;
    private javax.swing.JTextField jTextField_Height;
    private javax.swing.JTextField jTextField_Width;
    // End of variables declaration//GEN-END:variables
}
