/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.axis;

import java.util.ArrayList;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.axis.Axis;
import org.meteoinfo.global.DataConvert;

public class LonLatAxis
extends Axis
implements Cloneable {
    private boolean drawDegreeSymbol = true;
    private boolean longitude;

    public LonLatAxis(String label, boolean isX, boolean longitude) {
        super(label, isX);
        this.longitude = longitude;
    }

    public LonLatAxis(String label, boolean isX) {
        this(label, isX, isX);
    }

    public LonLatAxis(Axis axis) {
        this(axis.getLabel().getText(), axis.isXAxis());
        this.setAutoTick(axis.isAutoTick());
        this.setDrawLabel(axis.isDrawLabel());
        this.setDrawTickLabel(axis.isDrawTickLabel());
        this.setDrawTickLine(axis.isDrawTickLine());
        this.setInsideTick(axis.isInsideTick());
        this.setInverse(axis.isInverse());
        this.setLabelColor(axis.getLabelColor());
        this.setLineWidth(axis.getLineWidth());
        this.setLineStyle(axis.getLineStyle());
        this.setLocation(axis.getLocation());
        this.setMaxValue(axis.getMaxValue());
        this.setMinValue(axis.getMinValue());
        this.setMinorTickNum(axis.getMinorTickNum());
        this.setMinorTickVisible(axis.isMinorTickVisible());
        this.setShift(axis.getShift());
        this.setTickColor(axis.getTickColor());
        this.setTickDeltaValue(axis.getTickDeltaValue());
        this.setTickLabelColor(axis.getTickLabelColor());
        this.setTickLabelFont(axis.getTickLabelFont());
        this.setTickLength(axis.getTickLength());
        this.setVisible(axis.isVisible());
    }

    public boolean isDrawDegreeSymbol() {
        return this.drawDegreeSymbol;
    }

    public void setDrawDegreeSymbol(boolean value) {
        this.drawDegreeSymbol = value;
    }

    public boolean isLongitude() {
        return this.longitude;
    }

    public void setLongitude(boolean value) {
        this.longitude = value;
    }

    @Override
    public void updateTickLabels() {
        ArrayList<ChartText> tls = new ArrayList<ChartText>();
        for (double v : this.getTickValues()) {
            double value = v;
            if (value > 180.0) {
                value -= 360.0;
            }
            String lab = String.valueOf(value);
            lab = DataConvert.removeTailingZeros(lab);
            if (this.isLongitude()) {
                if (value == -180.0) {
                    lab = "180";
                } else if (value != 0.0 && value != 180.0) {
                    lab = lab.substring(0, 1).equals("-") ? lab.substring(1) + "W" : lab + "E";
                }
            } else if (value != 0.0) {
                lab = lab.substring(0, 1).equals("-") ? lab.substring(1) + "S" : lab + "N";
            }
            if (this.drawDegreeSymbol) {
                lab = lab.endsWith("E") || lab.endsWith("W") || lab.endsWith("N") || lab.endsWith("S") ? lab.substring(0, lab.length() - 1) + String.valueOf('\u00ba') + lab.substring(lab.length() - 1) : lab + String.valueOf('\u00ba');
            }
            tls.add(new ChartText(lab));
        }
        this.setTickLabels(tls);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (LonLatAxis)super.clone();
    }
}

