/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.meteoinfo.data.DataTypes;
import org.meteoinfo.data.TableData;
import org.meteoinfo.data.TimeTableData;
import org.meteoinfo.data.analysis.Statistics;
import org.meteoinfo.global.util.GlobalUtil;
import org.meteoinfo.table.DataColumn;
import org.meteoinfo.table.DataRow;
import org.meteoinfo.table.DataTable;
import ucar.ma2.Array;

public class TableUtil {
    public static TableData readASCIIFile(String fileName, String delimiter, int headerLines, String formatSpec, String encoding, boolean readVarNames) throws FileNotFoundException, IOException, Exception {
        TableData tableData = new TableData();
        BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), encoding));
        if (headerLines > 0) {
            for (int i = 0; i < headerLines; ++i) {
                sr.readLine();
            }
        }
        String title = sr.readLine().trim();
        if (encoding.equals("UTF8") && title.startsWith("\ufeff")) {
            title = title.substring(1);
        }
        String[] titleArray = GlobalUtil.split(title, delimiter);
        int colNum = titleArray.length;
        if (headerLines == -1 || !readVarNames) {
            for (int i = 0; i < colNum; ++i) {
                titleArray[i] = "Col_" + String.valueOf(i);
            }
        }
        boolean hasTimeCol = false;
        String tcolName = null;
        if (titleArray.length < 2) {
            System.out.println("File Format Error!");
            sr.close();
        } else {
            String[] colFormats;
            if (formatSpec == null) {
                colFormats = new String[colNum];
                for (int i = 0; i < colNum; ++i) {
                    colFormats[i] = "C";
                }
            } else {
                colFormats = formatSpec.split("%");
            }
            int idx = 0;
            boolean isBreak = false;
            for (String colFormat : colFormats) {
                if (colFormat.isEmpty()) continue;
                int num = 1;
                if (colFormat.length() > 1 && !colFormat.substring(0, 1).equals("{")) {
                    int index = colFormat.indexOf("{");
                    if (index < 0) {
                        index = colFormat.length() - 1;
                    }
                    num = Integer.parseInt(colFormat.substring(0, index));
                    colFormat = colFormat.substring(index);
                }
                for (int i = 0; i < num; ++i) {
                    String colName = titleArray[idx].trim();
                    if (colFormat.equals("C") || colFormat.equals("s")) {
                        tableData.addColumn(colName, DataTypes.String);
                    } else if (colFormat.equals("i")) {
                        tableData.addColumn(colName, DataTypes.Integer);
                    } else if (colFormat.equals("f")) {
                        tableData.addColumn(colName, DataTypes.Float);
                    } else if (colFormat.equals("d")) {
                        tableData.addColumn(colName, DataTypes.Double);
                    } else if (colFormat.equals("B")) {
                        tableData.addColumn(colName, DataTypes.Boolean);
                    } else if (colFormat.substring(0, 1).equals("{")) {
                        int eidx = colFormat.indexOf("}");
                        String formatStr = colFormat.substring(1, eidx);
                        tableData.addColumn(new DataColumn(colName, DataTypes.Date, formatStr));
                        hasTimeCol = true;
                        if (tcolName == null) {
                            tcolName = titleArray[idx];
                        }
                    } else {
                        tableData.addColumn(colName, DataTypes.String);
                    }
                    if (++idx != colNum) continue;
                    isBreak = true;
                    break;
                }
                if (isBreak) break;
            }
            if (idx < colNum) {
                for (int i = idx; i < colNum; ++i) {
                    tableData.addColumn(titleArray[i], DataTypes.String);
                }
            }
            int rn = 0;
            String line = headerLines == -1 || !readVarNames ? title : sr.readLine();
            while (line != null) {
                int i;
                if ((line = line.trim()).isEmpty()) {
                    line = sr.readLine();
                    continue;
                }
                String[] dataArray = GlobalUtil.split(line, delimiter);
                tableData.addRow();
                int cn = 0;
                for (i = 0; i < dataArray.length && cn < colNum; ++cn, ++i) {
                    tableData.setValue(rn, cn, (Object)dataArray[i]);
                }
                if (cn < colNum) {
                    for (i = cn; i < colNum; ++i) {
                        tableData.setValue(rn, i, (Object)"");
                    }
                }
                ++rn;
                line = sr.readLine();
            }
            sr.close();
        }
        if (hasTimeCol) {
            TimeTableData tTableData = new TimeTableData(tableData, tcolName);
            return tTableData;
        }
        return tableData;
    }

    public static TableData readASCIIFile(String fileName, String delimiter, int headerLines, String formatSpec, String encoding, boolean readVarNames, List<Object> usecolsin) throws FileNotFoundException, IOException, Exception {
        TableData tableData = new TableData();
        BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), encoding));
        if (headerLines > 0) {
            for (int i = 0; i < headerLines; ++i) {
                sr.readLine();
            }
        }
        String title = sr.readLine().trim();
        if (encoding.equals("UTF8") && title.startsWith("\ufeff")) {
            title = title.substring(1);
        }
        String[] titleArray1 = GlobalUtil.split(title, delimiter);
        ArrayList<Integer> usecols = new ArrayList<Integer>();
        if (usecolsin.get(0) instanceof Integer) {
            for (Object o : usecolsin) {
                usecols.add((Integer)o);
            }
        } else {
            ArrayList<String> titleArray2 = new ArrayList<String>(Arrays.asList(titleArray1));
            for (Object o : usecolsin) {
                int idx = titleArray2.indexOf((String)o);
                if (idx < 0) continue;
                usecols.add(idx);
            }
        }
        ArrayList<String> titleArray = new ArrayList<String>();
        for (int i = 0; i < titleArray1.length; ++i) {
            if (!usecols.contains(i)) continue;
            titleArray.add(titleArray1[i]);
        }
        int colNum = titleArray.size();
        if (headerLines == -1 || !readVarNames) {
            for (int i = 0; i < colNum; ++i) {
                titleArray.set(i, "Col_" + String.valueOf(i));
            }
        }
        boolean hasTimeCol = false;
        String tcolName = null;
        if (titleArray.size() < 2) {
            System.out.println("File Format Error!");
            sr.close();
        } else {
            String[] colFormats;
            if (formatSpec == null) {
                colFormats = new String[colNum];
                for (int i = 0; i < colNum; ++i) {
                    colFormats[i] = "C";
                }
            } else {
                colFormats = formatSpec.split("%");
            }
            int idx = 0;
            boolean isBreak = false;
            for (String colFormat : colFormats) {
                if (colFormat.isEmpty()) continue;
                int num = 1;
                if (colFormat.length() > 1 && !colFormat.substring(0, 1).equals("{")) {
                    int index = colFormat.indexOf("{");
                    if (index < 0) {
                        index = colFormat.length() - 1;
                    }
                    num = Integer.parseInt(colFormat.substring(0, index));
                    colFormat = colFormat.substring(index);
                }
                for (int i = 0; i < num; ++i) {
                    String colName = ((String)titleArray.get(idx)).trim();
                    if (colFormat.equals("C") || colFormat.equals("s")) {
                        tableData.addColumn(colName, DataTypes.String);
                    } else if (colFormat.equals("i")) {
                        tableData.addColumn(colName, DataTypes.Integer);
                    } else if (colFormat.equals("f")) {
                        tableData.addColumn(colName, DataTypes.Float);
                    } else if (colFormat.equals("d")) {
                        tableData.addColumn(colName, DataTypes.Double);
                    } else if (colFormat.equals("B")) {
                        tableData.addColumn(colName, DataTypes.Boolean);
                    } else if (colFormat.substring(0, 1).equals("{")) {
                        int eidx = colFormat.indexOf("}");
                        String formatStr = colFormat.substring(1, eidx);
                        tableData.addColumn(new DataColumn(colName, DataTypes.Date, formatStr));
                        hasTimeCol = true;
                        if (tcolName == null) {
                            tcolName = (String)titleArray.get(idx);
                        }
                    } else {
                        tableData.addColumn(colName, DataTypes.String);
                    }
                    if (++idx != colNum) continue;
                    isBreak = true;
                    break;
                }
                if (isBreak) break;
            }
            if (idx < colNum) {
                for (int i = idx; i < colNum; ++i) {
                    tableData.addColumn((String)titleArray.get(i), DataTypes.String);
                }
            }
            int rn = 0;
            String line = headerLines == -1 || !readVarNames ? title : sr.readLine();
            while (line != null) {
                int i;
                if ((line = line.trim()).isEmpty()) {
                    line = sr.readLine();
                    continue;
                }
                String[] dataArray = GlobalUtil.split(line, delimiter);
                tableData.addRow();
                int cn = 0;
                for (i = 0; i < dataArray.length && cn < colNum; ++i) {
                    if (!usecols.contains(i)) continue;
                    tableData.setValue(rn, cn, (Object)dataArray[i]);
                    ++cn;
                }
                if (cn < colNum) {
                    for (i = cn; i < colNum; ++i) {
                        tableData.setValue(rn, i, (Object)"");
                    }
                }
                ++rn;
                line = sr.readLine();
            }
            sr.close();
        }
        if (hasTimeCol) {
            TimeTableData tTableData = new TimeTableData(tableData, tcolName);
            return tTableData;
        }
        return tableData;
    }

    public static List<String> getFormats(String formatSpec) {
        String[] colFormats;
        if (formatSpec == null) {
            return null;
        }
        ArrayList<String> formats = new ArrayList<String>();
        for (String colFormat : colFormats = formatSpec.split("%")) {
            if (colFormat.isEmpty()) continue;
            if (colFormat.substring(0, 1).equals("{")) {
                int eidx = colFormat.indexOf("}");
                colFormat = colFormat.substring(1, eidx);
            } else {
                colFormat = "%" + colFormat;
            }
            formats.add(colFormat);
        }
        return formats;
    }

    public static DataTypes toDataTypes(String dt) {
        if (dt.contains("%")) {
            dt = dt.split("%")[1];
        }
        switch (dt.toLowerCase()) {
            case "c": 
            case "s": 
            case "string": {
                return DataTypes.String;
            }
            case "i": 
            case "int": {
                return DataTypes.Integer;
            }
            case "f": 
            case "float": {
                return DataTypes.Float;
            }
            case "d": 
            case "double": {
                return DataTypes.Double;
            }
        }
        if (dt.substring(0, 1).equals("{")) {
            return DataTypes.Date;
        }
        return DataTypes.String;
    }

    public static String getDateFormat(String dt) {
        int sidx = dt.indexOf("{");
        int eidx = dt.indexOf("}");
        String formatStr = dt.substring(sidx + 1, eidx);
        return formatStr;
    }

    public static DataTable ave_Month(List<Array> data, List<String> colNames, List<Date> time) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("YearMonth", DataTypes.String);
        for (String col : colNames) {
            rTable.addColumn(col, DataTypes.Double);
        }
        List<String> yms = TableUtil.getYearMonths(time);
        Calendar cal = Calendar.getInstance();
        for (String ym : yms) {
            int year = Integer.parseInt(ym.substring(0, 4));
            int month = Integer.parseInt(ym.substring(4));
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)ym);
            int col = 0;
            for (Array a : data) {
                ArrayList<Double> values = new ArrayList<Double>();
                for (int i = 0; i < time.size(); ++i) {
                    double v;
                    cal.setTime(time.get(i));
                    if (cal.get(1) != year || cal.get(2) != month - 1 || Double.isNaN(v = a.getDouble(i))) continue;
                    values.add(v);
                }
                nRow.setValue(colNames.get(col), (Object)Statistics.mean(values));
                ++col;
            }
        }
        return rTable;
    }

    public static List<String> getYearMonths(List<Date> time) {
        ArrayList<String> yms = new ArrayList<String>();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        for (Date t : time) {
            String ym = format.format(t);
            if (yms.contains(ym)) continue;
            yms.add(ym);
        }
        return yms;
    }
}

