/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.ArrayMath;
import org.meteoinfo.data.ArrayUtil;
import org.meteoinfo.data.DataMath;
import org.meteoinfo.data.DataTypes;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.XYListDataset;
import org.meteoinfo.data.mapdata.Field;
import org.meteoinfo.data.meteodata.StationInfoData;
import org.meteoinfo.data.meteodata.StationModel;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.drawing.ContourDraw;
import org.meteoinfo.drawing.Draw;
import org.meteoinfo.geoprocess.GeoComputation;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.layer.ImageLayer;
import org.meteoinfo.layer.LayerDrawType;
import org.meteoinfo.layer.RasterLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.layer.WorldFilePara;
import org.meteoinfo.legend.ArrowBreak;
import org.meteoinfo.legend.LegendManage;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.LegendType;
import org.meteoinfo.legend.MarkerType;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.shape.Graphic;
import org.meteoinfo.shape.ImageShape;
import org.meteoinfo.shape.PointShape;
import org.meteoinfo.shape.PointZ;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.PolylineShape;
import org.meteoinfo.shape.PolylineZShape;
import org.meteoinfo.shape.ShapeTypes;
import org.meteoinfo.shape.StationModelShape;
import org.meteoinfo.shape.WindArrow;
import org.meteoinfo.shape.WindBarb;
import ucar.ma2.Array;
import wContour.Contour;
import wContour.Global.PointD;
import wContour.Global.PolyLine;
import wContour.Global.Polygon;

public class DrawMeteoData {
    public static VectorLayer createPolylineLayer(XYListDataset data, LegendScheme ls, String layerName, String fieldName) {
        VectorLayer layer = new VectorLayer(ShapeTypes.Polyline);
        Field aDC = new Field(fieldName, DataTypes.Double);
        layer.editAddField(aDC);
        for (int i = 0; i < data.getSeriesCount(); ++i) {
            double[] xd = data.getXValues(i);
            double[] yd = data.getYValues(i);
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<org.meteoinfo.global.PointD> pList = new ArrayList<org.meteoinfo.global.PointD>();
            for (int j = 0; j < xd.length; ++j) {
                org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
                aPoint.X = xd[j];
                aPoint.Y = yd[j];
                pList.add(aPoint);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(i);
            aPolyline.setExtent(MIMath.getPointsExtent(pList));
            int shapeNum = layer.getShapeNum();
            try {
                if (!layer.editInsertShape(aPolyline, shapeNum)) continue;
                layer.editCellValue(fieldName, shapeNum, (Object)i);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        layer.setLayerName(layerName);
        ls.setFieldName(fieldName);
        layer.setLegendScheme(ls);
        return layer;
    }

    public static VectorLayer createPolylineLayer(List<Array> xdata, List<Array> ydata, LegendScheme ls, String layerName, String fieldName) {
        VectorLayer layer = new VectorLayer(ShapeTypes.Polyline);
        Field aDC = new Field(fieldName, DataTypes.Double);
        layer.editAddField(aDC);
        for (int i = 0; i < xdata.size(); ++i) {
            Array xd = xdata.get(i);
            Array yd = ydata.get(i);
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<org.meteoinfo.global.PointD> pList = new ArrayList<org.meteoinfo.global.PointD>();
            int j = 0;
            while ((long)j < xd.getSize()) {
                org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
                aPoint.X = xd.getDouble(j);
                aPoint.Y = yd.getDouble(j);
                pList.add(aPoint);
                ++j;
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(i);
            aPolyline.setExtent(MIMath.getPointsExtent(pList));
            int shapeNum = layer.getShapeNum();
            try {
                if (!layer.editInsertShape(aPolyline, shapeNum)) continue;
                layer.editCellValue(fieldName, shapeNum, (Object)i);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        layer.setLayerName(layerName);
        ls.setFieldName(fieldName);
        layer.setLegendScheme(ls);
        return layer;
    }

    public static VectorLayer createPolylineLayer(XYListDataset data, LegendScheme ls, String layerName, String fieldName, double westLon, double eastLon) {
        VectorLayer layer = new VectorLayer(ShapeTypes.Polyline);
        Field aDC = new Field(fieldName, DataTypes.Double);
        layer.editAddField(aDC);
        for (int i = 0; i < data.getSeriesCount(); ++i) {
            double[] xd = data.getXValues(i);
            double[] yd = data.getYValues(i);
            ArrayList<org.meteoinfo.global.PointD> pList = new ArrayList<org.meteoinfo.global.PointD>();
            ArrayList ppList = new ArrayList();
            double preLon = 0.0;
            for (int j = 0; j < xd.length; ++j) {
                org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
                aPoint.X = xd[j];
                aPoint.Y = yd[j];
                if (j == 0) {
                    preLon = xd[j];
                    pList.add(aPoint);
                    continue;
                }
                if (Math.abs(aPoint.X - preLon) > 350.0) {
                    if (aPoint.X > preLon) {
                        pList.add(new org.meteoinfo.global.PointD(westLon, aPoint.Y));
                    } else {
                        pList.add(new org.meteoinfo.global.PointD(eastLon, aPoint.Y));
                    }
                    if (pList.size() > 1) {
                        ppList.add(new ArrayList(pList));
                    }
                    pList.clear();
                    pList.add(aPoint);
                } else {
                    pList.add(aPoint);
                }
                preLon = xd[j];
            }
            if (pList.size() > 1) {
                ppList.add(pList);
            }
            for (List list : ppList) {
                PolylineShape aPolyline = new PolylineShape();
                aPolyline.setPoints(list);
                aPolyline.setValue(i);
                aPolyline.setExtent(MIMath.getPointsExtent(list));
                int shapeNum = layer.getShapeNum();
                try {
                    if (!layer.editInsertShape(aPolyline, shapeNum)) continue;
                    layer.editCellValue(fieldName, shapeNum, (Object)i);
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        layer.setLayerName(layerName);
        ls.setFieldName(fieldName);
        layer.setLegendScheme(ls);
        return layer;
    }

    public static VectorLayer createPolylineLayer(List<Array> xdata, List<Array> ydata, LegendScheme ls, String layerName, String fieldName, double westLon, double eastLon) {
        VectorLayer layer = new VectorLayer(ShapeTypes.Polyline);
        Field aDC = new Field(fieldName, DataTypes.Double);
        layer.editAddField(aDC);
        for (int i = 0; i < xdata.size(); ++i) {
            org.meteoinfo.global.PointD aPoint;
            double preLon;
            ArrayList<org.meteoinfo.global.PointD> pList;
            Array xd = xdata.get(i);
            Array yd = ydata.get(i);
            ArrayList ppList = new ArrayList();
            if (xd.getRank() == 1) {
                pList = new ArrayList<org.meteoinfo.global.PointD>();
                preLon = 0.0;
                int j = 0;
                while ((long)j < xd.getSize()) {
                    aPoint = new org.meteoinfo.global.PointD();
                    aPoint.X = xd.getDouble(j);
                    aPoint.Y = yd.getDouble(j);
                    if (j == 0) {
                        preLon = xd.getDouble(j);
                        pList.add(aPoint);
                    } else {
                        if (Double.isNaN(aPoint.X)) {
                            if (pList.size() > 1) {
                                ppList.add(new ArrayList(pList));
                            }
                            pList.clear();
                        } else if (Math.abs(aPoint.X - preLon) > 350.0) {
                            if (aPoint.X > preLon) {
                                pList.add(new org.meteoinfo.global.PointD(westLon, aPoint.Y));
                            } else {
                                pList.add(new org.meteoinfo.global.PointD(eastLon, aPoint.Y));
                            }
                            if (pList.size() > 1) {
                                ppList.add(new ArrayList(pList));
                            }
                            pList.clear();
                            pList.add(aPoint);
                        } else {
                            pList.add(aPoint);
                        }
                        preLon = xd.getDouble(j);
                    }
                    ++j;
                }
                if (pList.size() > 1) {
                    ppList.add(pList);
                }
            } else {
                int[] shape = xd.getShape();
                int ny = shape[0];
                int n = shape[1];
                for (int k = 0; k < ny; ++k) {
                    pList = new ArrayList();
                    preLon = 0.0;
                    for (int j = 0; j < n; ++j) {
                        aPoint = new org.meteoinfo.global.PointD();
                        aPoint.X = xd.getDouble(k * n + j);
                        aPoint.Y = yd.getDouble(k * n + j);
                        if (j == 0) {
                            preLon = aPoint.X;
                            pList.add(aPoint);
                            continue;
                        }
                        if (Double.isNaN(aPoint.X)) {
                            if (pList.size() > 1) {
                                ppList.add(new ArrayList(pList));
                            }
                            pList.clear();
                        } else if (Math.abs(aPoint.X - preLon) > 350.0) {
                            if (aPoint.X > preLon) {
                                pList.add(new org.meteoinfo.global.PointD(westLon, aPoint.Y));
                            } else {
                                pList.add(new org.meteoinfo.global.PointD(eastLon, aPoint.Y));
                            }
                            if (pList.size() > 1) {
                                ppList.add(new ArrayList(pList));
                            }
                            pList.clear();
                            pList.add(aPoint);
                        } else {
                            pList.add(aPoint);
                        }
                        preLon = xd.getDouble(j);
                    }
                    if (pList.size() <= 1) continue;
                    ppList.add(pList);
                }
            }
            int k = 0;
            for (List list : ppList) {
                PolylineShape aPolyline = new PolylineShape();
                aPolyline.setPoints(list);
                aPolyline.setValue(k);
                aPolyline.setExtent(MIMath.getPointsExtent(list));
                int shapeNum = layer.getShapeNum();
                try {
                    if (layer.editInsertShape(aPolyline, shapeNum)) {
                        layer.editCellValue(fieldName, shapeNum, (Object)k);
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
                ++k;
            }
        }
        layer.setLayerName(layerName);
        ls.setFieldName(fieldName);
        layer.setLegendScheme(ls);
        return layer;
    }

    public static VectorLayer createPolylineLayer(Array xdata, Array ydata, Array zdata, LegendScheme ls, String layerName, String fieldName, double westLon, double eastLon) {
        PointZ aPoint;
        double preLon;
        ArrayList<PointZ> pList;
        VectorLayer layer = new VectorLayer(ShapeTypes.PolylineZ);
        Field aDC = new Field(fieldName, DataTypes.Double);
        layer.editAddField(aDC);
        ArrayList ppList = new ArrayList();
        if (xdata.getRank() == 1) {
            pList = new ArrayList<PointZ>();
            preLon = 0.0;
            int j = 0;
            while ((long)j < xdata.getSize()) {
                aPoint = new PointZ();
                aPoint.X = xdata.getDouble(j);
                aPoint.Y = ydata.getDouble(j);
                aPoint.Z = zdata.getDouble(j);
                if (j == 0) {
                    preLon = xdata.getDouble(j);
                    pList.add(aPoint);
                } else {
                    if (Double.isNaN(aPoint.X)) {
                        if (pList.size() > 1) {
                            ppList.add(new ArrayList(pList));
                        }
                        pList.clear();
                    } else if (Math.abs(aPoint.X - preLon) > 350.0) {
                        if (aPoint.X > preLon) {
                            pList.add(new PointZ(westLon, aPoint.Y, aPoint.Z));
                        } else {
                            pList.add(new PointZ(eastLon, aPoint.Y, aPoint.Z));
                        }
                        if (pList.size() > 1) {
                            ppList.add(new ArrayList(pList));
                        }
                        pList.clear();
                        pList.add(aPoint);
                    } else {
                        pList.add(aPoint);
                    }
                    preLon = xdata.getDouble(j);
                }
                ++j;
            }
            if (pList.size() > 1) {
                ppList.add(pList);
            }
        } else {
            int[] shape = xdata.getShape();
            int n = shape[0];
            int nx = shape[1];
            for (int i = 0; i < n; ++i) {
                pList = new ArrayList();
                preLon = 0.0;
                for (int j = 0; j < nx; ++j) {
                    aPoint = new PointZ();
                    aPoint.X = xdata.getDouble(i * nx + j);
                    aPoint.Y = ydata.getDouble(i * nx + j);
                    aPoint.Z = zdata.getDouble(i * nx + j);
                    if (j == 0) {
                        preLon = aPoint.X;
                        pList.add(aPoint);
                        continue;
                    }
                    if (Double.isNaN(aPoint.X)) {
                        if (pList.size() > 1) {
                            ppList.add(new ArrayList(pList));
                        }
                        pList.clear();
                    } else if (Math.abs(aPoint.X - preLon) > 350.0) {
                        if (aPoint.X > preLon) {
                            pList.add(new PointZ(westLon, aPoint.Y, aPoint.Z));
                        } else {
                            pList.add(new PointZ(eastLon, aPoint.Y, aPoint.Z));
                        }
                        if (pList.size() > 1) {
                            ppList.add(new ArrayList(pList));
                        }
                        pList.clear();
                        pList.add(aPoint);
                    } else {
                        pList.add(aPoint);
                    }
                    preLon = xdata.getDouble(j);
                }
                if (pList.size() <= 1) continue;
                ppList.add(pList);
            }
        }
        for (List list : ppList) {
            PolylineZShape aPolyline = new PolylineZShape();
            aPolyline.setPoints(list);
            aPolyline.setValue(0.0);
            aPolyline.setExtent(MIMath.getPointsExtent(list));
            int shapeNum = layer.getShapeNum();
            try {
                if (!layer.editInsertShape(aPolyline, shapeNum)) continue;
                layer.editCellValue(fieldName, shapeNum, (Object)0);
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        layer.setLayerName(layerName);
        layer.setLegendScheme(ls);
        return layer;
    }

    public static VectorLayer createContourLayer(GridData gridData, String lName, String fieldName) {
        LegendScheme ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.UniqueValue, ShapeTypes.Polyline);
        return DrawMeteoData.createContourLayer(gridData, ls, lName, fieldName, true);
    }

    public static VectorLayer createContourLayer(GridData gridData, String lName, String fieldName, boolean isSmooth) {
        LegendScheme ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.UniqueValue, ShapeTypes.Polyline);
        return DrawMeteoData.createContourLayer(gridData, ls, lName, fieldName, isSmooth);
    }

    public static VectorLayer createContourLayer(Array data, Array x, Array y, LegendScheme aLS, String lName, String fieldName, boolean isSmooth) {
        GridData gridData = new GridData(data, x, y);
        return DrawMeteoData.createContourLayer(gridData, aLS, lName, fieldName, isSmooth);
    }

    public static VectorLayer createContourLayer(GridData gridData, LegendScheme aLS, String lName, String fieldName, boolean isSmooth) {
        int[][] S1;
        LegendScheme ls = aLS.convertTo(ShapeTypes.Polyline);
        Object[] ccs = LegendManage.getContoursAndColors(ls);
        double[] cValues = (double[])ccs[0];
        Object[] cbs = ContourDraw.tracingContourLines(gridData.data, cValues, gridData.xArray, gridData.yArray, gridData.missingValue, S1 = new int[gridData.data.length][gridData.data[0].length]);
        List ContourLines = (List)cbs[0];
        if (ContourLines.isEmpty()) {
            return null;
        }
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Polyline);
        Field aDC = new Field(fieldName, DataTypes.Double);
        aLayer.editAddField(aDC);
        for (int i = 0; i < ContourLines.size(); ++i) {
            PolyLine aLine = (PolyLine)ContourLines.get(i);
            double aValue = aLine.Value;
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<org.meteoinfo.global.PointD> pList = new ArrayList<org.meteoinfo.global.PointD>();
            for (int j = 0; j < aLine.PointList.size(); ++j) {
                org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
                aPoint.X = ((PointD)aLine.PointList.get((int)j)).X;
                aPoint.Y = ((PointD)aLine.PointList.get((int)j)).Y;
                pList.add(aPoint);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(aValue);
            aPolyline.setExtent(MIMath.getPointsExtent(pList));
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape(aPolyline, shapeNum)) continue;
                aLayer.editCellValue(fieldName, shapeNum, (Object)aValue);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(lName);
        ls.setFieldName(fieldName);
        aLayer.setLegendScheme(ls);
        aLayer.setLayerDrawType(LayerDrawType.Contour);
        aLayer.getLabelSet().setDrawLabels(true);
        aLayer.getLabelSet().setDrawShadow(true);
        aLayer.getLabelSet().setShadowColor(Color.white);
        aLayer.getLabelSet().setYOffset(3);
        aLayer.getLabelSet().setFieldName(fieldName);
        aLayer.getLabelSet().setColorByLegend(true);
        aLayer.getLabelSet().setDynamicContourLabel(true);
        int decimaln = MIMath.getDecimalNum(cValues[0]);
        if (cValues.length > 1) {
            int decimaln2 = MIMath.getDecimalNum(cValues[1] - cValues[0]);
            decimaln = Math.max(decimaln, decimaln2);
        }
        aLayer.getLabelSet().setDecimalDigits(decimaln);
        return aLayer;
    }

    public static VectorLayer createContourLayer(double[][] data, double[] xArray, double[] yArray, double missingValue, LegendScheme aLS, String lName, String fieldName, boolean isSmooth) {
        int[][] S1;
        LegendScheme ls = aLS.convertTo(ShapeTypes.Polyline);
        Object[] ccs = LegendManage.getContoursAndColors(ls);
        double[] cValues = (double[])ccs[0];
        Object[] cbs = ContourDraw.tracingContourLines(data, cValues, xArray, yArray, missingValue, S1 = new int[data.length][data[0].length]);
        List ContourLines = (List)cbs[0];
        if (ContourLines.isEmpty()) {
            return null;
        }
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Polyline);
        Field aDC = new Field(fieldName, DataTypes.Double);
        aLayer.editAddField(aDC);
        for (PolyLine aLine : ContourLines) {
            double aValue = aLine.Value;
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<org.meteoinfo.global.PointD> pList = new ArrayList<org.meteoinfo.global.PointD>();
            for (PointD p : aLine.PointList) {
                org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
                aPoint.X = p.X;
                aPoint.Y = p.Y;
                pList.add(aPoint);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(aValue);
            aPolyline.setExtent(MIMath.getPointsExtent(pList));
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape(aPolyline, shapeNum)) continue;
                aLayer.editCellValue(fieldName, shapeNum, (Object)aValue);
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(lName);
        ls.setFieldName(fieldName);
        aLayer.setLegendScheme(ls);
        aLayer.setLayerDrawType(LayerDrawType.Contour);
        aLayer.getLabelSet().setDrawLabels(true);
        aLayer.getLabelSet().setDrawShadow(true);
        aLayer.getLabelSet().setShadowColor(Color.white);
        aLayer.getLabelSet().setYOffset(3);
        aLayer.getLabelSet().setFieldName(fieldName);
        aLayer.getLabelSet().setColorByLegend(true);
        aLayer.getLabelSet().setDynamicContourLabel(true);
        return aLayer;
    }

    public static VectorLayer createShadedLayer(GridData gridData, String lName, String fieldName) {
        LegendScheme ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.GraduatedColor, ShapeTypes.Polygon);
        return DrawMeteoData.createShadedLayer(gridData, ls, lName, fieldName, true);
    }

    public static VectorLayer createShadedLayer(GridData gridData, String lName, String fieldName, boolean isSmooth) {
        LegendScheme ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.GraduatedColor, ShapeTypes.Polygon);
        return DrawMeteoData.createShadedLayer(gridData, ls, lName, fieldName, isSmooth);
    }

    public static VectorLayer createShadedLayer(Array data, Array x, Array y, LegendScheme aLS, String lName, String fieldName, boolean isSmooth) {
        GridData gridData = new GridData(data, x, y);
        return DrawMeteoData.createShadedLayer(gridData, aLS, lName, fieldName, isSmooth);
    }

    public static VectorLayer createShadedLayer(GridData gridData, LegendScheme aLS, String lName, String fieldName, boolean isSmooth) {
        LegendScheme ls = aLS.convertTo(ShapeTypes.Polygon);
        Object[] ccs = LegendManage.getContoursAndColors(ls);
        double[] cValues = (double[])ccs[0];
        double[] maxmin = new double[2];
        gridData.getMaxMinValue(maxmin);
        double maxData = maxmin[0];
        double minData = maxmin[1];
        int[][] S1 = new int[gridData.data.length][gridData.data[0].length];
        Object[] cbs = ContourDraw.tracingContourLines(gridData.data, cValues, gridData.xArray, gridData.yArray, gridData.missingValue, S1);
        List ContourLines = (List)cbs[0];
        List borders = (List)cbs[1];
        if (isSmooth) {
            ContourLines = Contour.smoothLines((List)ContourLines);
        }
        List<Polygon> ContourPolygons = ContourDraw.tracingPolygons(gridData.data, ContourLines, borders, cValues);
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Polygon);
        Field aDC = new Field(fieldName + "_Low", DataTypes.Double);
        aLayer.editAddField(aDC);
        aDC = new Field(fieldName + "_High", DataTypes.Double);
        aLayer.editAddField(aDC);
        for (Polygon aPolygon : ContourPolygons) {
            int valueIdx;
            org.meteoinfo.global.PointD aPoint;
            double aValue = aPolygon.LowValue;
            ArrayList<org.meteoinfo.global.PointD> pList = new ArrayList<org.meteoinfo.global.PointD>();
            for (Object pointList : aPolygon.OutLine.PointList) {
                aPoint = new org.meteoinfo.global.PointD();
                aPoint.X = ((PointD)pointList).X;
                aPoint.Y = ((PointD)pointList).Y;
                pList.add(aPoint);
            }
            if (!GeoComputation.isClockwise(pList)) {
                Collections.reverse(pList);
            }
            PolygonShape aPolygonShape = new PolygonShape();
            aPolygonShape.setPoints(pList);
            aPolygonShape.setExtent(MIMath.getPointsExtent(pList));
            aPolygonShape.lowValue = aValue;
            if (aPolygon.HasHoles()) {
                for (PolyLine holeLine : aPolygon.HoleLines) {
                    if (holeLine.PointList.size() < 3) continue;
                    pList = new ArrayList();
                    for (PointD pointList : holeLine.PointList) {
                        aPoint = new org.meteoinfo.global.PointD();
                        aPoint.X = pointList.X;
                        aPoint.Y = pointList.Y;
                        pList.add(aPoint);
                    }
                    aPolygonShape.addHole(pList, 0);
                }
            }
            if ((valueIdx = Arrays.binarySearch(cValues, aValue)) < 0) {
                valueIdx = -valueIdx - 1;
            }
            aPolygonShape.highValue = valueIdx >= cValues.length - 1 ? maxData : cValues[valueIdx + 1];
            if (!aPolygon.IsHighCenter && aPolygon.HighValue == aPolygon.LowValue) {
                aPolygonShape.highValue = aValue;
                aPolygonShape.lowValue = valueIdx == 0 ? minData : cValues[valueIdx - 1];
            }
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape(aPolygonShape, shapeNum)) continue;
                aLayer.editCellValue(fieldName + "_Low", shapeNum, (Object)aPolygonShape.lowValue);
                aLayer.editCellValue(fieldName + "_High", shapeNum, (Object)aPolygonShape.highValue);
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(lName);
        ls.setFieldName(fieldName + "_Low");
        aLayer.setLegendScheme(ls);
        aLayer.setLayerDrawType(LayerDrawType.Shaded);
        return aLayer;
    }

    public static VectorLayer createGridFillLayer(GridData gridData, String lName, String fieldName) {
        LegendScheme ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.GraduatedColor, ShapeTypes.Polygon);
        return DrawMeteoData.createGridFillLayer(gridData, ls, lName, fieldName);
    }

    public static VectorLayer createGridFillLayer(GridData gridData, LegendScheme aLS, String lName, String fieldName) {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Polygon);
        Field aDC = new Field(fieldName, DataTypes.Double);
        aLayer.editAddField(aDC);
        double XDelt = gridData.xArray[1] - gridData.xArray[0];
        double YDelt = gridData.yArray[1] - gridData.yArray[0];
        for (int i = 0; i < gridData.getYNum(); ++i) {
            for (int j = 0; j < gridData.getXNum(); ++j) {
                ArrayList<org.meteoinfo.global.PointD> PList = new ArrayList<org.meteoinfo.global.PointD>();
                org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
                aPoint.X = gridData.xArray[j] - XDelt / 2.0;
                aPoint.Y = gridData.yArray[i] - YDelt / 2.0;
                PList.add(aPoint);
                aPoint = new org.meteoinfo.global.PointD();
                aPoint.X = gridData.xArray[j] - XDelt / 2.0;
                aPoint.Y = gridData.yArray[i] + YDelt / 2.0;
                PList.add(aPoint);
                aPoint = new org.meteoinfo.global.PointD();
                aPoint.X = gridData.xArray[j] + XDelt / 2.0;
                aPoint.Y = gridData.yArray[i] + YDelt / 2.0;
                PList.add(aPoint);
                aPoint = new org.meteoinfo.global.PointD();
                aPoint.X = gridData.xArray[j] + XDelt / 2.0;
                aPoint.Y = gridData.yArray[i] - YDelt / 2.0;
                PList.add(aPoint);
                PList.add((org.meteoinfo.global.PointD)PList.get(0));
                PolygonShape aPGS = new PolygonShape();
                aPGS.highValue = aPGS.lowValue = gridData.data[i][j];
                aPGS.setPoints(PList);
                int shapeNum = aLayer.getShapeNum();
                try {
                    if (!aLayer.editInsertShape(aPGS, shapeNum)) continue;
                    aLayer.editCellValue(fieldName, shapeNum, (Object)gridData.data[i][j]);
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        aLayer.setLayerName(lName);
        aLS.setFieldName(fieldName);
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.Polygon));
        aLayer.setLayerDrawType(LayerDrawType.GridFill);
        return aLayer;
    }

    public static VectorLayer createGridFillLayer(Array x_s, Array y_s, Array a, LegendScheme ls, String lName, String fieldName) {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Polygon);
        Field aDC = new Field(fieldName, DataTypes.Double);
        aLayer.editAddField(aDC);
        int colNum = (int)x_s.getSize();
        int rowNum = (int)y_s.getSize();
        double x1 = 0.0;
        double y1 = 0.0;
        for (int i = 0; i < rowNum; ++i) {
            double yd;
            double y2;
            if (i == 0) {
                y1 = y_s.getDouble(i);
            }
            double y = y_s.getDouble(i);
            if (i < rowNum - 1) {
                y2 = y_s.getDouble(i + 1);
                yd = y2 - y;
            } else {
                y2 = y_s.getDouble(i - 1);
                yd = y - y2;
            }
            if (i == 0) {
                y1 -= yd * 0.5;
            }
            y2 = y + yd * 0.5;
            for (int j = 0; j < colNum; ++j) {
                double v;
                double xd;
                double x2;
                if (j == 0) {
                    x1 = x_s.getDouble(j);
                }
                double x = x_s.getDouble(j);
                if (j < colNum - 1) {
                    x2 = x_s.getDouble(j + 1);
                    xd = x2 - x;
                } else {
                    x2 = x_s.getDouble(j - 1);
                    xd = x - x2;
                }
                x2 = x + xd * 0.5;
                PolygonShape ps = new PolygonShape();
                ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                points.add(new org.meteoinfo.global.PointD(x1, y1));
                points.add(new org.meteoinfo.global.PointD(x1, y2));
                points.add(new org.meteoinfo.global.PointD(x2, y2));
                points.add(new org.meteoinfo.global.PointD(x2, y1));
                points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                ps.setPoints(points);
                ps.lowValue = v = a.getDouble(i * colNum + j);
                ps.highValue = v;
                int shapeNum = aLayer.getShapeNum();
                try {
                    if (aLayer.editInsertShape(ps, shapeNum)) {
                        aLayer.editCellValue(fieldName, shapeNum, (Object)v);
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
                x1 = x2;
            }
            y1 = y2;
        }
        aLayer.setLayerName(lName);
        ls.setFieldName(fieldName);
        aLayer.setLegendScheme(ls.convertTo(ShapeTypes.Polygon));
        aLayer.setLayerDrawType(LayerDrawType.GridFill);
        return aLayer;
    }

    public static VectorLayer createGridPointLayer(GridData gridData, String lName, String fieldName) {
        LegendScheme ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.GraduatedColor, ShapeTypes.Point);
        return DrawMeteoData.createGridPointLayer(gridData, ls, lName, fieldName);
    }

    public static VectorLayer createGridPointLayer(GridData gridData, LegendScheme aLS, String lName, String fieldName) {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Point);
        Field aDC = new Field(fieldName, DataTypes.Double);
        aLayer.editAddField(aDC);
        for (int i = 0; i < gridData.getYNum(); ++i) {
            for (int j = 0; j < gridData.getXNum(); ++j) {
                org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
                aPoint.X = gridData.xArray[j];
                aPoint.Y = gridData.yArray[i];
                PointShape aPointShape = new PointShape();
                aPointShape.setPoint(aPoint);
                aPointShape.setValue(gridData.data[i][j]);
                int shapeNum = aLayer.getShapeNum();
                try {
                    if (!aLayer.editInsertShape(aPointShape, shapeNum)) continue;
                    aLayer.editCellValue(fieldName, shapeNum, (Object)gridData.data[i][j]);
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        aLayer.setLayerName(lName);
        aLS.setFieldName(fieldName);
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.Point));
        aLayer.setLayerDrawType(LayerDrawType.GridPoint);
        return aLayer;
    }

    public static VectorLayer createGridVectorLayer(GridData uData, GridData vData, String lName, boolean isUV) {
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Point, Color.blue, 10.0f);
        ls.asArrow();
        return DrawMeteoData.createGridVectorLayer(uData, vData, uData, ls, false, lName, isUV);
    }

    public static VectorLayer createGridVectorLayer(GridData uData, GridData vData, LegendScheme ls, String lName, boolean isUV) {
        ls.asArrow();
        return DrawMeteoData.createGridVectorLayer(uData, vData, uData, ls, false, lName, isUV);
    }

    public static VectorLayer createGridVectorLayer(GridData uData, GridData vData, GridData gridData, String lName, boolean isUV) {
        LegendScheme ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.GraduatedColor, ShapeTypes.Point);
        for (int i = 0; i < ls.getBreakNum(); ++i) {
            PointBreak aPB = (PointBreak)ls.getLegendBreaks().get(i);
            aPB.setSize(10.0f);
            ls.setLegendBreak(i, new ArrowBreak(aPB));
        }
        return DrawMeteoData.createGridVectorLayer(uData, vData, gridData, ls, true, lName, isUV);
    }

    public static VectorLayer createGridVectorLayer(GridData uData, GridData vData, GridData gridData, LegendScheme ls, String lName, boolean isUV) {
        ls.asArrow();
        return DrawMeteoData.createGridVectorLayer(uData, vData, gridData, ls, true, lName, isUV);
    }

    public static VectorLayer createGridVectorLayer(GridData uData, GridData vData, GridData gridData, LegendScheme ls, boolean ifColor, String lName, boolean isUV) {
        int i;
        GridData windSpeedData;
        GridData windDirData;
        if (isUV) {
            GridData[] uv = DataMath.getDSFromUV(uData, vData);
            windDirData = uv[0];
            windSpeedData = uv[1];
        } else {
            windDirData = uData;
            windSpeedData = vData;
        }
        float size = 6.0f;
        int XNum = uData.xArray.length;
        int YNum = uData.yArray.length;
        String columnName = lName.split("_")[0];
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Point);
        if (isUV) {
            aLayer.editAddField("U", DataTypes.Float);
            aLayer.editAddField("V", DataTypes.Float);
        }
        aLayer.editAddField("WindDirection", DataTypes.Float);
        aLayer.editAddField("WindSpeed", DataTypes.Float);
        boolean ifAdd = true;
        if (aLayer.getFieldNames().contains(columnName)) {
            ifAdd = false;
        }
        if (ifColor && ifAdd) {
            aLayer.editAddField(columnName, DataTypes.Float);
        }
        for (i = 0; i < YNum; ++i) {
            for (int j = 0; j < XNum; ++j) {
                double windDir = windDirData.data[i][j];
                double windSpeed = windSpeedData.data[i][j];
                if (MIMath.doubleEquals(windDir, windDirData.missingValue) || MIMath.doubleEquals(windSpeed, windSpeedData.missingValue)) continue;
                org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
                aPoint.X = uData.xArray[j];
                aPoint.Y = uData.yArray[i];
                WindArrow aArraw = new WindArrow();
                aArraw.angle = windDir;
                aArraw.length = (float)windSpeed;
                aArraw.size = size;
                aArraw.setPoint(aPoint);
                if (ifColor) {
                    aArraw.setValue(gridData.data[i][j]);
                }
                int shapeNum = aLayer.getShapeNum();
                try {
                    if (!aLayer.editInsertShape(aArraw, shapeNum)) continue;
                    if (isUV) {
                        aLayer.editCellValue("U", shapeNum, (Object)uData.data[i][j]);
                        aLayer.editCellValue("V", shapeNum, (Object)vData.data[i][j]);
                    }
                    aLayer.editCellValue("WindDirection", shapeNum, (Object)aArraw.angle);
                    aLayer.editCellValue("WindSpeed", shapeNum, (Object)Float.valueOf(aArraw.length));
                    if (!ifColor || !ifAdd) continue;
                    aLayer.editCellValue(columnName, shapeNum, (Object)gridData.data[i][j]);
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        aLayer.setLayerName(lName);
        if (ifColor && ifAdd) {
            ls.setFieldName(columnName);
        } else {
            ls.setFieldName("WindSpeed");
        }
        LegendScheme nls = ls.convertTo(ShapeTypes.Point);
        nls.asArrow();
        if (ls.getShapeType() != nls.getShapeType()) {
            for (i = 0; i < nls.getBreakNum(); ++i) {
                PointBreak aPB = (PointBreak)nls.getLegendBreaks().get(i);
                aPB.setSize(10.0f);
            }
        }
        aLayer.setLegendScheme(nls);
        aLayer.setLayerDrawType(LayerDrawType.Vector);
        return aLayer;
    }

    public static VectorLayer createGridBarbLayer(GridData uData, GridData vData, String lName, boolean isUV) {
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Point, Color.blue, 10.0f);
        ls.asArrow();
        return DrawMeteoData.createGridBarbLayer(uData, vData, uData, ls, false, lName, isUV);
    }

    public static VectorLayer createGridBarbLayer(GridData uData, GridData vData, LegendScheme ls, String lName, boolean isUV) {
        ls.asArrow();
        return DrawMeteoData.createGridBarbLayer(uData, vData, uData, ls, false, lName, isUV);
    }

    public static VectorLayer createGridBarbLayer(GridData uData, GridData vData, GridData gridData, String lName, boolean isUV) {
        LegendScheme ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.GraduatedColor, ShapeTypes.Point);
        for (int i = 0; i < ls.getBreakNum(); ++i) {
            PointBreak aPB = (PointBreak)ls.getLegendBreaks().get(i);
            aPB.setSize(10.0f);
        }
        return DrawMeteoData.createGridBarbLayer(uData, vData, gridData, ls, true, lName, isUV);
    }

    public static VectorLayer createGridBarbLayer(GridData uData, GridData vData, GridData gridData, LegendScheme aLS, String lName, boolean isUV) {
        return DrawMeteoData.createGridBarbLayer(uData, vData, gridData, aLS, true, lName, isUV);
    }

    public static VectorLayer createGridBarbLayer(GridData uData, GridData vData, GridData gridData, LegendScheme aLS, boolean ifColor, String lName, boolean isUV) {
        int i;
        GridData windSpeedData;
        GridData windDirData;
        if (isUV) {
            GridData[] wwData = DataMath.getDSFromUV(uData, vData);
            windDirData = wwData[0];
            windSpeedData = wwData[1];
        } else {
            windDirData = uData;
            windSpeedData = vData;
        }
        int XNum = windDirData.xArray.length;
        int YNum = windDirData.yArray.length;
        String columnName = lName.split("_")[0];
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Point);
        if (isUV) {
            aLayer.editAddField("U", DataTypes.Float);
            aLayer.editAddField("V", DataTypes.Float);
        }
        aLayer.editAddField("WindDirection", DataTypes.Float);
        aLayer.editAddField("WindSpeed", DataTypes.Float);
        boolean ifAdd = true;
        if (aLayer.getFieldNames().contains(columnName)) {
            ifAdd = false;
        }
        if (ifColor && ifAdd) {
            aLayer.editAddField(columnName, DataTypes.Float);
        }
        for (i = 0; i < YNum; ++i) {
            for (int j = 0; j < XNum; ++j) {
                double windDir = windDirData.data[i][j];
                double windSpeed = windSpeedData.data[i][j];
                if (MIMath.doubleEquals(windDir, windDirData.missingValue) || MIMath.doubleEquals(windSpeed, windSpeedData.missingValue)) continue;
                org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
                aPoint.X = windDirData.xArray[j];
                aPoint.Y = windDirData.yArray[i];
                WindBarb aWB = Draw.calWindBarb((float)windDir, (float)windSpeed, 0.0, 10.0f, aPoint);
                if (ifColor) {
                    aWB.setValue(gridData.data[i][j]);
                }
                int shapeNum = aLayer.getShapeNum();
                try {
                    if (!aLayer.editInsertShape(aWB, shapeNum)) continue;
                    if (isUV) {
                        aLayer.editCellValue("U", shapeNum, (Object)uData.data[i][j]);
                        aLayer.editCellValue("V", shapeNum, (Object)vData.data[i][j]);
                    }
                    aLayer.editCellValue("WindDirection", shapeNum, (Object)aWB.angle);
                    aLayer.editCellValue("WindSpeed", shapeNum, (Object)Float.valueOf(aWB.windSpeed));
                    if (!ifColor || !ifAdd) continue;
                    aLayer.editCellValue(columnName, shapeNum, (Object)gridData.data[i][j]);
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        aLayer.setLayerName(lName);
        if (ifColor && ifAdd) {
            aLS.setFieldName(columnName);
        } else {
            aLS.setFieldName("WindSpeed");
        }
        LegendScheme ls = aLS.convertTo(ShapeTypes.Point);
        if (aLS.getShapeType() != ls.getShapeType()) {
            for (i = 0; i < ls.getBreakNum(); ++i) {
                PointBreak aPB = (PointBreak)ls.getLegendBreaks().get(i);
                aPB.setSize(10.0f);
            }
        }
        aLayer.setLegendScheme(ls);
        aLayer.setLayerDrawType(LayerDrawType.Barb);
        return aLayer;
    }

    public static VectorLayer createStreamlineLayer(GridData uData, GridData vData, String lName, boolean isUV) {
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Polyline, Color.blue, 1.0f);
        return DrawMeteoData.createStreamlineLayer(uData, vData, 4, ls, lName, isUV);
    }

    public static VectorLayer createStreamlineLayer(GridData uData, GridData vData, int density, String lName, boolean isUV) {
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Polyline, Color.blue, 1.0f);
        return DrawMeteoData.createStreamlineLayer(uData, vData, density, ls, lName, isUV);
    }

    public static VectorLayer createStreamlineLayer(Array u, Array v, Array x, Array y, int density, LegendScheme aLS, String lName, boolean isUV) {
        GridData uData = new GridData(u, x, y);
        GridData vData = new GridData(v, x, y);
        return DrawMeteoData.createStreamlineLayer(uData, vData, density, aLS, lName, isUV);
    }

    public static VectorLayer createStreamlineLayer(GridData uData, GridData vData, int density, LegendScheme aLS, String lName, boolean isUV) {
        GridData vGridData;
        GridData uGridData;
        if (isUV) {
            uGridData = uData;
            vGridData = vData;
        } else {
            GridData[] uvData = DataMath.getUVFromDS(uData, vData);
            uGridData = uvData[0];
            vGridData = uvData[1];
        }
        List streamlines = Contour.tracingStreamline((double[][])uGridData.data, (double[][])vGridData.data, (double[])uGridData.xArray, (double[])vGridData.yArray, (double)uGridData.missingValue, (int)density);
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Polyline);
        aLayer.editAddField("ID", DataTypes.Integer);
        for (int i = 0; i < streamlines.size() - 1; ++i) {
            PolyLine aLine = (PolyLine)streamlines.get(i);
            PolylineShape aPolyline = new PolylineShape();
            ArrayList<org.meteoinfo.global.PointD> pList = new ArrayList<org.meteoinfo.global.PointD>();
            for (int j = 0; j < aLine.PointList.size(); ++j) {
                org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
                aPoint.X = ((PointD)aLine.PointList.get((int)j)).X;
                aPoint.Y = ((PointD)aLine.PointList.get((int)j)).Y;
                pList.add(aPoint);
            }
            aPolyline.setPoints(pList);
            aPolyline.setValue(density);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape(aPolyline, shapeNum)) continue;
                aLayer.editCellValue("ID", shapeNum, (Object)(shapeNum + 1));
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(lName);
        aLS.setFieldName("ID");
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.Polyline));
        aLayer.setLayerDrawType(LayerDrawType.Streamline);
        return aLayer;
    }

    public static ImageLayer createImageLayer(Array x, Array y, Graphic graphic, String layerName) {
        BufferedImage image = ((ImageShape)graphic.getShape()).getImage();
        return DrawMeteoData.createImageLayer(x, y, image, layerName);
    }

    public static ImageLayer createImageLayer(Array x, Array y, BufferedImage image, String layerName) {
        ImageLayer aImageLayer = new ImageLayer();
        aImageLayer.setImage(image);
        aImageLayer.setLayerName(layerName);
        aImageLayer.setVisible(true);
        WorldFilePara aWFP = new WorldFilePara();
        double xdelta = x.getDouble(1) - x.getDouble(0);
        double ydelta = y.getDouble(1) - y.getDouble(0);
        aWFP.xUL = x.getDouble(0) - xdelta / 2.0;
        aWFP.yUL = y.getDouble(y.getShape()[0] - 1) + ydelta / 2.0;
        aWFP.xScale = xdelta;
        aWFP.yScale = -ydelta;
        aWFP.xRotate = 0.0;
        aWFP.yRotate = 0.0;
        aImageLayer.setWorldFilePara(aWFP);
        double XBR = (double)aImageLayer.getImage().getWidth() * aImageLayer.getWorldFilePara().xScale + aImageLayer.getWorldFilePara().xUL;
        double YBR = (double)aImageLayer.getImage().getHeight() * aImageLayer.getWorldFilePara().yScale + aImageLayer.getWorldFilePara().yUL;
        Extent aExtent = new Extent();
        aExtent.minX = aImageLayer.getWorldFilePara().xUL;
        aExtent.minY = YBR;
        aExtent.maxX = XBR;
        aExtent.maxY = aImageLayer.getWorldFilePara().yUL;
        aImageLayer.setExtent(aExtent);
        aImageLayer.setLayerDrawType(LayerDrawType.Image);
        aImageLayer.setMaskout(true);
        return aImageLayer;
    }

    public static RasterLayer createRasterLayer(GridData gridData, String lName) {
        LegendScheme ls;
        boolean isUnique = gridData.testUniqueValues();
        if (isUnique) {
            List<Number> values = gridData.getUniqueValues();
            ls = LegendManage.createUniqValueLegendScheme(values, ShapeTypes.Polygon);
        } else {
            ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.GraduatedColor, ShapeTypes.Polygon);
        }
        return DrawMeteoData.createRasterLayer(gridData, lName, ls);
    }

    public static RasterLayer createRasterLayer(GridArray gridData, String lName) {
        LegendScheme ls;
        boolean isUnique = gridData.testUniqueValues();
        if (isUnique) {
            List<Number> values = gridData.getUniqueValues();
            ls = LegendManage.createUniqValueLegendScheme(values, ShapeTypes.Polygon);
        } else {
            ls = LegendManage.createLegendSchemeFromGridData(gridData, LegendType.GraduatedColor, ShapeTypes.Polygon);
        }
        return DrawMeteoData.createRasterLayer(gridData, lName, ls);
    }

    public static RasterLayer createRasterLayer(GridArray gridData, String LName, LegendScheme aLS) {
        RasterLayer aRLayer = new RasterLayer();
        aRLayer.setGridData(gridData);
        aRLayer.setShapeType(ShapeTypes.Image);
        aRLayer.setLegendScheme(aLS.convertTo(ShapeTypes.Image));
        aRLayer.setLayerName(LName);
        aRLayer.setVisible(true);
        aRLayer.setLayerDrawType(LayerDrawType.Raster);
        aRLayer.setMaskout(true);
        return aRLayer;
    }

    public static RasterLayer createRasterLayer(GridData gridData, String LName, LegendScheme aLS) {
        RasterLayer aRLayer = new RasterLayer();
        aRLayer.setGridData(gridData.toGridArray());
        aRLayer.setShapeType(ShapeTypes.Image);
        aRLayer.setLegendScheme(aLS.convertTo(ShapeTypes.Image));
        aRLayer.setLayerName(LName);
        aRLayer.setVisible(true);
        aRLayer.setLayerDrawType(LayerDrawType.Raster);
        aRLayer.setMaskout(true);
        return aRLayer;
    }

    public static RasterLayer createRasterLayer(GridData gridData, String LName, String paletteFile) {
        RasterLayer aRLayer = new RasterLayer();
        aRLayer.setGridData(gridData.toGridArray());
        aRLayer.setPalette(paletteFile);
        aRLayer.setLayerName(LName);
        aRLayer.setVisible(true);
        aRLayer.setLayerDrawType(LayerDrawType.Raster);
        aRLayer.setMaskout(true);
        return aRLayer;
    }

    public static VectorLayer createSTPointLayer(StationData stationData, String lName, String fieldName) {
        LegendScheme ls = LegendManage.createLegendSchemeFromStationData(stationData, LegendType.GraduatedColor, ShapeTypes.Point);
        return DrawMeteoData.createSTPointLayer(stationData, ls, lName, fieldName);
    }

    public static VectorLayer createSTPointLayer(Array data, Array x, Array y, LegendScheme aLS, String lName, String fieldName) {
        if (data.getRank() == 2 && x.getRank() == 1) {
            Array[] xy = ArrayUtil.meshgrid(x, y);
            x = xy[0];
            y = xy[1];
        }
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Point);
        aLayer.editAddField(fieldName, DataTypes.Double);
        int i = 0;
        while ((long)i < data.getSize()) {
            org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
            aPoint.X = x.getDouble(i);
            aPoint.Y = y.getDouble(i);
            if (!Double.isNaN(aPoint.X)) {
                PointShape aPointShape = new PointShape();
                aPointShape.setPoint(aPoint);
                aPointShape.setValue(data.getDouble(i));
                int shapeNum = aLayer.getShapeNum();
                try {
                    if (aLayer.editInsertShape(aPointShape, shapeNum)) {
                        aLayer.editCellValue(fieldName, shapeNum, (Object)data.getDouble(i));
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            ++i;
        }
        aLayer.setLayerName(lName);
        aLS.setFieldName(fieldName);
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.Point));
        aLayer.setLayerDrawType(LayerDrawType.StationPoint);
        return aLayer;
    }

    public static VectorLayer createSTPointLayer(StationData stationData, LegendScheme aLS, String lName, String fieldName) {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Point);
        aLayer.editAddField("Stid", DataTypes.String);
        aLayer.editAddField(fieldName, DataTypes.Double);
        for (int i = 0; i < stationData.data.length; ++i) {
            org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
            aPoint.X = stationData.data[i][0];
            aPoint.Y = stationData.data[i][1];
            if (Double.isNaN(aPoint.X)) continue;
            PointShape aPointShape = new PointShape();
            aPointShape.setPoint(aPoint);
            aPointShape.setValue(stationData.data[i][2]);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape(aPointShape, shapeNum)) continue;
                aLayer.editCellValue("Stid", shapeNum, (Object)stationData.stations.get(i));
                aLayer.editCellValue(fieldName, shapeNum, (Object)stationData.data[i][2]);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(lName);
        aLS.setFieldName(fieldName);
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.Point));
        aLayer.setLayerDrawType(LayerDrawType.StationPoint);
        return aLayer;
    }

    public static VectorLayer createSTPointLayer_Unique(Array data, Array x, Array y, LegendScheme aLS, String lName, String fieldName) {
        if (data.getRank() == 2 && x.getRank() == 1) {
            Array[] xy = ArrayUtil.meshgrid(x, y);
            x = xy[0];
            y = xy[1];
        }
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Point);
        aLayer.editAddField("ID", DataTypes.Integer);
        aLayer.editAddField(fieldName, DataTypes.Double);
        int i = 0;
        while ((long)i < data.getSize()) {
            org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
            aPoint.X = x.getDouble(i);
            aPoint.Y = y.getDouble(i);
            if (!Double.isNaN(aPoint.X)) {
                PointShape aPointShape = new PointShape();
                aPointShape.setPoint(aPoint);
                aPointShape.setValue(data.getDouble(i));
                int shapeNum = aLayer.getShapeNum();
                try {
                    if (aLayer.editInsertShape(aPointShape, shapeNum)) {
                        aLayer.editCellValue("ID", shapeNum, (Object)i);
                        aLayer.editCellValue(fieldName, shapeNum, (Object)data.getDouble(i));
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            ++i;
        }
        aLayer.setLayerName(lName);
        aLS.setFieldName("ID");
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.Point));
        aLayer.setLayerDrawType(LayerDrawType.StationPoint);
        return aLayer;
    }

    public static VectorLayer createSTPointLayer_Unique(StationData stationData, LegendScheme aLS, String lName, String fieldName) {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Point);
        aLayer.editAddField("ID", DataTypes.Integer);
        aLayer.editAddField("Stid", DataTypes.String);
        aLayer.editAddField(fieldName, DataTypes.Double);
        for (int i = 0; i < stationData.data.length; ++i) {
            org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
            aPoint.X = stationData.data[i][0];
            aPoint.Y = stationData.data[i][1];
            if (Double.isNaN(aPoint.X)) continue;
            PointShape aPointShape = new PointShape();
            aPointShape.setPoint(aPoint);
            aPointShape.setValue(stationData.data[i][2]);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape(aPointShape, shapeNum)) continue;
                aLayer.editCellValue("ID", shapeNum, (Object)i);
                aLayer.editCellValue("Stid", shapeNum, (Object)stationData.stations.get(i));
                aLayer.editCellValue(fieldName, shapeNum, (Object)stationData.data[i][2]);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(lName);
        aLS.setFieldName("ID");
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.Point));
        aLayer.setLayerDrawType(LayerDrawType.StationPoint);
        return aLayer;
    }

    public static VectorLayer createSTInfoLayer(StationInfoData stInfoData, String layerName) {
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Point, Color.red, 8.0f);
        return DrawMeteoData.createSTInfoLayer(stInfoData, ls, layerName);
    }

    public static VectorLayer createSTInfoLayer(StationInfoData stInfoData, LegendScheme aLS, String layerName) {
        int i;
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Point);
        for (i = 0; i < stInfoData.getFields().size(); ++i) {
            String fieldName = stInfoData.getFields().get(i);
            DataTypes dtype = DataTypes.String;
            if (stInfoData.getVariables().contains(stInfoData.getFields().get(i))) {
                dtype = DataTypes.Double;
            }
            aLayer.editAddField(fieldName, dtype);
        }
        for (i = 0; i < stInfoData.getDataList().size(); ++i) {
            List<String> dataList = stInfoData.getDataList().get(i);
            org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
            aPoint.X = Double.parseDouble(dataList.get(1));
            aPoint.Y = Double.parseDouble(dataList.get(2));
            PointShape aPointShape = new PointShape();
            aPointShape.setPoint(aPoint);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape(aPointShape, shapeNum)) continue;
                for (int j = 0; j < stInfoData.getFields().size(); ++j) {
                    if (stInfoData.getVariables().contains(stInfoData.getFields().get(j))) {
                        double v = dataList.size() <= j ? -9999.0 : (dataList.get(j).isEmpty() ? -9999.0 : Double.parseDouble(dataList.get(j)));
                        aLayer.editCellValue(stInfoData.getFields().get(j), shapeNum, (Object)v);
                        continue;
                    }
                    aLayer.editCellValue(stInfoData.getFields().get(j), shapeNum, (Object)dataList.get(j));
                }
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(layerName);
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.Point));
        aLayer.setLayerDrawType(LayerDrawType.StationPoint);
        return aLayer;
    }

    public static VectorLayer createSTVectorLayer(StationData uData, StationData vData, StationData stData, String layerName, boolean isUV) {
        LegendScheme ls = LegendManage.createLegendSchemeFromStationData(stData, LegendType.GraduatedColor, ShapeTypes.Point);
        for (int i = 0; i < ls.getLegendBreaks().size(); ++i) {
            PointBreak aPB = (PointBreak)ls.getLegendBreaks().get(i);
            aPB.setSize(10.0f);
        }
        return DrawMeteoData.createSTVectorLayer(uData, vData, stData, ls, layerName, isUV);
    }

    public static VectorLayer createSTVectorLayer(StationData uData, StationData vData, StationData stData, LegendScheme aLS, String layerName, boolean isUV) {
        StationData windSpeedData;
        StationData windDirData;
        aLS.asArrow();
        if (isUV) {
            StationData[] dsData = DataMath.getDSFromUV(uData, vData);
            windDirData = dsData[0];
            windSpeedData = dsData[1];
        } else {
            windDirData = uData;
            windSpeedData = vData;
        }
        String columnName = layerName.split("_")[0];
        VectorLayer aLayer = new VectorLayer(ShapeTypes.WindArraw);
        if (isUV) {
            aLayer.editAddField("U", DataTypes.Float);
            aLayer.editAddField("V", DataTypes.Float);
        }
        aLayer.editAddField("WindDirection", DataTypes.Float);
        aLayer.editAddField("WindSpeed", DataTypes.Float);
        boolean ifAdd = true;
        if (aLayer.getFieldNames().contains(columnName)) {
            ifAdd = false;
        }
        if (ifAdd) {
            aLayer.editAddField(columnName, DataTypes.Float);
        }
        for (int i = 0; i < windDirData.getStNum(); ++i) {
            float windDir = (float)windDirData.data[i][2];
            float windSpeed = (float)windSpeedData.data[i][2];
            if (MIMath.doubleEquals(windDir, windDirData.missingValue) || MIMath.doubleEquals(windSpeed, windSpeedData.missingValue)) continue;
            org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
            aPoint.X = windDirData.data[i][0];
            aPoint.Y = windDirData.data[i][1];
            WindArrow aArraw = new WindArrow();
            aArraw.angle = windDir;
            aArraw.length = windSpeed;
            aArraw.size = 6.0f;
            aArraw.setPoint(aPoint);
            aArraw.setValue(stData.data[i][2]);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape(aArraw, shapeNum)) continue;
                if (isUV) {
                    aLayer.editCellValue("U", shapeNum, (Object)uData.data[i][2]);
                    aLayer.editCellValue("V", shapeNum, (Object)vData.data[i][2]);
                }
                aLayer.editCellValue("WindDirection", shapeNum, (Object)Float.valueOf(windDir));
                aLayer.editCellValue("WindSpeed", shapeNum, (Object)Float.valueOf(windSpeed));
                if (!ifAdd) continue;
                aLayer.editCellValue(columnName, shapeNum, (Object)stData.data[i][2]);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(layerName);
        aLS.setFieldName(columnName);
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.Point));
        aLayer.setLayerDrawType(LayerDrawType.Vector);
        return aLayer;
    }

    public static VectorLayer createVectorLayer(Array xData, Array yData, Array uData, Array vData, Array stData, LegendScheme aLS, String layerName, boolean isUV) {
        Array windSpeedData;
        Array windDirData;
        if (isUV) {
            Array[] dsData = ArrayMath.uv2ds(uData, vData);
            windDirData = dsData[0];
            windSpeedData = dsData[1];
        } else {
            windDirData = uData;
            windSpeedData = vData;
        }
        String columnName = layerName.split("_")[0];
        VectorLayer aLayer = new VectorLayer(ShapeTypes.WindArraw);
        if (isUV) {
            aLayer.editAddField("U", DataTypes.Float);
            aLayer.editAddField("V", DataTypes.Float);
        }
        aLayer.editAddField("WindDirection", DataTypes.Float);
        aLayer.editAddField("WindSpeed", DataTypes.Float);
        boolean ifAdd = true;
        if (aLayer.getFieldNames().contains(columnName)) {
            ifAdd = false;
        }
        if (ifAdd) {
            aLayer.editAddField(columnName, DataTypes.Float);
        }
        int i = 0;
        while ((long)i < windDirData.getSize()) {
            double windDir = (float)windDirData.getDouble(i);
            double windSpeed = (float)windSpeedData.getDouble(i);
            if (!Double.isNaN(windDir) && !Double.isNaN(windSpeed)) {
                org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
                aPoint.X = xData.getDouble(i);
                aPoint.Y = yData.getDouble(i);
                WindArrow aArraw = new WindArrow();
                aArraw.angle = windDir;
                aArraw.length = (float)windSpeed;
                aArraw.size = 6.0f;
                aArraw.setPoint(aPoint);
                if (stData != null) {
                    aArraw.setValue(stData.getDouble(i));
                }
                int shapeNum = aLayer.getShapeNum();
                try {
                    if (aLayer.editInsertShape(aArraw, shapeNum)) {
                        if (isUV) {
                            aLayer.editCellValue("U", shapeNum, (Object)uData.getDouble(i));
                            aLayer.editCellValue("V", shapeNum, (Object)vData.getDouble(i));
                        }
                        aLayer.editCellValue("WindDirection", shapeNum, (Object)windDir);
                        aLayer.editCellValue("WindSpeed", shapeNum, (Object)windSpeed);
                        if (ifAdd && stData != null) {
                            aLayer.editCellValue(columnName, shapeNum, (Object)stData.getDouble(i));
                        }
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            ++i;
        }
        aLayer.setLayerName(layerName);
        aLS.setFieldName(columnName);
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.Point));
        aLayer.setLayerDrawType(LayerDrawType.Vector);
        return aLayer;
    }

    public static VectorLayer createBarbLayer(Array xData, Array yData, Array uData, Array vData, Array stData, LegendScheme aLS, String layerName, boolean isUV) {
        Array windSpeedData;
        Array windDirData;
        if (isUV) {
            Array[] dsData = ArrayMath.uv2ds(uData, vData);
            windDirData = dsData[0];
            windSpeedData = dsData[1];
        } else {
            windDirData = uData;
            windSpeedData = vData;
        }
        String columnName = layerName.split("_")[0];
        VectorLayer aLayer = new VectorLayer(ShapeTypes.WindArraw);
        if (isUV) {
            aLayer.editAddField("U", DataTypes.Float);
            aLayer.editAddField("V", DataTypes.Float);
        }
        aLayer.editAddField("WindDirection", DataTypes.Float);
        aLayer.editAddField("WindSpeed", DataTypes.Float);
        boolean ifAdd = true;
        if (aLayer.getFieldNames().contains(columnName)) {
            ifAdd = false;
        }
        if (ifAdd) {
            aLayer.editAddField(columnName, DataTypes.Float);
        }
        int i = 0;
        while ((long)i < windDirData.getSize()) {
            double windDir = (float)windDirData.getDouble(i);
            double windSpeed = (float)windSpeedData.getDouble(i);
            if (!Double.isNaN(windDir) && !Double.isNaN(windSpeed)) {
                org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
                aPoint.X = xData.getDouble(i);
                aPoint.Y = yData.getDouble(i);
                WindBarb aWB = Draw.calWindBarb((float)windDir, (float)windSpeed, 0.0, 10.0f, aPoint);
                if (stData != null) {
                    aWB.setValue(stData.getDouble(i));
                }
                int shapeNum = aLayer.getShapeNum();
                try {
                    if (aLayer.editInsertShape(aWB, shapeNum)) {
                        if (isUV) {
                            aLayer.editCellValue("U", shapeNum, (Object)uData.getDouble(i));
                            aLayer.editCellValue("V", shapeNum, (Object)vData.getDouble(i));
                        }
                        aLayer.editCellValue("WindDirection", shapeNum, (Object)aWB.angle);
                        aLayer.editCellValue("WindSpeed", shapeNum, (Object)Float.valueOf(aWB.windSpeed));
                        if (ifAdd && stData != null) {
                            aLayer.editCellValue(columnName, shapeNum, (Object)stData.getDouble(i));
                        }
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            ++i;
        }
        aLayer.setLayerName(layerName);
        aLS.setFieldName(columnName);
        aLayer.setLegendScheme(aLS.convertTo(ShapeTypes.Point));
        aLayer.setLayerDrawType(LayerDrawType.Barb);
        return aLayer;
    }

    public static VectorLayer createSTVectorLayer(StationData uData, StationData vData, String layerName, boolean isUV) {
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Point, Color.blue, 10.0f);
        return DrawMeteoData.createSTVectorLayer(uData, vData, ls, layerName, isUV);
    }

    public static VectorLayer createSTVectorLayer(StationData uData, StationData vData, LegendScheme aLS, String layerName, boolean isUV) {
        int i;
        StationData windSpeedData;
        StationData windDirData;
        aLS.asArrow();
        if (isUV) {
            StationData[] dsData = DataMath.getDSFromUV(uData, vData);
            windDirData = dsData[0];
            windSpeedData = dsData[1];
        } else {
            windDirData = uData;
            windSpeedData = vData;
        }
        String columnName = layerName.split("_")[0];
        VectorLayer aLayer = new VectorLayer(ShapeTypes.WindArraw);
        if (isUV) {
            aLayer.editAddField("U", DataTypes.Float);
            aLayer.editAddField("V", DataTypes.Float);
        }
        aLayer.editAddField("WindDirection", DataTypes.Float);
        aLayer.editAddField("WindSpeed", DataTypes.Float);
        for (i = 0; i < windDirData.getStNum(); ++i) {
            float windDir = (float)windDirData.data[i][2];
            float windSpeed = (float)windSpeedData.data[i][2];
            if (MIMath.doubleEquals(windDir, windDirData.missingValue) || MIMath.doubleEquals(windSpeed, windSpeedData.missingValue)) continue;
            org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
            aPoint.X = windDirData.data[i][0];
            aPoint.Y = windDirData.data[i][1];
            WindArrow aArraw = new WindArrow();
            aArraw.angle = windDir;
            aArraw.length = windSpeed;
            aArraw.size = 6.0f;
            aArraw.setPoint(aPoint);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape(aArraw, shapeNum)) continue;
                if (isUV) {
                    aLayer.editCellValue("U", shapeNum, (Object)uData.data[i][2]);
                    aLayer.editCellValue("V", shapeNum, (Object)vData.data[i][2]);
                }
                aLayer.editCellValue("WindDirection", shapeNum, (Object)Float.valueOf(windDir));
                aLayer.editCellValue("WindSpeed", shapeNum, (Object)Float.valueOf(windSpeed));
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(layerName);
        aLS.setFieldName(columnName);
        LegendScheme ls = aLS.convertTo(ShapeTypes.Point);
        if (aLS.getShapeType() != ls.getShapeType()) {
            for (i = 0; i < ls.getBreakNum(); ++i) {
                PointBreak aPB = (PointBreak)ls.getLegendBreaks().get(i);
                aPB.setSize(10.0f);
            }
        }
        aLayer.setLegendScheme(ls);
        aLayer.setLayerDrawType(LayerDrawType.Vector);
        return aLayer;
    }

    public static VectorLayer createSTBarbLayer(StationData uData, StationData vData, StationData stData, String layerName, boolean isUV) {
        LegendScheme ls = LegendManage.createLegendSchemeFromStationData(stData, LegendType.GraduatedColor, ShapeTypes.Point);
        for (int i = 0; i < ls.getLegendBreaks().size(); ++i) {
            PointBreak aPB = (PointBreak)ls.getLegendBreaks().get(i);
            aPB.setSize(10.0f);
        }
        return DrawMeteoData.createSTBarbLayer(uData, vData, stData, ls, layerName, isUV);
    }

    public static VectorLayer createSTBarbLayer(StationData uData, StationData vData, StationData stData, LegendScheme aLS, String layerName, boolean isUV) {
        int i;
        StationData windSpeedData;
        StationData windDirData;
        if (isUV) {
            StationData[] dsData = DataMath.getDSFromUV(uData, vData);
            windDirData = dsData[0];
            windSpeedData = dsData[1];
        } else {
            windDirData = uData;
            windSpeedData = vData;
        }
        String columnName = layerName.split("_")[0];
        VectorLayer aLayer = new VectorLayer(ShapeTypes.WindBarb);
        if (isUV) {
            aLayer.editAddField("U", DataTypes.Float);
            aLayer.editAddField("V", DataTypes.Float);
        }
        aLayer.editAddField("WindDirection", DataTypes.Float);
        aLayer.editAddField("WindSpeed", DataTypes.Float);
        boolean ifAdd = true;
        if (aLayer.getFieldNames().contains(columnName)) {
            ifAdd = false;
        }
        if (ifAdd) {
            aLayer.editAddField(columnName, DataTypes.Float);
        }
        for (i = 0; i < windDirData.getStNum(); ++i) {
            float windDir = (float)windDirData.data[i][2];
            float windSpeed = (float)windSpeedData.data[i][2];
            if (windSpeed == 0.0f || MIMath.doubleEquals(windDir, windDirData.missingValue) || MIMath.doubleEquals(windSpeed, windSpeedData.missingValue)) continue;
            org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
            aPoint.X = windDirData.data[i][0];
            aPoint.Y = windDirData.data[i][1];
            WindBarb aWB = Draw.calWindBarb(windDir, windSpeed, 0.0, 10.0f, aPoint);
            aWB.setValue(stData.data[i][2]);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape(aWB, shapeNum)) continue;
                if (isUV) {
                    aLayer.editCellValue("U", shapeNum, (Object)uData.data[i][2]);
                    aLayer.editCellValue("V", shapeNum, (Object)vData.data[i][2]);
                }
                aLayer.editCellValue("WindDirection", shapeNum, (Object)Float.valueOf(windDir));
                aLayer.editCellValue("WindSpeed", shapeNum, (Object)Float.valueOf(windSpeed));
                if (!ifAdd) continue;
                aLayer.editCellValue(columnName, shapeNum, (Object)stData.data[i][2]);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(layerName);
        aLS.setFieldName(columnName);
        LegendScheme ls = aLS.convertTo(ShapeTypes.Point);
        if (aLS.getShapeType() != ls.getShapeType()) {
            for (i = 0; i < ls.getBreakNum(); ++i) {
                PointBreak aPB = (PointBreak)ls.getLegendBreaks().get(i);
                aPB.setSize(10.0f);
            }
        }
        aLayer.setLegendScheme(ls);
        aLayer.setLayerDrawType(LayerDrawType.Barb);
        return aLayer;
    }

    public static VectorLayer createSTBarbLayer(StationData uData, StationData vData, String layerName, boolean isUV) {
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Point, Color.blue, 10.0f);
        return DrawMeteoData.createSTBarbLayer(uData, vData, ls, layerName, isUV);
    }

    public static VectorLayer createSTBarbLayer(StationData uData, StationData vData, LegendScheme aLS, String layerName, boolean isUV) {
        int i;
        StationData windSpeedData;
        StationData windDirData;
        if (isUV) {
            StationData[] dsData = DataMath.getDSFromUV(uData, vData);
            windDirData = dsData[0];
            windSpeedData = dsData[1];
        } else {
            windDirData = uData;
            windSpeedData = vData;
        }
        String columnName = layerName.split("_")[0];
        VectorLayer aLayer = new VectorLayer(ShapeTypes.WindBarb);
        if (isUV) {
            aLayer.editAddField("U", DataTypes.Float);
            aLayer.editAddField("V", DataTypes.Float);
        }
        aLayer.editAddField("WindDirection", DataTypes.Float);
        aLayer.editAddField("WindSpeed", DataTypes.Float);
        for (i = 0; i < windDirData.getStNum(); ++i) {
            float windDir = (float)windDirData.data[i][2];
            float windSpeed = (float)windSpeedData.data[i][2];
            if (windSpeed == 0.0f || MIMath.doubleEquals(windDir, windDirData.missingValue) || MIMath.doubleEquals(windSpeed, windSpeedData.missingValue)) continue;
            org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
            aPoint.X = windDirData.data[i][0];
            aPoint.Y = windDirData.data[i][1];
            WindBarb aWB = Draw.calWindBarb(windDir, windSpeed, 0.0, 10.0f, aPoint);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape(aWB, shapeNum)) continue;
                if (isUV) {
                    aLayer.editCellValue("U", shapeNum, (Object)uData.data[i][2]);
                    aLayer.editCellValue("V", shapeNum, (Object)vData.data[i][2]);
                }
                aLayer.editCellValue("WindDirection", shapeNum, (Object)Float.valueOf(windDir));
                aLayer.editCellValue("WindSpeed", shapeNum, (Object)Float.valueOf(windSpeed));
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(layerName);
        aLS.setFieldName(columnName);
        LegendScheme ls = aLS.convertTo(ShapeTypes.Point);
        if (aLS.getShapeType() != ls.getShapeType()) {
            for (i = 0; i < ls.getBreakNum(); ++i) {
                PointBreak aPB = (PointBreak)ls.getLegendBreaks().get(i);
                aPB.setSize(10.0f);
            }
        }
        aLayer.setLegendScheme(ls);
        aLayer.setLayerDrawType(LayerDrawType.Barb);
        return aLayer;
    }

    public static VectorLayer createStationModelLayer(StationModelData stationModelData, String layerName) {
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Point, Color.blue, 12.0f);
        return DrawMeteoData.createStationModelLayer(stationModelData, layerName, true);
    }

    public static VectorLayer createStationModelLayer(StationModelData stationModelData, String layerName, boolean isSurface) {
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Point, Color.blue, 12.0f);
        return DrawMeteoData.createStationModelLayer(stationModelData, ls, layerName, isSurface);
    }

    public static VectorLayer createStationModelLayer(StationModelData stationModelData, LegendScheme aLS, String layerName) {
        return DrawMeteoData.createStationModelLayer(stationModelData, aLS, layerName, true);
    }

    public static VectorLayer createStationModelLayer(StationModelData stationModelData, LegendScheme aLS, String layerName, boolean isSurface) {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Point);
        aLayer.editAddField(new Field("WindDirection", DataTypes.Float));
        aLayer.editAddField(new Field("WindSpeed", DataTypes.Float));
        aLayer.editAddField(new Field("Weather", DataTypes.Integer));
        aLayer.editAddField(new Field("Temperature", DataTypes.Integer));
        aLayer.editAddField(new Field("DewPoint", DataTypes.Integer));
        aLayer.editAddField(new Field("Pressure", DataTypes.Integer));
        aLayer.editAddField(new Field("CloudCoverage", DataTypes.Integer));
        for (int i = 0; i < stationModelData.getDataNum(); ++i) {
            StationModel sm = stationModelData.getData().get(i);
            float windDir = (float)sm.getWindDirection();
            float windSpeed = (float)sm.getWindSpeed();
            if (MIMath.doubleEquals(windDir, stationModelData.getMissingValue()) || MIMath.doubleEquals(windSpeed, stationModelData.getMissingValue())) continue;
            org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
            aPoint.X = (float)sm.getLongitude();
            aPoint.Y = (float)sm.getLatitude();
            int weather = (int)sm.getWeather();
            int cCover = (int)sm.getCloudCover();
            int temp = (int)sm.getTemperature();
            int dewPoint = (int)sm.getDewPoint();
            int pressure = (int)sm.getPressure();
            if (isSurface && !MIMath.doubleEquals(sm.getPressure(), stationModelData.getMissingValue())) {
                String pStr = String.valueOf((int)(sm.getPressure() * 10.0));
                if (pStr.length() < 3) {
                    pressure = (int)stationModelData.getMissingValue();
                } else {
                    pStr = pStr.substring(pStr.length() - 3);
                    pressure = Integer.parseInt(pStr);
                }
            }
            StationModelShape aSM = Draw.calStationModel(windDir, windSpeed, 0.0, 12.0f, aPoint, weather, temp, dewPoint, pressure, cCover);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape(aSM, shapeNum)) continue;
                aLayer.editCellValue("WindDirection", shapeNum, (Object)Float.valueOf(windDir));
                aLayer.editCellValue("WindSpeed", shapeNum, (Object)Float.valueOf(windSpeed));
                aLayer.editCellValue("Weather", shapeNum, (Object)weather);
                aLayer.editCellValue("Temperature", shapeNum, (Object)temp);
                aLayer.editCellValue("DewPoint", shapeNum, (Object)dewPoint);
                aLayer.editCellValue("Pressure", shapeNum, (Object)pressure);
                aLayer.editCellValue("CloudCoverage", shapeNum, (Object)cCover);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(layerName);
        aLS.setFieldName("");
        aLayer.setLegendScheme(aLS);
        aLayer.setAvoidCollision(true);
        aLayer.setLayerDrawType(LayerDrawType.StationModel);
        return aLayer;
    }

    public static VectorLayer createWeatherSymbolLayer(StationData weatherData, String layerName) {
        return DrawMeteoData.createWeatherSymbolLayer(weatherData, "All Weather", layerName);
    }

    public static VectorLayer createWeatherSymbolLayer(StationData weatherData, String WeatherType, String layerName) {
        List<Integer> wList = DrawMeteoData.getWeatherTypes(WeatherType);
        return DrawMeteoData.createWeatherSymbolLayer(weatherData, wList, layerName);
    }

    public static VectorLayer createWeatherSymbolLayer(StationData weatherData, List<Integer> wList, String layerName) {
        LegendScheme aLS = DrawMeteoData.createWeatherLegendScheme(wList, 20, Color.blue);
        return DrawMeteoData.createWeatherSymbolLayer(weatherData, wList, aLS, layerName);
    }

    public static VectorLayer createWeatherSymbolLayer(StationData weatherData, List<Integer> wList, LegendScheme aLS, String layerName) {
        String columnName = "Weather";
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Point);
        aLayer.editAddField(columnName, DataTypes.Double);
        for (int i = 0; i < weatherData.getStNum(); ++i) {
            int weather = (int)weatherData.data[i][2];
            if (MIMath.doubleEquals(weather, weatherData.missingValue) || !wList.contains(weather)) continue;
            org.meteoinfo.global.PointD aPoint = new org.meteoinfo.global.PointD();
            aPoint.X = weatherData.data[i][0];
            aPoint.Y = weatherData.data[i][1];
            PointShape aPS = new PointShape();
            aPS.setPoint(aPoint);
            aPS.setValue(weather);
            int shapeNum = aLayer.getShapeNum();
            try {
                if (!aLayer.editInsertShape(aPS, shapeNum)) continue;
                aLayer.editCellValue(columnName, shapeNum, (Object)weather);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(DrawMeteoData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName(layerName);
        aLS.setFieldName(columnName);
        aLayer.setLegendScheme(aLS);
        aLayer.setLayerDrawType(LayerDrawType.StationPoint);
        return aLayer;
    }

    public static LegendScheme createWeatherLegendScheme(List<Integer> wList, int size, Color color) {
        LegendScheme aLS = new LegendScheme(ShapeTypes.Point);
        aLS.setLegendType(LegendType.UniqueValue);
        for (int w : wList) {
            PointBreak aPB = new PointBreak();
            aPB.setMarkerType(MarkerType.Character);
            aPB.setSize(size);
            aPB.setColor(color);
            aPB.setFontName("Weather");
            aPB.setStartValue(w);
            aPB.setEndValue(w);
            int charIdx = w + 28;
            if (w == 99) {
                charIdx = w + 97;
            }
            aPB.setCharIndex(charIdx);
            aPB.setCaption(String.valueOf(w));
            aLS.getLegendBreaks().add(aPB);
        }
        return aLS;
    }

    public static List<Integer> getWeatherTypes(String weatherType) {
        int[] weathers;
        ArrayList<Integer> weatherList = new ArrayList<Integer>();
        switch (weatherType.toLowerCase()) {
            default: {
                int i;
                weathers = new int[96];
                for (i = 4; i < 100; ++i) {
                    weathers[i - 4] = i;
                }
                break;
            }
            case "sds": 
            case "dust": {
                weathers = new int[]{6, 7, 8, 9, 30, 31, 32, 33, 34, 35};
                break;
            }
            case "sds, haze": {
                weathers = new int[]{5, 6, 7, 8, 9, 30, 31, 32, 33, 34, 35};
                break;
            }
            case "smoke, haze, mist": {
                weathers = new int[]{4, 5, 10};
                break;
            }
            case "smoke": {
                weathers = new int[]{4};
                break;
            }
            case "haze": {
                weathers = new int[]{5};
                break;
            }
            case "mist": {
                weathers = new int[]{10};
                break;
            }
            case "Fog": {
                int i;
                weathers = new int[10];
                for (i = 40; i < 50; ++i) {
                    weathers[i - 40] = i;
                }
            }
        }
        for (Object w : (String)weathers) {
            weatherList.add((int)w);
        }
        return weatherList;
    }

    public static LegendScheme createCloudLegendScheme(int size, Color color) {
        int[] clouds;
        LegendScheme aLS = new LegendScheme(ShapeTypes.Point);
        aLS.setLegendType(LegendType.UniqueValue);
        for (int w : clouds = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}) {
            PointBreak aPB = new PointBreak();
            aPB.setMarkerType(MarkerType.Character);
            aPB.setSize(size);
            aPB.setColor(color);
            aPB.setFontName("Weather");
            aPB.setStartValue(w);
            aPB.setEndValue(w);
            int charIdx = w + 197;
            aPB.setCharIndex(charIdx);
            aPB.setCaption(String.valueOf(w));
            aLS.getLegendBreaks().add(aPB);
        }
        return aLS;
    }
}

