/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.meteoinfo.data.meteodata.Dimension;
import org.meteoinfo.data.meteodata.DimensionType;
import org.meteoinfo.global.util.DateUtil;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;

public class Variable
extends ucar.nc2.Variable {
    public int Number;
    private int _levelType;
    private List<Double> _levels;
    private String _units;
    private String _description;
    private String _hdfPath;
    private boolean _isStation = false;
    private boolean _isSwath = false;
    private int _varId;
    private boolean dimVar = false;
    private List<Integer> _levelIdxs = new ArrayList<Integer>();
    private List<Integer> _varInLevelIdxs = new ArrayList<Integer>();
    private double fill_value = -9999.0;
    private double scale_factor = 1.0;
    private double add_offset = 0.0;

    public Variable() {
        this.setShortName("null");
        this.setDataType(DataType.FLOAT);
        this._levels = new ArrayList<Double>();
        this._units = "null";
        this._description = "null";
    }

    public Variable(ucar.nc2.Variable from) {
        super(from);
        this._levels = new ArrayList<Double>();
        this._units = "null";
        this._description = "null";
    }

    public Variable(int aNum, String aName, String aDesc, String aUnit) {
        this.Number = aNum;
        this.setShortName(aName);
        this.setUnits(aUnit);
        this._description = aDesc;
        this._levels = new ArrayList<Double>();
    }

    public String getName() {
        return this.getShortName();
    }

    public String setName(String value) {
        this.setShortName(value);
        return value;
    }

    public int getLevelType() {
        return this._levelType;
    }

    public void setLevelType(int value) {
        this._levelType = value;
    }

    public List<Double> getLevels() {
        Dimension zDim = this.getZDimension();
        if (zDim == null) {
            return this._levels;
        }
        return zDim.getDimValue();
    }

    public void setLevels(List<Double> value) {
        this._levels = value;
        this.updateZDimension();
    }

    public String getUnits() {
        return this._units;
    }

    public void setUnits(String value) {
        this._units = value;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String value) {
        this._description = value;
    }

    public int getDimNumber() {
        return this.getDimensions().size();
    }

    public int getLevelNum() {
        Dimension zDim = this.getZDimension();
        if (zDim == null) {
            return 0;
        }
        return zDim.getLength();
    }

    public String getHDFPath() {
        return this._hdfPath;
    }

    public void setHDFPath(String value) {
        this._hdfPath = value;
    }

    public Dimension getXDimension() {
        return this.getDimension(DimensionType.X);
    }

    public void setXDimension(Dimension value) {
        this.setDimension(value, DimensionType.X);
    }

    public Dimension getYDimension() {
        return this.getDimension(DimensionType.Y);
    }

    public void setYDimension(Dimension value) {
        this.setDimension(value, DimensionType.Y);
    }

    public Dimension getZDimension() {
        return this.getDimension(DimensionType.Z);
    }

    public void setZDimension(Dimension value) {
        this.setDimension(value, DimensionType.Z);
    }

    public Dimension getTDimension() {
        return this.getDimension(DimensionType.T);
    }

    public void setTDimension(Dimension value) {
        this.setDimension(value, DimensionType.T);
    }

    public int[] getDimIds() {
        int[] dimids = new int[this.getDimensions().size()];
        for (int i = 0; i < this.getDimensions().size(); ++i) {
            dimids[i] = ((Dimension)this.getDimension(i)).getDimId();
        }
        return dimids;
    }

    public boolean isStation() {
        return this._isStation;
    }

    public void setStation(boolean value) {
        this._isStation = value;
    }

    public boolean isSwath() {
        return this._isSwath;
    }

    public void setSwath(boolean value) {
        this._isSwath = value;
    }

    public boolean isPlottable() {
        if (this._isStation) {
            return true;
        }
        if (this.getXDimension() == null) {
            return false;
        }
        return this.getYDimension() != null;
    }

    public int getAttNumber() {
        return this.getAttributes().size();
    }

    public int getVarId() {
        return this._varId;
    }

    public void setVarId(int value) {
        this._varId = value;
    }

    public boolean isDimVar() {
        return this.dimVar;
    }

    public void setDimVar(boolean value) {
        this.dimVar = value;
    }

    public List<Integer> getLevelIdxs() {
        return this._levelIdxs;
    }

    public void setLevelIdxs(List<Integer> value) {
        this._levelIdxs = value;
    }

    public List<Integer> getVarInLevelIdxs() {
        return this._varInLevelIdxs;
    }

    public void setVarInLevelIdxs(List<Integer> value) {
        this._varInLevelIdxs = value;
    }

    public double getFillValue() {
        return this.fill_value;
    }

    public void setFillValue(double value) {
        this.fill_value = value;
    }

    public double getScaleFactor() {
        return this.scale_factor;
    }

    public void setScaleFactor(double value) {
        this.scale_factor = value;
    }

    public double getAddOffset() {
        return this.add_offset;
    }

    public void setAddOffset(double value) {
        this.add_offset = value;
    }

    public Object clone() {
        Variable aPar = new Variable();
        aPar.Number = this.Number;
        aPar.setShortName(this.getShortName());
        aPar.setUnits(this._units);
        aPar.setDescription(this._description);
        aPar.setLevelType(this._levelType);
        aPar.getDimensions().addAll(this.getDimensions());
        aPar.setDimVar(this.dimVar);
        aPar.getLevels().addAll(this._levels);
        aPar.setVarId(this._varId);
        return aPar;
    }

    public boolean equals(Variable aVar) {
        if (!this.getShortName().equals(aVar.getShortName())) {
            return false;
        }
        if (this.Number != aVar.Number) {
            return false;
        }
        if (!this._description.equals(aVar.getDescription())) {
            return false;
        }
        return this._units.equals(aVar.getUnits());
    }

    public boolean tEquals(Variable aVar) {
        if (!this.getShortName().equals(aVar.getShortName())) {
            return false;
        }
        if (this.Number != aVar.Number) {
            return false;
        }
        if (!this._description.equals(aVar.getDescription())) {
            return false;
        }
        if (!this._units.equals(aVar.getUnits())) {
            return false;
        }
        return this._levelType == aVar.getLevelType();
    }

    public void addLevel(double levelValue) {
        if (!this._levels.contains(levelValue)) {
            this._levels.add(levelValue);
        }
    }

    public int getTrueLevelNumber() {
        if (this.getLevelNum() == 0) {
            return 1;
        }
        return this.getLevelNum();
    }

    public Dimension getDimension(DimensionType dimType) {
        for (int i = 0; i < this.getDimNumber(); ++i) {
            Dimension aDim = (Dimension)this.getDimension(i);
            if (aDim.getDimType() != dimType) continue;
            return aDim;
        }
        return null;
    }

    public void setDimension(String tstr, List<Number> values, boolean reverse) {
        DimensionType dType = DimensionType.Other;
        switch (tstr) {
            case "X": {
                dType = DimensionType.X;
                break;
            }
            case "Y": {
                dType = DimensionType.Y;
                break;
            }
            case "Z": {
                dType = DimensionType.Z;
                break;
            }
            case "T": {
                dType = DimensionType.T;
            }
        }
        Dimension dim = new Dimension("null", values.size(), dType);
        dim.setDimValues(values);
        dim.setReverse(reverse);
        this.setDimension(dim);
    }

    public void setDimension(String tstr, List<Number> values, boolean reverse, int index) {
        DimensionType dType = DimensionType.Other;
        switch (tstr) {
            case "X": {
                dType = DimensionType.X;
                break;
            }
            case "Y": {
                dType = DimensionType.Y;
                break;
            }
            case "Z": {
                dType = DimensionType.Z;
                break;
            }
            case "T": {
                dType = DimensionType.T;
            }
        }
        Dimension dim = new Dimension("null", values.size(), dType);
        dim.setDimValues(values);
        dim.setReverse(reverse);
        this.setDimension(dim, index);
    }

    public void setDimension(Dimension aDim) {
        if (aDim == null) {
            return;
        }
        if (aDim.getDimType() == DimensionType.Other) {
            this.addDimension(aDim);
        } else {
            boolean hasDim = false;
            for (int i = 0; i < this.getDimNumber(); ++i) {
                Dimension bDim = (Dimension)this.getDimension(i);
                if (bDim.getDimType() != aDim.getDimType()) continue;
                this.setDimension(i, aDim);
                hasDim = true;
                break;
            }
            if (!hasDim) {
                this.addDimension(aDim);
                this.resetShape();
            }
        }
    }

    public void setDimension(Dimension aDim, int idx) {
        if (aDim == null) {
            return;
        }
        if (this.getDimNumber() > idx) {
            this.setDimension(idx, aDim);
        } else {
            this.setDimension(aDim);
        }
        this.resetShape();
    }

    public void setDimension(Dimension aDim, DimensionType dimType) {
        if (aDim.getDimType() == dimType) {
            this.setDimension(aDim);
        }
    }

    public int getDimIndex(Dimension aDim) {
        int idx = -1;
        for (int i = 0; i < this.getDimNumber(); ++i) {
            if (!aDim.equals(this.getDimension(i))) continue;
            idx = i;
            break;
        }
        return idx;
    }

    public int getDimLength(int idx) {
        return this.getDimension(idx).getLength();
    }

    public boolean hasXtrackDimension() {
        boolean has = false;
        for (int i = 0; i < this.getDimNumber(); ++i) {
            if (((Dimension)this.getDimension(i)).getDimType() != DimensionType.Xtrack) continue;
            has = true;
            break;
        }
        return has;
    }

    public boolean hasDimension(int dimId) {
        for (int i = 0; i < this.getDimNumber(); ++i) {
            Dimension aDim = (Dimension)this.getDimension(i);
            if (aDim.getDimId() != dimId) continue;
            return true;
        }
        return false;
    }

    public boolean hasNullDimension() {
        for (int i = 0; i < this.getDimNumber(); ++i) {
            Dimension aDim = (Dimension)this.getDimension(i);
            if (aDim == null) {
                return true;
            }
            if (aDim.getShortName() == null) {
                return true;
            }
            if (!aDim.getShortName().equals("null")) continue;
            return true;
        }
        return false;
    }

    public boolean dimensionEquales(Variable var) {
        if (this.getDimNumber() != var.getDimNumber()) {
            return false;
        }
        for (int i = 0; i < this.getDimNumber(); ++i) {
            Dimension adim = (Dimension)this.getDimension(i);
            Dimension bdim = (Dimension)var.getDimension(i);
            if (adim.getShortName().equals(bdim.getShortName())) continue;
            return false;
        }
        return true;
    }

    public boolean dimensionSizeEquals(Variable var) {
        if (this.getDimNumber() != var.getDimNumber()) {
            return false;
        }
        for (int i = 0; i < this.getDimNumber(); ++i) {
            Dimension adim = (Dimension)this.getDimension(i);
            Dimension bdim = (Dimension)var.getDimension(i);
            if (adim.getLength() == bdim.getLength()) continue;
            return false;
        }
        return true;
    }

    public boolean dimensionContains(Variable var) {
        if (this.getDimNumber() < var.getDimNumber()) {
            return false;
        }
        int sidx = 0;
        if (this.getDimNumber() > var.getDimNumber()) {
            sidx = this.getDimNumber() - var.getDimNumber();
        }
        for (int i = sidx; i < var.getDimNumber(); ++i) {
            Dimension adim = (Dimension)this.getDimension(i);
            Dimension bdim = (Dimension)var.getDimension(i - sidx);
            if (adim.getLength() == bdim.getLength()) continue;
            return false;
        }
        return true;
    }

    public Dimension getLevelDimension(Variable var) {
        if (this.getDimNumber() > var.getDimNumber()) {
            for (int i = var.getDimNumber(); i < this.getDimNumber(); ++i) {
                Dimension dim = (Dimension)this.getDimension(i);
                if (dim.getDimType() != DimensionType.Other) continue;
                return dim;
            }
        }
        return null;
    }

    public List<Date> getTimes() {
        Dimension tDim = this.getTDimension();
        if (tDim == null) {
            return null;
        }
        List<Double> values = tDim.getDimValue();
        ArrayList<Date> times = new ArrayList<Date>();
        for (Double v : values) {
            times.add(DateUtil.fromOADate(v));
        }
        return times;
    }

    public int getAttributeIndex(String attName) {
        int idx = -1;
        for (int i = 0; i < this.getAttributes().size(); ++i) {
            if (!((Attribute)this.getAttributes().get(i)).getShortName().equalsIgnoreCase(attName)) continue;
            idx = i;
            break;
        }
        return idx;
    }

    public String getAttributeString(String attName) {
        String attStr = "";
        for (Attribute aAtt : this.getAttributes()) {
            if (!aAtt.getShortName().equalsIgnoreCase(attName)) continue;
            attStr = aAtt.toString();
        }
        return attStr;
    }

    public List<ucar.nc2.Dimension> toNCDimensions() {
        ArrayList<ucar.nc2.Dimension> dims = new ArrayList<ucar.nc2.Dimension>();
        for (int i = 0; i < this.getDimNumber(); ++i) {
            Dimension dim = (Dimension)this.getDimension(i);
            ucar.nc2.Dimension udim = new ucar.nc2.Dimension(dim.getShortName(), dim.getLength(), dim.isShared(), dim.isUnlimited(), dim.isVariableLength());
            dims.add(udim);
        }
        return dims;
    }

    public void addDimension(Dimension dim) {
        this.getDimensions().add(dim);
        this.resetShape();
    }

    public void addDimension(int idx, Dimension dim) {
        this.getDimensions().add(idx, dim);
        this.resetShape();
    }

    public void addDimension(DimensionType dType, List<Number> values) {
        Dimension dim = new Dimension("null", values.size(), dType);
        dim.setDimValues(values);
        this.addDimension(dim);
    }

    public void addDimension(String tstr, List<Number> values) {
        DimensionType dType = DimensionType.Other;
        switch (tstr) {
            case "X": {
                dType = DimensionType.X;
                break;
            }
            case "Y": {
                dType = DimensionType.Y;
                break;
            }
            case "Z": {
                dType = DimensionType.Z;
                break;
            }
            case "T": {
                dType = DimensionType.T;
            }
        }
        Dimension dim = new Dimension("null", values.size(), dType);
        dim.setDimValues(values);
        this.addDimension(dim);
    }

    public void addAttribute(String attName, List attValue) {
        Attribute aAtt = new Attribute(attName, attValue);
        this.addAttribute(aAtt);
    }

    public void addAttribute(String attName, String attValue) {
        Attribute aAtt = new Attribute(attName, attValue);
        this.addAttribute(aAtt);
    }

    public void addAttribute(String attName, double attValue) {
        Attribute aAtt = new Attribute(attName, (Number)attValue);
        this.addAttribute(aAtt);
    }

    public void updateZDimension() {
        if (this._levels.size() > 0) {
            Dimension zdim = new Dimension("null", 0, DimensionType.Z);
            zdim.setValues(this._levels);
            this.setZDimension(zdim);
        }
    }
}

