/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.grib.grib2;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.DataMath;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.grib.grib2.GRIB2MessageIndex;
import org.meteoinfo.global.Bytes2Number;
import org.meteoinfo.projection.info.ProjectionInfo;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2SectionIndicator;
import ucar.nc2.grib.grib2.Grib2SectionLocalUse;
import ucar.nc2.grib.grib2.Grib2SectionProductDefinition;
import ucar.unidata.io.RandomAccessFile;

public class GRIB2DataInfo
extends DataInfo
implements IGridDataInfo {
    private int _headerLength = 0;
    private List<GRIB2MessageIndex> _messageIdxList = new ArrayList<GRIB2MessageIndex>();
    private ProjectionInfo _projInfo;

    public GRIB2DataInfo() {
        this.setDataType(MeteoDataType.GRIB2);
    }

    public int getHeaderLength() {
        return this._headerLength;
    }

    public void setHeaderLength(int length) {
        this._headerLength = length;
    }

    @Override
    public void readDataInfo(String fileName) {
        this.setFileName(fileName);
        try {
            RandomAccessFile br = new RandomAccessFile(fileName, "r");
            br.seek((long)this._headerLength);
            boolean isNewTime = false;
            int recordNum = 0;
            int gridNum = 0;
            ArrayList times = new ArrayList();
            ArrayList variables = new ArrayList();
            while (br.getFilePointer() < br.length() - 30L) {
                Grib2SectionIndicator rINS = new Grib2SectionIndicator(br);
                long messageStart = rINS.getStartPos();
                long messageEnd = rINS.getEndPos();
                Grib2SectionIdentification rIDS = new Grib2SectionIdentification(br);
                while (this.readSectionNumber(br) != 8) {
                    int sectionNum = this.readSectionNumber(br);
                    GRIB2MessageIndex messageIdx = new GRIB2MessageIndex();
                    messageIdx.messagePos = messageStart;
                    messageIdx.dataPos = br.getFilePointer();
                    messageIdx.startSection = sectionNum;
                    if (sectionNum == 2) {
                        Grib2SectionLocalUse rLUS = new Grib2SectionLocalUse(br);
                        Grib2SectionGridDefinition rGDS = new Grib2SectionGridDefinition(br);
                        if (gridNum == 0) {
                            this.setProjectionInfo(this._projInfo);
                        }
                        ++gridNum;
                    }
                    if (sectionNum == 3) {
                        Grib2SectionGridDefinition rGDS = new Grib2SectionGridDefinition(br);
                        if (gridNum == 0) {
                            this.setProjectionInfo(this._projInfo);
                        }
                        ++gridNum;
                    }
                    Grib2SectionProductDefinition rPDS = new Grib2SectionProductDefinition(br);
                    this.seekNextSction(br);
                    this.seekNextSction(br);
                    this.seekNextSction(br);
                    ++recordNum;
                }
            }
            br.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(GRIB2DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(GRIB2DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private int readSectionNumber(RandomAccessFile br) throws IOException {
        byte[] bytes = br.readBytes(4);
        if (new String(bytes).trim().equals("GRIB")) {
            br.seek(br.getFilePointer() - 4L);
            return 0;
        }
        if (bytes[0] == 55 && bytes[1] == 55 && bytes[2] == 55 && bytes[3] == 55) {
            br.seek(br.getFilePointer() - 4L);
            return 8;
        }
        byte sectionNum = br.readByte();
        br.seek(br.getFilePointer() - 5L);
        return sectionNum;
    }

    private void seekNextSction(RandomAccessFile br) {
        try {
            int length = Bytes2Number.int4(br.getRandomAccessFile());
            br.seek(br.getFilePointer() + (long)length - 4L);
        }
        catch (IOException ex) {
            Logger.getLogger(GRIB2DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public double[] getGaussYArray(int ny) {
        double[] Y = new double[ny];
        Y = (double[])DataMath.gauss2Lats(ny)[0];
        return Y;
    }

    @Override
    public Array read(String varName) {
        return null;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        return null;
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridArray getGridArray(String varName) {
        return null;
    }

    @Override
    public GridData getGridData_LonLat(int timeIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_TimeLat(int lonIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_TimeLon(int latIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLat(int lonIdx, int varIdx, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLon(int latIdx, int varIdx, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelTime(int latIdx, int varIdx, int lonIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Time(int lonIdx, int latIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Level(int lonIdx, int latIdx, int varIdx, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lon(int timeIdx, int latIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lat(int timeIdx, int lonIdx, int varIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

