/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.hysplit;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.DataTypes;
import org.meteoinfo.data.XYListDataset;
import org.meteoinfo.data.mapdata.Field;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.Dimension;
import org.meteoinfo.data.meteodata.DimensionType;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.TrajDataInfo;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.hysplit.TrajectoryInfo;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.global.util.DateUtil;
import org.meteoinfo.layer.LayerDrawType;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.LegendManage;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.LegendType;
import org.meteoinfo.legend.PointStyle;
import org.meteoinfo.legend.PolylineBreak;
import org.meteoinfo.shape.PointZ;
import org.meteoinfo.shape.PointZShape;
import org.meteoinfo.shape.PolylineZShape;
import org.meteoinfo.shape.ShapeTypes;
import ucar.ma2.Array;
import ucar.nc2.Attribute;

public class HYSPLITTrajDataInfo_bak
extends DataInfo
implements TrajDataInfo {
    public List<String> fileNames;
    public List<Integer> meteoFileNums;
    public int trajeoryNumber;
    public List<Integer> trajeoryNums;
    public List<String> trajDirections;
    public List<String> verticalMotions;
    public List<List<TrajectoryInfo>> trajInfos;
    public List<Integer> varNums;
    public List<List<String>> varNames;

    public HYSPLITTrajDataInfo_bak() {
        this.setDataType(MeteoDataType.HYSPLIT_Traj);
        this.initVariables();
    }

    private void initVariables() {
        this.fileNames = new ArrayList<String>();
        this.meteoFileNums = new ArrayList<Integer>();
        this.trajeoryNums = new ArrayList<Integer>();
        this.trajDirections = new ArrayList<String>();
        this.verticalMotions = new ArrayList<String>();
        this.trajInfos = new ArrayList<List<TrajectoryInfo>>();
        this.varNums = new ArrayList<Integer>();
        this.varNames = new ArrayList<List<String>>();
        this.trajeoryNumber = 0;
    }

    @Override
    public void readDataInfo(String fileName) {
        String[] trajFiles = new String[]{fileName};
        try {
            this.readDataInfo(trajFiles);
        }
        catch (IOException ex) {
            Logger.getLogger(HYSPLITTrajDataInfo_bak.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void readDataInfo(String[] trajFiles) throws IOException {
        this.setFileName(trajFiles[0]);
        this.initVariables();
        ArrayList<Double> times = new ArrayList<Double>();
        for (int t = 0; t < trajFiles.length; ++t) {
            int i;
            String aFile = trajFiles[t];
            this.fileNames.add(aFile);
            BufferedReader sr = new BufferedReader(new FileReader(new File(aFile)));
            String aLine = sr.readLine().trim();
            String[] dataArray = aLine.split("\\s+");
            this.meteoFileNums.add(Integer.parseInt(dataArray[0]));
            for (i = 0; i < this.meteoFileNums.get(t); ++i) {
                sr.readLine();
            }
            aLine = sr.readLine().trim();
            dataArray = aLine.split("\\s+");
            this.trajeoryNums.add(Integer.parseInt(dataArray[0]));
            this.trajeoryNumber += this.trajeoryNums.get(t).intValue();
            this.trajDirections.add(dataArray[1]);
            this.verticalMotions.add(dataArray[2]);
            ArrayList<TrajectoryInfo> trajInfoList = new ArrayList<TrajectoryInfo>();
            for (i = 0; i < this.trajeoryNums.get(t); ++i) {
                aLine = sr.readLine().trim();
                dataArray = aLine.split("\\s+");
                int y = Integer.parseInt(dataArray[0]);
                if (y < 100) {
                    y = y > 50 ? 1900 + y : 2000 + y;
                }
                GregorianCalendar cal = new GregorianCalendar(y, Integer.parseInt(dataArray[1]) - 1, Integer.parseInt(dataArray[2]), Integer.parseInt(dataArray[3]), 0, 0);
                if (times.isEmpty()) {
                    times.add(DateUtil.toOADate(cal.getTime()));
                }
                TrajectoryInfo aTrajInfo = new TrajectoryInfo();
                aTrajInfo.startTime = cal.getTime();
                aTrajInfo.startLat = Float.parseFloat(dataArray[4]);
                aTrajInfo.startLon = Float.parseFloat(dataArray[5]);
                aTrajInfo.startHeight = Float.parseFloat(dataArray[6]);
                trajInfoList.add(aTrajInfo);
            }
            this.trajInfos.add(trajInfoList);
            Dimension tdim = new Dimension(DimensionType.T);
            tdim.setValues(times);
            aLine = sr.readLine().trim();
            dataArray = aLine.split("\\s+");
            int nvar = Integer.parseInt(dataArray[0]);
            if (nvar > dataArray.length - 1) {
                nvar = dataArray.length - 1;
            }
            this.varNums.add(nvar);
            ArrayList<String> varNameList = new ArrayList<String>();
            for (i = 0; i < this.varNums.get(t); ++i) {
                varNameList.add(dataArray[i + 1]);
            }
            this.varNames.add(varNameList);
            Variable var = new Variable();
            var.setName("Traj");
            var.setStation(true);
            var.setDimension(tdim);
            ArrayList<Variable> variables = new ArrayList<Variable>();
            variables.add(var);
            this.setVariables(variables);
            sr.close();
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        String dataInfo = "";
        for (int t = 0; t < this.fileNames.size(); ++t) {
            dataInfo = dataInfo + "File Name: " + this.fileNames.get(t);
            dataInfo = dataInfo + System.getProperty("line.separator") + "Trajectory number = " + String.valueOf(this.trajeoryNums.get(t));
            dataInfo = dataInfo + System.getProperty("line.separator") + "Trajectory direction = " + this.trajDirections.get(t);
            dataInfo = dataInfo + System.getProperty("line.separator") + "Vertical motion =" + this.verticalMotions.get(t);
            dataInfo = dataInfo + System.getProperty("line.separator") + "Number of diagnostic output variables = " + String.valueOf(this.varNums.get(t));
            dataInfo = dataInfo + System.getProperty("line.separator") + "Variables:";
            for (int i = 0; i < this.varNums.get(t); ++i) {
                dataInfo = dataInfo + " " + this.varNames.get(t).get(i);
            }
            dataInfo = dataInfo + System.getProperty("line.separator") + System.getProperty("line.separator") + "Trajectories:";
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:00");
            for (TrajectoryInfo aTrajInfo : this.trajInfos.get(t)) {
                dataInfo = dataInfo + System.getProperty("line.separator") + "  " + format.format(aTrajInfo.startTime) + "  " + String.valueOf(aTrajInfo.startLat) + "  " + String.valueOf(aTrajInfo.startLon) + "  " + String.valueOf(aTrajInfo.startHeight);
            }
            if (t >= this.fileNames.size() - 1) continue;
            dataInfo = dataInfo + System.getProperty("line.separator") + System.getProperty("line.separator") + "******************************" + System.getProperty("line.separator");
        }
        return dataInfo;
    }

    @Override
    public Array read(String varName) {
        return null;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        return null;
    }

    @Override
    public VectorLayer createTrajLineLayer() {
        return this.createTrajLineLayer(false);
    }

    public VectorLayer createTrajLineLayer(boolean zPres) {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.PolylineZ);
        aLayer.editAddField("ID", DataTypes.Integer);
        aLayer.editAddField("Date", DataTypes.Date);
        aLayer.editAddField("Year", DataTypes.Integer);
        aLayer.editAddField("Month", DataTypes.Integer);
        aLayer.editAddField("Day", DataTypes.Integer);
        aLayer.editAddField("Hour", DataTypes.Integer);
        aLayer.editAddField("Height", DataTypes.Float);
        Calendar cal = Calendar.getInstance();
        int TrajNum = 0;
        for (int t = 0; t < this.fileNames.size(); ++t) {
            try {
                String aLine;
                int i;
                String aFile = this.fileNames.get(t);
                BufferedReader sr = new BufferedReader(new FileReader(new File(aFile)));
                sr.readLine();
                for (i = 0; i < this.meteoFileNums.get(t); ++i) {
                    sr.readLine();
                }
                sr.readLine();
                for (i = 0; i < this.trajeoryNums.get(t); ++i) {
                    sr.readLine();
                }
                sr.readLine();
                ArrayList PointList = new ArrayList();
                for (i = 0; i < this.trajeoryNums.get(t); ++i) {
                    ArrayList pList = new ArrayList();
                    PointList.add(pList);
                }
                int dn = 12 + this.varNums.get(t);
                while ((aLine = sr.readLine()) != null) {
                    if (aLine.isEmpty()) continue;
                    String[] dataArray = (aLine = aLine.trim()).split("\\s+");
                    if (dataArray.length < dn) {
                        sr.readLine();
                    }
                    int TrajIdx = Integer.parseInt(dataArray[0]) - 1;
                    PointZ aPoint = new PointZ();
                    aPoint.X = Double.parseDouble(dataArray[10]);
                    aPoint.Y = Double.parseDouble(dataArray[9]);
                    if (dataArray.length >= 13) {
                        if (zPres) {
                            aPoint.M = Double.parseDouble(dataArray[11]);
                            aPoint.Z = Double.parseDouble(dataArray[12]);
                        } else {
                            aPoint.M = Double.parseDouble(dataArray[12]);
                            aPoint.Z = Double.parseDouble(dataArray[11]);
                        }
                    } else {
                        aPoint.Z = Double.parseDouble(dataArray[11]);
                    }
                    if (((List)PointList.get(TrajIdx)).size() > 1) {
                        PointZ oldPoint = (PointZ)((List)PointList.get(TrajIdx)).get(((List)PointList.get(TrajIdx)).size() - 1);
                        if (Math.abs(aPoint.X - oldPoint.X) > 100.0) {
                            aPoint.X = aPoint.X > oldPoint.X ? (aPoint.X -= 360.0) : (aPoint.X += 360.0);
                        }
                    }
                    ((List)PointList.get(TrajIdx)).add(aPoint);
                }
                for (i = 0; i < this.trajeoryNums.get(t); ++i) {
                    PolylineZShape aPolyline = new PolylineZShape();
                    aPolyline.setValue(++TrajNum);
                    aPolyline.setPoints((List)PointList.get(i));
                    aPolyline.setExtent(MIMath.getPointsExtent(aPolyline.getPoints()));
                    int shapeNum = aLayer.getShapeNum();
                    if (!aLayer.editInsertShape(aPolyline, shapeNum)) continue;
                    cal.setTime(this.trajInfos.get((int)t).get((int)i).startTime);
                    aLayer.editCellValue("ID", shapeNum, (Object)TrajNum);
                    aLayer.editCellValue("Date", shapeNum, (Object)cal.getTime());
                    aLayer.editCellValue("Year", shapeNum, (Object)cal.get(1));
                    aLayer.editCellValue("Month", shapeNum, (Object)(cal.get(2) + 1));
                    aLayer.editCellValue("Day", shapeNum, (Object)cal.get(5));
                    aLayer.editCellValue("Hour", shapeNum, (Object)cal.get(11));
                    aLayer.editCellValue("Height", shapeNum, (Object)Float.valueOf(this.trajInfos.get((int)t).get((int)i).startHeight));
                }
                sr.close();
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger(HYSPLITTrajDataInfo_bak.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(HYSPLITTrajDataInfo_bak.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName("Trajectory_Lines");
        aLayer.setLayerDrawType(LayerDrawType.TrajLine);
        aLayer.setVisible(true);
        aLayer.updateLegendScheme(LegendType.UniqueValue, "ID");
        LegendScheme ls = aLayer.getLegendScheme();
        int i = 0;
        for (ColorBreak cb : ls.getLegendBreaks()) {
            PolylineBreak plb = (PolylineBreak)cb;
            plb.setDrawSymbol(true);
            plb.setSymbolFillColor(plb.getSymbolColor());
            plb.setSymbolInterval(6);
            plb.setWidth(2.0f);
            if (i == PointStyle.values().length) {
                i = 0;
            }
            plb.setSymbolStyle(PointStyle.values()[i]);
            ++i;
        }
        return aLayer;
    }

    @Override
    public VectorLayer createTrajPointLayer() {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Point);
        aLayer.editAddField(new Field("TrajID", DataTypes.Integer));
        aLayer.editAddField(new Field("Date", DataTypes.String));
        aLayer.editAddField(new Field("Lon", DataTypes.Double));
        aLayer.editAddField(new Field("Lat", DataTypes.Double));
        aLayer.editAddField(new Field("Altitude", DataTypes.Double));
        aLayer.editAddField(new Field("Pressure", DataTypes.Double));
        boolean isMultiVar = false;
        if (this.varNums.get(0) > 1) {
            isMultiVar = true;
            for (int v = 1; v < this.varNums.get(0); ++v) {
                aLayer.editAddField(new Field(this.varNames.get(0).get(v), DataTypes.Double));
            }
        }
        int TrajNum = 0;
        for (int t = 0; t < this.fileNames.size(); ++t) {
            try {
                String aLine;
                int i;
                String aFile = this.fileNames.get(t);
                BufferedReader sr = new BufferedReader(new FileReader(new File(aFile)));
                sr.readLine();
                for (i = 0; i < this.meteoFileNums.get(t); ++i) {
                    sr.readLine();
                }
                sr.readLine();
                for (i = 0; i < this.trajeoryNums.get(t); ++i) {
                    sr.readLine();
                }
                sr.readLine();
                ArrayList PointList = new ArrayList();
                for (i = 0; i < this.trajeoryNums.get(t); ++i) {
                    ArrayList pList = new ArrayList();
                    PointList.add(pList);
                }
                int dn = 12 + this.varNums.get(t);
                while ((aLine = sr.readLine()) != null) {
                    if (aLine.isEmpty()) continue;
                    String[] dataArray = (aLine = aLine.trim()).split("\\s+");
                    if (dataArray.length < dn) {
                        aLine = sr.readLine().trim();
                        String[] tempArray = aLine.split("\\s+");
                        dataArray = (String[])DataConvert.resizeArray(dataArray, dn);
                        for (i = 0; i < tempArray.length; ++i) {
                            dataArray[dn - tempArray.length + i] = tempArray[i];
                        }
                    }
                    ArrayList<Object> dList = new ArrayList<Object>();
                    int TrajIdx = Integer.parseInt(dataArray[0]) - 1;
                    int y = Integer.parseInt(dataArray[2]);
                    if (y < 100) {
                        y = y > 50 ? 1900 + y : 2000 + y;
                    }
                    GregorianCalendar cal = new GregorianCalendar(y, Integer.parseInt(dataArray[3]) - 1, Integer.parseInt(dataArray[4]), Integer.parseInt(dataArray[5]), 0, 0);
                    PointZ aPoint = new PointZ();
                    aPoint.X = Double.parseDouble(dataArray[10]);
                    aPoint.Y = Double.parseDouble(dataArray[9]);
                    double Height = Double.parseDouble(dataArray[11]);
                    double Press = Double.parseDouble(dataArray[12]);
                    aPoint.Z = Height;
                    aPoint.M = Press;
                    dList.add(aPoint);
                    dList.add(cal.getTime());
                    dList.add(Height);
                    dList.add(Press);
                    if (isMultiVar) {
                        for (i = 13; i < dataArray.length; ++i) {
                            dList.add(Double.parseDouble(dataArray[i]));
                        }
                    }
                    ((List)PointList.get(TrajIdx)).add(dList);
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHH");
                for (i = 0; i < this.trajeoryNums.get(t); ++i) {
                    ++TrajNum;
                    for (int j = 0; j < ((List)PointList.get(i)).size(); ++j) {
                        PointZShape aPS = new PointZShape();
                        aPS.setValue(TrajNum);
                        aPS.setPoint((PointD)((List)((List)PointList.get(i)).get(j)).get(0));
                        int shapeNum = aLayer.getShapeNum();
                        if (!aLayer.editInsertShape(aPS, shapeNum)) continue;
                        aLayer.editCellValue("TrajID", shapeNum, (Object)TrajNum);
                        aLayer.editCellValue("Date", shapeNum, (Object)format.format((Date)((List)((List)PointList.get(i)).get(j)).get(1)));
                        aLayer.editCellValue("Lat", shapeNum, (Object)aPS.getPoint().Y);
                        aLayer.editCellValue("Lon", shapeNum, (Object)aPS.getPoint().X);
                        aLayer.editCellValue("Altitude", shapeNum, ((List)((List)PointList.get(i)).get(j)).get(2));
                        aLayer.editCellValue("Pressure", shapeNum, ((List)((List)PointList.get(i)).get(j)).get(3));
                        if (!isMultiVar) continue;
                        for (int v = 1; v < this.varNums.get(0); ++v) {
                            aLayer.editCellValue(this.varNames.get(0).get(v), shapeNum, ((List)((List)PointList.get(i)).get(j)).get(3 + v));
                        }
                    }
                }
                sr.close();
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger(HYSPLITTrajDataInfo_bak.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(HYSPLITTrajDataInfo_bak.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName("Trajectory_Points");
        aLayer.setLayerDrawType(LayerDrawType.TrajLine);
        aLayer.setVisible(true);
        LegendScheme aLS = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Point, Color.red, 5.0f);
        aLS.setFieldName("TrajID");
        aLayer.setLegendScheme(aLS);
        return aLayer;
    }

    @Override
    public VectorLayer createTrajStartPointLayer() {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.PointZ);
        aLayer.editAddField(new Field("TrajID", DataTypes.Integer));
        aLayer.editAddField(new Field("StartDate", DataTypes.String));
        aLayer.editAddField(new Field("StartLon", DataTypes.Double));
        aLayer.editAddField(new Field("StartLat", DataTypes.Double));
        aLayer.editAddField(new Field("StartHeight", DataTypes.Double));
        int TrajNum = 0;
        for (int t = 0; t < this.fileNames.size(); ++t) {
            try {
                String aLine;
                int i;
                String aFile = this.fileNames.get(t);
                BufferedReader sr = new BufferedReader(new FileReader(new File(aFile)));
                sr.readLine();
                for (i = 0; i < this.meteoFileNums.get(t); ++i) {
                    sr.readLine();
                }
                sr.readLine();
                for (i = 0; i < this.trajeoryNums.get(t); ++i) {
                    sr.readLine();
                }
                sr.readLine();
                ArrayList<PointZ> PointList = new ArrayList<PointZ>();
                PointZ aPoint = new PointZ();
                for (i = 0; i < this.trajeoryNums.get(t); ++i) {
                    PointList.add(aPoint);
                }
                int dn = 12 + this.varNums.get(t);
                while ((aLine = sr.readLine()) != null) {
                    if (aLine.isEmpty()) continue;
                    String[] dataArray = (aLine = aLine.trim()).split("\\s+");
                    if (dataArray.length < dn) {
                        sr.readLine();
                    }
                    if (Float.parseFloat(dataArray[8]) != 0.0f) continue;
                    int TrajIdx = Integer.parseInt(dataArray[0]) - 1;
                    aPoint = new PointZ();
                    aPoint.X = Double.parseDouble(dataArray[10]);
                    aPoint.Y = Double.parseDouble(dataArray[9]);
                    aPoint.Z = Double.parseDouble(dataArray[11]);
                    aPoint.M = Double.parseDouble(dataArray[12]);
                    PointList.set(TrajIdx, aPoint);
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHH");
                for (i = 0; i < this.trajeoryNums.get(t); ++i) {
                    PointZShape aPS = new PointZShape();
                    aPS.setValue(++TrajNum);
                    aPS.setPoint((PointZ)PointList.get(i));
                    int shapeNum = aLayer.getShapeNum();
                    if (!aLayer.editInsertShape(aPS, shapeNum)) continue;
                    aLayer.editCellValue("TrajID", shapeNum, (Object)TrajNum);
                    aLayer.editCellValue("StartDate", shapeNum, (Object)format.format(this.trajInfos.get((int)t).get((int)i).startTime));
                    aLayer.editCellValue("StartLat", shapeNum, (Object)Float.valueOf(this.trajInfos.get((int)t).get((int)i).startLat));
                    aLayer.editCellValue("StartLon", shapeNum, (Object)Float.valueOf(this.trajInfos.get((int)t).get((int)i).startLon));
                    aLayer.editCellValue("StartHeight", shapeNum, (Object)Float.valueOf(this.trajInfos.get((int)t).get((int)i).startHeight));
                }
                sr.close();
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger(HYSPLITTrajDataInfo_bak.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(HYSPLITTrajDataInfo_bak.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        aLayer.setLayerName("Trajectory_Start_Points");
        aLayer.setLayerDrawType(LayerDrawType.TrajPoint);
        aLayer.setVisible(true);
        LegendScheme aLS = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Point, Color.black, 8.0f);
        aLS.setFieldName("TrajID");
        aLayer.setLegendScheme(aLS);
        return aLayer;
    }

    public XYListDataset getXYDataset(int varIndex) {
        XYListDataset dataset = new XYListDataset();
        Calendar cal = Calendar.getInstance();
        int trajNum = 1;
        for (int t = 0; t < this.fileNames.size(); ++t) {
            try {
                String aLine;
                int i;
                String aFile = this.fileNames.get(t);
                BufferedReader sr = new BufferedReader(new FileReader(new File(aFile)));
                sr.readLine();
                for (i = 0; i < this.meteoFileNums.get(t); ++i) {
                    sr.readLine();
                }
                sr.readLine();
                for (i = 0; i < this.trajeoryNums.get(t); ++i) {
                    sr.readLine();
                }
                sr.readLine();
                ArrayList PointList = new ArrayList();
                for (i = 0; i < this.trajeoryNums.get(t); ++i) {
                    ArrayList pList = new ArrayList();
                    PointList.add(pList);
                }
                int dn = 12 + this.varNums.get(t);
                while ((aLine = sr.readLine()) != null) {
                    if (aLine.isEmpty()) continue;
                    String[] dataArray = (aLine = aLine.trim()).split("\\s+");
                    if (dataArray.length < dn) {
                        aLine = sr.readLine().trim();
                        String[] tempArray = aLine.split("\\s+");
                        dataArray = (String[])DataConvert.resizeArray(dataArray, dn);
                        for (i = 0; i < tempArray.length; ++i) {
                            dataArray[dn - tempArray.length + i] = tempArray[i];
                        }
                    }
                    int TrajIdx = Integer.parseInt(dataArray[0]) - 1;
                    int y = Integer.parseInt(dataArray[2]);
                    if (y < 100) {
                        y = y > 50 ? 1900 + y : 2000 + y;
                    }
                    cal.set(y, Integer.parseInt(dataArray[3]) - 1, Integer.parseInt(dataArray[4]), Integer.parseInt(dataArray[5]), 0, 0);
                    PointD aPoint = new PointD();
                    aPoint.X = DateUtil.toOADate(cal.getTime());
                    aPoint.Y = Double.parseDouble(dataArray[varIndex]);
                    ((List)PointList.get(TrajIdx)).add(aPoint);
                }
                for (i = 0; i < this.trajeoryNums.get(t); ++i) {
                    int n = ((List)PointList.get(i)).size();
                    double[] xvs = new double[n];
                    double[] yvs = new double[n];
                    for (int j = 0; j < n; ++j) {
                        xvs[j] = ((PointD)((List)PointList.get((int)i)).get((int)j)).X;
                        yvs[j] = ((PointD)((List)PointList.get((int)i)).get((int)j)).Y;
                    }
                    dataset.addSeries("Traj_" + String.valueOf(trajNum), xvs, yvs);
                    ++trajNum;
                }
                sr.close();
                continue;
            }
            catch (IOException | NumberFormatException ex) {
                Logger.getLogger(HYSPLITTrajDataInfo_bak.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return dataset;
    }

    public XYListDataset getXYDataset_HourX(int varIndex) {
        XYListDataset dataset = new XYListDataset();
        Calendar cal = Calendar.getInstance();
        int trajNum = 1;
        for (int t = 0; t < this.fileNames.size(); ++t) {
            try {
                String aLine;
                int i;
                String aFile = this.fileNames.get(t);
                BufferedReader sr = new BufferedReader(new FileReader(new File(aFile)));
                sr.readLine();
                for (i = 0; i < this.meteoFileNums.get(t); ++i) {
                    sr.readLine();
                }
                sr.readLine();
                for (i = 0; i < this.trajeoryNums.get(t); ++i) {
                    sr.readLine();
                }
                sr.readLine();
                ArrayList PointList = new ArrayList();
                for (i = 0; i < this.trajeoryNums.get(t); ++i) {
                    ArrayList pList = new ArrayList();
                    PointList.add(pList);
                }
                int dn = 12 + this.varNums.get(t);
                while ((aLine = sr.readLine()) != null) {
                    if (aLine.isEmpty()) continue;
                    String[] dataArray = (aLine = aLine.trim()).split("\\s+");
                    if (dataArray.length < dn) {
                        aLine = sr.readLine().trim();
                        String[] tempArray = aLine.split("\\s+");
                        dataArray = (String[])DataConvert.resizeArray(dataArray, dn);
                        for (i = 0; i < tempArray.length; ++i) {
                            dataArray[dn - tempArray.length + i] = tempArray[i];
                        }
                    }
                    int TrajIdx = Integer.parseInt(dataArray[0]) - 1;
                    int y = Integer.parseInt(dataArray[2]);
                    if (y < 100) {
                        y = y > 50 ? 1900 + y : 2000 + y;
                    }
                    cal.set(y, Integer.parseInt(dataArray[3]) - 1, Integer.parseInt(dataArray[4]), Integer.parseInt(dataArray[5]), 0, 0);
                    PointD aPoint = new PointD();
                    aPoint.X = DateUtil.toOADate(cal.getTime());
                    aPoint.Y = Double.parseDouble(dataArray[varIndex]);
                    ((List)PointList.get(TrajIdx)).add(aPoint);
                }
                for (i = 0; i < this.trajeoryNums.get(t); ++i) {
                    int n = ((List)PointList.get(i)).size();
                    double[] xvs = new double[n];
                    double[] yvs = new double[n];
                    Date sdate = new Date();
                    for (int j = 0; j < n; ++j) {
                        Date cdate = DateUtil.fromOADate(((PointD)((List)PointList.get((int)i)).get((int)j)).X);
                        if (j == 0) {
                            sdate = cdate;
                            xvs[j] = 0.0;
                        } else {
                            xvs[j] = DateUtil.getHours(cdate, sdate);
                        }
                        yvs[j] = ((PointD)((List)PointList.get((int)i)).get((int)j)).Y;
                    }
                    dataset.addSeries("Traj_" + String.valueOf(trajNum), xvs, yvs);
                    ++trajNum;
                }
                sr.close();
                continue;
            }
            catch (IOException | NumberFormatException ex) {
                Logger.getLogger(HYSPLITTrajDataInfo_bak.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return dataset;
    }
}

