/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geoprocess;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.global.PointD;

public class GeometryUtil {
    public static PointD getEllipseXY(double x0, double y0, double a, double b, double angle) {
        double rangle = Math.toRadians(angle);
        double x = a * b / Math.sqrt(b * b + a * a * Math.tan(rangle) * Math.tan(rangle));
        if (angle > 90.0 && angle < 270.0) {
            x = -x;
        }
        double y = Math.tan(rangle) * x;
        if (angle > 0.0 && angle < 180.0) {
            y = -Math.abs(y);
        }
        return new PointD(x + x0, y + y0);
    }

    public static List<PointD> getEllipseCoordinates(double x0, double y0, double a, double b, double deltaAngle) {
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (double angle = 0.0; angle <= 360.0; angle += deltaAngle) {
            points.add(GeometryUtil.getEllipseXY(x0, y0, a, b, angle));
        }
        return points;
    }

    public static List<PointD> getEllipseCoordinates(double x0, double y0, double a, double b) {
        ArrayList<PointD> points = new ArrayList<PointD>();
        double deltaAngle = 1.0;
        for (double angle = 0.0; angle <= 360.0; angle += deltaAngle) {
            points.add(GeometryUtil.getEllipseXY(x0, y0, a, b, angle));
        }
        return points;
    }
}

