/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.global;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.data.mapdata.Field;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.Extent3D;
import org.meteoinfo.global.PointD;
import org.meteoinfo.global.PointF;
import org.meteoinfo.global.util.BigDecimalUtil;
import org.meteoinfo.shape.PointZ;
import org.meteoinfo.shape.Shape;

public class MIMath {
    public static boolean doubleEquals(double a, double b) {
        double difference = Math.abs(a * 1.0E-5);
        return Math.abs(a - b) <= difference;
    }

    public static boolean doubleEquals_Abs(double a, double b) {
        return Math.abs(a - b) < 1.0E-7;
    }

    public static double[] getMinMaxValue(double[] S, double unDef) {
        double min = unDef;
        double max = unDef;
        int validNum = 0;
        for (int i = 0; i < S.length; ++i) {
            if (MIMath.doubleEquals(S[i], unDef)) continue;
            if (++validNum == 1) {
                max = min = S[i];
                continue;
            }
            if (S[i] < min) {
                min = S[i];
            }
            if (!(S[i] > max)) continue;
            max = S[i];
        }
        return new double[]{min, max};
    }

    public static double[] getMinMaxValue(List<Double> S, double unDef) {
        double min = unDef;
        double max = unDef;
        int validNum = 0;
        for (int i = 0; i < S.size(); ++i) {
            if (MIMath.doubleEquals(S.get(i), unDef)) continue;
            if (++validNum == 1) {
                max = min = S.get(i).doubleValue();
                continue;
            }
            if (S.get(i) < min) {
                min = S.get(i);
            }
            if (!(S.get(i) > max)) continue;
            max = S.get(i);
        }
        return new double[]{min, max};
    }

    public static double[] getMinMaxValue(List S) {
        double min = 0.0;
        double max = 0.0;
        for (int i = 0; i < S.size(); ++i) {
            double v = (Double)S.get(i);
            if (i == 0) {
                min = v;
                max = v;
                continue;
            }
            if (min > v) {
                min = v;
            }
            if (!(max < v)) continue;
            max = v;
        }
        return new double[]{min, max};
    }

    public static int[] getMinMaxInt(List S) {
        int min = 0;
        int max = 0;
        for (int i = 0; i < S.size(); ++i) {
            int v = (Integer)S.get(i);
            if (i == 0) {
                min = v;
                max = v;
                continue;
            }
            if (min > v) {
                min = v;
            }
            if (max >= v) continue;
            max = v;
        }
        return new int[]{min, max};
    }

    public static boolean isNumeric(String strNumber) {
        try {
            Double.parseDouble(strNumber);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isNumeric(Field field) {
        switch (field.getDataType()) {
            case Integer: 
            case Float: 
            case Double: 
            case Decimal: {
                return true;
            }
        }
        return false;
    }

    public static Extent getPointsExtent(List<? extends PointD> PList) {
        if (PList.get(0) instanceof PointZ) {
            Extent3D cET = new Extent3D();
            for (int i = 0; i < PList.size(); ++i) {
                PointZ aP = (PointZ)PList.get(i);
                if (i == 0) {
                    cET.minX = aP.X;
                    cET.maxX = aP.X;
                    cET.minY = aP.Y;
                    cET.maxY = aP.Y;
                    cET.minZ = aP.Z;
                    continue;
                }
                if (cET.minX > aP.X) {
                    cET.minX = aP.X;
                } else if (cET.maxX < aP.X) {
                    cET.maxX = aP.X;
                }
                if (cET.minY > aP.Y) {
                    cET.minY = aP.Y;
                } else if (cET.maxY < aP.Y) {
                    cET.maxY = aP.Y;
                }
                if (cET.minZ > aP.Z) {
                    cET.minZ = aP.Z;
                    continue;
                }
                if (!(cET.maxZ < aP.Z)) continue;
                cET.maxZ = aP.Z;
            }
            return cET;
        }
        Extent cET = new Extent();
        for (int i = 0; i < PList.size(); ++i) {
            PointD aP = PList.get(i);
            if (i == 0) {
                cET.minX = aP.X;
                cET.maxX = aP.X;
                cET.minY = aP.Y;
                cET.maxY = aP.Y;
                continue;
            }
            if (cET.minX > aP.X) {
                cET.minX = aP.X;
            } else if (cET.maxX < aP.X) {
                cET.maxX = aP.X;
            }
            if (cET.minY > aP.Y) {
                cET.minY = aP.Y;
                continue;
            }
            if (!(cET.maxY < aP.Y)) continue;
            cET.maxY = aP.Y;
        }
        return cET;
    }

    public static Extent getPointFsExtent(PointF[] PList) {
        Extent cET = new Extent();
        for (int i = 0; i < PList.length; ++i) {
            PointF aP = PList[i];
            if (i == 0) {
                cET.minX = aP.X;
                cET.maxX = aP.X;
                cET.minY = aP.Y;
                cET.maxY = aP.Y;
                continue;
            }
            if (cET.minX > (double)aP.X) {
                cET.minX = aP.X;
            } else if (cET.maxX < (double)aP.X) {
                cET.maxX = aP.X;
            }
            if (cET.minY > (double)aP.Y) {
                cET.minY = aP.Y;
                continue;
            }
            if (!(cET.maxY < (double)aP.Y)) continue;
            cET.maxY = aP.Y;
        }
        return cET;
    }

    public static Extent getPointFsExtent(List<PointF> PList) {
        Extent cET = new Extent();
        for (int i = 0; i < PList.size(); ++i) {
            PointF aP = PList.get(i);
            if (i == 0) {
                cET.minX = aP.X;
                cET.maxX = aP.X;
                cET.minY = aP.Y;
                cET.maxY = aP.Y;
                continue;
            }
            if (cET.minX > (double)aP.X) {
                cET.minX = aP.X;
            } else if (cET.maxX < (double)aP.X) {
                cET.maxX = aP.X;
            }
            if (cET.minY > (double)aP.Y) {
                cET.minY = aP.Y;
                continue;
            }
            if (!(cET.maxY < (double)aP.Y)) continue;
            cET.maxY = aP.Y;
        }
        return cET;
    }

    public static void arrayReverse(PointD[] points) {
        int left = 0;
        for (int right = points.length - 1; left < right; ++left, --right) {
            PointD temp = points[left];
            points[left] = points[right];
            points[right] = temp;
        }
    }

    public static void arrayReverse(double[] values) {
        int left = 0;
        for (int right = values.length - 1; left < right; ++left, --right) {
            double temp = values[left];
            values[left] = values[right];
            values[right] = temp;
        }
    }

    public static void arrayReverse(Object[] values) {
        int left = 0;
        for (int right = values.length - 1; left < right; ++left, --right) {
            Object temp = values[left];
            values[left] = values[right];
            values[right] = temp;
        }
    }

    public static double[] arrayMinMax(double[] values) {
        double min = values[0];
        double max = values[0];
        for (double value : values) {
            min = Math.min(value, min);
            max = Math.max(value, max);
        }
        return new double[]{min, max};
    }

    public static double[] arrayMinMax(Double[] values) {
        double min = values[0];
        double max = values[0];
        Double[] doubleArray = values;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double value = doubleArray[i];
            min = Math.min(value, min);
            max = Math.max(value, max);
        }
        return new double[]{min, max};
    }

    public static PointF getCrossPoint(PointF aP1, PointF aP2, PointF bP1, PointF bP2) {
        PointF IPoint = new PointF(0.0f, 0.0f);
        double XP1 = (bP1.X - aP1.X) * (aP2.Y - aP1.Y) - (aP2.X - aP1.X) * (bP1.Y - aP1.Y);
        double XP2 = (bP2.X - aP1.X) * (aP2.Y - aP1.Y) - (aP2.X - aP1.X) * (bP2.Y - aP1.Y);
        if (XP1 == 0.0) {
            IPoint = bP1;
        } else if (XP2 == 0.0) {
            IPoint = bP2;
        } else {
            PointF p1 = aP1;
            PointF p2 = aP2;
            PointF q1 = bP1;
            PointF q2 = bP2;
            double tempLeft = (q2.X - q1.X) * (p1.Y - p2.Y) - (p2.X - p1.X) * (q1.Y - q2.Y);
            double tempRight = (p1.Y - q1.Y) * (p2.X - p1.X) * (q2.X - q1.X) + q1.X * (q2.Y - q1.Y) * (p2.X - p1.X) - p1.X * (p2.Y - p1.Y) * (q2.X - q1.X);
            IPoint.X = (float)(tempRight / tempLeft);
            tempLeft = (p1.X - p2.X) * (q2.Y - q1.Y) - (p2.Y - p1.Y) * (q1.X - q2.X);
            tempRight = p2.Y * (p1.X - p2.X) * (q2.Y - q1.Y) + (q2.X - p2.X) * (q2.Y - q1.Y) * (p1.Y - p2.Y) - q2.Y * (q1.X - q2.X) * (p2.Y - p1.Y);
            IPoint.Y = (float)(tempRight / tempLeft);
        }
        return IPoint;
    }

    public static Extent shiftExtentLon(Extent aET, double lonShift) {
        Extent cET = new Extent();
        cET.minX = aET.minX + lonShift;
        cET.maxX = aET.maxX + lonShift;
        cET.minY = aET.minY;
        cET.maxY = aET.maxY;
        return cET;
    }

    public static Extent getLagerExtent(Extent aET, Extent bET) {
        if (aET.is3D() && bET.is3D()) {
            Extent3D cET = new Extent3D();
            if (aET.isNaN()) {
                return bET;
            }
            if (bET.isNaN()) {
                return aET;
            }
            cET.minX = Math.min(aET.minX, bET.minX);
            cET.minY = Math.min(aET.minY, bET.minY);
            cET.maxX = Math.max(aET.maxX, bET.maxX);
            cET.maxY = Math.max(aET.maxY, bET.maxY);
            cET.minZ = Math.min(((Extent3D)aET).minZ, ((Extent3D)bET).minZ);
            cET.maxZ = Math.max(((Extent3D)aET).maxZ, ((Extent3D)bET).maxZ);
            return cET;
        }
        Extent cET = new Extent();
        if (aET.isNaN()) {
            return bET;
        }
        if (bET.isNaN()) {
            return aET;
        }
        cET.minX = Math.min(aET.minX, bET.minX);
        cET.minY = Math.min(aET.minY, bET.minY);
        cET.maxX = Math.max(aET.maxX, bET.maxX);
        cET.maxY = Math.max(aET.maxY, bET.maxY);
        return cET;
    }

    public static Extent getSmallerExtent(Extent aET, Extent bET) {
        Extent cET = new Extent();
        cET.minX = Math.max(aET.minX, bET.minX);
        cET.minY = Math.max(aET.minY, bET.minY);
        cET.maxX = Math.min(aET.maxX, bET.maxX);
        cET.maxY = Math.min(aET.maxY, bET.maxY);
        return cET;
    }

    public static Extent getExtent(List<? extends Shape> shapes) {
        Extent extent = (Extent)shapes.get(0).getExtent().clone();
        double minx = extent.minX;
        double maxx = extent.maxX;
        double miny = extent.minY;
        double maxy = extent.maxY;
        for (int i = 1; i < shapes.size(); ++i) {
            Extent ext = shapes.get(i).getExtent();
            if (minx > ext.minX) {
                minx = ext.minX;
            }
            if (maxx < ext.maxX) {
                maxx = ext.maxX;
            }
            if (miny > ext.minY) {
                miny = ext.minY;
            }
            if (!(maxy < ext.maxY)) continue;
            maxy = ext.maxY;
        }
        extent.minX = minx;
        extent.maxX = maxx;
        extent.minY = miny;
        extent.maxY = maxy;
        return extent;
    }

    public static Boolean isExtentCross(Extent aET, Extent bET) {
        if (aET.maxX < bET.minX || aET.maxY < bET.minY || bET.maxX < aET.minX || bET.maxY < aET.minY) {
            return false;
        }
        return true;
    }

    public static boolean pointInExtent(PointD aP, Extent aET) {
        return aP.X >= aET.minX && aP.X <= aET.maxX && aP.Y >= aET.minY && aP.Y <= aET.maxY;
    }

    public static boolean pointInExtent(PointF aP, Extent aET) {
        return (double)aP.X >= aET.minX && (double)aP.X <= aET.maxX && (double)aP.Y >= aET.minY && (double)aP.Y <= aET.maxY;
    }

    public static boolean pointInRectangle(PointF aP, Rectangle aRect) {
        return aP.X > (float)aRect.x && aP.X < (float)(aRect.x + aRect.width) && aP.Y > (float)aRect.y && aP.Y < (float)(aRect.y + aRect.height);
    }

    public static boolean pointInRectangle(Point aP, Rectangle aRect) {
        return aP.x > aRect.x && aP.x < aRect.x + aRect.width && aP.y > aRect.y && aP.y < aRect.y + aRect.height;
    }

    public static boolean pointInRectangle(PointD aP, Rectangle aRect) {
        return aP.X > (double)aRect.x && aP.X < (double)(aRect.x + aRect.width) && aP.Y > (double)aRect.y && aP.Y < (double)(aRect.y + aRect.height);
    }

    public static boolean isInclude(Rectangle aRect, Rectangle bRect) {
        if (aRect.width >= bRect.width && aRect.height >= bRect.height) {
            return aRect.x <= bRect.x && aRect.x + aRect.width >= bRect.x + bRect.width && aRect.y <= bRect.y && aRect.y + aRect.height >= bRect.y + bRect.height;
        }
        return false;
    }

    public static PointF calEllipseCoordByAngle(double x0, double y0, double a, double b, double angle) {
        double y;
        double x;
        double dx = Math.sqrt(a * a * b * b / (b * b + a * a * Math.tan(angle) * Math.tan(angle)));
        double dy = dx * Math.tan(angle);
        if (angle <= 1.5707963267948966) {
            x = x0 + dx;
            y = y0 + dy;
        } else if (angle <= Math.PI) {
            x = x0 - dx;
            y = y0 - dy;
        } else if (angle <= 4.71238898038469) {
            x = x0 - dx;
            y = y0 - dy;
        } else {
            x = x0 + dx;
            y = y0 + dy;
        }
        PointF aP = new PointF((float)x, (float)y);
        return aP;
    }

    public static int getDecimalNum(double aData) {
        int dNum;
        if (aData - (double)((int)aData) == 0.0) {
            return 0;
        }
        double v = aData * 10.0;
        for (dNum = 1; v - (double)((int)v) != 0.0 && dNum <= 5; ++dNum) {
            v *= 10.0;
        }
        return dNum;
    }

    public static int getDecimalNum_back(double aData) {
        if (aData - (double)((int)aData) == 0.0) {
            return 0;
        }
        int aE = (int)Math.floor(Math.log10(aData));
        int dNum = aE >= 0 ? 2 : Math.abs(aE);
        return dNum;
    }

    public static float lonDistance(float lon1, float lon2) {
        if (Math.abs(lon1 - lon2) > 180.0f) {
            if (lon1 > lon2) {
                lon2 += 360.0f;
            } else {
                lon1 += 360.0f;
            }
        }
        return Math.abs(lon1 - lon2);
    }

    public static float lonAdd(float lon1, float delta) {
        float lon = lon1 + delta;
        if (lon > 180.0f) {
            lon -= 360.0f;
        }
        if (lon < -180.0f) {
            lon += 360.0f;
        }
        return lon;
    }

    public static double getValue(double[] data, float idx) {
        double v = data[0];
        if (idx == 0.0f) {
            return v;
        }
        for (int i = 1; i < data.length; ++i) {
            if (idx == (float)i) {
                v = data[i];
                break;
            }
            if (!(idx < (float)i)) continue;
            v = data[i - 1] + (data[i] - data[i - 1]) * (double)(idx - (float)(i - 1));
            break;
        }
        return v;
    }

    public static double[] getIntervalValues(double min, double max, double interval) {
        min = BigDecimalUtil.add(min, interval);
        double mod = BigDecimalUtil.mod(min, interval);
        min = BigDecimalUtil.sub(min, mod);
        int cNum = (int)((max - min) / interval) + 1;
        double[] cValues = new double[cNum];
        for (int i = 0; i < cNum; ++i) {
            cValues[i] = BigDecimalUtil.add(min, BigDecimalUtil.mul((double)i, interval));
        }
        return cValues;
    }

    public static double[] getIntervalValues(double min, double max, int n) {
        double range = BigDecimalUtil.sub(max, min);
        if (range == 0.0) {
            return new double[]{min};
        }
        String eStr = String.format("%1$E", range);
        int aD = Integer.parseInt(eStr.substring(0, 1));
        int aE = (int)Math.floor(Math.log10(range));
        while (n > aD) {
            aD *= 10;
            --aE;
        }
        double interval = BigDecimalUtil.mul((double)(aD / n), Math.pow(10.0, aE));
        return MIMath.getIntervalValues(min, max, interval);
    }

    public static double[] getIntervalValues(double min, double max) {
        return (double[])MIMath.getIntervalValues(min, max, false).get(0);
    }

    public static List<Object> getIntervalValues1(double min, double max) {
        return MIMath.getIntervalValues(min, max, false);
    }

    public static List<Object> getIntervalValues(double min, double max, boolean isExtend) {
        int i;
        int cNum;
        double cDelt;
        ArrayList<Object> r = new ArrayList<Object>();
        double range = BigDecimalUtil.sub(max, min);
        if (range == 0.0) {
            r.add(new double[]{min});
            r.add(0.0);
            return r;
        }
        if (range < 0.0) {
            range = -range;
            double temp = min;
            min = max;
            max = temp;
        }
        String eStr = String.format("%1$E", range);
        int aD = Integer.parseInt(eStr.substring(0, 1));
        int aE = (int)Math.floor(Math.log10(range));
        if (aD > 5) {
            cDelt = BigDecimalUtil.pow(10.0, aE);
            cNum = aD;
        } else if (aD == 5) {
            cDelt = (double)aD * BigDecimalUtil.pow(10.0, aE - 1);
            cNum = 10;
            ++cNum;
        } else {
            double cd = BigDecimalUtil.pow(10.0, aE - 1);
            cDelt = BigDecimalUtil.mul(5.0, cd);
            cNum = (int)(range / cDelt);
            if (cNum < 5 && (cNum = (int)(range / (cDelt = BigDecimalUtil.mul(2.0, cd)))) < 5) {
                cDelt = BigDecimalUtil.mul(1.0, cd);
                cNum = (int)(range / cDelt);
            }
        }
        int temp = (int)(min / cDelt + 1.0);
        double newMin = BigDecimalUtil.mul((double)temp, cDelt);
        if (newMin - min >= cDelt) {
            newMin = BigDecimalUtil.sub(newMin, cDelt);
            ++cNum;
        }
        if (newMin + (double)(cNum - 1) * cDelt > max) {
            --cNum;
        } else if (newMin + (double)(cNum - 1) * cDelt + cDelt < max) {
            ++cNum;
        }
        ArrayList<Double> values = new ArrayList<Double>();
        for (i = 0; i < cNum; ++i) {
            values.add(BigDecimalUtil.add(newMin, BigDecimalUtil.mul((double)i, cDelt)));
        }
        if (isExtend) {
            if ((Double)values.get(0) > min) {
                values.add(0, BigDecimalUtil.sub(newMin, cDelt));
            }
            if ((Double)values.get(values.size() - 1) < max) {
                values.add(BigDecimalUtil.add((Double)values.get(values.size() - 1), cDelt));
            }
        }
        double[] cValues = new double[values.size()];
        for (i = 0; i < values.size(); ++i) {
            cValues[i] = (Double)values.get(i);
        }
        r.add(cValues);
        r.add(cDelt);
        return r;
    }

    public static double[] getIntervalValues_Log(double min, double max) {
        int minE = (int)Math.floor(Math.log10(min));
        int maxE = (int)Math.ceil(Math.log10(max));
        if (min == 0.0) {
            minE = maxE - 2;
        }
        if (max == 0.0) {
            maxE = minE + 2;
        }
        double[] cValues = new double[maxE - minE + 1];
        int i = 0;
        for (int v = minE; v <= maxE; ++v) {
            cValues[i] = Math.pow(10.0, v);
            ++i;
        }
        return cValues;
    }

    public static double[] getIntervalValues_Log_bak(double min, double max) {
        int minE = (int)Math.floor(Math.log10(min));
        int maxE = (int)Math.ceil(Math.log10(max));
        if (min == 0.0) {
            minE = maxE - 2;
        }
        if (max == 0.0) {
            maxE = minE + 2;
        }
        ArrayList<Double> values = new ArrayList<Double>();
        for (int v = minE; v <= maxE; ++v) {
            double vv = Math.pow(10.0, v);
            if (!(vv >= min) || !(vv <= max)) continue;
            values.add(vv);
        }
        double[] cValues = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            cValues[i] = (Double)values.get(i);
        }
        return cValues;
    }

    public static double[] cartesianToPolar(double x, double y) {
        double r = Math.hypot(x, y);
        double B = Math.atan2(y, x);
        return new double[]{B, r};
    }

    public static double[] polarToCartesian(double B, double r) {
        double x = Math.cos(B) * r;
        double y = Math.sin(B) * r;
        return new double[]{x, y};
    }
}

