/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.layer;

import com.l2fprod.common.swing.JFontChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteoinfo.data.mapdata.Field;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.layer.LabelSet;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.legend.AlignType;
import org.meteoinfo.legend.LabelBreak;
import org.meteoinfo.map.MapView;
import org.meteoinfo.shape.Graphic;
import org.meteoinfo.shape.ShapeTypes;

public class FrmLabelSet
extends JDialog {
    private final MapView _mapView;
    private VectorLayer _layer;
    private Font _font;
    private Color _color;
    private Color _shadowColor;
    private JButton jButton2;
    private JButton jButton_Add;
    private JButton jButton_Clear;
    private JButton jButton_Font;
    private JButton jButton_Update;
    private JCheckBox jCheckBox_AutoDecimal;
    private JCheckBox jCheckBox_AvoidCollision;
    private JCheckBox jCheckBox_ColorByLegend;
    private JCheckBox jCheckBox_ContourDynamic;
    private JCheckBox jCheckBox_ShadowColor;
    private JComboBox jComboBox_Align;
    private JComboBox jComboBox_Field;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel_Color;
    private JLabel jLabel_DecimalDigits;
    private JLabel jLabel_ShadowColor;
    private JPanel jPanel1;
    private JTextField jTextField_DecimalDigits;
    private JTextField jTextField_XOffset;
    private JTextField jTextField_YOffset;

    public FrmLabelSet(Frame parent, boolean modal, MapView mapView) {
        super(parent, modal);
        this.initComponents();
        this._mapView = mapView;
    }

    private void initComponents() {
        this.jButton2 = new JButton();
        this.jCheckBox_ContourDynamic = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBox_Field = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jTextField_XOffset = new JTextField();
        this.jLabel3 = new JLabel();
        this.jComboBox_Align = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jTextField_YOffset = new JTextField();
        this.jButton_Font = new JButton();
        this.jLabel_Color = new JLabel();
        this.jCheckBox_AvoidCollision = new JCheckBox();
        this.jCheckBox_ColorByLegend = new JCheckBox();
        this.jCheckBox_AutoDecimal = new JCheckBox();
        this.jCheckBox_ShadowColor = new JCheckBox();
        this.jLabel_ShadowColor = new JLabel();
        this.jLabel_DecimalDigits = new JLabel();
        this.jTextField_DecimalDigits = new JTextField();
        this.jButton_Update = new JButton();
        this.jButton_Add = new JButton();
        this.jButton_Clear = new JButton();
        this.jButton2.setText("jButton2");
        this.setDefaultCloseOperation(2);
        this.jCheckBox_ContourDynamic.setText("Contour Dynamic Label");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("Field:");
        this.jComboBox_Field.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLabelSet.this.jComboBox_FieldActionPerformed(evt);
            }
        });
        this.jLabel2.setText("X Offset:");
        this.jTextField_XOffset.setText("0");
        this.jLabel3.setText("Align:");
        this.jComboBox_Align.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel4.setText("Y Offset:");
        this.jTextField_YOffset.setText("0");
        this.jButton_Font.setText("Font");
        this.jButton_Font.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLabelSet.this.jButton_FontActionPerformed(evt);
            }
        });
        this.jLabel_Color.setHorizontalAlignment(0);
        this.jLabel_Color.setText("Color");
        this.jLabel_Color.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel_Color.setHorizontalTextPosition(0);
        this.jLabel_Color.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmLabelSet.this.jLabel_ColorMouseClicked(evt);
            }
        });
        this.jCheckBox_AvoidCollision.setText("Avoid Collision");
        this.jCheckBox_AvoidCollision.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLabelSet.this.jCheckBox_AvoidCollisionActionPerformed(evt);
            }
        });
        this.jCheckBox_ColorByLegend.setText("Color by Legend");
        this.jCheckBox_ColorByLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLabelSet.this.jCheckBox_ColorByLegendActionPerformed(evt);
            }
        });
        this.jCheckBox_AutoDecimal.setText("Auto Decimal");
        this.jCheckBox_AutoDecimal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLabelSet.this.jCheckBox_AutoDecimalActionPerformed(evt);
            }
        });
        this.jCheckBox_ShadowColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLabelSet.this.jCheckBox_ShadowColorActionPerformed(evt);
            }
        });
        this.jLabel_ShadowColor.setHorizontalAlignment(0);
        this.jLabel_ShadowColor.setText("Shadow Color");
        this.jLabel_ShadowColor.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel_ShadowColor.setHorizontalTextPosition(0);
        this.jLabel_ShadowColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmLabelSet.this.jLabel_ShadowColorMouseClicked(evt);
            }
        });
        this.jLabel_DecimalDigits.setText("Decimal Digits:");
        this.jTextField_DecimalDigits.setText("0");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Align, -2, 129, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextField_YOffset, -2, 44, -2).addGap(20, 20, 20)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Field, -2, 129, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_XOffset, -2, 44, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton_Font, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel_Color, -2, 53, -2)).addComponent(this.jCheckBox_ColorByLegend)).addGap(31, 31, 31).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox_AvoidCollision).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBox_ShadowColor).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel_ShadowColor, -1, -1, Short.MAX_VALUE)))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBox_AutoDecimal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel_DecimalDigits).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_DecimalDigits, -2, 44, -2))).addContainerGap(-1, Short.MAX_VALUE)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox_Field, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jTextField_XOffset, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBox_Align, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jTextField_YOffset, -2, -1, -2)).addGap(14, 14, 14).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_Font).addComponent(this.jLabel_Color, -2, 23, -2).addComponent(this.jCheckBox_AvoidCollision)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox_ColorByLegend).addComponent(this.jCheckBox_ShadowColor)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel_ShadowColor, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField_DecimalDigits, -2, -1, -2).addComponent(this.jLabel_DecimalDigits).addComponent(this.jCheckBox_AutoDecimal)))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton_Update.setText("Update");
        this.jButton_Update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLabelSet.this.jButton_UpdateActionPerformed(evt);
            }
        });
        this.jButton_Add.setText("Add");
        this.jButton_Add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLabelSet.this.jButton_AddActionPerformed(evt);
            }
        });
        this.jButton_Clear.setText("Clear");
        this.jButton_Clear.setPreferredSize(new Dimension(69, 23));
        this.jButton_Clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLabelSet.this.jButton_ClearActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBox_ContourDynamic).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jButton_Update).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton_Add, -2, 78, -2).addGap(43, 43, 43).addComponent(this.jButton_Clear, -2, 78, -2).addGap(28, 28, 28)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBox_ContourDynamic).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton_Clear, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_Update).addComponent(this.jButton_Add))).addGap(18, 18, 18)));
        this.pack();
    }

    private void jButton_FontActionPerformed(ActionEvent evt) {
        Font font = JFontChooser.showDialog((Component)this, null, (Font)this._font);
        if (font != null) {
            this._font = font;
            this.updateLabelSet();
            this.updateLabelsFontColor();
            this._mapView.paintLayers();
        }
    }

    private void jLabel_ColorMouseClicked(MouseEvent evt) {
        Color color = JColorChooser.showDialog(this, null, this._color);
        if (color != null) {
            this._color = color;
            this.updateLabelSet();
            this.updateLabelsFontColor();
            this._mapView.paintLayers();
        }
    }

    private void jLabel_ShadowColorMouseClicked(MouseEvent evt) {
        Color color = JColorChooser.showDialog(this, null, this._shadowColor);
        if (color != null) {
            this._shadowColor = color;
            this.updateLabelSet();
            this._mapView.paintLayers();
        }
    }

    private void jCheckBox_ColorByLegendActionPerformed(ActionEvent evt) {
        this.jLabel_Color.setEnabled(this.jCheckBox_ColorByLegend.isSelected());
    }

    private void jComboBox_FieldActionPerformed(ActionEvent evt) {
        if (this.jComboBox_Field.getItemCount() == 0) {
            return;
        }
        if (this.jComboBox_Field.getSelectedItem() == null) {
            return;
        }
        String fieldName = this.jComboBox_Field.getSelectedItem().toString();
        Field field = (Field)this._layer.getAttributeTable().getTable().getColumns().get(fieldName);
        this.jCheckBox_AutoDecimal.setSelected(MIMath.isNumeric(field));
    }

    private void jCheckBox_AvoidCollisionActionPerformed(ActionEvent evt) {
        this._layer.getLabelSet().setAvoidCollision(this.jCheckBox_AvoidCollision.isSelected());
        if (this._layer.getLabelPoints().size() > 0) {
            this._mapView.paintLayers();
        }
    }

    private void jCheckBox_AutoDecimalActionPerformed(ActionEvent evt) {
        this.autoDecimal_CheckedChanged();
    }

    private void jButton_UpdateActionPerformed(ActionEvent evt) {
        this._layer.removeLabels();
        this.updateLabelSet();
        this.addLabels();
        this._mapView.paintLayers();
    }

    private void jButton_AddActionPerformed(ActionEvent evt) {
        this.updateLabelSet();
        this.addLabels();
        this._mapView.paintLayers();
    }

    private void jButton_ClearActionPerformed(ActionEvent evt) {
        this._layer.removeLabels();
        if (!this._layer.getLabelSet().isDynamicContourLabel()) {
            this._layer.getLabelSet().setDrawLabels(false);
        }
        this._mapView.paintLayers();
    }

    private void jCheckBox_ShadowColorActionPerformed(ActionEvent evt) {
        this.updateLabelSet();
        this._mapView.paintLayers();
    }

    private void updateLabelSet() {
        if (this.jComboBox_Field.getSelectedItem() == null) {
            return;
        }
        this._layer.getLabelSet().setFieldName(this.jComboBox_Field.getSelectedItem().toString());
        this._layer.getLabelSet().setAvoidCollision(this.jCheckBox_AvoidCollision.isSelected());
        this._layer.getLabelSet().setLabelAlignType(AlignType.valueOf(this.jComboBox_Align.getSelectedItem().toString()));
        this._layer.getLabelSet().setXOffset(Integer.parseInt(this.jTextField_XOffset.getText()));
        this._layer.getLabelSet().setYOffset(Integer.parseInt(this.jTextField_YOffset.getText()));
        this._layer.getLabelSet().setLabelFont(this._font);
        this._layer.getLabelSet().setLabelColor(this._color);
        this._layer.getLabelSet().setDrawShadow(this.jCheckBox_ShadowColor.isSelected());
        this._layer.getLabelSet().setShadowColor(this._shadowColor);
        this._layer.getLabelSet().setDrawLabels(true);
        this._layer.getLabelSet().setColorByLegend(this.jCheckBox_ColorByLegend.isSelected());
        this._layer.getLabelSet().setDynamicContourLabel(this.jCheckBox_ContourDynamic.isSelected());
        this._layer.getLabelSet().setAutoDecimal(this.jCheckBox_AutoDecimal.isSelected());
        if (!"".equals(this.jTextField_DecimalDigits.getText())) {
            this._layer.getLabelSet().setDecimalDigits(Integer.parseInt(this.jTextField_DecimalDigits.getText()));
        }
    }

    private void addLabels() {
        if (this._layer.getLabelSet().isDynamicContourLabel()) {
            this._layer.addLabelsContourDynamic(this._mapView.getViewExtent());
        } else {
            this._layer.addLabels();
        }
    }

    private void updateLabelsFontColor() {
        for (Graphic lp : this._layer.getLabelPoints()) {
            LabelBreak lb = (LabelBreak)lp.getLegend();
            LabelSet labelSet = this._layer.getLabelSet();
            if (!labelSet.isColorByLegend()) {
                lb.setColor(labelSet.getLabelColor());
            }
            lb.setFont(labelSet.getLabelFont());
        }
    }

    private void autoDecimal_CheckedChanged() {
        if (this.jCheckBox_AutoDecimal.isSelected()) {
            this.jLabel_DecimalDigits.setEnabled(false);
            this.jTextField_DecimalDigits.setEnabled(false);
            this.jTextField_DecimalDigits.setText("");
        } else {
            this.jLabel_DecimalDigits.setEnabled(true);
            this.jTextField_DecimalDigits.setEnabled(true);
            this.jTextField_DecimalDigits.setText(String.valueOf(this._layer.getLabelSet().getDecimalDigits()));
        }
    }

    public void setLayer(VectorLayer aLayer) {
        this._layer = aLayer;
        LabelSet labelSet = this._layer.getLabelSet();
        this._font = labelSet.getLabelFont();
        this._color = labelSet.getLabelColor();
        this._shadowColor = labelSet.getShadowColor();
        this.jComboBox_Field.removeAllItems();
        for (int i = 0; i < this._layer.getFieldNumber(); ++i) {
            this.jComboBox_Field.addItem(this._layer.getFieldName(i));
        }
        if (this.jComboBox_Field.getItemCount() > 0) {
            if (labelSet.getFieldName() != null && !labelSet.getFieldName().isEmpty()) {
                this.jComboBox_Field.setSelectedItem(labelSet.getFieldName());
            } else {
                this.jComboBox_Field.setSelectedIndex(0);
            }
        }
        this.jComboBox_Align.removeAllItems();
        for (AlignType align : AlignType.values()) {
            this.jComboBox_Align.addItem(align.toString());
        }
        this.jComboBox_Align.setSelectedItem(labelSet.getLabelAlignType().toString());
        this.jTextField_XOffset.setText(String.valueOf(labelSet.getXOffset()));
        this.jTextField_YOffset.setText(String.valueOf(labelSet.getYOffset()));
        this.jCheckBox_AvoidCollision.setSelected(labelSet.isAvoidCollision());
        this.jCheckBox_ShadowColor.setSelected(labelSet.isDrawShadow());
        this.jCheckBox_ColorByLegend.setSelected(labelSet.isColorByLegend());
        this.jCheckBox_ContourDynamic.setSelected(labelSet.isDynamicContourLabel());
        if (this._layer.getShapeType() == ShapeTypes.Polyline) {
            this.jCheckBox_ContourDynamic.setEnabled(true);
        } else {
            this.jCheckBox_ContourDynamic.setEnabled(false);
        }
        this.jCheckBox_AutoDecimal.setSelected(labelSet.isAutoDecimal());
        this.autoDecimal_CheckedChanged();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmLabelSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmLabelSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmLabelSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmLabelSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmLabelSet dialog = new FrmLabelSet((Frame)new JFrame(), true, new MapView());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

