/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.layout;

import com.l2fprod.common.beans.BaseBeanInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.meteoinfo.drawing.Draw;
import org.meteoinfo.global.PointF;
import org.meteoinfo.layout.ElementType;
import org.meteoinfo.layout.LayoutElement;
import org.meteoinfo.layout.LayoutMap;
import org.meteoinfo.layout.NorthArrowTypes;
import org.meteoinfo.layout.ResizeAbility;

public class LayoutNorthArrow
extends LayoutElement {
    private LayoutMap _layoutMap;
    private boolean _antiAlias;
    private boolean _drawNeatLine;
    private Color _neatLineColor;
    private float _neatLineSize;
    private NorthArrowTypes _northArrowType;
    private float _angle;

    public LayoutNorthArrow(LayoutMap layoutMap) {
        this.setElementType(ElementType.LayoutNorthArraw);
        this.setResizeAbility(ResizeAbility.ResizeAll);
        this.setWidth(50);
        this.setHeight(50);
        this._layoutMap = layoutMap;
        this._antiAlias = true;
        this._drawNeatLine = false;
        this._neatLineColor = Color.black;
        this._neatLineSize = 1.0f;
        this._northArrowType = NorthArrowTypes.NorthArrow1;
        this._angle = 0.0f;
    }

    public LayoutMap getLayoutMap() {
        return this._layoutMap;
    }

    public boolean isDrawNeatLine() {
        return this._drawNeatLine;
    }

    public void setDrawNeatLine(boolean istrue) {
        this._drawNeatLine = istrue;
    }

    public Color getNeatLineColor() {
        return this._neatLineColor;
    }

    public void setNeatLineColor(Color color) {
        this._neatLineColor = color;
    }

    public float getNeatLineSize() {
        return this._neatLineSize;
    }

    public void setNeatLineSize(float size) {
        this._neatLineSize = size;
    }

    public float getAngle() {
        return this._angle;
    }

    public void setAngle(float angle) {
        this._angle = angle;
    }

    @Override
    public void paint(Graphics2D g) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void paintOnLayout(Graphics2D g, PointF pageLocation, float zoom) {
        if (this.isVisible()) {
            this.paintGraphics(g, pageLocation, zoom);
        }
    }

    public void paintGraphics(Graphics2D g, PointF pageLocation, float zoom) {
        AffineTransform oldMatrix = g.getTransform();
        PointF aP = this.pageToScreen(this.getLeft(), this.getTop(), pageLocation, zoom);
        g.translate(aP.X, aP.Y);
        g.scale(zoom, zoom);
        if (this._angle != 0.0f) {
            g.rotate(this._angle);
        }
        if (this._antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.isDrawBackColor()) {
            g.setColor(this.getBackColor());
            g.fill(new Rectangle2D.Float(0.0f, 0.0f, (float)this.getWidth() * zoom, (float)this.getHeight() * zoom));
        }
        this.drawNorthArrow(g, zoom);
        if (this._drawNeatLine) {
            Rectangle2D.Float mapRect = new Rectangle2D.Float(this._neatLineSize - 1.0f, this._neatLineSize - 1.0f, ((float)this.getWidth() - this._neatLineSize) * zoom, ((float)this.getHeight() - this._neatLineSize) * zoom);
            g.setColor(this._neatLineColor);
            g.setStroke(new BasicStroke(this._neatLineSize));
            g.draw(mapRect);
        }
        g.setTransform(oldMatrix);
    }

    private void drawNorthArrow(Graphics2D g, float zoom) {
        switch (this._northArrowType) {
            case NorthArrow1: {
                this.drawNorthArrow1(g, zoom);
            }
        }
    }

    private void drawNorthArrow1(Graphics2D g, float zoom) {
        g.setColor(this.getForeColor());
        g.setStroke(new BasicStroke(zoom));
        PointF[] points = new PointF[4];
        int x = this.getWidth() / 2;
        int y = this.getHeight() / 6;
        int w = this.getWidth() / 6;
        int h = this.getHeight() / 4;
        points[0] = new PointF(x - w / 2, y + h / 2);
        points[1] = new PointF(x - w / 2, y - h / 2);
        points[2] = new PointF(x + w / 2, y + h / 2);
        points[3] = new PointF(x + w / 2, y - h / 2);
        Draw.drawPolyline(points, g);
        w = this.getWidth() / 2;
        h = this.getHeight() * 2 / 3;
        points = new PointF[]{new PointF(x - w / 2, this.getHeight()), new PointF(x, this.getHeight() - h / 2), new PointF(x, this.getHeight() - h)};
        Draw.fillPolygon(points, g, null);
        points = new PointF[]{new PointF(x + w / 2, this.getHeight()), new PointF(x, this.getHeight() - h / 2), new PointF(x, this.getHeight() - h), points[0]};
        Draw.drawPolyline(points, g);
    }

    @Override
    public void moveUpdate() {
    }

    @Override
    public void resizeUpdate() {
    }

    public static class LayoutNorthArrowBeanBeanInfo
    extends BaseBeanInfo {
        public LayoutNorthArrowBeanBeanInfo() {
            super(LayoutNorthArrowBean.class);
            this.addProperty("drawBackColor").setCategory("General").setDisplayName("Draw Background");
            this.addProperty("backColor").setCategory("General").setDisplayName("Background");
            this.addProperty("foreColor").setCategory("General").setDisplayName("Foreground");
            this.addProperty("drawNeatLine").setCategory("Neat Line").setDisplayName("Draw Neat Line");
            this.addProperty("neatLineColor").setCategory("Neat Line").setDisplayName("Neat Line Color");
            this.addProperty("neatLineSize").setCategory("Neat Line").setDisplayName("Neat Line Size");
            this.addProperty("angle").setCategory("Location").setDisplayName("Angle");
            this.addProperty("left").setCategory("Location").setDisplayName("Left");
            this.addProperty("top").setCategory("Location").setDisplayName("Top");
            this.addProperty("width").setCategory("Location").setDisplayName("Width");
            this.addProperty("height").setCategory("Location").setDisplayName("Height");
        }
    }

    public class LayoutNorthArrowBean {
        LayoutNorthArrowBean() {
        }

        public boolean isDrawNeatLine() {
            return LayoutNorthArrow.this._drawNeatLine;
        }

        public void setDrawNeatLine(boolean istrue) {
            LayoutNorthArrow.this._drawNeatLine = istrue;
        }

        public Color getNeatLineColor() {
            return LayoutNorthArrow.this._neatLineColor;
        }

        public void setNeatLineColor(Color color) {
            LayoutNorthArrow.this._neatLineColor = color;
        }

        public float getNeatLineSize() {
            return LayoutNorthArrow.this._neatLineSize;
        }

        public void setNeatLineSize(float size) {
            LayoutNorthArrow.this._neatLineSize = size;
        }

        public float getAngle() {
            return LayoutNorthArrow.this._angle;
        }

        public void setAngle(float angle) {
            LayoutNorthArrow.this._angle = angle;
        }

        public boolean isDrawBackColor() {
            return LayoutNorthArrow.this.isDrawBackColor();
        }

        public void setDrawBackColor(boolean value) {
            LayoutNorthArrow.this.setDrawBackColor(value);
        }

        public Color getBackColor() {
            return LayoutNorthArrow.this.getBackColor();
        }

        public void setBackColor(Color c) {
            LayoutNorthArrow.this.setBackColor(c);
        }

        public Color getForeColor() {
            return LayoutNorthArrow.this.getForeColor();
        }

        public void setForeColor(Color c) {
            LayoutNorthArrow.this.setForeColor(c);
        }

        public int getLeft() {
            return LayoutNorthArrow.this.getLeft();
        }

        public void setLeft(int left) {
            LayoutNorthArrow.this.setLeft(left);
        }

        public int getTop() {
            return LayoutNorthArrow.this.getTop();
        }

        public void setTop(int top) {
            LayoutNorthArrow.this.setTop(top);
        }

        public int getWidth() {
            return LayoutNorthArrow.this.getWidth();
        }

        public void setWidth(int width) {
            LayoutNorthArrow.this.setWidth(width);
        }

        public int getHeight() {
            return LayoutNorthArrow.this.getHeight();
        }

        public void setHeight(int height) {
            LayoutNorthArrow.this.setHeight(height);
        }
    }
}

