/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.legend;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.parsers.ParserConfigurationException;
import org.meteoinfo.global.GenericFileFilter;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.FrmLegendBreaks;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.LegendView;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.PolylineBreak;
import org.meteoinfo.shape.ShapeTypes;
import org.xml.sax.SAXException;

public class FrmLegendSet
extends JDialog {
    private LegendScheme _legendScheme = null;
    private boolean _isOK = false;
    private JButton jButton_AddBreak;
    private JButton jButton_Cancel;
    private JButton jButton_ExportLegend;
    private JButton jButton_ImportLegend;
    private JButton jButton_MakeBreaks;
    private JButton jButton_MoveBreakDown;
    private JButton jButton_MoveBreakUp;
    private JButton jButton_OK;
    private JButton jButton_RemoveAllBreaks;
    private JButton jButton_RemoveBreak;
    private JButton jButton_ReverseBreaks;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar jToolBar1;
    private LegendView legendView1;

    public FrmLegendSet(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public FrmLegendSet(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButton_ImportLegend = new JButton();
        this.jButton_ExportLegend = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButton_AddBreak = new JButton();
        this.jButton_RemoveBreak = new JButton();
        this.jButton_RemoveAllBreaks = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButton_MoveBreakUp = new JButton();
        this.jButton_MoveBreakDown = new JButton();
        this.jButton_ReverseBreaks = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButton_MakeBreaks = new JButton();
        this.legendView1 = new LegendView();
        this.jButton_OK = new JButton();
        this.jButton_Cancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButton_ImportLegend.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Open.Image.png")));
        this.jButton_ImportLegend.setToolTipText("Import Legend");
        this.jButton_ImportLegend.setFocusable(false);
        this.jButton_ImportLegend.setHorizontalTextPosition(0);
        this.jButton_ImportLegend.setVerticalTextPosition(3);
        this.jButton_ImportLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLegendSet.this.jButton_ImportLegendActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_ImportLegend);
        this.jButton_ExportLegend.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Save.Image.png")));
        this.jButton_ExportLegend.setToolTipText("Export Legend");
        this.jButton_ExportLegend.setFocusable(false);
        this.jButton_ExportLegend.setHorizontalTextPosition(0);
        this.jButton_ExportLegend.setVerticalTextPosition(3);
        this.jButton_ExportLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLegendSet.this.jButton_ExportLegendActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_ExportLegend);
        this.jToolBar1.add(this.jSeparator1);
        this.jButton_AddBreak.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Add.Image.png")));
        this.jButton_AddBreak.setToolTipText("Add Break");
        this.jButton_AddBreak.setFocusable(false);
        this.jButton_AddBreak.setHorizontalTextPosition(0);
        this.jButton_AddBreak.setVerticalTextPosition(3);
        this.jButton_AddBreak.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLegendSet.this.jButton_AddBreakActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_AddBreak);
        this.jButton_RemoveBreak.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Del.Image.png")));
        this.jButton_RemoveBreak.setToolTipText("Remove Break");
        this.jButton_RemoveBreak.setFocusable(false);
        this.jButton_RemoveBreak.setHorizontalTextPosition(0);
        this.jButton_RemoveBreak.setVerticalTextPosition(3);
        this.jButton_RemoveBreak.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLegendSet.this.jButton_RemoveBreakActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_RemoveBreak);
        this.jButton_RemoveAllBreaks.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_DelAll.Image.png")));
        this.jButton_RemoveAllBreaks.setToolTipText("Remove All Breaks");
        this.jButton_RemoveAllBreaks.setFocusable(false);
        this.jButton_RemoveAllBreaks.setHorizontalTextPosition(0);
        this.jButton_RemoveAllBreaks.setVerticalTextPosition(3);
        this.jButton_RemoveAllBreaks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLegendSet.this.jButton_RemoveAllBreaksActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_RemoveAllBreaks);
        this.jToolBar1.add(this.jSeparator2);
        this.jButton_MoveBreakUp.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Up.Image.png")));
        this.jButton_MoveBreakUp.setToolTipText("Move Break Up");
        this.jButton_MoveBreakUp.setFocusable(false);
        this.jButton_MoveBreakUp.setHorizontalTextPosition(0);
        this.jButton_MoveBreakUp.setVerticalTextPosition(3);
        this.jButton_MoveBreakUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLegendSet.this.jButton_MoveBreakUpActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_MoveBreakUp);
        this.jButton_MoveBreakDown.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Down.Image.png")));
        this.jButton_MoveBreakDown.setToolTipText("Move Break Down");
        this.jButton_MoveBreakDown.setFocusable(false);
        this.jButton_MoveBreakDown.setHorizontalTextPosition(0);
        this.jButton_MoveBreakDown.setVerticalTextPosition(3);
        this.jButton_MoveBreakDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLegendSet.this.jButton_MoveBreakDownActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_MoveBreakDown);
        this.jButton_ReverseBreaks.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Reverse.Image.png")));
        this.jButton_ReverseBreaks.setToolTipText("Reverse Breaks");
        this.jButton_ReverseBreaks.setFocusable(false);
        this.jButton_ReverseBreaks.setHorizontalTextPosition(0);
        this.jButton_ReverseBreaks.setVerticalTextPosition(3);
        this.jButton_ReverseBreaks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLegendSet.this.jButton_ReverseBreaksActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_ReverseBreaks);
        this.jToolBar1.add(this.jSeparator3);
        this.jButton_MakeBreaks.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_MakeBreaks.Image.png")));
        this.jButton_MakeBreaks.setFocusable(false);
        this.jButton_MakeBreaks.setHorizontalTextPosition(0);
        this.jButton_MakeBreaks.setVerticalTextPosition(3);
        this.jButton_MakeBreaks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLegendSet.this.jButton_MakeBreaksActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_MakeBreaks);
        GroupLayout legendView1Layout = new GroupLayout(this.legendView1);
        this.legendView1.setLayout(legendView1Layout);
        legendView1Layout.setHorizontalGroup(legendView1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 382, Short.MAX_VALUE));
        legendView1Layout.setVerticalGroup(legendView1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 342, Short.MAX_VALUE));
        this.jButton_OK.setText("OK");
        this.jButton_OK.setPreferredSize(new Dimension(70, 27));
        this.jButton_OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLegendSet.this.jButton_OKActionPerformed(evt);
            }
        });
        this.jButton_Cancel.setText("Cancel");
        this.jButton_Cancel.setPreferredSize(new Dimension(70, 27));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLegendSet.this.jButton_CancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 382, Short.MAX_VALUE).addComponent(this.legendView1, GroupLayout.Alignment.TRAILING, -1, 382, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(68, 68, 68).addComponent(this.jButton_OK, -2, 71, -2).addGap(69, 69, 69).addComponent(this.jButton_Cancel, -2, 82, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.legendView1, -1, 342, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(this.jButton_OK, -1, -1, Short.MAX_VALUE).addComponent(this.jButton_Cancel, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void jButton_ImportLegendActionPerformed(ActionEvent evt) {
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(new File(System.getProperty("user.dir")));
        String[] fileExts = new String[]{"lgs", "pal"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "LegendScheme file (*.lgs,*.pal)");
        aDlg.setFileFilter(mapFileFilter);
        if (0 == aDlg.showOpenDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            System.setProperty("user.dir", aFile.getParent());
            String fext = GenericFileFilter.getExtension(aFile);
            if (fext.equals("pal")) {
                this._legendScheme.importFromPaletteFile_Unique(aFile.getAbsolutePath());
            } else if (fext.equals("lgs")) {
                try {
                    this._legendScheme.importFromXMLFile(aFile.getAbsolutePath());
                }
                catch (ParserConfigurationException ex) {
                    Logger.getLogger(FrmLegendSet.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (SAXException ex) {
                    Logger.getLogger(FrmLegendSet.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(FrmLegendSet.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.legendView1.update(this._legendScheme);
        }
    }

    private void jButton_ExportLegendActionPerformed(ActionEvent evt) {
        JFileChooser aDlg = new JFileChooser();
        String[] fileExts = new String[]{"lgs"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "LegendScheme file (*.lgs)");
        aDlg.setFileFilter(mapFileFilter);
        String path = System.getProperty("user.dir");
        aDlg.setCurrentDirectory(new File(path));
        if (0 == aDlg.showSaveDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            String filePath = aFile.getAbsolutePath();
            if (!filePath.substring(filePath.length() - 4).equals(".lgs")) {
                filePath = filePath + ".lgs";
            }
            try {
                this._legendScheme.exportToXMLFile(filePath);
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(FrmLegendSet.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void jButton_AddBreakActionPerformed(ActionEvent evt) {
        switch (this._legendScheme.getShapeType()) {
            case Polyline: 
            case PolylineZ: {
                PolylineBreak aPLB = new PolylineBreak();
                aPLB.setDrawPolyline(true);
                aPLB.setWidth(0.1f);
                aPLB.setColor(Color.red);
                aPLB.setStartValue(0);
                aPLB.setEndValue(0);
                aPLB.setCaption("");
                this._legendScheme.getLegendBreaks().add(aPLB);
                break;
            }
            case Point: {
                PointBreak aPB = new PointBreak();
                aPB.setDrawShape(true);
                aPB.setDrawFill(true);
                aPB.setSize(5.0f);
                aPB.setColor(Color.red);
                aPB.setStartValue(0);
                aPB.setEndValue(0);
                aPB.setCaption("");
                this._legendScheme.getLegendBreaks().add(aPB);
                break;
            }
            case Polygon: {
                PolygonBreak aPGB = new PolygonBreak();
                aPGB.setDrawShape(true);
                aPGB.setDrawFill(true);
                aPGB.setColor(Color.red);
                aPGB.setStartValue(0);
                aPGB.setEndValue(0);
                aPGB.setCaption("");
                this._legendScheme.getLegendBreaks().add(aPGB);
                break;
            }
            case Image: {
                ColorBreak aCB = new ColorBreak();
                aCB.setColor(Color.red);
                aCB.setStartValue(0);
                aCB.setEndValue(0);
                aCB.setCaption("");
                this._legendScheme.getLegendBreaks().add(aCB);
            }
        }
        this.legendView1.update(this._legendScheme);
    }

    private void jButton_RemoveBreakActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.legendView1.getSelectedRows().size(); ++i) {
            int rowIdx = this.legendView1.getSelectedRows().get(i);
            this._legendScheme.getLegendBreaks().remove(rowIdx);
        }
        this.legendView1.update(this._legendScheme);
    }

    private void jButton_RemoveAllBreaksActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(null, "If remove all breaks?", "Alarm", 0) == 0) {
            this._legendScheme.getLegendBreaks().clear();
            this.legendView1.update(this._legendScheme);
        }
    }

    private void jButton_MoveBreakUpActionPerformed(ActionEvent evt) {
        int oldIdx = this.legendView1.getSelectedRows().get(0);
        if (oldIdx > 0) {
            PointBreak aPB;
            if (this._legendScheme.getShapeType() == ShapeTypes.Point && (aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(oldIdx)).isNoData()) {
                return;
            }
            int newIdx = oldIdx - 1;
            this._legendScheme.getLegendBreaks().add(newIdx, this._legendScheme.getLegendBreaks().get(oldIdx));
            this._legendScheme.getLegendBreaks().remove(oldIdx + 1);
            this.legendView1.getSelectedRows().clear();
            this.legendView1.getSelectedRows().add(newIdx);
            this.legendView1.update(this._legendScheme);
        }
    }

    private void jButton_MoveBreakDownActionPerformed(ActionEvent evt) {
        PointBreak aPB;
        int oldIdx = this.legendView1.getSelectedRows().get(0);
        int endIdx = this.legendView1.getLegendScheme().getBreakNum() - 1;
        if (this._legendScheme.getShapeType() == ShapeTypes.Point && (aPB = (PointBreak)this._legendScheme.getLegendBreaks().get(oldIdx)).isNoData()) {
            --endIdx;
        }
        if (oldIdx < endIdx) {
            int newIdx = oldIdx + 2;
            this._legendScheme.getLegendBreaks().add(newIdx, this._legendScheme.getLegendBreaks().get(oldIdx));
            this._legendScheme.getLegendBreaks().remove(oldIdx);
            this.legendView1.getSelectedRows().clear();
            this.legendView1.getSelectedRows().add(newIdx - 1);
            this.legendView1.update(this._legendScheme);
        }
    }

    private void jButton_ReverseBreaksActionPerformed(ActionEvent evt) {
        Collections.reverse(this._legendScheme.getLegendBreaks());
        if (this._legendScheme.getHasNoData()) {
            this._legendScheme.getLegendBreaks().add(this._legendScheme.getLegendBreaks().get(0));
            this._legendScheme.getLegendBreaks().remove(0);
        }
        this.legendView1.update(this._legendScheme);
    }

    private void jButton_MakeBreaksActionPerformed(ActionEvent evt) {
        FrmLegendBreaks frmLB = new FrmLegendBreaks((Dialog)this, false, false);
        frmLB.setLegendScheme(this._legendScheme);
        frmLB.setLocationRelativeTo(this);
        frmLB.setVisible(true);
    }

    private void jButton_OKActionPerformed(ActionEvent evt) {
        this._isOK = true;
        this.dispose();
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public boolean isOK() {
        return this._isOK;
    }

    public void setLegendScheme(LegendScheme aLS) {
        this._legendScheme = (LegendScheme)aLS.clone();
        this.legendView1.setLegendScheme(this._legendScheme);
        this.legendView1.update(aLS);
    }

    public LegendScheme getLegendScheme() {
        return this._legendScheme;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmLegendSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmLegendSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmLegendSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmLegendSet.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmLegendSet dialog = new FrmLegendSet((Dialog)new JDialog(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

