/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.legend;

import java.awt.Color;
import java.util.HashMap;
import org.meteoinfo.legend.BreakTypes;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.HatchStyle;

public class PolygonBreak
extends ColorBreak {
    protected Color outlineColor;
    protected float outlineSize;
    protected boolean drawOutline;
    protected boolean drawFill;
    protected HatchStyle style;
    protected int styleSize;
    protected Color backColor;
    protected boolean isMaskout;

    public PolygonBreak() {
        this.breakType = BreakTypes.PolygonBreak;
        this.outlineColor = Color.black;
        this.outlineSize = 1.0f;
        this.drawOutline = true;
        this.drawFill = true;
        this.style = HatchStyle.NONE;
        this.styleSize = 8;
        this.backColor = new Color(1.0f, 1.0f, 1.0f, 0.0f);
        this.isMaskout = false;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color c) {
        this.outlineColor = c;
    }

    public float getOutlineSize() {
        return this.outlineSize;
    }

    public void setOutlineSize(float size) {
        this.outlineSize = size;
    }

    public boolean isDrawOutline() {
        return this.drawOutline;
    }

    public void setDrawOutline(boolean isTrue) {
        this.drawOutline = isTrue;
    }

    public boolean isDrawFill() {
        return this.drawFill;
    }

    public void setDrawFill(boolean isTrue) {
        this.drawFill = isTrue;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setBackColor(Color c) {
        this.backColor = c;
    }

    public boolean isUsingHatchStyle() {
        return this.style != HatchStyle.NONE;
    }

    public HatchStyle getStyle() {
        return this.style;
    }

    public void setStyle(HatchStyle value) {
        this.style = value;
    }

    public void setStyle(String value) {
        this.style = HatchStyle.getStyle(value);
    }

    public int getStyleSize() {
        return this.styleSize;
    }

    public void setStyleSize(int value) {
        this.styleSize = value;
    }

    public boolean isMaskout() {
        return this.isMaskout;
    }

    public void setMaskout(boolean isTrue) {
        this.isMaskout = isTrue;
    }

    @Override
    public Object getPropertyObject() {
        HashMap<String, String> objAttr = new HashMap<String, String>();
        objAttr.put("Color", "Color");
        objAttr.put("OutlineColor", "OutlineColor");
        objAttr.put("OutlineSize", "OutlineSize");
        objAttr.put("DrawOutline", "DrawOutline");
        objAttr.put("DrawFill", "DrawFill");
        objAttr.put("DrawPolygon", "DrawPolygon");
        objAttr.put("UsingHatchStyle", "UsingHatchStyle");
        objAttr.put("Style", "Style");
        objAttr.put("SytleSize", "StyleSize");
        objAttr.put("BackColor", "BackColor");
        objAttr.put("TransparencyPercent", "TransparencyPercent");
        return objAttr;
    }

    @Override
    public Object clone() {
        PolygonBreak aCB = new PolygonBreak();
        aCB.setCaption(this.getCaption());
        aCB.setColor(this.getColor());
        aCB.setDrawShape(this.isDrawShape());
        aCB.setEndValue(this.getEndValue());
        aCB.setNoData(this.isNoData());
        aCB.setStartValue(this.getStartValue());
        aCB.setOutlineColor(this.outlineColor);
        aCB.setOutlineSize(this.outlineSize);
        aCB.setDrawOutline(this.drawOutline);
        aCB.setDrawFill(this.drawFill);
        aCB.setStyle(this.style);
        aCB.setStyleSize(this.styleSize);
        aCB.setBackColor(this.backColor);
        aCB.setMaskout(this.isMaskout);
        return aCB;
    }
}

