/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.legend;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.EventListenerList;
import org.meteoinfo.drawing.Draw;
import org.meteoinfo.global.PointF;
import org.meteoinfo.global.event.ISelectedCellChangedListener;
import org.meteoinfo.global.event.SelectedCellChangedEvent;
import org.meteoinfo.legend.HatchStyle;
import org.meteoinfo.legend.LineStyles;
import org.meteoinfo.legend.MarkerType;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PointStyle;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.PolylineBreak;
import org.meteoinfo.shape.ShapeTypes;

public class SymbolControl
extends JPanel {
    private EventListenerList _listeners = new EventListenerList();
    private ShapeTypes _shapeType;
    private MarkerType _markerType;
    private Dimension _cellSize;
    private int _symbolNumber;
    private int _colNumber;
    private int _rowNumber;
    private int _selectedCell;
    private List<Image> _imageList;
    private JScrollBar _vScrollBar;
    private Color _selColor = new Color(210, 255, 255);

    public SymbolControl() {
        this.initComponents();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SymbolControl.this.onComponentResized(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SymbolControl.this.onMouseClicked(e);
            }
        });
        this._shapeType = ShapeTypes.Point;
        this._markerType = MarkerType.Simple;
        this._cellSize = new Dimension(25, 25);
        this._symbolNumber = PointStyle.values().length;
        this._colNumber = 10;
        this._rowNumber = 26;
        this._selectedCell = -1;
        this._imageList = new ArrayList<Image>();
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(200, 100));
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this._vScrollBar = new JScrollBar(1);
        this._vScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                SymbolControl.this.onScrollValueChanged(e);
            }
        });
        this.add((Component)this._vScrollBar, "East");
        this._vScrollBar.setSize(20, this.getHeight());
        this._vScrollBar.setLocation(this.getWidth() - this._vScrollBar.getWidth(), 0);
    }

    public void addSelectedCellChangedListener(ISelectedCellChangedListener listener) {
        this._listeners.add(ISelectedCellChangedListener.class, listener);
    }

    public void removeSelectedCellChangedListener(ISelectedCellChangedListener listener) {
        this._listeners.remove(ISelectedCellChangedListener.class, listener);
    }

    public void fireSelectedCellChangedEvent() {
        this.fireSelectedCellChangedEvent(new SelectedCellChangedEvent(this));
    }

    private void fireSelectedCellChangedEvent(SelectedCellChangedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ISelectedCellChangedListener.class) continue;
            ((ISelectedCellChangedListener)listeners[i + 1]).selectedCellChangedEvent(event);
        }
    }

    public void onScrollValueChanged(AdjustmentEvent e) {
        this._vScrollBar.setValue(e.getValue());
        this.repaint();
    }

    public void onComponentResized(ComponentEvent e) {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this.updateSize();
            this._vScrollBar.setLocation(this.getWidth() - this._vScrollBar.getWidth(), 0);
            this._vScrollBar.setSize(this._vScrollBar.getWidth(), this.getHeight());
        }
        this.repaint();
    }

    public void onMouseClicked(MouseEvent e) {
        int col = e.getX() / this._cellSize.width;
        int row = (e.getY() + this._vScrollBar.getValue()) / this._cellSize.height;
        int sel = row * this._colNumber + col;
        if (sel < this._symbolNumber) {
            this._selectedCell = row * this._colNumber + col;
            this.repaint();
            this.fireSelectedCellChangedEvent();
        }
    }

    public ShapeTypes getShapeType() {
        return this._shapeType;
    }

    public void setShapeType(ShapeTypes st) {
        this._shapeType = st;
        switch (this._shapeType) {
            case Point: {
                this.setCellSize(new Dimension(25, 25));
                if (this._markerType == MarkerType.Simple) {
                    this.setSymbolNumber(PointStyle.values().length);
                    break;
                }
                this.setSymbolNumber(256);
                break;
            }
            case Polyline: {
                this.setCellSize(new Dimension(50, 40));
                this.setSymbolNumber(LineStyles.values().length);
                break;
            }
            case Polygon: {
                this.setCellSize(new Dimension(30, 30));
                this.setSymbolNumber(HatchStyle.values().length);
            }
        }
    }

    public MarkerType getMarkerType() {
        return this._markerType;
    }

    public void setMarkerType(MarkerType mt) {
        this._markerType = mt;
        if (this._selectedCell < 0 || this._selectedCell >= this._symbolNumber) {
            this._selectedCell = 0;
        }
        this.repaint();
    }

    public Dimension getCellSize() {
        return this._cellSize;
    }

    public void setCellSize(Dimension size) {
        this._cellSize = size;
        this.updateSize();
    }

    public int getSelectedCell() {
        return this._selectedCell;
    }

    public void setSelectedCell(int idx) {
        this._selectedCell = idx;
    }

    public int getSymbolNumber() {
        return this._symbolNumber;
    }

    public void setSymbolNumber(int sn) {
        this._symbolNumber = sn;
        this._rowNumber = (int)Math.ceil((float)this._symbolNumber / (float)this._colNumber);
    }

    public int getColumnNumber() {
        return this._colNumber;
    }

    public void setColumnNumber(int n) {
        this._colNumber = n;
    }

    public void setIamgeList(List<Image> imageList) {
        this._imageList = imageList;
        this.setSymbolNumber(imageList.size());
    }

    private void updateSize() {
        this._colNumber = this._vScrollBar.isVisible() ? (this.getWidth() - this._vScrollBar.getWidth()) / this._cellSize.width : this.getWidth() / this._cellSize.width;
        if (this._colNumber == 0) {
            this._colNumber = 1;
        }
        this._rowNumber = (int)Math.ceil((float)this._symbolNumber / (float)this._colNumber);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintGraphics(g2);
    }

    private void paintGraphics(Graphics2D g) {
        Rectangle rect;
        int TotalHeight = this.calcTotalDrawHeight();
        if (TotalHeight > this.getHeight()) {
            this._vScrollBar.setMinimum(0);
            this._vScrollBar.setUnitIncrement(this._cellSize.height);
            this._vScrollBar.setBlockIncrement(this.getHeight());
            this._vScrollBar.setMaximum(TotalHeight);
            if (!this._vScrollBar.isVisible()) {
                this._vScrollBar.setValue(0);
                this._vScrollBar.setVisible(true);
            }
            rect = new Rectangle(0, -this._vScrollBar.getValue(), this.getWidth() - this._vScrollBar.getWidth(), TotalHeight);
        } else {
            this._vScrollBar.setVisible(false);
            rect = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        this.updateSize();
        this.drawCells(g, rect.y);
    }

    private void drawCells(Graphics2D g, int sHeight) {
        int hideRows = 0;
        block0 : switch (this._shapeType) {
            case Point: {
                switch (this._markerType) {
                    case Character: {
                        Font smallFont = new Font(this.getFont().getFamily(), 0, (int)((float)this._cellSize.width * 0.8f));
                        for (int i = 0; i < this._symbolNumber; ++i) {
                            int row = i / this._colNumber;
                            if (row > hideRows) {
                                sHeight += this._cellSize.height;
                                hideRows = row;
                            }
                            if (sHeight + this._cellSize.height < 0) continue;
                            int col = i % this._colNumber;
                            if (i == this._selectedCell) {
                                g.setColor(this._selColor);
                                g.fill(new Rectangle(col * this._cellSize.width, sHeight, this._cellSize.width, this._cellSize.height));
                            }
                            String text = String.valueOf((char)i);
                            g.setColor(Color.black);
                            g.setFont(smallFont);
                            g.drawString(text, col * this._cellSize.width, sHeight + this._cellSize.height);
                        }
                        break block0;
                    }
                    case Simple: {
                        PointBreak aPB = new PointBreak();
                        aPB.setColor(Color.red);
                        aPB.setDrawOutline(true);
                        aPB.setSize((float)this._cellSize.width * 0.8f);
                        for (int i = 0; i < this._symbolNumber; ++i) {
                            int row = i / this._colNumber;
                            if (row > hideRows) {
                                sHeight += this._cellSize.height;
                                hideRows = row;
                            }
                            if (sHeight + this._cellSize.height < 0) continue;
                            int col = i % this._colNumber;
                            if (i == this._selectedCell) {
                                g.setColor(this._selColor);
                                g.fill(new Rectangle(col * this._cellSize.width, sHeight, this._cellSize.width, this._cellSize.height));
                            }
                            PointF sP = new PointF(col * this._cellSize.width + this._cellSize.width / 2, sHeight + this._cellSize.height / 2);
                            aPB.setStyle(PointStyle.values()[i]);
                            Draw.drawPoint(sP, aPB, g);
                        }
                        break block0;
                    }
                    case Image: {
                        float size = (float)this._cellSize.width * 0.8f;
                        for (int i = 0; i < this._symbolNumber; ++i) {
                            int row = i / this._colNumber;
                            if (row > hideRows) {
                                sHeight += this._cellSize.height;
                                hideRows = row;
                            }
                            if (sHeight + this._cellSize.height < 0) continue;
                            int col = i % this._colNumber;
                            if (i == this._selectedCell) {
                                g.setColor(this._selColor);
                                g.fill(new Rectangle(col * this._cellSize.width, sHeight, this._cellSize.width, this._cellSize.height));
                            }
                            if (this._imageList.size() <= i) continue;
                            g.drawImage(this._imageList.get(i), col * this._cellSize.width, sHeight, (int)size, (int)size, null);
                        }
                    }
                }
                break;
            }
            case Polyline: {
                PolylineBreak aPLB = new PolylineBreak();
                aPLB.setWidth(2.0f);
                aPLB.setColor(Color.black);
                for (int i = 0; i < this._symbolNumber; ++i) {
                    int row = i / this._colNumber;
                    if (row > hideRows) {
                        sHeight += this._cellSize.height;
                        hideRows = row;
                    }
                    if (sHeight + this._cellSize.height < 0) continue;
                    int col = i % this._colNumber;
                    Rectangle rect = new Rectangle(col * this._cellSize.width, sHeight + this._cellSize.height / 4, this._cellSize.width, this._cellSize.height / 2);
                    if (i == this._selectedCell) {
                        g.setColor(this._selColor);
                        g.fill(rect);
                    }
                    aPLB.setStyle(LineStyles.values()[i]);
                    Draw.drawPolylineSymbol(new PointF(rect.x + rect.width / 2, rect.y + rect.height / 2), (float)rect.width * 0.8f, (float)rect.height * 0.8f, aPLB, g);
                }
                break;
            }
            case Polygon: {
                PolygonBreak aPGB = new PolygonBreak();
                aPGB.setColor(Color.red);
                aPGB.setOutlineColor(Color.black);
                for (int i = 0; i < this._symbolNumber; ++i) {
                    int row = i / this._colNumber;
                    if (row > hideRows) {
                        sHeight += this._cellSize.height;
                        hideRows = row;
                    }
                    if (sHeight + this._cellSize.height < 0) continue;
                    int col = i % this._colNumber;
                    Rectangle rect = new Rectangle(col * this._cellSize.width, sHeight, this._cellSize.width, this._cellSize.height);
                    if (i == this._selectedCell) {
                        g.setColor(this._selColor);
                        g.fill(rect);
                    }
                    aPGB.setStyle(HatchStyle.values()[i]);
                    Draw.drawPolygonSymbol(new PointF(rect.x + rect.width / 2, rect.y + rect.height / 2), (float)rect.width * 0.8f, (float)rect.height * 0.8f, aPGB, g);
                }
                break;
            }
        }
    }

    private int calcTotalDrawHeight() {
        return this._cellSize.height * this._rowNumber;
    }
}

