/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.distribution;

import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import ucar.ma2.Array;
import ucar.ma2.DataType;

public class DistributionUtil {
    public static Array rvs(RealDistribution dis, int n) {
        double[] samples = dis.sample(n);
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n}, (Object)samples);
        return r;
    }

    public static double pdf(RealDistribution dis, Number x) {
        return dis.density(x.doubleValue());
    }

    public static Array pdf(RealDistribution dis, Array x) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])x.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, dis.density(x.getDouble(i)));
            ++i;
        }
        return r;
    }

    public static double logpdf(NormalDistribution dis, Number x) {
        return dis.logDensity(x.doubleValue());
    }

    public static Array logpdf(NormalDistribution dis, Array x) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])x.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, dis.logDensity(x.getDouble(i)));
            ++i;
        }
        return r;
    }

    public static double cdf(RealDistribution dis, Number x) {
        return dis.cumulativeProbability(x.doubleValue());
    }

    public static Array cdf(RealDistribution dis, Array x) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])x.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, dis.cumulativeProbability(x.getDouble(i)));
            ++i;
        }
        return r;
    }

    public static double pmf(RealDistribution dis, Number x) {
        return dis.probability(x.doubleValue());
    }

    public static Array pmf(RealDistribution dis, Array x) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])x.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, dis.probability(x.getDouble(i)));
            ++i;
        }
        return r;
    }

    public static double ppf(RealDistribution dis, Number q) {
        return dis.inverseCumulativeProbability(q.doubleValue());
    }

    public static Array ppf(RealDistribution dis, Array q) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])q.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, dis.inverseCumulativeProbability(q.getDouble(i)));
            ++i;
        }
        return r;
    }
}

