/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection.proj4j.proj;

import org.meteoinfo.projection.proj4j.ProjCoordinate;
import org.meteoinfo.projection.proj4j.ProjectionException;
import org.meteoinfo.projection.proj4j.proj.AzimuthalProjection;
import org.meteoinfo.projection.proj4j.util.ProjectionMath;

public class OrthographicAzimuthalProjection
extends AzimuthalProjection {
    public OrthographicAzimuthalProjection() {
        this.proj4Name = "ortho";
        this.name = "Orthographic";
        this.initialize();
    }

    @Override
    public ProjCoordinate project(double lam, double phi, ProjCoordinate xy) {
        double cosphi = Math.cos(phi);
        double coslam = Math.cos(lam);
        switch (this.mode) {
            case 3: {
                if (cosphi * coslam < -1.0E-10) {
                    xy.x = Double.NaN;
                    xy.y = Double.NaN;
                    break;
                }
                xy.y = Math.sin(phi);
                break;
            }
            case 4: {
                double sinphi = Math.sin(phi);
                if (this.sinphi0 * sinphi + this.cosphi0 * cosphi * coslam < -1.0E-10) {
                    xy.x = Double.NaN;
                    xy.y = Double.NaN;
                    break;
                }
                xy.y = this.cosphi0 * sinphi - this.sinphi0 * cosphi * coslam;
                break;
            }
            case 1: {
                coslam = -coslam;
            }
            case 2: {
                if (Math.abs(phi - this.projectionLatitude) - 1.0E-10 > 1.5707963267948966) {
                    xy.x = Double.NaN;
                    xy.y = Double.NaN;
                    break;
                }
                xy.y = cosphi * coslam;
            }
        }
        if (xy.x != Double.NaN) {
            xy.x = cosphi * Math.sin(lam);
        }
        return xy;
    }

    @Override
    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate lp) {
        double d;
        double rh;
        double sinc = rh = ProjectionMath.distance(x, y);
        if (d > 1.0) {
            if (sinc - 1.0 > 1.0E-10) {
                throw new ProjectionException();
            }
            sinc = 1.0;
        }
        double cosc = Math.sqrt(1.0 - sinc * sinc);
        if (Math.abs(rh) <= 1.0E-10) {
            lp.y = this.projectionLatitude;
        } else {
            switch (this.mode) {
                case 1: {
                    y = -y;
                    lp.y = Math.acos(sinc);
                    break;
                }
                case 2: {
                    lp.y = -Math.acos(sinc);
                    break;
                }
                case 3: {
                    lp.y = y * sinc / rh;
                    x *= sinc;
                    y = cosc * rh;
                    if (Math.abs(lp.y) >= 1.0) {
                        lp.y = lp.y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
                        break;
                    }
                    lp.y = Math.asin(lp.y);
                    break;
                }
                case 4: {
                    lp.y = cosc * this.sinphi0 + y * sinc * this.cosphi0 / rh;
                    y = (cosc - this.sinphi0 * lp.y) * rh;
                    x *= sinc * this.cosphi0;
                    lp.y = Math.abs(lp.y) >= 1.0 ? (lp.y < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Math.asin(lp.y);
                }
            }
        }
        lp.x = y == 0.0 && (this.mode == 4 || this.mode == 3) ? (x == 0.0 ? 0.0 : (x < 0.0 ? -1.5707963267948966 : 1.5707963267948966)) : Math.atan2(x, y);
        return lp;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Orthographic Azimuthal";
    }
}

