/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.shape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.shape.Polyline;
import org.meteoinfo.shape.Shape;
import org.meteoinfo.shape.ShapeTypes;

public class PolylineShape
extends Shape
implements Cloneable {
    private List<? extends PointD> _points = new ArrayList<PointD>();
    private List<? extends Polyline> _polylines;
    private int _numParts = 1;
    public int[] parts = new int[1];

    public PolylineShape() {
        this.parts[0] = 0;
        this._polylines = new ArrayList<Polyline>();
    }

    public PolylineShape(Geometry geometry) {
        this();
        Coordinate[] cs = geometry.getCoordinates();
        ArrayList<? extends PointD> points = new ArrayList<PointD>();
        for (Coordinate c : cs) {
            points.add(new PointD(c.x, c.y));
        }
        switch (geometry.getGeometryType()) {
            case "MultiLineString": {
                int i;
                int n;
                this._points = points;
                this._numParts = n = geometry.getNumGeometries();
                ArrayList<Integer> partlist = new ArrayList<Integer>();
                int idx = 0;
                for (i = 0; i < n; ++i) {
                    LineString poly = (LineString)geometry.getGeometryN(i);
                    partlist.add(idx);
                    Polyline polyline = new Polyline();
                    ArrayList pp = new ArrayList();
                    for (int j = idx; j < idx + poly.getNumPoints(); ++j) {
                        pp.add(points.get(j));
                    }
                    polyline.setPointList(pp);
                    idx += poly.getNumPoints();
                    this._polylines.add(polyline);
                }
                this.parts = new int[n];
                for (i = 0; i < this.parts.length; ++i) {
                    this.parts[i] = (Integer)partlist.get(i);
                }
                this.setExtent(MIMath.getPointsExtent(this._points));
                break;
            }
            default: {
                this.setPoints(points);
            }
        }
    }

    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.Polyline;
    }

    @Override
    public Geometry toGeometry(GeometryFactory factory) {
        if (this.getPartNum() == 1) {
            Coordinate[] cs = new Coordinate[this.getPointNum()];
            for (int i = 0; i < cs.length; ++i) {
                PointD p = this._points.get(i);
                cs[i] = new Coordinate(p.X, p.Y);
            }
            return factory.createLineString(cs);
        }
        LineString[] lss = new LineString[this._polylines.size()];
        for (int j = 0; j < lss.length; ++j) {
            Polyline line = this._polylines.get(j);
            Coordinate[] cs = new Coordinate[line.getPointList().size()];
            for (int i = 0; i < cs.length; ++i) {
                PointD p = line.getPointList().get(i);
                cs[i] = new Coordinate(p.X, p.Y);
            }
            lss[j] = factory.createLineString(cs);
        }
        MultiLineString mls = factory.createMultiLineString(lss);
        return mls;
    }

    @Override
    public List<? extends PointD> getPoints() {
        return this._points;
    }

    @Override
    public void setPoints(List<? extends PointD> points) {
        this._points = points;
        this.setExtent(MIMath.getPointsExtent(this._points));
        this.updatePolyLines();
    }

    public int getPartNum() {
        return this._numParts;
    }

    public void setPartNum(int value) {
        this._numParts = value;
    }

    public int getPointNum() {
        return this._points.size();
    }

    public List<? extends Polyline> getPolylines() {
        return this._polylines;
    }

    public void setPolylines(List<? extends Polyline> polylines) {
        if (!polylines.isEmpty()) {
            this._polylines = polylines;
            this.updatePartsPoints();
        }
    }

    public double getLength() {
        double length = 0.0;
        for (Polyline polyline : this._polylines) {
            for (int i = 0; i < polyline.getPointList().size() - 1; ++i) {
                double dx = polyline.getPointList().get((int)(i + 1)).X - polyline.getPointList().get((int)i).X;
                double dy = polyline.getPointList().get((int)(i + 1)).Y - polyline.getPointList().get((int)i).Y;
                length += Math.sqrt(dx * dx + dy * dy);
            }
        }
        return length;
    }

    private void updatePolyLines() {
        ArrayList<? extends Polyline> polylines = new ArrayList<Polyline>();
        if (this._numParts == 1) {
            Polyline aPolyLine = new Polyline();
            aPolyLine.setPointList(this._points);
            polylines.add(aPolyLine);
        } else {
            int numPoints = this.getPointNum();
            for (int p = 0; p < this._numParts; ++p) {
                int pp;
                PointD[] Pointps;
                if (p == this._numParts - 1) {
                    Pointps = new PointD[numPoints - this.parts[p]];
                    for (pp = this.parts[p]; pp < numPoints; ++pp) {
                        Pointps[pp - this.parts[p]] = this._points.get(pp);
                    }
                } else {
                    Pointps = new PointD[this.parts[p + 1] - this.parts[p]];
                    for (pp = this.parts[p]; pp < this.parts[p + 1]; ++pp) {
                        Pointps[pp - this.parts[p]] = this._points.get(pp);
                    }
                }
                Polyline aPolyLine = new Polyline();
                aPolyLine.setPointList(Arrays.asList(Pointps));
                polylines.add(aPolyLine);
            }
        }
        this._polylines = polylines;
    }

    private void updatePartsPoints() {
        int i;
        this._numParts = 0;
        ArrayList<? extends PointD> points = new ArrayList<PointD>();
        ArrayList<Integer> partList = new ArrayList<Integer>();
        for (i = 0; i < this._polylines.size(); ++i) {
            ++this._numParts;
            partList.add(points.size());
            points.addAll(this._polylines.get(i).getPointList());
        }
        this._points = points;
        this.parts = new int[partList.size()];
        for (i = 0; i < partList.size(); ++i) {
            this.parts[i] = (Integer)partList.get(i);
        }
        this.setExtent(MIMath.getPointsExtent(this._points));
    }

    public int getPartIndex(int vIdx) {
        if (this._numParts == 1) {
            return 0;
        }
        for (int p = 1; p < this._numParts; ++p) {
            if (vIdx >= this.parts[p]) continue;
            return p - 1;
        }
        return this._numParts - 1;
    }

    @Override
    public void addVertice(int vIdx, PointD vertice) {
        int partIdx = this.getPartIndex(vIdx);
        if (partIdx < this._numParts - 1) {
            int n = partIdx + 1;
            this.parts[n] = this.parts[n] + 1;
        }
        this._points.add(vIdx, vertice);
        this.setExtent(MIMath.getPointsExtent(this._points));
        this.updatePolyLines();
    }

    @Override
    public void removeVerice(int vIdx) {
        int partIdx = this.getPartIndex(vIdx);
        if (partIdx < this._numParts - 1) {
            int n = partIdx + 1;
            this.parts[n] = this.parts[n] - 1;
        }
        this._points.remove(vIdx);
        this.setExtent(MIMath.getPointsExtent(this._points));
        this.updatePolyLines();
    }

    @Override
    public void reverse() {
        Collections.reverse(this._points);
    }

    public Object clone_back() {
        PolylineShape o = (PolylineShape)super.clone();
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (PointD pointD : this._points) {
            points.add((PointD)pointD.clone());
        }
        o.setPoints(points);
        return o;
    }

    @Override
    public Object clone() {
        PolylineShape aPLS = new PolylineShape();
        aPLS.setValue(this.getValue());
        aPLS.setExtent(this.getExtent());
        aPLS._numParts = this._numParts;
        aPLS.parts = (int[])this.parts.clone();
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (PointD pointD : this._points) {
            points.add((PointD)pointD.clone());
        }
        aPLS.setPoints(points);
        aPLS.setVisible(this.isVisible());
        aPLS.setSelected(this.isSelected());
        aPLS.setLegendIndex(this.getLegendIndex());
        return aPLS;
    }

    public Object valueClone() {
        PolylineShape aPLS = new PolylineShape();
        aPLS.setValue(this.getValue());
        aPLS.setVisible(this.isVisible());
        aPLS.setSelected(this.isSelected());
        aPLS.setLegendIndex(this.getLegendIndex());
        return aPLS;
    }

    @Override
    public void cloneValue(Shape other) {
        PolylineShape o = (PolylineShape)other;
        this.setValue(o.getValue());
        this.setExtent(o.getExtent());
        this._numParts = o._numParts;
        this.parts = (int[])o.parts.clone();
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (PointD pointD : o._points) {
            points.add((PointD)pointD.clone());
        }
        this.setPoints(points);
        this.setVisible(o.isVisible());
        this.setSelected(o.isSelected());
        this.setLegendIndex(o.getLegendIndex());
    }

    public boolean isClosed() {
        return MIMath.doubleEquals(this._points.get((int)0).X, this._points.get((int)(this._points.size() - 1)).X) && MIMath.doubleEquals(this._points.get((int)0).Y, this._points.get((int)(this._points.size() - 1)).Y);
    }
}

