/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.meteoinfo.layer;

import org.meteoinfo.global.GenericFileFilter;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.data.DataTypes;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.FrmLegendBreaks;
import org.meteoinfo.legend.LegendManage;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.LegendType;
import org.meteoinfo.legend.MapFrame;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.PolylineBreak;
import org.meteoinfo.shape.ShapeTypes;
import com.l2fprod.common.model.DefaultBeanInfoResolver;
import com.l2fprod.common.propertysheet.PropertySheet;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import java.awt.Color;
import java.beans.BeanInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import org.meteoinfo.ui.CheckBoxListEntry;
import org.meteoinfo.legend.AlignType;
import org.meteoinfo.legend.ChartTypes;
import org.meteoinfo.shape.PointZ;
import org.meteoinfo.shape.Shape;
import org.xml.sax.SAXException;

/**
 *
 * @author Yaqiang
 */
public class FrmLayerProperty extends javax.swing.JDialog {

    private MapLayer _mapLayer = null;
    private Object _object;
    private MapFrame _mapFrame = null;
    private LegendScheme _legendScheme = null;
    private boolean _ifCreateLegendScheme = false;
    private boolean _isLoading = false;

    /**
     * Creates new form frmLayerProperty
     *
     * @param parent
     * @param modal
     */
    public FrmLayerProperty(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();

    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jButton_Cancel = new javax.swing.JButton();
        jButton_OK = new javax.swing.JButton();
        jButton_Apply = new javax.swing.JButton();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel_General = new javax.swing.JPanel();
        propertySheetPanel1 = new com.l2fprod.common.propertysheet.PropertySheetPanel();
        jPanel_Legend = new javax.swing.JPanel();
        jToolBar1 = new javax.swing.JToolBar();
        jButton_ImportLegend = new javax.swing.JButton();
        jButton_ExportLegend = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JToolBar.Separator();
        jButton_AddBreak = new javax.swing.JButton();
        jButton_RemoveBreak = new javax.swing.JButton();
        jButton_RemoveAllBreaks = new javax.swing.JButton();
        jSeparator2 = new javax.swing.JToolBar.Separator();
        jButton_MoveBreakUp = new javax.swing.JButton();
        jButton_MoveBreakDown = new javax.swing.JButton();
        jButton_ReverseBreaks = new javax.swing.JButton();
        jSeparator3 = new javax.swing.JToolBar.Separator();
        jButton_MakeBreaks = new javax.swing.JButton();
        legendView1 = new org.meteoinfo.legend.LegendView();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jComboBox_LegendType = new javax.swing.JComboBox();
        jComboBox_Field = new javax.swing.JComboBox();
        jPanel_Chart = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jComboBox_ChartType = new javax.swing.JComboBox();
        legendView_Chart = new org.meteoinfo.legend.LegendView();
        jPanel1 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        jTextField_Minimum = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        jTextField_Maximum = new javax.swing.JTextField();
        jLabel_BarWidth = new javax.swing.JLabel();
        jTextField_BarWidth = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        jTextField_XShift = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        jTextField_YShift = new javax.swing.JTextField();
        jCheckBox_CollisionAvoidance = new javax.swing.JCheckBox();
        jLabel9 = new javax.swing.JLabel();
        jComboBox_Align = new javax.swing.JComboBox();
        jPanel2 = new javax.swing.JPanel();
        jCheckBox_DisplayIn3D = new javax.swing.JCheckBox();
        jLabel10 = new javax.swing.JLabel();
        jTextField_Thickness = new javax.swing.JTextField();
        jScrollPane2 = new javax.swing.JScrollPane();
        checkBoxList_Fields = new org.meteoinfo.ui.JCheckBoxList();
        jButton_ChartLabel = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Layer Property");
        setResizable(false);

        jButton_Cancel.setText("Cancel");
        jButton_Cancel.setPreferredSize(new java.awt.Dimension(70, 27));
        jButton_Cancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_CancelActionPerformed(evt);
            }
        });

        jButton_OK.setText("OK");
        jButton_OK.setPreferredSize(new java.awt.Dimension(70, 27));
        jButton_OK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_OKActionPerformed(evt);
            }
        });

        jButton_Apply.setText("Apply");
        jButton_Apply.setPreferredSize(new java.awt.Dimension(70, 27));
        jButton_Apply.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_ApplyActionPerformed(evt);
            }
        });

        jTabbedPane1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jTabbedPane1StateChanged(evt);
            }
        });

        jPanel_General.setToolTipText("");

        javax.swing.GroupLayout jPanel_GeneralLayout = new javax.swing.GroupLayout(jPanel_General);
        jPanel_General.setLayout(jPanel_GeneralLayout);
        jPanel_GeneralLayout.setHorizontalGroup(
            jPanel_GeneralLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(propertySheetPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, 378, Short.MAX_VALUE)
        );
        jPanel_GeneralLayout.setVerticalGroup(
            jPanel_GeneralLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(propertySheetPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, 409, Short.MAX_VALUE)
        );

        jTabbedPane1.addTab("General", jPanel_General);

        jToolBar1.setFloatable(false);
        jToolBar1.setRollover(true);

        jButton_ImportLegend.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_Open.Image.png"))); // NOI18N
        jButton_ImportLegend.setToolTipText("Import Legend");
        jButton_ImportLegend.setFocusable(false);
        jButton_ImportLegend.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_ImportLegend.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_ImportLegend.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_ImportLegendActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_ImportLegend);

        jButton_ExportLegend.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_Save.Image.png"))); // NOI18N
        jButton_ExportLegend.setToolTipText("Export Legend");
        jButton_ExportLegend.setFocusable(false);
        jButton_ExportLegend.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_ExportLegend.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_ExportLegend.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_ExportLegendActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_ExportLegend);
        jToolBar1.add(jSeparator1);

        jButton_AddBreak.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_Add.Image.png"))); // NOI18N
        jButton_AddBreak.setToolTipText("Add Break");
        jButton_AddBreak.setFocusable(false);
        jButton_AddBreak.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_AddBreak.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_AddBreak.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_AddBreakActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_AddBreak);

        jButton_RemoveBreak.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_Del.Image.png"))); // NOI18N
        jButton_RemoveBreak.setToolTipText("Remove Break");
        jButton_RemoveBreak.setFocusable(false);
        jButton_RemoveBreak.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_RemoveBreak.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_RemoveBreak.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_RemoveBreakActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_RemoveBreak);

        jButton_RemoveAllBreaks.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_DelAll.Image.png"))); // NOI18N
        jButton_RemoveAllBreaks.setToolTipText("Remove All Breaks");
        jButton_RemoveAllBreaks.setFocusable(false);
        jButton_RemoveAllBreaks.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_RemoveAllBreaks.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_RemoveAllBreaks.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_RemoveAllBreaksActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_RemoveAllBreaks);
        jToolBar1.add(jSeparator2);

        jButton_MoveBreakUp.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_Up.Image.png"))); // NOI18N
        jButton_MoveBreakUp.setToolTipText("Move Break Up");
        jButton_MoveBreakUp.setFocusable(false);
        jButton_MoveBreakUp.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_MoveBreakUp.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_MoveBreakUp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_MoveBreakUpActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_MoveBreakUp);

        jButton_MoveBreakDown.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_Down.Image.png"))); // NOI18N
        jButton_MoveBreakDown.setToolTipText("Move Break Down");
        jButton_MoveBreakDown.setFocusable(false);
        jButton_MoveBreakDown.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_MoveBreakDown.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_MoveBreakDown.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_MoveBreakDownActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_MoveBreakDown);

        jButton_ReverseBreaks.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_Reverse.Image.png"))); // NOI18N
        jButton_ReverseBreaks.setToolTipText("Reverse Breaks");
        jButton_ReverseBreaks.setFocusable(false);
        jButton_ReverseBreaks.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_ReverseBreaks.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_ReverseBreaks.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_ReverseBreaksActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_ReverseBreaks);
        jToolBar1.add(jSeparator3);

        jButton_MakeBreaks.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_MakeBreaks.Image.png"))); // NOI18N
        jButton_MakeBreaks.setFocusable(false);
        jButton_MakeBreaks.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_MakeBreaks.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_MakeBreaks.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_MakeBreaksActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_MakeBreaks);

        javax.swing.GroupLayout legendView1Layout = new javax.swing.GroupLayout(legendView1);
        legendView1.setLayout(legendView1Layout);
        legendView1Layout.setHorizontalGroup(
            legendView1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );
        legendView1Layout.setVerticalGroup(
            legendView1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 312, Short.MAX_VALUE)
        );

        jLabel1.setText("Legend Type:");

        jLabel2.setText("Field:");

        jComboBox_LegendType.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox_LegendType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox_LegendTypeActionPerformed(evt);
            }
        });

        jComboBox_Field.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox_Field.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox_FieldActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel_LegendLayout = new javax.swing.GroupLayout(jPanel_Legend);
        jPanel_Legend.setLayout(jPanel_LegendLayout);
        jPanel_LegendLayout.setHorizontalGroup(
            jPanel_LegendLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jToolBar1, javax.swing.GroupLayout.DEFAULT_SIZE, 378, Short.MAX_VALUE)
            .addComponent(legendView1, javax.swing.GroupLayout.DEFAULT_SIZE, 378, Short.MAX_VALUE)
            .addGroup(jPanel_LegendLayout.createSequentialGroup()
                .addGap(56, 56, 56)
                .addGroup(jPanel_LegendLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabel1)
                    .addComponent(jLabel2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel_LegendLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jComboBox_LegendType, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jComboBox_Field, javax.swing.GroupLayout.PREFERRED_SIZE, 163, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel_LegendLayout.setVerticalGroup(
            jPanel_LegendLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel_LegendLayout.createSequentialGroup()
                .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGroup(jPanel_LegendLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel_LegendLayout.createSequentialGroup()
                        .addGap(43, 43, 43)
                        .addComponent(jLabel2))
                    .addGroup(jPanel_LegendLayout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanel_LegendLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jComboBox_LegendType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel1))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jComboBox_Field, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(legendView1, javax.swing.GroupLayout.DEFAULT_SIZE, 312, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("Legend", jPanel_Legend);

        jLabel3.setText("Chart Type:");

        jComboBox_ChartType.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox_ChartType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox_ChartTypeActionPerformed(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Size"));

        jLabel4.setText("Minimum:");

        jLabel5.setText("Maximum:");

        jLabel_BarWidth.setText("BarWidth:");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel4, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabel5, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabel_BarWidth, javax.swing.GroupLayout.Alignment.TRAILING))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jTextField_Minimum, javax.swing.GroupLayout.PREFERRED_SIZE, 77, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextField_Maximum)
                    .addComponent(jTextField_BarWidth))
                .addGap(16, 16, 16))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(jTextField_Minimum, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel5)
                    .addComponent(jTextField_Maximum, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel_BarWidth)
                    .addComponent(jTextField_BarWidth, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );

        jLabel7.setText("X Shift:");

        jLabel8.setText("Y Shift:");

        jCheckBox_CollisionAvoidance.setText("Avoid collision");
        jCheckBox_CollisionAvoidance.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBox_CollisionAvoidanceActionPerformed(evt);
            }
        });

        jLabel9.setText("Align:");

        jComboBox_Align.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("3D"));

        jCheckBox_DisplayIn3D.setText("Display in 3D");

        jLabel10.setText("Thickness:");

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jCheckBox_DisplayIn3D)
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jLabel10)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextField_Thickness)))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addComponent(jCheckBox_DisplayIn3D)
                .addGap(18, 18, 18)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel10)
                    .addComponent(jTextField_Thickness, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 12, Short.MAX_VALUE))
        );

        checkBoxList_Fields.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        checkBoxList_Fields.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                checkBoxList_FieldsMouseClicked(evt);
            }
        });
        jScrollPane2.setViewportView(checkBoxList_Fields);

        jButton_ChartLabel.setText("Label");
        jButton_ChartLabel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_ChartLabelActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel_ChartLayout = new javax.swing.GroupLayout(jPanel_Chart);
        jPanel_Chart.setLayout(jPanel_ChartLayout);
        jPanel_ChartLayout.setHorizontalGroup(
            jPanel_ChartLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel_ChartLayout.createSequentialGroup()
                .addGap(6, 6, 6)
                .addGroup(jPanel_ChartLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel_ChartLayout.createSequentialGroup()
                        .addGroup(jPanel_ChartLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addGroup(jPanel_ChartLayout.createSequentialGroup()
                                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 185, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGroup(jPanel_ChartLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(jPanel_ChartLayout.createSequentialGroup()
                                        .addGap(34, 34, 34)
                                        .addGroup(jPanel_ChartLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                            .addComponent(jLabel7)
                                            .addComponent(jLabel8))
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addGroup(jPanel_ChartLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                            .addComponent(jTextField_YShift, javax.swing.GroupLayout.DEFAULT_SIZE, 79, Short.MAX_VALUE)
                                            .addComponent(jTextField_XShift)))
                                    .addGroup(jPanel_ChartLayout.createSequentialGroup()
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                            .addGroup(jPanel_ChartLayout.createSequentialGroup()
                                .addComponent(legendView_Chart, javax.swing.GroupLayout.PREFERRED_SIZE, 181, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGroup(jPanel_ChartLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(jPanel_ChartLayout.createSequentialGroup()
                                        .addGap(34, 34, 34)
                                        .addComponent(jLabel9)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(jComboBox_Align, javax.swing.GroupLayout.PREFERRED_SIZE, 97, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addGroup(jPanel_ChartLayout.createSequentialGroup()
                                        .addGap(26, 26, 26)
                                        .addComponent(jCheckBox_CollisionAvoidance))
                                    .addGroup(jPanel_ChartLayout.createSequentialGroup()
                                        .addGap(14, 14, 14)
                                        .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))))
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(jPanel_ChartLayout.createSequentialGroup()
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jComboBox_ChartType, javax.swing.GroupLayout.PREFERRED_SIZE, 162, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jButton_ChartLabel)
                        .addGap(44, 44, 44))))
        );
        jPanel_ChartLayout.setVerticalGroup(
            jPanel_ChartLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel_ChartLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel_ChartLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(jComboBox_ChartType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButton_ChartLabel))
                .addGap(8, 8, 8)
                .addGroup(jPanel_ChartLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel_ChartLayout.createSequentialGroup()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel_ChartLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel7)
                            .addComponent(jTextField_XShift, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel_ChartLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel8)
                            .addComponent(jTextField_YShift, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 169, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel_ChartLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(legendView_Chart, javax.swing.GroupLayout.PREFERRED_SIZE, 183, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel_ChartLayout.createSequentialGroup()
                        .addComponent(jCheckBox_CollisionAvoidance)
                        .addGap(18, 18, 18)
                        .addGroup(jPanel_ChartLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel9)
                            .addComponent(jComboBox_Align, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(18, 18, 18)
                        .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("Chart", jPanel_Chart);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jTabbedPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(32, Short.MAX_VALUE)
                .addComponent(jButton_Apply, javax.swing.GroupLayout.PREFERRED_SIZE, 82, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(26, 26, 26)
                .addComponent(jButton_OK, javax.swing.GroupLayout.PREFERRED_SIZE, 82, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jButton_Cancel, javax.swing.GroupLayout.PREFERRED_SIZE, 82, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(61, 61, 61))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jTabbedPane1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE, false)
                    .addComponent(jButton_Apply, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jButton_OK, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jButton_Cancel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(8, 8, 8))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButton_ApplyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_ApplyActionPerformed
        // TODO add your handling code here:
        this.propertySheetPanel1.writeToObject(_object);
        switch (this.jTabbedPane1.getSelectedIndex()) {
            case 1:    //Legend                
                _mapLayer.setLegendScheme(this.legendView1.getLegendScheme());
                break;
            case 2:    //Chart
                if (((VectorLayer) _mapLayer).getChartPoints().size() > 0) {
                    updateCharts();
                    ((VectorLayer) _mapLayer).updateCharts();
                } else {
                    //((VectorLayer) _mapLayer).removeCharts();
                    addCharts();
                }
                break;
        }
        _mapFrame.updateLayerNode(_mapLayer);
        _mapFrame.getMapView().paintLayers();
    }//GEN-LAST:event_jButton_ApplyActionPerformed

    private void addCharts() {
        this.updateCharts();
        ((VectorLayer) _mapLayer).addCharts();
    }

    private void updateCharts() {
        if (this.checkBoxList_Fields.getCheckedIdexes().length < 1) {
            return;
        }

        VectorLayer aLayer = (VectorLayer) _mapLayer;
        ChartSet chartSet = aLayer.getChartSet();
        chartSet.setChartType(ChartTypes.valueOf(this.jComboBox_ChartType.getSelectedItem().toString()));
        List<String> fieldNames = new ArrayList<>();
        int i, j;
        for (i = 0; i < this.checkBoxList_Fields.getCheckedIdexes().length; i++) {
            fieldNames.add(((CheckBoxListEntry) this.checkBoxList_Fields.getCheckedItems().get(i)).getValue().toString());
        }

        chartSet.setFieldNames(fieldNames);
        chartSet.setLegendScheme(legendView_Chart.getLegendScheme());
        chartSet.setMinSize(Integer.parseInt(this.jTextField_Minimum.getText()));
        chartSet.setMaxSize(Integer.parseInt(this.jTextField_Maximum.getText()));
        chartSet.setBarWidth(Integer.parseInt(this.jTextField_BarWidth.getText()));
        chartSet.setXShift(Integer.parseInt(this.jTextField_XShift.getText()));
        chartSet.setYShift(Integer.parseInt(this.jTextField_YShift.getText()));
        chartSet.setAvoidCollision(this.jCheckBox_CollisionAvoidance.isSelected());
        chartSet.setAlignType(AlignType.valueOf(this.jComboBox_Align.getSelectedItem().toString()));
        chartSet.setView3D(this.jCheckBox_DisplayIn3D.isSelected());
        chartSet.setThickness(Integer.parseInt(this.jTextField_Thickness.getText()));

        //List<List<Float>> values = new ArrayList<List<Float>>();
        List<Double> minList = new ArrayList<>();
        List<Double> maxList = new ArrayList<>();
        List<Double> sumList = new ArrayList<>();
        double[] minMax;
        for (i = 0; i < aLayer.getShapeNum(); i++) {
            List<Double> vList = new ArrayList<>();
            double sum = 0;
            double v;
            for (j = 0; j < fieldNames.size(); j++) {
                v = Double.parseDouble(aLayer.getCellValue(fieldNames.get(j), i).toString());
                vList.add(v);
                sum += v;
            }
            //values.add(vList);
            minMax = MIMath.getMinMaxValue(vList, -9999.0);
            minList.add(minMax[0]);
            maxList.add(minMax[1]);
            sumList.add(sum);
        }

        switch (chartSet.getChartType()) {
            case BarChart:
                minMax = MIMath.getMinMaxValue(minList, -9999.0);
                chartSet.setMinValue((float) minMax[0]);
                minMax = MIMath.getMinMaxValue(maxList, -9999.0);
                chartSet.setMaxValue((float) minMax[1]);
                break;
            case PieChart:
                minMax = MIMath.getMinMaxValue(sumList, -9999.0);
                chartSet.setMinValue((float) minMax[0]);
                chartSet.setMaxValue((float) minMax[1]);
                break;
        }

        //aLayer.addCharts();
    }

    private void jButton_OKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_OKActionPerformed
        // TODO add your handling code here:
        this.propertySheetPanel1.writeToObject(_object);
        switch (this.jTabbedPane1.getSelectedIndex()) {
            case 1:    //Legend                
                _mapLayer.setLegendScheme(this.legendView1.getLegendScheme());
                break;
            case 2:    //Chart
                ((VectorLayer) _mapLayer).removeCharts();
                addCharts();
                break;
        }
        _mapFrame.updateLayerNode(_mapLayer);
        _mapFrame.getMapView().paintLayers();

        switch (this.jTabbedPane1.getSelectedIndex()) {
            case 0:    //General
            case 1:    //Legend
                this.dispose();
                break;
        }
    }//GEN-LAST:event_jButton_OKActionPerformed

    private void jButton_CancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_CancelActionPerformed
        // TODO add your handling code here:
        switch (this.jTabbedPane1.getSelectedIndex()) {
            case 0:    //General
                this.dispose();
                break;
            case 1:    //Legend
                _mapLayer.setLegendScheme(_legendScheme);
                _mapFrame.updateLayerNode(_mapLayer);
                _mapFrame.getMapView().paintLayers();
                this.dispose();
                break;
            case 2:    //Chart - Clear charts
                ((VectorLayer) _mapLayer).removeCharts();
                this._mapFrame.updateLayerNode(_mapLayer);
                this._mapFrame.getMapView().paintLayers();
                break;
        }
    }//GEN-LAST:event_jButton_CancelActionPerformed

    private void jComboBox_LegendTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox_LegendTypeActionPerformed
        // TODO add your handling code here:
//        if (this._isLoading){
//            return;
//        }
        if (this.jComboBox_LegendType.getItemCount() == 0) {
            return;
        }

        LegendType aLT = (LegendType) this.jComboBox_LegendType.getSelectedItem();
        switch (this._mapLayer.getLayerType()) {
            case VectorLayer:
                this._ifCreateLegendScheme = false;
                setFieldByLegendType(aLT);
                this._ifCreateLegendScheme = true;
                break;
            case RasterLayer:
                switch (aLT) {
                    case UniqueValue:

                        break;
                    case GraduatedColor:
                        if (this._legendScheme == null || this._legendScheme.getLegendType() != LegendType.GraduatedColor)
                            this._legendScheme = LegendManage.createLegendSchemeFromGridData(((RasterLayer) _mapLayer).getGridData(), LegendType.GraduatedColor, ShapeTypes.Polygon);
                        break;
                }
                this.legendView1.setLegendScheme(_legendScheme);
                this.legendView1.repaint();
                break;
        }
    }//GEN-LAST:event_jComboBox_LegendTypeActionPerformed

    private void jComboBox_FieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox_FieldActionPerformed
        // TODO add your handling code here:
        if (this._isLoading) {
            return;
        }
        if (this.jComboBox_Field.getItemCount() == 0) {
            return;
        }

        LegendType aLT = (LegendType) this.jComboBox_LegendType.getSelectedItem();
        String fieldName = this.jComboBox_Field.getSelectedItem().toString();
        if (!"<None>".equals(fieldName)) {
            createLegendScheme(aLT, fieldName);
        }
    }//GEN-LAST:event_jComboBox_FieldActionPerformed

    private void jButton_ImportLegendActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_ImportLegendActionPerformed
        // TODO add your handling code here:
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(new File(System.getProperty("user.dir")));
        String[] fileExts = new String[]{"lgs", "pal"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "LegendScheme file (*.lgs,*.pal)");
        aDlg.setFileFilter(mapFileFilter);
        if (JFileChooser.APPROVE_OPTION == aDlg.showOpenDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            System.setProperty("user.dir", aFile.getParent());

            String fext = GenericFileFilter.getExtension(aFile);
            if (fext.equals("pal")) {
                _legendScheme.importFromPaletteFile_Unique(aFile.getAbsolutePath());
            } else if (fext.equals("lgs")) {
                try {
                    _legendScheme.importFromXMLFile(aFile.getAbsolutePath());
                    if (this._mapLayer.getLayerType() == LayerTypes.VectorLayer) {
                        VectorLayer layer = (VectorLayer) this._mapLayer;
                        if (layer.getField(_legendScheme.getFieldName()) == null) {
                            _legendScheme.setFieldName(this.jComboBox_Field.getSelectedItem().toString());
                        }
                    }
                } catch (ParserConfigurationException ex) {
                    Logger.getLogger(FrmLayerProperty.class.getName()).log(Level.SEVERE, null, ex);
                } catch (SAXException ex) {
                    Logger.getLogger(FrmLayerProperty.class.getName()).log(Level.SEVERE, null, ex);
                } catch (IOException ex) {
                    Logger.getLogger(FrmLayerProperty.class.getName()).log(Level.SEVERE, null, ex);
                }
            }

            _ifCreateLegendScheme = false;
            this.jComboBox_LegendType.setSelectedItem(_legendScheme.getLegendType().toString());
            if (_legendScheme.getFieldName() == null || _legendScheme.getFieldName().isEmpty()) {
                if (this.jComboBox_Field.getSelectedIndex() >= 0) {
                    _legendScheme.setFieldName(this.jComboBox_Field.getSelectedItem().toString());
                }
            }
            this.jComboBox_Field.setSelectedItem(_legendScheme.getFieldName());
            legendView1.update(_legendScheme);
            _ifCreateLegendScheme = true;
        }
    }//GEN-LAST:event_jButton_ImportLegendActionPerformed

    private void jButton_ExportLegendActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_ExportLegendActionPerformed
        // TODO add your handling code here:
        JFileChooser aDlg = new JFileChooser();
        String[] fileExts = new String[]{"lgs"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "LegendScheme file (*.lgs)");
        aDlg.setFileFilter(mapFileFilter);
        String path = System.getProperty("user.dir");
        aDlg.setCurrentDirectory(new File(path));
        if (JFileChooser.APPROVE_OPTION == aDlg.showSaveDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            String filePath = aFile.getAbsolutePath();
            if (!filePath.substring(filePath.length() - 4).equals(".lgs")) {
                filePath = filePath + ".lgs";
            }
            try {
                _legendScheme.exportToXMLFile(filePath);
            } catch (ParserConfigurationException ex) {
                Logger.getLogger(FrmLayerProperty.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }//GEN-LAST:event_jButton_ExportLegendActionPerformed

    private void jButton_AddBreakActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_AddBreakActionPerformed
        // TODO add your handling code here:
        switch (_legendScheme.getShapeType()) {
            case Polyline:
            case PolylineZ:
                PolylineBreak aPLB = new PolylineBreak();
                aPLB.setDrawPolyline(true);
                aPLB.setWidth(0.1F);
                aPLB.setColor(Color.red);
                aPLB.setStartValue(0);
                aPLB.setEndValue(0);
                aPLB.setCaption("");
                _legendScheme.getLegendBreaks().add(aPLB);
                break;
            case Point:
                PointBreak aPB = new PointBreak();
                aPB.setDrawShape(true);
                aPB.setDrawFill(true);
                aPB.setSize(5);
                aPB.setColor(Color.red);
                aPB.setStartValue(0);
                aPB.setEndValue(0);
                aPB.setCaption("");
                _legendScheme.getLegendBreaks().add(aPB);
                break;
            case Polygon:
                PolygonBreak aPGB = new PolygonBreak();
                aPGB.setDrawShape(true);
                aPGB.setDrawFill(true);
                aPGB.setColor(Color.red);
                aPGB.setStartValue(0);
                aPGB.setEndValue(0);
                aPGB.setCaption("");
                _legendScheme.getLegendBreaks().add(aPGB);
                break;
            case Image:
                ColorBreak aCB = new ColorBreak();
                aCB.setColor(Color.red);
                aCB.setStartValue(0);
                aCB.setEndValue(0);
                aCB.setCaption("");
                _legendScheme.getLegendBreaks().add(aCB);
                break;
        }
        legendView1.update(_legendScheme);
    }//GEN-LAST:event_jButton_AddBreakActionPerformed

    private void jButton_RemoveBreakActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_RemoveBreakActionPerformed
        // TODO add your handling code here:
        int i, rowIdx;
        for (i = 0; i < legendView1.getSelectedRows().size(); i++) {
            rowIdx = legendView1.getSelectedRows().get(i);
            _legendScheme.getLegendBreaks().remove(rowIdx);
        }
        legendView1.update(_legendScheme);
    }//GEN-LAST:event_jButton_RemoveBreakActionPerformed

    private void jButton_RemoveAllBreaksActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_RemoveAllBreaksActionPerformed
        // TODO add your handling code here:
        if (JOptionPane.showConfirmDialog(null, "If remove all breaks?", "Alarm", JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION) {
            _legendScheme.getLegendBreaks().clear();
            legendView1.update(_legendScheme);
        }
    }//GEN-LAST:event_jButton_RemoveAllBreaksActionPerformed

    private void jButton_MoveBreakUpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_MoveBreakUpActionPerformed
        // TODO add your handling code here:
        int oldIdx, newIdx;
        oldIdx = legendView1.getSelectedRows().get(0);
        if (oldIdx > 0) {
            if (_legendScheme.getShapeType() == ShapeTypes.Point) {
                PointBreak aPB = (PointBreak) _legendScheme.getLegendBreaks().get(oldIdx);
                if (aPB.isNoData()) {
                    return;
                }
            }
            newIdx = oldIdx - 1;
            _legendScheme.getLegendBreaks().add(newIdx, _legendScheme.getLegendBreaks().get(oldIdx));
            _legendScheme.getLegendBreaks().remove(oldIdx + 1);
            legendView1.getSelectedRows().clear();
            legendView1.getSelectedRows().add(newIdx);
            legendView1.update(_legendScheme);
        }
    }//GEN-LAST:event_jButton_MoveBreakUpActionPerformed

    private void jButton_MoveBreakDownActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_MoveBreakDownActionPerformed
        // TODO add your handling code here:
        int oldIdx, newIdx, endIdx;
        oldIdx = legendView1.getSelectedRows().get(0);
        endIdx = legendView1.getLegendScheme().getBreakNum() - 1;
        if (_legendScheme.getShapeType() == ShapeTypes.Point) {
            PointBreak aPB = (PointBreak) _legendScheme.getLegendBreaks().get(oldIdx);
            if (aPB.isNoData()) {
                endIdx = endIdx - 1;
            }
        }
        if (oldIdx < endIdx) {
            newIdx = oldIdx + 2;
            _legendScheme.getLegendBreaks().add(newIdx, _legendScheme.getLegendBreaks().get(oldIdx));
            _legendScheme.getLegendBreaks().remove(oldIdx);
            legendView1.getSelectedRows().clear();
            legendView1.getSelectedRows().add(newIdx - 1);
            legendView1.update(_legendScheme);
        }
    }//GEN-LAST:event_jButton_MoveBreakDownActionPerformed

    private void jButton_ReverseBreaksActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_ReverseBreaksActionPerformed
        // TODO add your handling code here:
        Collections.reverse(_legendScheme.getLegendBreaks());
        if (_legendScheme.getHasNoData()) {
            _legendScheme.getLegendBreaks().add(_legendScheme.getLegendBreaks().get(0));
            _legendScheme.getLegendBreaks().remove(0);
        }
        legendView1.update(_legendScheme);
    }//GEN-LAST:event_jButton_ReverseBreaksActionPerformed

    private void jButton_MakeBreaksActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_MakeBreaksActionPerformed
        // TODO add your handling code here:
        boolean isUniqueValue = false;
        if (_legendScheme.getLegendType() == LegendType.UniqueValue) {
            isUniqueValue = true;
        }

        FrmLegendBreaks frmLB = new FrmLegendBreaks(this, false, isUniqueValue);
        frmLB.setLegendScheme(_legendScheme);
        frmLB.setLocationRelativeTo(this);
        frmLB.setVisible(true);
    }//GEN-LAST:event_jButton_MakeBreaksActionPerformed

    private void checkBoxList_FieldsMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_checkBoxList_FieldsMouseClicked
        // TODO add your handling code here:
        DefaultListModel listModel = (DefaultListModel) this.checkBoxList_Fields.getModel();
        int idx = this.checkBoxList_Fields.getSelectedIndex();
        CheckBoxListEntry item = (CheckBoxListEntry) listModel.getElementAt(idx);
        String selFieldStr = item.getValue().toString();
        if (item.isSelected()) {
            PolygonBreak aPB = new PolygonBreak();
            aPB.setCaption(selFieldStr);
            aPB.setTag(selFieldStr);
            aPB.setColor(LegendManage.createRandomColors(1)[0]);
            legendView_Chart.getLegendScheme().getLegendBreaks().add(aPB);
        } else {
            for (int i = 0; i < legendView_Chart.getLegendScheme().getBreakNum(); i++) {
                if (legendView_Chart.getLegendScheme().getLegendBreaks().get(i).getTag().equals(selFieldStr)) {
                    legendView_Chart.getLegendScheme().getLegendBreaks().remove(i);
                    break;
                }
            }
        }
        this.legendView_Chart.repaint();
    }//GEN-LAST:event_checkBoxList_FieldsMouseClicked

    private void jComboBox_ChartTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox_ChartTypeActionPerformed
        // TODO add your handling code here:
        if (this.jComboBox_ChartType.getItemCount() > 0) {
            if (this.jComboBox_ChartType.getSelectedItem().toString().equals(ChartTypes.PieChart.toString())) {
                this.jLabel_BarWidth.setEnabled(false);
                this.jTextField_BarWidth.setEnabled(false);
            } else {
                this.jLabel_BarWidth.setEnabled(true);
                this.jTextField_BarWidth.setEnabled(true);
            }
        }
    }//GEN-LAST:event_jComboBox_ChartTypeActionPerformed

    private void jCheckBox_CollisionAvoidanceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBox_CollisionAvoidanceActionPerformed
        // TODO add your handling code here:
        ((VectorLayer) _mapLayer).getChartSet().setAvoidCollision(this.jCheckBox_CollisionAvoidance.isSelected());
        if (((VectorLayer) _mapLayer).getChartPoints().size() > 0) {
            _mapFrame.getMapView().paintLayers();
        }
    }//GEN-LAST:event_jCheckBox_CollisionAvoidanceActionPerformed

    private void jTabbedPane1StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jTabbedPane1StateChanged
        // TODO add your handling code here:
        int selIndex = this.jTabbedPane1.getSelectedIndex();
        switch (selIndex) {
            case 0:   //General
            case 1:    //Legend
                this.jButton_Apply.setText("Apply");
                this.jButton_OK.setText("OK");
                this.jButton_Cancel.setText("Cancel");
                break;
            case 2:    //Chart
                this.jButton_Apply.setText("Update");
                this.jButton_OK.setText("Reset");
                this.jButton_Cancel.setText("Clear");
                break;
        }
    }//GEN-LAST:event_jTabbedPane1StateChanged

    private void jButton_ChartLabelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_ChartLabelActionPerformed
        // TODO add your handling code here:
        FrmChartLabel frm = new FrmChartLabel(this, false, ((VectorLayer) _mapLayer).getChartSet());
        frm.setLocationRelativeTo(this);
        frm.setVisible(true);
    }//GEN-LAST:event_jButton_ChartLabelActionPerformed

    private void setFieldByLegendType(LegendType aLT) {
        if (_mapLayer.getLayerType() == LayerTypes.VectorLayer) {
            VectorLayer aLayer = (VectorLayer) _mapLayer;
            switch (aLT) {
                case SingleSymbol:
                    this.jComboBox_Field.setEnabled(false);
                    this.jComboBox_Field.removeAllItems();
                    if (!this._isLoading) {
                        this._ifCreateLegendScheme = true;
                    }
                    createLegendScheme(aLT, "");
                    this._ifCreateLegendScheme = false;
                    break;
                case UniqueValue:
                    this.jComboBox_Field.setEnabled(true);
                    this.jComboBox_Field.removeAllItems();
                    for (String fn : aLayer.getFieldNames()) {
                        this.jComboBox_Field.addItem(fn);
                    }
                    this.jComboBox_Field.setSelectedItem("<None>");
                    break;
                case GraduatedColor:
                    this.jComboBox_Field.setEnabled(true);
                    this.jComboBox_Field.removeAllItems();
                    for (int i = 0; i < aLayer.getFieldNumber(); i++) {
                        if (MIMath.isNumeric(aLayer.getField(i))) {
                            this.jComboBox_Field.addItem(aLayer.getFieldName(i));
                        }
                    }
                    switch (aLayer.getShapeType()){
                        case PolylineM:
                            this.jComboBox_Field.addItem("Geometry_M");
                            break;
                        case PolylineZ:
                            this.jComboBox_Field.addItem("Geometry_M");
                            this.jComboBox_Field.addItem("Geometry_Z");
                            break;
                    }
                    this.jComboBox_Field.setSelectedItem("<None>");
                    break;
            }
        }
    }

    private void createLegendScheme(LegendType aLT, String fieldName) {
        if (_ifCreateLegendScheme) {
            double min, max;
            ShapeTypes aST = _legendScheme.getShapeType();

            min = _legendScheme.getMinValue();
            max = _legendScheme.getMaxValue();
            switch (aLT) {
                case SingleSymbol:
                    Color aColor = Color.black;
                    switch (aST) {
                        case Point:
                            aColor = Color.black;
                            break;
                        case Polyline:
                        case PolylineZ:
                            aColor = Color.black;
                            break;
                        case Polygon:
                        case Image:
                            aColor = new Color(255, 251, 195);
                            break;
                    }
                    float size = 1.0F;
                    if (_legendScheme.getShapeType() == ShapeTypes.Point) {
                        size = 5;
                    }
                    _legendScheme = LegendManage.createSingleSymbolLegendScheme(_legendScheme.getShapeType(), aColor,
                            size);

                    this.jButton_AddBreak.setEnabled(false);
                    this.jButton_RemoveBreak.setEnabled(false);
                    this.jButton_RemoveAllBreaks.setEnabled(false);
                    this.jButton_MoveBreakDown.setEnabled(false);
                    this.jButton_MoveBreakUp.setEnabled(false);
                    this.jButton_MakeBreaks.setEnabled(false);
                    this.jButton_ReverseBreaks.setEnabled(false);
                    break;
                case UniqueValue:
                    Color[] colors;
                    List<String> valueList = new ArrayList<>();

                    VectorLayer aLayer = (VectorLayer) _mapLayer;
                    boolean isDateField = false;
                    DataTypes colType = aLayer.getAttributeTable().getTable().getColumns().get(fieldName).getDataType();
                    if (colType == DataTypes.Date) {
                        isDateField = true;
                    }

                    List<String> captions = new ArrayList<>();

                    for (int i = 0; i < aLayer.getAttributeTable().getNumRecords(); i++) {
                        if (!valueList.contains(aLayer.getAttributeTable().getTable().getRows().get(i).getValue(fieldName).toString())) {
                            valueList.add(aLayer.getAttributeTable().getTable().getRows().get(i).getValue(fieldName).toString());
                            if (isDateField) {
                                captions.add(aLayer.getAttributeTable().getTable().getRows().get(i).getValue(fieldName).toString());
                            }
                        }
                    }

//                    if (valueList.size() == 1) {
//                        JOptionPane.showMessageDialog(this, "The values of all shapes are same!");
//                        break;
//                    }
                    if (valueList.size() <= 13) {
                        colors = LegendManage.createRainBowColors(valueList.size());
                    } else {
                        colors = LegendManage.createRandomColors(valueList.size());
                    }
                    List<Color> CList = new ArrayList(Arrays.asList(colors));
                    CList.add(0, Color.white);
                    colors = CList.toArray(new Color[CList.size()]);

                    if (isDateField) {
                        _legendScheme = LegendManage.createUniqValueLegendScheme(valueList, captions, colors, aST, min,
                                max, _legendScheme.getHasNoData(), _legendScheme.getUndefValue());
                    } else {
                        _legendScheme = LegendManage.createUniqValueLegendScheme(valueList, colors,
                                aST, min, max, _legendScheme.getHasNoData(), _legendScheme.getUndefValue());
                    }

                    _legendScheme.setFieldName(fieldName);

                    this.jButton_AddBreak.setEnabled(true);
                    this.jButton_RemoveBreak.setEnabled(true);
                    this.jButton_RemoveAllBreaks.setEnabled(true);
                    this.jButton_MoveBreakDown.setEnabled(true);
                    this.jButton_MoveBreakUp.setEnabled(true);
                    this.jButton_MakeBreaks.setEnabled(true);
                    this.jButton_ReverseBreaks.setEnabled(true);
                    break;
                case GraduatedColor:
                    aLayer = (VectorLayer) _mapLayer;
                    List<Double> S  = new ArrayList<>();
                    if (fieldName.equals("Geometry_M")){
                        for (Shape shape : aLayer.getShapes()){
                            for (PointZ p : (List<PointZ>)shape.getPoints()){
                                S.add(p.M);
                            }
                        }
                    } else if (fieldName.equals("Geometry_Z")){
                        for (Shape shape : aLayer.getShapes()){
                            for (PointZ p : (List<PointZ>)shape.getPoints()){
                                S.add(p.Z);
                            }
                        }
                    } else {
                        for (int i = 0; i < aLayer.getAttributeTable().getNumRecords(); i++) {
                            String vstr = aLayer.getCellValue(fieldName, i).toString();
                            if (vstr.isEmpty()) {
                                S.add(0D);
                            } else {
                                S.add(Double.parseDouble(vstr));
                            }
                        }
                    }
                    double[] minmax = MIMath.getMinMaxValue(S, _legendScheme.getUndefValue());
                    min = minmax[0];
                    max = minmax[1];

                    if (min == max) {
                        JOptionPane.showMessageDialog(this, "The values of all shapes are same!");
                        break;
                    }

                    double[] CValues;
                    CValues = LegendManage.createContourValues(min, max);
                    colors = LegendManage.createRainBowColors(CValues.length + 1);

                    _legendScheme = LegendManage.createGraduatedLegendScheme(CValues, colors,
                            aST, min, max, _legendScheme.getHasNoData(), _legendScheme.getUndefValue());
                    _legendScheme.setFieldName(fieldName);

                    this.jButton_AddBreak.setEnabled(true);
                    this.jButton_RemoveBreak.setEnabled(true);
                    this.jButton_RemoveAllBreaks.setEnabled(true);
                    this.jButton_MoveBreakDown.setEnabled(true);
                    this.jButton_MoveBreakUp.setEnabled(true);
                    this.jButton_MakeBreaks.setEnabled(true);
                    this.jButton_ReverseBreaks.setEnabled(true);
                    break;
            }

            //ShowLegendScheme(_legendScheme);
            //DataGridView1.Refresh();
            legendView1.setLegendScheme(_legendScheme);
            legendView1.repaint();
        }
    }

    /**
     * Get layer property sheet
     *
     * @return The layer property sheet
     */
    public PropertySheetPanel getPropertySheet() {
        return this.propertySheetPanel1;
    }

    public void setMapLayer(MapLayer aLayer) {
        _mapLayer = aLayer;
        _object = aLayer;
        switch (aLayer.getLayerType()) {
            case VectorLayer:
                _legendScheme = (LegendScheme) _mapLayer.getLegendScheme().clone();
                this.legendView1.setLegendScheme(_mapLayer.getLegendScheme());
                break;
            case RasterLayer:
                if (_mapLayer.getLegendScheme() != null) {
                    _legendScheme = (LegendScheme) _mapLayer.getLegendScheme().clone();
                    this.legendView1.setLegendScheme(_mapLayer.getLegendScheme());
                } else {
                    _legendScheme = null;
                }
                _object = ((RasterLayer) aLayer).new RasterLayerBean();
                break;
            case ImageLayer:
                _object = ((ImageLayer) aLayer).new ImageLayerBean();
                break;
            case WebMapLayer:
                _object = ((WebMapLayer) aLayer).new WebMapLayerBean();
        }

        DefaultBeanInfoResolver resolver = new DefaultBeanInfoResolver();
        BeanInfo beanInfo = resolver.getBeanInfo(_object);

        this.propertySheetPanel1.setMode(PropertySheet.VIEW_AS_CATEGORIES);
        this.propertySheetPanel1.setProperties(beanInfo.getPropertyDescriptors());
        this.propertySheetPanel1.readFromObject(_object);

        this._ifCreateLegendScheme = false;
        this._isLoading = true;
        update();
        this._ifCreateLegendScheme = true;
        this._isLoading = false;
    }

    /**
     * Set legend scheme
     *
     * @param aLS Legend scheme
     */
    public void setLegendScheme(LegendScheme aLS) {
        _legendScheme = (LegendScheme) aLS.clone();
        legendView1.setLegendScheme(_legendScheme);
        legendView1.update(aLS);
    }

    private void update() {
        this.jTabbedPane1.removeAll();
        this.jTabbedPane1.addTab("General", jPanel_General);
        switch (_mapLayer.getLayerType()) {
            case VectorLayer:
            case RasterLayer:
                if (this._legendScheme != null) {
                    this.jTabbedPane1.addTab("Legend", jPanel_Legend);
                }
                break;
        }

        switch (_mapLayer.getLayerType()) {
            case VectorLayer:
                this.jComboBox_LegendType.setEnabled(true);
                this.jComboBox_Field.setEnabled(true);
                //Set legend type             
                this.jComboBox_LegendType.removeAllItems();
                this.jComboBox_LegendType.addItem(LegendType.SingleSymbol);
                this.jComboBox_LegendType.addItem(LegendType.UniqueValue);
                this.jComboBox_LegendType.addItem(LegendType.GraduatedColor);
                this.jComboBox_LegendType.setSelectedItem(_legendScheme.getLegendType());
                switch ((LegendType) this.jComboBox_LegendType.getSelectedItem()) {
                    case SingleSymbol:
                        this.jButton_AddBreak.setEnabled(false);
                        this.jButton_RemoveBreak.setEnabled(false);
                        this.jButton_RemoveAllBreaks.setEnabled(false);
                        this.jButton_MoveBreakUp.setEnabled(false);
                        this.jButton_MoveBreakDown.setEnabled(false);
                        this.jButton_MakeBreaks.setEnabled(false);
                        break;
                    default:
                        this.jButton_AddBreak.setEnabled(true);
                        this.jButton_RemoveBreak.setEnabled(true);
                        this.jButton_RemoveAllBreaks.setEnabled(true);
                        this.jButton_MoveBreakUp.setEnabled(true);
                        this.jButton_MoveBreakDown.setEnabled(true);
                        this.jButton_MakeBreaks.setEnabled(true);
                        break;
                }

                //Set field text
                this.jComboBox_Field.setSelectedItem(_legendScheme.getFieldName());

                //Set chart
                switch (_mapLayer.getLegendScheme().getBreakType()) {
                    case PointBreak:
                    case PolygonBreak:
                        //this.jTabbedPane1.setEnabledAt(2, true);
                        this.jTabbedPane1.addTab("Chart", jPanel_Chart);
                        VectorLayer aLayer = (VectorLayer) _mapLayer;
                        if (_mapLayer.getShapeType() == ShapeTypes.Polygon) {
                            this.jComboBox_ChartType.removeAllItems();
                            this.jComboBox_ChartType.addItem(ChartTypes.BarChart.toString());
                            this.jComboBox_ChartType.addItem(ChartTypes.PieChart.toString());
                        } else {
                            this.jComboBox_ChartType.removeAllItems();
                            this.jComboBox_ChartType.addItem(ChartTypes.BarChart.toString());
                            this.jComboBox_ChartType.addItem(ChartTypes.PieChart.toString());
                            //CB_ChartType.Items.Add(ChartTypes.WindVector.ToString());
                            //CB_ChartType.Items.Add(ChartTypes.WindBarb.ToString());
                            //CB_ChartType.Items.Add(ChartTypes.StationModel.ToString());
                        }
                        this.jComboBox_ChartType.setSelectedItem(aLayer.getChartSet().getChartType().toString());

                        //Add fields    
                        aLayer.getChartSet().update();
                        DefaultListModel listModel = new DefaultListModel();
                        boolean isCheck;
                        for (int i = 0; i < aLayer.getFieldNumber(); i++) {
                            if (MIMath.isNumeric(aLayer.getField(i))) {
                                String fn = aLayer.getFieldName(i);
                                isCheck = false;
                                if (aLayer.getChartSet().getFieldNames().contains(fn)) {
                                    isCheck = true;
                                }
                                listModel.addElement(new CheckBoxListEntry(fn, isCheck));
                            }
                        }
                        //this.checkBoxList_Fields = new CheckBoxList();
                        this.checkBoxList_Fields.setModel(listModel);

                        this.jTextField_BarWidth.setText(String.valueOf(aLayer.getChartSet().getBarWidth()));
                        this.jTextField_Maximum.setText(String.valueOf(aLayer.getChartSet().getMaxSize()));
                        this.jTextField_Minimum.setText(String.valueOf(aLayer.getChartSet().getMinSize()));
                        this.jTextField_XShift.setText(String.valueOf(aLayer.getChartSet().getXShift()));
                        this.jTextField_YShift.setText(String.valueOf(aLayer.getChartSet().getYShift()));
                        this.jCheckBox_CollisionAvoidance.setSelected(aLayer.getChartSet().isAvoidCollision());
                        //Set align type
                        this.jComboBox_Align.removeAllItems();
                        for (AlignType align : AlignType.values()) {
                            this.jComboBox_Align.addItem(align.toString());
                        }
                        this.jComboBox_Align.setSelectedItem(aLayer.getChartSet().getAlignType().toString());
                        this.jCheckBox_DisplayIn3D.setSelected(aLayer.getChartSet().isView3D());
                        this.jTextField_Thickness.setText(String.valueOf(aLayer.getChartSet().getThickness()));

                        legendView_Chart.setLegendScheme(aLayer.getChartSet().getLegendScheme());
                        break;
                    default:
                        //this.jTabbedPane1.setEnabledAt(2, false);
                        break;
                }
                break;
            case RasterLayer:
                if (this._legendScheme != null) {
                    this.jComboBox_LegendType.setEnabled(true);
                    this.jComboBox_Field.removeAllItems();
                    this.jComboBox_Field.setEnabled(false);
                    //Set legend type             
                    this.jComboBox_LegendType.removeAllItems();
                    this.jComboBox_LegendType.addItem(LegendType.UniqueValue);
                    this.jComboBox_LegendType.addItem(LegendType.GraduatedColor);
                    this.jComboBox_LegendType.setSelectedItem(_legendScheme.getLegendType());
                    this.jButton_AddBreak.setEnabled(true);
                    this.jButton_RemoveBreak.setEnabled(true);
                    this.jButton_RemoveAllBreaks.setEnabled(true);
                    this.jButton_MoveBreakUp.setEnabled(true);
                    this.jButton_MoveBreakDown.setEnabled(true);
                    this.jButton_MakeBreaks.setEnabled(true);
                }
                break;
            default:
                this.jComboBox_LegendType.removeAllItems();
                this.jComboBox_LegendType.setEnabled(false);
                this.jComboBox_Field.removeAllItems();
                this.jComboBox_Field.setEnabled(false);
                this.jButton_AddBreak.setEnabled(true);
                this.jButton_RemoveBreak.setEnabled(true);
                this.jButton_RemoveAllBreaks.setEnabled(true);
                this.jButton_MoveBreakUp.setEnabled(true);
                this.jButton_MoveBreakDown.setEnabled(true);
                this.jButton_MakeBreaks.setEnabled(true);
                break;
        }
    }

    public void setMapFrame(MapFrame mf) {
        _mapFrame = mf;
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(FrmLayerProperty.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(FrmLayerProperty.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(FrmLayerProperty.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(FrmLayerProperty.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the dialog */
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                FrmLayerProperty dialog = new FrmLayerProperty(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    @Override
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private org.meteoinfo.ui.JCheckBoxList checkBoxList_Fields;
    private javax.swing.JButton jButton_AddBreak;
    private javax.swing.JButton jButton_Apply;
    private javax.swing.JButton jButton_Cancel;
    private javax.swing.JButton jButton_ChartLabel;
    private javax.swing.JButton jButton_ExportLegend;
    private javax.swing.JButton jButton_ImportLegend;
    private javax.swing.JButton jButton_MakeBreaks;
    private javax.swing.JButton jButton_MoveBreakDown;
    private javax.swing.JButton jButton_MoveBreakUp;
    private javax.swing.JButton jButton_OK;
    private javax.swing.JButton jButton_RemoveAllBreaks;
    private javax.swing.JButton jButton_RemoveBreak;
    private javax.swing.JButton jButton_ReverseBreaks;
    private javax.swing.JCheckBox jCheckBox_CollisionAvoidance;
    private javax.swing.JCheckBox jCheckBox_DisplayIn3D;
    private javax.swing.JComboBox jComboBox_Align;
    private javax.swing.JComboBox jComboBox_ChartType;
    private javax.swing.JComboBox jComboBox_Field;
    private javax.swing.JComboBox jComboBox_LegendType;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JLabel jLabel_BarWidth;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel_Chart;
    private javax.swing.JPanel jPanel_General;
    private javax.swing.JPanel jPanel_Legend;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JToolBar.Separator jSeparator1;
    private javax.swing.JToolBar.Separator jSeparator2;
    private javax.swing.JToolBar.Separator jSeparator3;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTextField jTextField_BarWidth;
    private javax.swing.JTextField jTextField_Maximum;
    private javax.swing.JTextField jTextField_Minimum;
    private javax.swing.JTextField jTextField_Thickness;
    private javax.swing.JTextField jTextField_XShift;
    private javax.swing.JTextField jTextField_YShift;
    private javax.swing.JToolBar jToolBar1;
    private org.meteoinfo.legend.LegendView legendView1;
    private org.meteoinfo.legend.LegendView legendView_Chart;
    private com.l2fprod.common.propertysheet.PropertySheetPanel propertySheetPanel1;
    // End of variables declaration//GEN-END:variables
}
