/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart;

import java.awt.Point;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.plot3d.Projector;
import org.meteoinfo.data.DataMath;
import org.meteoinfo.global.Extent3D;
import org.meteoinfo.shape.PointZ;

public class ChartText3D
extends ChartText {
    private double z;
    private PointZ zdir = null;

    public double getZ() {
        return this.z;
    }

    public void setZ(double value) {
        this.z = value;
    }

    public PointZ getZDir() {
        return this.zdir;
    }

    public void setZDir(PointZ value) {
        this.zdir = value;
    }

    public void setZDir(float x, float y, float z) {
        this.zdir = x == 0.0f && y == 0.0f && z == 0.0f ? null : new PointZ(x, y, z);
    }

    public void setZDir(String value) {
        float x1 = 0.0f;
        float y1 = 0.0f;
        float z1 = 0.0f;
        switch (value.toLowerCase()) {
            case "x": {
                x1 = 1.0f;
                break;
            }
            case "y": {
                y1 = 1.0f;
                break;
            }
            case "z": {
                z1 = 1.0f;
            }
        }
        this.setZDir(x1, y1, z1);
    }

    public void setPoint(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        Extent3D aExtent = new Extent3D();
        aExtent.minX = x;
        aExtent.maxX = x;
        aExtent.minY = y;
        aExtent.maxY = y;
        aExtent.minZ = z;
        aExtent.maxZ = z;
        this.setExtent(aExtent);
    }

    public void updateAngle(Projector projector) {
        if (this.zdir == null) {
            return;
        }
        Point p0 = projector.project(0.0f, 0.0f, 0.0f);
        Point p1 = projector.project((float)this.zdir.X, (float)this.zdir.Y, (float)this.zdir.Z);
        double[] value = DataMath.getDSFromUV(p1.x - p0.x, p1.y - p0.y);
        this.angle = (float)value[0];
    }
}

