/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.axis;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.axis.LonLatAxis;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.Reproject;
import org.meteoinfo.projection.info.ProjectionInfo;

public class ProjLonLatAxis
extends LonLatAxis {
    private ProjectionInfo proj;
    private double x_y;

    public ProjLonLatAxis(String label, boolean isX, ProjectionInfo proj) {
        super(label, isX, isX);
        this.proj = proj;
    }

    public ProjLonLatAxis(String label, boolean isX, ProjectionInfo proj, double xy) {
        super(label, isX);
        this.proj = proj;
        this.x_y = xy;
    }

    public ProjectionInfo getProject() {
        return this.proj;
    }

    public void setProject(ProjectionInfo value) {
        this.proj = value;
    }

    public double getX_Y() {
        return this.x_y;
    }

    public void setX_Y(double value) {
        this.x_y = value;
    }

    @Override
    public void updateTickValues() {
        double maxv;
        double minv;
        if (this.proj == null) {
            return;
        }
        double min = this.getMinValue();
        double max = this.getMaxValue();
        ProjectionInfo toproj = KnownCoordinateSystems.geographic.world.WGS1984;
        double[][] points = new double[2][];
        if (this.isXAxis()) {
            points[0] = new double[]{min, this.x_y};
            points[1] = new double[]{max, this.x_y};
            Reproject.reprojectPoints(points, this.proj, toproj);
            minv = points[0][0];
            maxv = points[1][0];
        } else {
            points[0] = new double[]{this.x_y, min};
            points[1] = new double[]{this.x_y, max};
            Reproject.reprojectPoints(points, this.proj, toproj);
            minv = points[0][1];
            maxv = points[1][1];
        }
        List<Object> r = MIMath.getIntervalValues1(minv, maxv);
        double[] values = (double[])r.get(0);
        double[] tickValues = new double[values.length];
        this.setTickValues((double[])r.get(0));
        this.setTickDeltaValue((Double)r.get(1));
    }

    @Override
    public void updateTickLabels() {
        ArrayList<ChartText> tls = new ArrayList<ChartText>();
        for (double v : this.getTickValues()) {
            double value = v;
            if (value > 180.0) {
                value -= 360.0;
            }
            String lab = String.valueOf(value);
            lab = DataConvert.removeTailingZeros(lab);
            if (this.isXAxis()) {
                if (value == -180.0) {
                    lab = "180";
                } else if (value != 0.0 && value != 180.0) {
                    lab = lab.substring(0, 1).equals("-") ? lab.substring(1) + "W" : lab + "E";
                }
            } else if (value != 0.0) {
                lab = lab.substring(0, 1).equals("-") ? lab.substring(1) + "S" : lab + "N";
            }
            if (this.isDrawDegreeSymbol()) {
                lab = lab.endsWith("E") || lab.endsWith("W") || lab.endsWith("N") || lab.endsWith("S") ? lab.substring(0, lab.length() - 1) + String.valueOf('\u00ba') + lab.substring(lab.length() - 1) : lab + String.valueOf('\u00ba');
            }
            tls.add(new ChartText(lab));
        }
        this.setTickLabels(tls);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (ProjLonLatAxis)super.clone();
    }
}

