/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.axis;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.axis.Axis;
import org.meteoinfo.chart.axis.TimeUnit;
import org.meteoinfo.global.util.DateUtil;

public class TimeAxis
extends Axis
implements Cloneable {
    private String timeFormat = "yyyy-MM-dd";
    private TimeUnit timeUnit = TimeUnit.DAY;
    private boolean varFormat = true;

    public TimeAxis(String label, boolean xAxis) {
        super(label, xAxis);
    }

    public TimeAxis(Axis axis) {
        this(axis.getLabel().getText(), axis.isXAxis());
        this.setAutoTick(axis.isAutoTick());
        this.setDrawLabel(axis.isDrawLabel());
        this.setDrawTickLabel(axis.isDrawTickLabel());
        this.setDrawTickLine(axis.isDrawTickLine());
        this.setInsideTick(axis.isInsideTick());
        this.setInverse(axis.isInverse());
        this.setLabelColor(axis.getLabelColor());
        this.setLineWidth(axis.getLineWidth());
        this.setLineStyle(axis.getLineStyle());
        this.setLocation(axis.getLocation());
        this.setMaxValue(axis.getMaxValue());
        this.setMinValue(axis.getMinValue());
        this.setMinorTickNum(axis.getMinorTickNum());
        this.setMinorTickVisible(axis.isMinorTickVisible());
        this.setShift(axis.getShift());
        this.setTickColor(axis.getTickColor());
        this.setTickDeltaValue(axis.getTickDeltaValue());
        this.setTickLabelColor(axis.getTickLabelColor());
        this.setTickLabelFont(axis.getTickLabelFont());
        this.setTickLength(axis.getTickLength());
        this.setVisible(axis.isVisible());
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String value) {
        this.timeFormat = value;
        this.timeUnit = value.contains("s") ? TimeUnit.SECOND : (value.contains("m") ? TimeUnit.MINUTE : (value.contains("H") ? TimeUnit.HOUR : (value.contains("d") ? TimeUnit.DAY : (value.contains("M") ? TimeUnit.MONTH : TimeUnit.YEAR))));
        this.varFormat = false;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit value) {
        this.timeUnit = value;
    }

    public boolean isVarFormat() {
        return this.varFormat;
    }

    public void setVarFormat(boolean value) {
        this.varFormat = value;
    }

    @Override
    public void updateTickLabels() {
        ArrayList<ChartText> tls = new ArrayList<ChartText>();
        SimpleDateFormat format = new SimpleDateFormat(this.timeFormat);
        double[] tvs = this.getTickValues();
        if (tvs != null) {
            for (double value : this.getTickValues()) {
                Date date = DateUtil.fromOADate(value);
                String lab = format.format(date);
                tls.add(new ChartText(lab));
            }
        }
        this.setTickLabels(tls);
    }

    @Override
    public void updateTickValues() {
        if (this.varFormat) {
            this.updateTimeTickValues_var();
        } else if (this.timeUnit != null) {
            this.updateTimeTickValues();
        }
    }

    private void updateTimeTickValues() {
        Date sdate = DateUtil.fromOADate(this.getMinValue());
        Date edate = DateUtil.fromOADate(this.getMaxValue());
        Calendar scal = Calendar.getInstance();
        Calendar ecal = Calendar.getInstance();
        scal.setTime(sdate);
        ecal.setTime(edate);
        Calendar sscal = Calendar.getInstance();
        sscal.setTime(sdate);
        ArrayList<Date> dates = new ArrayList<Date>();
        switch (this.timeUnit) {
            case YEAR: {
                scal.set(2, 0);
                scal.set(5, 1);
                scal.set(11, 0);
                scal.set(12, 0);
                scal.set(13, 0);
                if (!scal.before(sscal)) {
                    dates.add(scal.getTime());
                }
                while (!scal.after(ecal)) {
                    scal.set(1, scal.get(1) + 1);
                    dates.add(scal.getTime());
                }
                break;
            }
            case MONTH: {
                scal.set(5, 1);
                scal.set(11, 0);
                scal.set(12, 0);
                scal.set(13, 0);
                if (!scal.before(sscal)) {
                    dates.add(scal.getTime());
                }
                while (!scal.after(ecal)) {
                    scal.add(2, 1);
                    if (scal.before(sscal)) continue;
                    dates.add(scal.getTime());
                }
                break;
            }
            case DAY: {
                scal.set(11, 0);
                scal.set(12, 0);
                scal.set(13, 0);
                if (!scal.before(sscal)) {
                    dates.add(scal.getTime());
                }
                while (!scal.after(ecal)) {
                    scal.add(5, 1);
                    if (!scal.before(ecal)) continue;
                    dates.add(scal.getTime());
                }
                break;
            }
            case HOUR: {
                scal.set(12, 0);
                scal.set(13, 0);
                if (!scal.before(sscal)) {
                    dates.add(scal.getTime());
                }
                while (!scal.after(ecal)) {
                    scal.add(11, 1);
                    if (!scal.before(ecal)) continue;
                    dates.add(scal.getTime());
                }
                break;
            }
            case MINUTE: {
                scal.set(13, 0);
                if (!scal.before(sscal)) {
                    dates.add(scal.getTime());
                }
                while (!scal.after(ecal)) {
                    scal.add(12, 1);
                    if (!scal.before(ecal)) continue;
                    dates.add(scal.getTime());
                }
                break;
            }
            case SECOND: {
                if (!scal.before(sscal)) {
                    dates.add(scal.getTime());
                }
                while (!scal.after(ecal)) {
                    scal.add(13, 1);
                    if (!scal.before(ecal)) continue;
                    dates.add(scal.getTime());
                }
                break;
            }
        }
        double[] tvs = new double[dates.size()];
        for (int i = 0; i < dates.size(); ++i) {
            tvs[i] = DateUtil.toOADate((Date)dates.get(i));
        }
        this.setTickValues(tvs);
    }

    private void updateTimeTickValues_var() {
        Date sdate = DateUtil.fromOADate(this.getMinValue());
        Date edate = DateUtil.fromOADate(this.getMaxValue());
        Calendar scal = Calendar.getInstance();
        Calendar ecal = Calendar.getInstance();
        scal.setTime(sdate);
        ecal.setTime(edate);
        Calendar sscal = Calendar.getInstance();
        sscal.setTime(sdate);
        ArrayList<Date> dates = new ArrayList<Date>();
        scal.add(1, 5);
        if (scal.before(ecal)) {
            this.timeFormat = "yyyy";
            this.timeUnit = TimeUnit.YEAR;
            scal.setTime(sdate);
            scal.set(2, 0);
            scal.set(5, 1);
            scal.set(11, 0);
            scal.set(12, 0);
            scal.set(13, 0);
            if (!scal.before(sscal)) {
                dates.add(scal.getTime());
            }
            while (!scal.after(ecal)) {
                scal.set(1, scal.get(1) + 1);
                dates.add(scal.getTime());
            }
        } else {
            scal.setTime(sdate);
            scal.add(2, 5);
            if (scal.before(ecal)) {
                scal.setTime(sdate);
                this.timeFormat = "M";
                this.timeUnit = TimeUnit.MONTH;
                scal.set(5, 1);
                scal.set(11, 0);
                scal.set(12, 0);
                scal.set(13, 0);
                if (!scal.before(sscal)) {
                    dates.add(scal.getTime());
                }
                while (!scal.after(ecal)) {
                    scal.add(2, 1);
                    if (!scal.before(ecal)) continue;
                    dates.add(scal.getTime());
                }
            } else {
                scal.setTime(sdate);
                scal.add(5, 5);
                if (scal.before(ecal)) {
                    scal.setTime(sdate);
                    this.timeFormat = "d";
                    this.timeUnit = TimeUnit.DAY;
                    scal.set(11, 0);
                    scal.set(12, 0);
                    scal.set(13, 0);
                    if (!scal.before(sscal)) {
                        dates.add(scal.getTime());
                    }
                    while (!scal.after(ecal)) {
                        scal.add(5, 1);
                        if (!scal.before(ecal)) continue;
                        dates.add(scal.getTime());
                    }
                } else {
                    scal.setTime(sdate);
                    scal.add(11, 5);
                    if (scal.before(ecal)) {
                        scal.setTime(sdate);
                        this.timeFormat = "H";
                        this.timeUnit = TimeUnit.HOUR;
                        scal.set(12, 0);
                        scal.set(13, 0);
                        if (!scal.before(sscal)) {
                            dates.add(scal.getTime());
                        }
                        while (!scal.after(ecal)) {
                            scal.add(11, 1);
                            if (!scal.before(ecal)) continue;
                            dates.add(scal.getTime());
                        }
                    } else {
                        scal.setTime(sdate);
                        scal.add(12, 5);
                        if (scal.before(ecal)) {
                            scal.setTime(sdate);
                            this.timeFormat = "HH:mm";
                            this.timeUnit = TimeUnit.MINUTE;
                            scal.set(13, 0);
                            if (!scal.before(sscal)) {
                                dates.add(scal.getTime());
                            }
                            while (!scal.after(ecal)) {
                                scal.add(12, 1);
                                if (!scal.before(ecal)) continue;
                                dates.add(scal.getTime());
                            }
                        } else {
                            scal.setTime(sdate);
                            this.timeFormat = "HH:mm:ss";
                            this.timeUnit = TimeUnit.SECOND;
                            if (!scal.before(sscal)) {
                                dates.add(scal.getTime());
                            }
                            while (!scal.after(ecal)) {
                                scal.add(13, 1);
                                if (!scal.before(ecal)) continue;
                                dates.add(scal.getTime());
                            }
                        }
                    }
                }
            }
        }
        double[] tvs = new double[dates.size()];
        for (int i = 0; i < dates.size(); ++i) {
            tvs[i] = DateUtil.toOADate((Date)dates.get(i));
        }
        this.setTickValues(tvs);
    }

    public void updateTimeLabels_back() {
        Date sdate = DateUtil.fromOADate(this.getMinValue());
        Date edate = DateUtil.fromOADate(this.getMaxValue());
        Calendar scal = Calendar.getInstance();
        Calendar ecal = Calendar.getInstance();
        Calendar cal = Calendar.getInstance();
        scal.setTime(sdate);
        ecal.setTime(edate);
        Calendar sscal = Calendar.getInstance();
        sscal.setTime(sdate);
        boolean sameYear = false;
        boolean sameMonth = false;
        boolean sameDay = false;
        boolean sameHour = false;
        if (scal.get(1) == ecal.get(1)) {
            sameYear = true;
        }
        if (scal.get(2) == ecal.get(2)) {
            sameMonth = true;
        }
        if (scal.get(6) == ecal.get(6)) {
            sameDay = true;
        }
        if (scal.get(11) == ecal.get(11)) {
            sameHour = true;
        }
        ArrayList<Date> dates = new ArrayList<Date>();
        if (sameYear) {
            if (sameMonth) {
                if (sameDay) {
                    if (sameHour) {
                        cal.setTime(scal.getTime());
                        cal.add(12, 5);
                        if (cal.before(ecal)) {
                            this.timeFormat = "HH:mm";
                            scal.set(12, scal.get(12) + 1);
                            scal.set(13, 0);
                            dates.add(scal.getTime());
                            while (scal.before(ecal)) {
                                scal.set(12, scal.get(12) + 1);
                                dates.add(scal.getTime());
                            }
                        } else {
                            this.timeFormat = "HH:mm:ss";
                            scal.set(12, 0);
                            scal.set(13, 0);
                            if (scal.after(sscal)) {
                                dates.add(scal.getTime());
                            }
                            while (scal.before(ecal)) {
                                scal.set(13, scal.get(13) + 10);
                                if (!scal.after(sscal)) continue;
                                dates.add(scal.getTime());
                            }
                        }
                    } else {
                        this.timeFormat = "HH:mm";
                        scal.set(11, scal.get(11) + 1);
                        scal.set(12, 0);
                        scal.set(13, 0);
                        dates.add(scal.getTime());
                        while (scal.before(ecal)) {
                            scal.set(11, scal.get(11) + 1);
                            dates.add(scal.getTime());
                        }
                    }
                } else {
                    cal.setTime(scal.getTime());
                    cal.add(5, 5);
                    if (cal.before(ecal)) {
                        this.timeFormat = "MM/dd";
                        scal.set(5, scal.get(5) + 1);
                        scal.set(11, 0);
                        scal.set(12, 0);
                        scal.set(13, 0);
                        dates.add(scal.getTime());
                        while (scal.before(ecal)) {
                            scal.set(5, scal.get(5) + 1);
                            dates.add(scal.getTime());
                        }
                    } else {
                        this.timeFormat = "HH:mm";
                        scal.set(11, 0);
                        scal.set(12, 0);
                        scal.set(13, 0);
                        if (scal.after(sscal)) {
                            dates.add(scal.getTime());
                        }
                        while (scal.before(ecal)) {
                            scal.set(11, scal.get(11) + 6);
                            if (!scal.after(sscal)) continue;
                            dates.add(scal.getTime());
                        }
                    }
                }
            } else {
                this.timeFormat = "MM";
                scal.set(2, scal.get(2) + 1);
                scal.set(5, 1);
                scal.set(11, 0);
                scal.set(12, 0);
                scal.set(13, 0);
                dates.add(scal.getTime());
                while (scal.before(ecal)) {
                    scal.set(2, scal.get(2) + 1);
                    dates.add(scal.getTime());
                }
            }
        } else {
            this.timeFormat = "yyyy";
            scal.set(1, scal.get(1) + 1);
            scal.set(2, 0);
            scal.set(5, 1);
            scal.set(11, 0);
            scal.set(12, 0);
            scal.set(13, 0);
            dates.add(scal.getTime());
            while (scal.before(ecal)) {
                scal.set(1, scal.get(1) + 1);
                dates.add(scal.getTime());
            }
        }
        double[] tvs = new double[dates.size()];
        for (int i = 0; i < dates.size(); ++i) {
            tvs[i] = DateUtil.toOADate((Date)dates.get(i));
        }
        this.setTickValues(tvs);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (TimeAxis)super.clone();
    }
}

