/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.meteoinfo.chart.ChartNorthArrow;
import org.meteoinfo.chart.ChartPanel;
import org.meteoinfo.chart.ChartScaleBar;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.Location;
import org.meteoinfo.chart.axis.LonLatAxis;
import org.meteoinfo.chart.plot.AbstractPlot2D;
import org.meteoinfo.chart.plot.PlotType;
import org.meteoinfo.chart.plot.XAlign;
import org.meteoinfo.chart.plot.YAlign;
import org.meteoinfo.data.Dataset;
import org.meteoinfo.data.mapdata.webmap.IWebMapPanel;
import org.meteoinfo.data.mapdata.webmap.TileLoadListener;
import org.meteoinfo.drawing.Draw;
import org.meteoinfo.global.Direction;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.global.PointF;
import org.meteoinfo.layer.LayerCollection;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.legend.LabelBreak;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.MapFrame;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.PolylineBreak;
import org.meteoinfo.map.GridLabel;
import org.meteoinfo.map.MapView;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionUtil;
import org.meteoinfo.projection.Reproject;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.shape.CircleShape;
import org.meteoinfo.shape.CurveLineShape;
import org.meteoinfo.shape.Graphic;
import org.meteoinfo.shape.PointShape;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.PolylineShape;
import org.meteoinfo.shape.ShapeUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MapPlot
extends AbstractPlot2D
implements IWebMapPanel {
    private MapFrame mapFrame;
    private MapView mapView;
    private boolean antialias = false;
    private MapLayer selectedLayer;
    private final TileLoadListener tileLoadListener = new TileLoadListener(this);
    private ChartPanel parent;
    private float[] lonLim;
    private float[] latLim;
    private Graphic boundary;
    private ChartScaleBar scaleBar;
    private ChartNorthArrow northArrow;

    public MapPlot() {
        this.setAutoAspect(false);
        try {
            this.setXAxis(new LonLatAxis("Longitude", true));
            this.setYAxis(new LonLatAxis("Latitude", false));
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(MapPlot.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.getAxis(Location.TOP).setDrawTickLabel(false);
        this.getAxis(Location.RIGHT).setDrawTickLabel(false);
        this.setDrawNeatLine(true);
        this.getGridLine().setTop(true);
    }

    public MapPlot(MapView mapView) {
        this();
        this.setMapView(mapView, true);
        this.mapFrame = new MapFrame();
        this.mapFrame.setMapView(mapView);
    }

    public MapPlot(MapFrame mapFrame) {
        this();
        this.mapFrame = mapFrame;
        this.setMapView(mapFrame.getMapView(), true);
    }

    public void setParent(ChartPanel value) {
        this.parent = value;
    }

    @Override
    public Dataset getDataset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDataset(Dataset dataset) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MapView getMapView() {
        return this.mapView;
    }

    public void setMapView(MapView value, boolean isGeoMap) {
        this.mapView = value;
        this.mapView.setGeoMap(isGeoMap);
        this.mapView.setMultiGlobalDraw(isGeoMap);
        Extent extent = this.getAutoExtent();
        this.setDrawExtent(extent);
        PolygonShape bvs = this.mapView.getProjection().getProjInfo().getBoundary();
        if (bvs != null) {
            this.setBoundary(bvs);
        }
    }

    @Override
    public PlotType getPlotType() {
        return PlotType.XY2D;
    }

    public boolean isAntialias() {
        return this.antialias;
    }

    public void setAntialias(boolean value) {
        this.antialias = value;
    }

    @Override
    public Color getBackground() {
        return this.mapView.getBackground();
    }

    @Override
    public void setBackground(Color value) {
        this.mapView.setBackground(value);
    }

    public MapFrame getMapFrame() {
        return this.mapFrame;
    }

    public void setMapFrame(MapFrame value) {
        this.mapFrame = value;
        this.setMapView(this.mapFrame.getMapView(), true);
    }

    public ProjectionInfo getProjInfo() {
        return this.getMapView().getProjection().getProjInfo();
    }

    public boolean isLonLatMap() {
        return this.getMapView().getProjection().isLonLatMap();
    }

    public MapLayer getSelectedLayer() {
        if (this.selectedLayer != null) {
            return this.selectedLayer;
        }
        if (this.mapView.getLastAddedLayer() != null) {
            return this.mapView.getLastAddedLayer();
        }
        return null;
    }

    public void setSelectedLayer(MapLayer value) {
        this.selectedLayer = value;
    }

    public float[] getLonLim() {
        return this.lonLim;
    }

    public void setLonLim(float[] value) {
        this.lonLim = value;
    }

    public void setLonLim(float lon1, float lon2) {
        this.lonLim = new float[]{lon1, lon2};
    }

    public float[] getLatLim() {
        return this.latLim;
    }

    public void setLatLim(float[] value) {
        this.latLim = value;
    }

    public void setLatLim(float lat1, float lat2) {
        this.latLim = new float[]{lat1, lat2};
    }

    public Graphic getBoundary() {
        return this.boundary;
    }

    public void setBoundary(Graphic value) {
        this.boundary = value;
    }

    public void setBoundary(PolygonShape value) {
        PolygonBreak pb = new PolygonBreak();
        pb.setOutlineSize(1.5f);
        pb.setDrawFill(false);
        this.boundary = new Graphic(value, pb);
    }

    public void setBoundaryProp(PolygonBreak pb) {
        if (this.boundary != null) {
            this.boundary = new Graphic(this.boundary.getShape(), pb);
        }
    }

    public ChartScaleBar getScaleBar() {
        return this.scaleBar;
    }

    public void setScaleBar(ChartScaleBar value) {
        this.scaleBar = value;
    }

    public ChartNorthArrow getNorthArrow() {
        return this.northArrow;
    }

    public void setNorthArrow(ChartNorthArrow value) {
        this.northArrow = value;
    }

    public boolean hasWebMapLayer() {
        return this.mapView.hasWebMapLayer();
    }

    @Override
    public int getWebMapZoom() {
        return this.mapView.getWebMapZoom();
    }

    @Override
    public void reDraw() {
        if (this.parent != null) {
            this.parent.paintGraphics();
        }
    }

    @Override
    public void draw(Graphics2D g, Rectangle2D area) {
        float y;
        float x;
        super.draw(g, area);
        if (this.scaleBar != null) {
            x = (float)(area.getWidth() * (double)this.scaleBar.getX());
            y = (float)(area.getHeight() * (double)(1.0f - this.scaleBar.getY()));
            this.scaleBar.draw(g, x, y);
        }
        if (this.northArrow != null) {
            x = (float)(area.getWidth() * (double)this.northArrow.getX());
            y = (float)(area.getHeight() * (double)(1.0f - this.northArrow.getY()));
            this.northArrow.draw(g, x, y);
        }
    }

    @Override
    void drawGraph(Graphics2D g, Rectangle2D area) {
        PolygonBreak pb;
        this.mapView.setAntiAlias(this.antialias);
        this.mapView.setViewExtent((Extent)this.getDrawExtent().clone());
        if (this.boundary != null && (pb = (PolygonBreak)this.boundary.getLegend().clone()).isDrawFill()) {
            pb.setDrawOutline(false);
            this.mapView.drawGraphic(g, new Graphic(this.boundary.getShape(), pb), area.getBounds());
        }
        this.mapView.paintGraphics(g, area, this.tileLoadListener);
        if (this.boundary != null) {
            pb = (PolygonBreak)this.boundary.getLegend().clone();
            pb.setDrawFill(false);
            this.mapView.drawGraphic(g, new Graphic(this.boundary.getShape(), pb), area.getBounds());
        }
    }

    @Override
    public Extent getAutoExtent() {
        return this.mapView.getLayersWholeExtent();
    }

    @Override
    public void setAutoExtent() {
    }

    @Override
    public void updateLegendScheme() {
    }

    public void addGraphic(Graphic graphic) {
        this.getMapView().addGraphic(graphic);
    }

    public Graphic addGrahic(Graphic graphic, ProjectionInfo proj) {
        ProjectionInfo toProj = this.getMapView().getProjection().getProjInfo();
        if (proj.equals(toProj)) {
            this.getMapView().addGraphic(graphic);
            return graphic;
        }
        Graphic nGraphic = ProjectionUtil.projectGraphic(graphic, proj, toProj);
        this.getMapView().addGraphic(nGraphic);
        return nGraphic;
    }

    public void addLayer(MapLayer layer) {
        this.mapView.addLayer(layer);
        this.setDrawExtent(layer.getExtent());
    }

    public void addLayer(int idx, MapLayer layer) {
        this.mapView.addLayer(idx, layer);
        this.setDrawExtent(layer.getExtent());
    }

    public void removeLastLayer() {
        this.mapView.removeLayer(this.mapView.getLastAddedLayer());
    }

    @Override
    public void setAxisOn(boolean value) {
        super.setAxisOn(value);
        this.mapFrame.setDrawGridTickLine(value);
        this.mapFrame.setDrawGridLabel(value);
    }

    public Extent getFullExtent() {
        Extent ext = this.mapView.getExtent();
        if (this.boundary != null) {
            ext = ext.union(this.boundary.getExtent().extend(0.01));
        }
        return ext;
    }

    public void setLonLatExtent(Extent extent) {
        if (this.getMapView().getProjection().isLonLatMap()) {
            super.setDrawExtent(extent);
        } else {
            this.getMapView().zoomToExtentLonLatEx(extent);
            super.setDrawExtent1(this.getMapView().getViewExtent());
            this.setAxisExtent(extent);
        }
    }

    public void setAxisExtent(Extent extent) {
        this.getAxis(Location.BOTTOM).setMinMaxValue(extent.minX, extent.maxX);
        this.getAxis(Location.TOP).setMinMaxValue(extent.minX, extent.maxX);
        this.getAxis(Location.LEFT).setMinMaxValue(extent.minY, extent.maxY);
        this.getAxis(Location.RIGHT).setMinMaxValue(extent.minY, extent.maxY);
    }

    @Override
    public void addText(ChartText text) {
        if (this.getMapView().getProjection().isLonLatMap()) {
            super.addText(text);
        } else {
            PointShape ps = new PointShape();
            PointD lonlatp = new PointD(text.getX(), text.getY());
            PointD xyp = Reproject.reprojectPoint(lonlatp, KnownCoordinateSystems.geographic.world.WGS1984, this.getMapView().getProjection().getProjInfo());
            ps.setPoint(xyp);
            LabelBreak lb = new LabelBreak();
            lb.setText(text.getText());
            lb.setFont(text.getFont());
            lb.setColor(text.getColor());
            Graphic aGraphic = new Graphic(ps, lb);
            this.getMapView().addGraphic(aGraphic);
        }
    }

    public void addPoint(double lat, double lon, PointBreak pb) {
        PointShape ps = new PointShape();
        PointD lonlatp = new PointD(lon, lat);
        if (this.getMapView().getProjection().isLonLatMap()) {
            ps.setPoint(lonlatp);
        } else {
            PointD xyp = Reproject.reprojectPoint(lonlatp, KnownCoordinateSystems.geographic.world.WGS1984, this.getMapView().getProjection().getProjInfo());
            ps.setPoint(xyp);
        }
        Graphic aGraphic = new Graphic(ps, pb);
        this.getMapView().addGraphic(aGraphic);
    }

    public Graphic addPoint(List<Number> lat, List<Number> lon, PointBreak pb) {
        int i = 0;
        if (i < lat.size()) {
            PointShape ps = new PointShape();
            double x = lon.get(i).doubleValue();
            double y = lat.get(i).doubleValue();
            PointD lonlatp = new PointD(x, y);
            if (this.getMapView().getProjection().isLonLatMap()) {
                ps.setPoint(lonlatp);
            } else {
                PointD xyp = Reproject.reprojectPoint(lonlatp, KnownCoordinateSystems.geographic.world.WGS1984, this.getMapView().getProjection().getProjInfo());
                ps.setPoint(xyp);
            }
            Graphic aGraphic = new Graphic(ps, pb);
            this.getMapView().addGraphic(aGraphic);
            return aGraphic;
        }
        return null;
    }

    public Graphic addPolyline(List<Number> lat, List<Number> lon, PolylineBreak plb) {
        PolylineShape pls;
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (int i = 0; i < lat.size(); ++i) {
            double x = lon.get(i).doubleValue();
            double y = lat.get(i).doubleValue();
            if (Double.isNaN(x)) {
                if (points.size() >= 2) {
                    pls = new PolylineShape();
                    pls.setPoints(points);
                    Graphic aGraphic = new Graphic(pls, plb);
                    this.getMapView().addGraphic(aGraphic);
                }
                points = new ArrayList();
                continue;
            }
            PointD lonlatp = new PointD(x, y);
            if (!this.getMapView().getProjection().isLonLatMap()) {
                lonlatp = Reproject.reprojectPoint(lonlatp, KnownCoordinateSystems.geographic.world.WGS1984, this.getMapView().getProjection().getProjInfo());
            }
            points.add(lonlatp);
        }
        if (points.size() >= 2) {
            pls = new PolylineShape();
            pls.setPoints(points);
            Graphic aGraphic = new Graphic(pls, plb);
            this.getMapView().addGraphic(aGraphic);
            return aGraphic;
        }
        return null;
    }

    public Graphic addPolyline(List<Number> lat, List<Number> lon, PolylineBreak plb, boolean iscurve) {
        PolylineShape pls;
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (int i = 0; i < lat.size(); ++i) {
            double x = lon.get(i).doubleValue();
            double y = lat.get(i).doubleValue();
            if (Double.isNaN(x)) {
                if (points.size() >= 2) {
                    pls = iscurve ? new CurveLineShape() : new PolylineShape();
                    pls.setPoints(points);
                    Graphic aGraphic = new Graphic(pls, plb);
                    this.getMapView().addGraphic(aGraphic);
                }
                points = new ArrayList();
                continue;
            }
            PointD lonlatp = new PointD(x, y);
            if (!this.getMapView().getProjection().isLonLatMap()) {
                lonlatp = Reproject.reprojectPoint(lonlatp, KnownCoordinateSystems.geographic.world.WGS1984, this.getMapView().getProjection().getProjInfo());
            }
            points.add(lonlatp);
        }
        if (points.size() >= 2) {
            pls = iscurve ? new CurveLineShape() : new PolylineShape();
            pls.setPoints(points);
            Graphic aGraphic = new Graphic(pls, plb);
            this.getMapView().addGraphic(aGraphic);
            return aGraphic;
        }
        return null;
    }

    public Graphic addPolygon(List<Number> lat, List<Number> lon, PolygonBreak pgb) {
        PolygonShape pgs;
        ArrayList<PointD> points = new ArrayList<PointD>();
        for (int i = 0; i < lat.size(); ++i) {
            double x = lon.get(i).doubleValue();
            double y = lat.get(i).doubleValue();
            if (Double.isNaN(x)) {
                if (points.size() > 2) {
                    pgs = new PolygonShape();
                    pgs.setPoints(points);
                    Graphic aGraphic = new Graphic(pgs, pgb);
                    this.getMapView().addGraphic(aGraphic);
                }
                points = new ArrayList();
                continue;
            }
            PointD lonlatp = new PointD(x, y);
            if (!this.getMapView().getProjection().isLonLatMap()) {
                lonlatp = Reproject.reprojectPoint(lonlatp, KnownCoordinateSystems.geographic.world.WGS1984, this.getMapView().getProjection().getProjInfo());
            }
            points.add(lonlatp);
        }
        if (points.size() > 2) {
            pgs = new PolygonShape();
            pgs.setPoints(points);
            Graphic aGraphic = new Graphic(pgs, pgb);
            this.getMapView().addGraphic(aGraphic);
            return aGraphic;
        }
        return null;
    }

    public Graphic addCircle(float x, float y, float radius, PolygonBreak pgb) {
        CircleShape aPGS = ShapeUtil.createCircleShape(x, y, radius);
        Graphic graphic = new Graphic(aPGS, pgb);
        this.mapView.addGraphic(graphic);
        return graphic;
    }

    @Override
    public Rectangle2D getPositionArea(Rectangle2D area) {
        Rectangle2D plotArea = super.getPositionArea(area);
        if (!this.isAutoAspect()) {
            MapView mv = this.mapFrame.getMapView();
            mv.setViewExtent((Extent)this.getDrawExtent().clone());
            Extent extent = mv.getViewExtent();
            double width = extent.getWidth();
            double height = extent.getHeight();
            double scaleFactor = mv.getXYScaleFactor();
            if (width / height / scaleFactor > plotArea.getWidth() / plotArea.getHeight()) {
                double h = plotArea.getWidth() * height * scaleFactor / width;
                double delta = plotArea.getHeight() - h;
                plotArea.setRect(plotArea.getX(), plotArea.getY() + delta / 2.0, plotArea.getWidth(), h);
            } else {
                double w = width * plotArea.getHeight() / height / scaleFactor;
                double delta = plotArea.getWidth() - w;
                plotArea.setRect(plotArea.getX() + delta / 2.0, plotArea.getY(), w, plotArea.getHeight());
            }
        }
        return plotArea;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    void drawAxis(Graphics2D g, Rectangle2D area) {
        block60: {
            if (this.mapFrame.getMapView().getProjection().isLonLatMap()) {
                super.drawAxis(g, area);
                return;
            }
            if (!this.mapFrame.isDrawGridLabel()) break block60;
            shift = 5.0f;
            extentList = new ArrayList<Extent>();
            maxExtent = new Extent();
            g.setColor(this.mapFrame.getGridLineColor());
            g.setStroke(new BasicStroke(this.mapFrame.getGridLineSize()));
            sP = new PointF(0.0f, 0.0f);
            eP = new PointF(0.0f, 0.0f);
            font = new Font(this.mapFrame.getGridFont().getFontName(), this.mapFrame.getGridFont().getStyle(), this.mapFrame.getGridFont().getSize());
            g.setFont(font);
            len = this.mapFrame.getTickLineLength();
            space = len + this.mapFrame.getGridLabelShift();
            if (this.mapFrame.isInsideTickLine()) {
                space = this.mapFrame.getGridLabelShift();
            }
            block27: for (i = 0; i < this.mapFrame.getMapView().getGridLabels().size(); ++i) {
                aGL = this.mapFrame.getMapView().getGridLabels().get(i);
                switch (1.$SwitchMap$org$meteoinfo$legend$GridLabelPosition[this.mapFrame.getGridLabelPosition().ordinal()]) {
                    case 1: {
                        switch (1.$SwitchMap$org$meteoinfo$global$Direction[aGL.getLabDirection().ordinal()]) {
                            case 1: 
                            case 2: {
                                continue block27;
                            }
                        }
                        ** GOTO lbl40
                    }
                    case 2: {
                        switch (1.$SwitchMap$org$meteoinfo$global$Direction[aGL.getLabDirection().ordinal()]) {
                            case 1: 
                            case 3: {
                                continue block27;
                            }
                        }
                        ** GOTO lbl40
                    }
                    case 3: {
                        switch (1.$SwitchMap$org$meteoinfo$global$Direction[aGL.getLabDirection().ordinal()]) {
                            case 2: 
                            case 4: {
                                continue block27;
                            }
                        }
                        ** GOTO lbl40
                    }
                    case 4: {
                        switch (1.$SwitchMap$org$meteoinfo$global$Direction[aGL.getLabDirection().ordinal()]) {
                            case 3: 
                            case 4: {
                                continue block27;
                            }
                        }
                    }
lbl40:
                    // 5 sources

                    default: {
                        labX = (float)aGL.getLabPoint().X;
                        labY = (float)aGL.getLabPoint().Y;
                        sP.X = labX += (float)area.getX();
                        sP.Y = labY += (float)area.getY();
                        drawStr = aGL.getLabString();
                        drawStr = drawStr.endsWith("E") != false || drawStr.endsWith("W") != false || drawStr.endsWith("N") != false || drawStr.endsWith("S") != false ? drawStr.substring(0, drawStr.length() - 1) + String.valueOf('\u00ba') + drawStr.substring(drawStr.length() - 1) : drawStr + String.valueOf('\u00ba');
                        aSF = Draw.getStringDimension(drawStr, g);
                        ifDraw = true;
                        aExtent = new Extent();
                        aExtent.minX = labX;
                        aExtent.maxX = labX + (float)aSF.width;
                        aExtent.minY = labY - (float)aSF.height;
                        aExtent.maxY = labY;
                        if (extentList.isEmpty()) {
                            maxExtent = (Extent)aExtent.clone();
                            extentList.add((Extent)aExtent.clone());
                        } else if (!MIMath.isExtentCross(aExtent, maxExtent).booleanValue()) {
                            extentList.add((Extent)aExtent.clone());
                            maxExtent = MIMath.getLagerExtent(maxExtent, aExtent);
                        } else {
                            for (j = 0; j < extentList.size(); ++j) {
                                if (!MIMath.isExtentCross(aExtent, (Extent)extentList.get(j)).booleanValue()) continue;
                                ifDraw = false;
                                break;
                            }
                            if (ifDraw) {
                                extentList.add(aExtent);
                                maxExtent = MIMath.getLagerExtent(maxExtent, aExtent);
                            }
                        }
                        if (!ifDraw) continue block27;
                        if (aGL.isBorder()) {
                            switch (1.$SwitchMap$org$meteoinfo$global$Direction[aGL.getLabDirection().ordinal()]) {
                                case 3: {
                                    labX -= (float)(aSF.width / 2);
                                    labY = labY + (float)(aSF.height * 3 / 4) + (float)space;
                                    eP.X = sP.X;
                                    if (this.mapFrame.isInsideTickLine()) {
                                        eP.Y = sP.Y - (float)len;
                                        break;
                                    }
                                    eP.Y = sP.Y + (float)len;
                                    break;
                                }
                                case 4: {
                                    labX = labX - (float)aSF.width - (float)space;
                                    labY += (float)(aSF.height / 3);
                                    eP.Y = sP.Y;
                                    if (this.mapFrame.isInsideTickLine()) {
                                        eP.X = sP.X + (float)len;
                                        break;
                                    }
                                    eP.X = sP.X - (float)len;
                                    break;
                                }
                                case 2: {
                                    labX -= (float)(aSF.width / 2);
                                    labY -= (float)space;
                                    eP.X = sP.X;
                                    if (this.mapFrame.isInsideTickLine()) {
                                        eP.Y = sP.Y + (float)len;
                                        break;
                                    }
                                    eP.Y = sP.Y - (float)len;
                                    break;
                                }
                                case 1: {
                                    labX += (float)space;
                                    labY += (float)(aSF.height / 3);
                                    eP.Y = sP.Y;
                                    eP.X = this.mapFrame.isInsideTickLine() != false ? sP.X - (float)len : sP.X + (float)len;
                                }
                            }
                            g.setColor(this.mapFrame.getGridLineColor());
                            g.draw(new Line2D.Float(sP.X, sP.Y, eP.X, eP.Y));
                            g.setColor(this.mapFrame.getForeColor());
                            g.drawString(drawStr, labX, labY);
                            continue block27;
                        }
                        g.setColor(this.mapFrame.getForeColor());
                        switch (1.$SwitchMap$org$meteoinfo$projection$ProjectionNames[this.getProjInfo().getProjectionName().ordinal()]) {
                            case 1: 
                            case 2: {
                                angle = aGL.getAngle();
                                v = aGL.getValue();
                                if (v == 0.0) {
                                    if (angle == 90.0f) {
                                        Draw.drawString(g, labX += shift, labY, drawStr, XAlign.LEFT, YAlign.CENTER, false);
                                        continue block27;
                                    }
                                    if (angle == 270.0f) {
                                        Draw.drawString(g, labX -= shift, labY, drawStr, XAlign.RIGHT, YAlign.CENTER, false);
                                        continue block27;
                                    }
                                    if (angle < 90.0f) {
                                        Draw.drawString(g, labX += shift, labY, drawStr, XAlign.LEFT, YAlign.BOTTOM, false);
                                        continue block27;
                                    }
                                    if (angle > 90.0f && angle <= 180.0f) {
                                        Draw.drawString(g, labX += shift, labY, drawStr, XAlign.LEFT, YAlign.TOP, false);
                                        continue block27;
                                    }
                                    if (angle > 180.0f && angle < 270.0f) {
                                        Draw.drawString(g, labX -= shift, labY, drawStr, XAlign.RIGHT, YAlign.TOP, false);
                                        continue block27;
                                    }
                                    if (!(angle > 270.0f) || !(angle <= 360.0f)) continue block27;
                                    Draw.drawString(g, labX -= shift, labY, drawStr, XAlign.RIGHT, YAlign.BOTTOM, false);
                                    continue block27;
                                }
                                if (v > 0.0) {
                                    if (aGL.getLabDirection() == Direction.East) {
                                        Draw.drawString(g, labX += shift, labY, drawStr, XAlign.LEFT, YAlign.BOTTOM, false);
                                        continue block27;
                                    }
                                    Draw.drawString(g, labX -= shift, labY, drawStr, XAlign.RIGHT, YAlign.BOTTOM, false);
                                    continue block27;
                                }
                                if (aGL.getLabDirection() == Direction.East) {
                                    Draw.drawString(g, labX += shift, labY, drawStr, XAlign.LEFT, YAlign.TOP, false);
                                    continue block27;
                                }
                                Draw.drawString(g, labX -= shift, labY, drawStr, XAlign.RIGHT, YAlign.TOP, false);
                                continue block27;
                            }
                            default: {
                                angle = aGL.getAngle();
                                if (angle == 0.0f) {
                                    Draw.drawString(g, labX, labY -= shift, drawStr, XAlign.CENTER, YAlign.BOTTOM, false);
                                    continue block27;
                                }
                                if (angle == 180.0f) {
                                    Draw.drawString(g, labX, labY += shift, drawStr, XAlign.CENTER, YAlign.TOP, false);
                                    continue block27;
                                }
                                if (angle == 90.0f) {
                                    Draw.drawString(g, labX += shift, labY, drawStr, XAlign.LEFT, YAlign.CENTER, false);
                                    continue block27;
                                }
                                if (angle == 270.0f) {
                                    Draw.drawString(g, labX -= shift, labY, drawStr, XAlign.RIGHT, YAlign.CENTER, false);
                                    continue block27;
                                }
                                if (angle > 0.0f && angle <= 45.0f) {
                                    Draw.drawString(g, labX, labY -= shift, drawStr, XAlign.LEFT, YAlign.BOTTOM, false);
                                    continue block27;
                                }
                                if (angle > 45.0f && angle < 90.0f) {
                                    Draw.drawString(g, labX += shift, labY, drawStr, XAlign.LEFT, YAlign.BOTTOM, false);
                                    continue block27;
                                }
                                if (angle > 90.0f && angle <= 135.0f) {
                                    Draw.drawString(g, labX += shift, labY, drawStr, XAlign.LEFT, YAlign.TOP, false);
                                    continue block27;
                                }
                                if (angle > 135.0f && angle < 180.0f) {
                                    Draw.drawString(g, labX, labY += shift, drawStr, XAlign.LEFT, YAlign.TOP, false);
                                    continue block27;
                                }
                                if (angle > 180.0f && angle <= 225.0f) {
                                    Draw.drawString(g, labX, labY += shift, drawStr, XAlign.RIGHT, YAlign.TOP, false);
                                    continue block27;
                                }
                                if (angle > 225.0f && angle < 270.0f) {
                                    Draw.drawString(g, labX -= shift, labY, drawStr, XAlign.RIGHT, YAlign.TOP, false);
                                    continue block27;
                                }
                                if (angle > 270.0f && angle <= 315.0f) {
                                    Draw.drawString(g, labX -= shift, labY, drawStr, XAlign.RIGHT, YAlign.BOTTOM, false);
                                    continue block27;
                                }
                                if (!(angle > 315.0f) || !(angle < 360.0f)) continue block27;
                                Draw.drawString(g, labX, labY -= shift, drawStr, XAlign.RIGHT, YAlign.BOTTOM, false);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    int getXAxisHeight(Graphics2D g) {
        if (this.isLonLatMap()) {
            return super.getXAxisHeight(g);
        }
        int space = 4;
        if (this.mapFrame.isDrawGridLabel()) {
            int height = space;
            height += this.mapFrame.getTickLineLength() + this.mapFrame.getGridLabelShift();
            FontMetrics m = g.getFontMetrics(this.mapFrame.getGridFont());
            return height += m.getHeight();
        }
        return 0;
    }

    @Override
    int getYAxisWidth(Graphics2D g) {
        if (this.isLonLatMap()) {
            return super.getYAxisWidth(g);
        }
        int space = 4;
        if (this.mapFrame.isDrawGridLabel()) {
            int width = space;
            width += this.mapFrame.getTickLineLength() + this.mapFrame.getGridLabelShift();
            FontMetrics m = g.getFontMetrics(this.mapFrame.getGridFont());
            List<GridLabel> labels = this.mapFrame.getMapView().getGridLabels();
            int labWidth = 0;
            for (int i = 0; i < labels.size(); ++i) {
                int w = m.stringWidth(labels.get(i).getLabString());
                if (w <= labWidth) continue;
                labWidth = w;
            }
            return width += labWidth;
        }
        return 0;
    }

    public int getLayerNum() {
        return this.mapView.getLayerNum();
    }

    public LayerCollection getLayers() {
        return this.mapView.getLayers();
    }

    public MapLayer getLayer(int i) {
        return (MapLayer)this.mapView.getLayers().get(i);
    }

    public MapLayer getLayer(String name) {
        return this.mapView.getLayer(name);
    }

    public LegendScheme getLegendScheme() {
        return null;
    }

    public void loadMIProjectFile(String fn, int mfidx) throws SAXException, IOException, ParserConfigurationException {
        File file = new File(fn);
        String userDir = System.getProperty("user.dir");
        System.setProperty("user.dir", file.getParent());
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new File(fn));
        Element root = doc.getDocumentElement();
        Element mapFrames = (Element)root.getElementsByTagName("MapFrames").item(0);
        if (mapFrames == null) {
            this.mapFrame.importProjectXML(root);
        } else {
            NodeList mfNodes = mapFrames.getElementsByTagName("MapFrame");
            Node mfNode = mfNodes.item(mfidx);
            this.mapFrame.importProjectXML((Element)mfNode);
        }
        this.setDrawExtent(this.mapView.getViewExtent());
        this.setExtent(this.mapView.getViewExtent());
        System.setProperty("user.dir", userDir);
    }

    public void loadMIProjectFile(String fn) throws SAXException, IOException, ParserConfigurationException {
        this.loadMIProjectFile(fn, 0);
    }
}

