/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.meteoinfo.data.ArrayMath;
import org.meteoinfo.data.DataTypes;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.mapdata.Field;
import org.meteoinfo.geoprocess.GeoComputation;
import org.meteoinfo.geoprocess.analysis.ResampleMethods;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.global.util.BigDecimalUtil;
import org.meteoinfo.global.util.GlobalUtil;
import org.meteoinfo.io.EndianDataOutputStream;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.ma.ArrayBoolean;
import org.meteoinfo.math.Complex;
import org.meteoinfo.math.ListIndexComparator;
import org.meteoinfo.math.spatial.KDTree;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionUtil;
import org.meteoinfo.projection.Reproject;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.ShapeTypes;
import org.python.core.PyComplex;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.Index2D;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;

public class ArrayUtil {
    public static Array readASCIIFile(String fileName, String delimiter, int headerLines, String dataType, List<Integer> shape, boolean readFirstCol) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        int i;
        BufferedReader sr = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        if (headerLines > 0) {
            for (int i2 = 0; i2 < headerLines; ++i2) {
                sr.readLine();
            }
        }
        DataType dt = DataType.DOUBLE;
        if (dataType != null) {
            if (dataType.contains("%")) {
                dataType = dataType.split("%")[1];
            }
            dt = ArrayUtil.toDataType(dataType);
        }
        int[] ss = new int[shape.size()];
        for (i = 0; i < shape.size(); ++i) {
            ss[i] = shape.get(i);
        }
        Array a = Array.factory((DataType)dt, (int[])ss);
        i = 0;
        String line = sr.readLine();
        int sCol = 0;
        if (!readFirstCol) {
            sCol = 1;
        }
        while (line != null) {
            if ((line = line.trim()).isEmpty()) {
                line = sr.readLine();
                continue;
            }
            String[] dataArray = GlobalUtil.split(line, delimiter);
            for (int j = sCol; j < dataArray.length; ++j) {
                a.setDouble(i, Double.parseDouble(dataArray[j]));
                if ((long)(++i) >= a.getSize()) break;
            }
            if ((long)i >= a.getSize()) break;
            line = sr.readLine();
        }
        sr.close();
        return a;
    }

    public static int numASCIIRow(String fileName) throws FileNotFoundException {
        int lineNumber;
        File f = new File(fileName);
        try (Scanner fileScanner = new Scanner(f);){
            lineNumber = 0;
            while (fileScanner.hasNextLine()) {
                fileScanner.nextLine();
                ++lineNumber;
            }
        }
        return lineNumber;
    }

    public static int numASCIICol(String fileName, String delimiter, int headerLines) throws FileNotFoundException, IOException {
        String[] dataArray;
        try (BufferedReader sr = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));){
            if (headerLines > 0) {
                for (int i = 0; i < headerLines; ++i) {
                    sr.readLine();
                }
            }
            String line = sr.readLine().trim();
            dataArray = GlobalUtil.split(line, delimiter);
        }
        return dataArray.length;
    }

    public static void saveBinFile(String fn, Array a, String byteOrder, boolean append, boolean sequential) {
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(new File(fn), append));){
            EndianDataOutputStream outs = new EndianDataOutputStream(out);
            ByteBuffer bb = a.getDataAsByteBuffer();
            int n = (int)a.getSize();
            ByteOrder bOrder = ByteOrder.LITTLE_ENDIAN;
            if (byteOrder.equalsIgnoreCase("big_endian")) {
                bOrder = ByteOrder.BIG_ENDIAN;
            }
            if (sequential) {
                if (bOrder == ByteOrder.BIG_ENDIAN) {
                    outs.writeIntBE(n * 4);
                } else {
                    outs.writeIntLE(n * 4);
                }
            }
            if (bOrder == ByteOrder.BIG_ENDIAN) {
                outs.write(bb.array());
            } else if (a.getDataType() == DataType.BYTE) {
                outs.write(bb.array());
            } else {
                ByteBuffer nbb = ByteBuffer.allocate(bb.array().length);
                nbb.order(bOrder);
                switch (a.getDataType()) {
                    case INT: {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            nbb.putInt(i * 4, bb.getInt());
                            ++i;
                        }
                        break;
                    }
                    case FLOAT: {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            nbb.putFloat(i * 4, bb.getFloat());
                            ++i;
                        }
                        break;
                    }
                    case DOUBLE: {
                        int i = 0;
                        while ((long)i < a.getSize()) {
                            nbb.putDouble(i * 8, bb.getDouble());
                            ++i;
                        }
                        break;
                    }
                    default: {
                        nbb.put(bb);
                    }
                }
                outs.write(nbb.array());
            }
            if (sequential) {
                if (bOrder == ByteOrder.BIG_ENDIAN) {
                    outs.writeIntBE(n * 4);
                } else {
                    outs.writeIntLE(n * 4);
                }
            }
            outs.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ArrayUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ArrayUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void saveASCIIFile(String fn, Array a, int colNum, String format, String delimiter) throws IOException {
        BufferedWriter sw = new BufferedWriter(new FileWriter(new File(fn)));
        String line = "";
        int j = 0;
        int i = 0;
        while ((long)i < a.getSize()) {
            line = format == null ? line + a.getObject(i).toString() : line + String.format(format, a.getObject(i));
            if (++j < colNum && (long)i < a.getSize() - 1L) {
                line = delimiter == null ? line + " " : line + delimiter;
            } else {
                sw.write(line);
                sw.newLine();
                line = "";
                j = 0;
            }
            ++i;
        }
        sw.flush();
        sw.close();
    }

    public static Array readBinFile(String fn, List<Integer> dims, String dataType, int skip, String byteOrder) {
        DataType dt = DataType.DOUBLE;
        if (dataType != null) {
            if (dataType.contains("%")) {
                dataType = dataType.split("%")[1];
            }
            dt = ArrayUtil.toDataType(dataType);
        }
        DataType ndt = dt;
        if (dt == DataType.BYTE) {
            ndt = DataType.INT;
        }
        ByteOrder bOrder = ByteOrder.LITTLE_ENDIAN;
        if (byteOrder.equalsIgnoreCase("big_endian")) {
            bOrder = ByteOrder.BIG_ENDIAN;
        }
        int[] shape = new int[dims.size()];
        for (int i = 0; i < dims.size(); ++i) {
            shape[i] = dims.get(i);
        }
        Array r = Array.factory((DataType)ndt, (int[])shape);
        IndexIterator iter = r.getIndexIterator();
        try {
            DataInputStream ins = new DataInputStream(new FileInputStream(fn));
            ins.skip(skip);
            int start = 0;
            switch (dt) {
                case BYTE: {
                    byte[] bytes = new byte[(int)r.getSize()];
                    ins.read(bytes);
                    int i = 0;
                    while ((long)i < r.getSize()) {
                        r.setInt(i, DataConvert.byte2Int(bytes[i]));
                        ++i;
                    }
                    break;
                }
                case SHORT: {
                    byte[] bytes = new byte[(int)r.getSize() * 2];
                    byte[] db = new byte[2];
                    ins.read(bytes);
                    while (iter.hasNext()) {
                        System.arraycopy(bytes, start, db, 0, 2);
                        iter.setShortNext(DataConvert.bytes2Short(db, bOrder));
                        start += 2;
                    }
                    break;
                }
                case INT: {
                    byte[] bytes = new byte[(int)r.getSize() * 4];
                    byte[] db = new byte[4];
                    ins.read(bytes);
                    while (iter.hasNext()) {
                        System.arraycopy(bytes, start, db, 0, 4);
                        iter.setIntNext(DataConvert.bytes2Int(db, bOrder));
                        start += 4;
                    }
                    break;
                }
                case FLOAT: {
                    byte[] bytes = new byte[(int)r.getSize() * 4];
                    byte[] db = new byte[4];
                    ins.read(bytes);
                    while (iter.hasNext()) {
                        System.arraycopy(bytes, start, db, 0, 4);
                        iter.setFloatNext(DataConvert.bytes2Float(db, bOrder));
                        start += 4;
                    }
                    break;
                }
                case DOUBLE: {
                    byte[] bytes = new byte[(int)r.getSize() * 8];
                    byte[] db = new byte[8];
                    ins.read(bytes);
                    while (iter.hasNext()) {
                        System.arraycopy(bytes, start, db, 0, 8);
                        iter.setDoubleNext(DataConvert.bytes2Double(db, bOrder));
                        start += 8;
                    }
                    break;
                }
            }
            ins.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ArrayUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ArrayUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return r;
    }

    public static Array factory(DataType dt, int[] shape) {
        Array r = Array.factory((DataType)dt, (int[])shape);
        if (dt == DataType.BOOLEAN) {
            return new ArrayBoolean(r);
        }
        return r;
    }

    public static Array factory(DataType dt, int[] shape, Object storage) {
        Array r = Array.factory((DataType)dt, (int[])shape, (Object)storage);
        if (dt == DataType.BOOLEAN) {
            return new ArrayBoolean(r);
        }
        return r;
    }

    public static Array array(Object data) {
        if (data instanceof Number) {
            DataType dt = ArrayMath.getDataType(data);
            Array a = Array.factory((DataType)dt, (int[])new int[]{1});
            a.setObject(0, data);
            return a;
        }
        if (data instanceof Array) {
            return (Array)data;
        }
        if (data instanceof ArrayList) {
            return ArrayUtil.array((List)data);
        }
        if (data.getClass().isArray()) {
            return Array.factory((Object)data);
        }
        return null;
    }

    public static Array array(ArrayList data) {
        return ArrayUtil.array((List<Object>)data);
    }

    public static Array array(List<Object> data) {
        Object d0 = data.get(0);
        if (d0 instanceof Number) {
            DataType dt = ArrayUtil.objectsToType(data);
            Array a = Array.factory((DataType)dt, (int[])new int[]{data.size()});
            for (int i = 0; i < data.size(); ++i) {
                a.setObject(i, data.get(i));
            }
            return a;
        }
        if (d0 instanceof String) {
            Array a = Array.factory((DataType)DataType.STRING, (int[])new int[]{data.size()});
            for (int i = 0; i < data.size(); ++i) {
                a.setObject(i, data.get(i));
            }
            return a;
        }
        if (d0 instanceof Boolean) {
            ArrayBoolean a = new ArrayBoolean(new int[]{data.size()});
            for (int i = 0; i < data.size(); ++i) {
                a.setObject(i, data.get(i));
            }
            return a;
        }
        if (d0 instanceof PyComplex) {
            Array a = Array.factory((DataType)DataType.OBJECT, (int[])new int[]{data.size()});
            for (int i = 0; i < data.size(); ++i) {
                PyComplex d = (PyComplex)data.get(i);
                a.setObject(i, (Object)new Complex(d.real, d.imag));
            }
            return a;
        }
        if (d0 instanceof List) {
            int ndim = data.size();
            int len = ((List)d0).size();
            DataType dt = ArrayUtil.objectsToType((List)d0);
            Array a = Array.factory((DataType)dt, (int[])new int[]{ndim, len});
            for (int i = 0; i < ndim; ++i) {
                List d = (List)data.get(i);
                for (int j = 0; j < len; ++j) {
                    a.setObject(i * len + j, d.get(j));
                }
            }
            return a;
        }
        Array a = Array.factory((DataType)DataType.OBJECT, (int[])new int[]{data.size()});
        for (int i = 0; i < data.size(); ++i) {
            a.setObject(i, data.get(i));
        }
        return a;
    }

    public static Array arrayRange_bak(Number start, Number stop, Number step) {
        double startv;
        if (stop == null) {
            stop = start;
            start = 0;
        }
        DataType dataType = ArrayUtil.objectsToType(new Object[]{start, stop, step});
        double stopv = stop.doubleValue();
        double stepv = step.doubleValue();
        ArrayList<Double> data = new ArrayList<Double>();
        if (dataType == DataType.FLOAT || dataType == DataType.DOUBLE) {
            while (startv < stopv) {
                data.add(startv);
                startv = BigDecimalUtil.add(startv, stepv);
            }
        } else {
            for (startv = start.doubleValue(); startv < stopv; startv += stepv) {
                data.add(startv);
            }
        }
        int length = data.size();
        Array a = Array.factory((DataType)dataType, (int[])new int[]{length});
        for (int i = 0; i < length; ++i) {
            a.setObject(i, data.get(i));
        }
        return a;
    }

    public static Array arrayRange(Number start, Number stop, Number step) {
        if (stop == null) {
            stop = start;
            start = 0;
        }
        DataType dataType = ArrayUtil.objectsToType(new Object[]{start, stop, step});
        double startv = start.doubleValue();
        double stopv = stop.doubleValue();
        double stepv = step.doubleValue();
        int length = Math.max(0, (int)Math.ceil((stopv - startv) / stepv));
        Array a = Array.factory((DataType)dataType, (int[])new int[]{length});
        if (dataType == DataType.FLOAT || dataType == DataType.DOUBLE) {
            for (int i = 0; i < length; ++i) {
                a.setObject(i, (Object)BigDecimalUtil.add(BigDecimalUtil.mul((double)i, stepv), startv));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                a.setObject(i, (Object)((double)i * stepv + startv));
            }
        }
        return a;
    }

    public static Array arrayRange1(Number start, int length, Number step) {
        DataType dataType = ArrayUtil.objectsToType(new Object[]{start, step});
        double startv = start.doubleValue();
        double stepv = step.doubleValue();
        Array a = Array.factory((DataType)dataType, (int[])new int[]{length});
        if (dataType == DataType.FLOAT || dataType == DataType.DOUBLE) {
            for (int i = 0; i < length; ++i) {
                a.setObject(i, (Object)BigDecimalUtil.add(BigDecimalUtil.mul((double)i, stepv), startv));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                a.setObject(i, (Object)((double)i * stepv + startv));
            }
        }
        return a;
    }

    public static Array lineSpace(Number start, Number stop, int n, boolean endpoint) {
        if (stop == null) {
            stop = start;
            start = 0;
        }
        double startv = start.doubleValue();
        double stopv = stop.doubleValue();
        int div = endpoint ? n - 1 : n;
        double stepv = (stopv - startv) / (double)div;
        Array a = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
        double v = startv;
        for (int i = 0; i < n; ++i) {
            a.setDouble(i, v);
            v += stepv;
        }
        if (endpoint && a.getDouble(n - 1) != stopv) {
            a.setDouble(n - 1, stopv);
        }
        return a;
    }

    public static Array lineSpace_bak(Number start, Number stop, int n, boolean endpoint) {
        if (stop == null) {
            stop = start;
            start = 0;
        }
        double startv = start.doubleValue();
        double stopv = stop.doubleValue();
        double stepv = (stopv - startv) / (double)(n - 1);
        double endv = (double)n * stepv + startv;
        int nn = n;
        if (endpoint) {
            if (endv < stopv) {
                // empty if block
            }
        } else if (endv >= stopv) {
            --nn;
        }
        Array a = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{++nn});
        for (int i = 0; i < nn; ++i) {
            a.setObject(i, (Object)BigDecimalUtil.add(BigDecimalUtil.mul((double)i, stepv), startv));
        }
        return a;
    }

    public static Array zeros(int n) {
        Array a = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{n});
        for (int i = 0; i < n; ++i) {
            a.setFloat(i, 0.0f);
        }
        return a;
    }

    public static Array zeros(List<Integer> shape, String dtype) {
        DataType dt = ArrayUtil.toDataType(dtype);
        return ArrayUtil.zeros(shape, dt);
    }

    public static Array zeros(List<Integer> shape, DataType dtype) {
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        Array a = Array.factory((DataType)dtype, (int[])ashape);
        return a;
    }

    public static Array full(List<Integer> shape, Object fillValue, DataType dtype) {
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        if (dtype == null) {
            dtype = ArrayMath.getDataType(fillValue);
        }
        Array a = Array.factory((DataType)dtype, (int[])ashape);
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setObject(i, fillValue);
            ++i;
        }
        return a;
    }

    public static Array ones(int n) {
        Array a = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{n});
        for (int i = 0; i < n; ++i) {
            a.setFloat(i, 1.0f);
        }
        return a;
    }

    public static Array ones(List<Integer> shape, String dtype) {
        DataType dt = ArrayUtil.toDataType(dtype);
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        Array a = Array.factory((DataType)dt, (int[])ashape);
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setObject(i, (Object)1);
            ++i;
        }
        return a;
    }

    public static Array identity(int n, String dtype) {
        DataType dt = ArrayUtil.toDataType(dtype);
        int[] shape = new int[]{n, n};
        Array a = Array.factory((DataType)dt, (int[])shape);
        IndexIterator index = a.getIndexIterator();
        while (index.hasNext()) {
            index.next();
            int[] current = index.getCurrentCounter();
            if (current[0] == current[1]) {
                index.setObjectCurrent((Object)1);
                continue;
            }
            index.setObjectCurrent((Object)0);
        }
        return a;
    }

    public static Array eye(int n, int m, int k, String dtype) {
        DataType dt = ArrayUtil.toDataType(dtype);
        int[] shape = new int[]{n, m};
        Array a = Array.factory((DataType)dt, (int[])shape);
        IndexIterator index = a.getIndexIterator();
        while (index.hasNext()) {
            index.next();
            int[] current = index.getCurrentCounter();
            int i = current[0];
            int j = current[1] - k;
            if (i == j) {
                index.setObjectCurrent((Object)1);
                continue;
            }
            index.setObjectCurrent((Object)0);
        }
        return a;
    }

    public static Array diag(Array a, int k) {
        if (a.getRank() == 2) {
            int m = a.getShape()[0];
            int n = a.getShape()[1];
            int len = Math.min(m, n) - Math.abs(k);
            Array r = Array.factory((DataType)a.getDataType(), (int[])new int[]{len});
            IndexIterator index = a.getIndexIterator();
            int idx = 0;
            while (index.hasNext()) {
                int j;
                index.next();
                int[] current = index.getCurrentCounter();
                int i = current[0];
                if (i != (j = current[1] - k)) continue;
                r.setObject(idx, index.getObjectCurrent());
                if (++idx != len) continue;
            }
            return r;
        }
        int m = a.getShape()[0];
        Array r = Array.factory((DataType)a.getDataType(), (int[])new int[]{m, m});
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < m; ++j) {
                if (i == j - k) {
                    r.setObject(i * m + j, a.getObject(i));
                    continue;
                }
                r.setObject(i * m + j, (Object)0);
            }
        }
        return r;
    }

    public static Array repeat(Number v, int n) {
        DataType dt = ArrayMath.getDataType(v);
        Array r = Array.factory((DataType)dt, (int[])new int[]{n});
        for (int i = 0; i < n; ++i) {
            r.setObject(i, (Object)v);
        }
        return r;
    }

    public static Array repeat(Array a, List<Integer> repeats) {
        Array r;
        if (repeats.size() == 1) {
            int n = repeats.get(0);
            r = Array.factory((DataType)a.getDataType(), (int[])new int[]{(int)a.getSize() * n});
            int i = 0;
            while ((long)i < a.getSize()) {
                for (int j = 0; j < n; ++j) {
                    r.setObject(i * n + j, a.getObject(i));
                }
                ++i;
            }
        } else {
            int n = 0;
            for (int i = 0; i < repeats.size(); ++i) {
                n += repeats.get(i).intValue();
            }
            r = Array.factory((DataType)a.getDataType(), (int[])new int[]{n});
            int idx = 0;
            int i = 0;
            while ((long)i < a.getSize()) {
                for (int j = 0; j < repeats.get(i); ++j) {
                    r.setObject(idx, a.getObject(i));
                    ++idx;
                }
                ++i;
            }
        }
        return r;
    }

    public static Array repeat(Array a, List<Integer> repeats, int axis) {
        Array r;
        if (repeats.size() == 1) {
            int n = repeats.get(0);
            int[] shape = a.getShape();
            shape[axis] = shape[axis] * n;
            r = Array.factory((DataType)a.getDataType(), (int[])shape);
            Index aindex = a.getIndex();
            Index index = r.getIndex();
            int i = 0;
            while ((long)i < r.getSize()) {
                int[] current = index.getCurrentCounter();
                current[axis] = current[axis] / n;
                aindex.set(current);
                r.setObject(index, a.getObject(aindex));
                index.incr();
                ++i;
            }
        } else {
            int n = 0;
            int[] rsum = new int[repeats.size()];
            for (int i = 0; i < repeats.size(); ++i) {
                rsum[i] = n;
                n += repeats.get(i).intValue();
            }
            int[] shape = a.getShape();
            shape[axis] = n;
            r = Array.factory((DataType)a.getDataType(), (int[])shape);
            Index aindex = a.getIndex();
            Index index = r.getIndex();
            int i = 0;
            while ((long)i < a.getSize()) {
                int[] current = aindex.getCurrentCounter();
                int idx = current[axis];
                for (int j = 0; j < repeats.get(idx); ++j) {
                    current[axis] = rsum[idx] + j;
                    index.set(current);
                    r.setObject(index, a.getObject(aindex));
                }
                aindex.incr();
                ++i;
            }
        }
        return r;
    }

    public static Array tile(Number v, int n) {
        DataType dt = ArrayMath.getDataType(v);
        Array r = Array.factory((DataType)dt, (int[])new int[]{n});
        for (int i = 0; i < n; ++i) {
            r.setObject(i, (Object)v);
        }
        return r;
    }

    public static Array tile(Number v, List<Integer> repeats) {
        int[] shape = new int[repeats.size()];
        for (int i = 0; i < repeats.size(); ++i) {
            shape[i] = repeats.get(i);
        }
        DataType dt = ArrayMath.getDataType(v);
        Array r = Array.factory((DataType)dt, (int[])shape);
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setObject(i, (Object)v);
            ++i;
        }
        return r;
    }

    public static Array tile(Array a, List<Integer> repeats) {
        if (a.getRank() > repeats.size()) {
            int n = a.getRank() - repeats.size();
            for (int i = 0; i < n; ++i) {
                repeats.add(0, 1);
            }
        } else if (a.getRank() < repeats.size()) {
            int[] shape = a.getShape();
            int[] nshape = new int[repeats.size()];
            int n = repeats.size() - shape.length;
            for (int i = 0; i < nshape.length; ++i) {
                nshape[i] = i < n ? 1 : shape[i - n];
            }
            a = a.reshape(nshape);
        }
        int[] ashape = a.getShape();
        int[] shape = a.getShape();
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = shape[i] * repeats.get(i);
        }
        Array r = Array.factory((DataType)a.getDataType(), (int[])shape);
        Index index = r.getIndex();
        Index aindex = a.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = index.getCurrentCounter();
            for (int j = 0; j < repeats.size(); ++j) {
                int idx = current[j];
                current[j] = idx %= ashape[j];
            }
            aindex.set(current);
            r.setObject(index, a.getObject(aindex));
            index.incr();
            ++i;
        }
        return r;
    }

    public static double rand() {
        Random r = new Random();
        return r.nextDouble();
    }

    public static Array rand(int n) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
        Random rd = new Random();
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, rd.nextDouble());
            ++i;
        }
        return r;
    }

    public static Array rand(List<Integer> shape) {
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        Array a = Array.factory((DataType)DataType.DOUBLE, (int[])ashape);
        Random rd = new Random();
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setDouble(i, rd.nextDouble());
            ++i;
        }
        return a;
    }

    private static DataType objectsToType(Object[] objects) {
        if (objects.length == 0) {
            return DataType.INT;
        }
        short sz = -1;
        DataType dataType = DataType.INT;
        for (Object o : objects) {
            DataType _type = ArrayMath.getDataType(o);
            short new_sz = ArrayMath.typeToNBytes(_type);
            if (new_sz <= sz) continue;
            dataType = _type;
        }
        return dataType;
    }

    private static DataType objectsToType(List<Object> objects) {
        if (objects.isEmpty()) {
            return DataType.INT;
        }
        short sz = -1;
        DataType dataType = DataType.INT;
        for (Object o : objects) {
            DataType _type = ArrayMath.getDataType(o);
            short new_sz = ArrayMath.typeToNBytes(_type);
            if (new_sz <= sz) continue;
            dataType = _type;
            sz = new_sz;
        }
        return dataType;
    }

    public static DataType mergeDataType(DataType dt1, DataType dt2) {
        if (dt1 == DataType.OBJECT || dt2 == DataType.OBJECT) {
            return DataType.OBJECT;
        }
        if (dt1 == DataType.STRING || dt2 == DataType.STRING) {
            return DataType.STRING;
        }
        if (dt1 == DataType.DOUBLE || dt2 == DataType.DOUBLE) {
            return DataType.DOUBLE;
        }
        if (dt1 == DataType.FLOAT || dt2 == DataType.FLOAT) {
            return DataType.FLOAT;
        }
        return dt1;
    }

    public static String convertToString(Array a) {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("array(");
        int ndim = a.getRank();
        if (ndim > 1) {
            sbuff.append("[");
        }
        int i = 0;
        int n = 0;
        IndexIterator ii = a.getIndexIterator();
        int shapeIdx = ndim - 1;
        if (shapeIdx < 0) {
            sbuff.append("[");
            sbuff.append(ii.getObjectNext());
            sbuff.append("])");
            return sbuff.toString();
        }
        int len = a.getShape()[shapeIdx];
        while (ii.hasNext()) {
            if (i == 0) {
                if (n > 0) {
                    sbuff.append("\n      ");
                }
                sbuff.append("[");
            }
            Object data = ii.getObjectNext();
            String dstr = data.toString();
            if (a.getDataType() == DataType.BOOLEAN) {
                dstr = GlobalUtil.capitalize(dstr);
            }
            sbuff.append(dstr);
            if (++i == len) {
                sbuff.append("]");
                len = a.getShape()[shapeIdx];
                i = 0;
            } else {
                sbuff.append(", ");
            }
            if (++n <= 200) continue;
            sbuff.append("...]");
            break;
        }
        if (ndim > 1) {
            sbuff.append("]");
        }
        sbuff.append(")");
        return sbuff.toString();
    }

    public static String toString_old(Array a) {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("array(");
        int ndim = a.getRank();
        if (ndim > 1) {
            sbuff.append("[");
        }
        int i = 0;
        int shapeIdx = ndim - 1;
        int len = a.getShape()[shapeIdx];
        IndexIterator ii = a.getIndexIterator();
        while (ii.hasNext()) {
            if (i == 0) {
                sbuff.append("[");
            }
            Object data = ii.getObjectNext();
            sbuff.append(data);
            if (++i == len) {
                sbuff.append("]");
                len = a.getShape()[shapeIdx];
                i = 0;
                continue;
            }
            sbuff.append(", ");
        }
        if (ndim > 1) {
            sbuff.append("]");
        }
        return sbuff.toString();
    }

    public static List<Array> getArraysFromStationData(StationData stdata) {
        int n = stdata.getStNum();
        int[] shape = new int[]{n};
        Array lon = Array.factory((DataType)DataType.FLOAT, (int[])shape);
        Array lat = Array.factory((DataType)DataType.FLOAT, (int[])shape);
        Array value = Array.factory((DataType)DataType.FLOAT, (int[])shape);
        for (int i = 0; i < n; ++i) {
            lon.setFloat(i, (float)stdata.getX(i));
            lat.setFloat(i, (float)stdata.getY(i));
            double v = stdata.getValue(i);
            if (v == stdata.missingValue) {
                v = Double.NaN;
            }
            value.setFloat(i, (float)v);
        }
        ArrayList<Array> r = new ArrayList<Array>();
        r.add(lon);
        r.add(lat);
        r.add(value);
        return r;
    }

    public static String dataTypeString(DataType dt) {
        String str = "string";
        switch (dt) {
            case BYTE: {
                str = "byte";
                break;
            }
            case SHORT: {
                str = "short";
                break;
            }
            case INT: {
                str = "int";
                break;
            }
            case FLOAT: {
                str = "float";
                break;
            }
            case DOUBLE: {
                str = "double";
            }
        }
        return str;
    }

    public static DataType toDataType(String dt) {
        if (dt.contains("%")) {
            dt = dt.split("%")[1];
        }
        switch (dt.toLowerCase()) {
            case "c": 
            case "s": 
            case "string": {
                return DataType.STRING;
            }
            case "b": 
            case "byte": {
                return DataType.BYTE;
            }
            case "short": {
                return DataType.SHORT;
            }
            case "i": 
            case "int": {
                return DataType.INT;
            }
            case "f": 
            case "float": {
                return DataType.FLOAT;
            }
            case "d": 
            case "double": {
                return DataType.DOUBLE;
            }
            case "bool": 
            case "boolean": {
                return DataType.BOOLEAN;
            }
        }
        return DataType.OBJECT;
    }

    public static Array toInteger(Array a) {
        Array r = Array.factory((DataType)DataType.INT, (int[])a.getShape());
        if (a.getDataType().isNumeric()) {
            int i = 0;
            while ((long)i < r.getSize()) {
                r.setInt(i, a.getInt(i));
                ++i;
            }
        } else if (a.getDataType() == DataType.BOOLEAN) {
            int i = 0;
            while ((long)i < r.getSize()) {
                r.setInt(i, a.getBoolean(i) ? 1 : 0);
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < r.getSize()) {
                r.setInt(i, Integer.valueOf(a.getObject(i).toString()).intValue());
                ++i;
            }
        }
        return r;
    }

    public static Array toFloat(Array a) {
        Array r = Array.factory((DataType)DataType.FLOAT, (int[])a.getShape());
        if (a.getDataType().isNumeric()) {
            int i = 0;
            while ((long)i < r.getSize()) {
                r.setFloat(i, a.getFloat(i));
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < r.getSize()) {
                r.setFloat(i, Float.valueOf(a.getObject(i).toString()).floatValue());
                ++i;
            }
        }
        return r;
    }

    public static Array toDouble(Array a) {
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])a.getShape());
        if (a.getDataType().isNumeric()) {
            int i = 0;
            while ((long)i < r.getSize()) {
                r.setDouble(i, a.getDouble(i));
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < r.getSize()) {
                r.setDouble(i, Double.valueOf(a.getObject(i).toString()).doubleValue());
                ++i;
            }
        }
        return r;
    }

    public static Array toBoolean(Array a) {
        ArrayBoolean r = new ArrayBoolean(a.getShape());
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setBoolean(i, a.getDouble(i) != 0.0);
            ++i;
        }
        return r;
    }

    public static Array concatenate(List<Array> arrays, Integer axis) throws InvalidRangeException {
        int ndim = arrays.get(0).getRank();
        if (axis == -1) {
            axis = ndim - 1;
        }
        int len = 0;
        int[] lens = new int[arrays.size()];
        int i = 0;
        ArrayList<Index> indexList = new ArrayList<Index>();
        for (Array a : arrays) {
            lens[i] = len += a.getShape()[axis];
            indexList.add(Index.factory((int[])a.getShape()));
            ++i;
        }
        int[] shape = arrays.get(0).getShape();
        shape[axis.intValue()] = len;
        Array r = Array.factory((DataType)arrays.get(0).getDataType(), (int[])shape);
        IndexIterator ii = r.getIndexIterator();
        int idx = 0;
        while (ii.hasNext()) {
            ii.next();
            int[] current = ii.getCurrentCounter();
            for (i = 0; i < lens.length; ++i) {
                if (current[axis] >= lens[i]) continue;
                idx = i;
                break;
            }
            if (idx > 0) {
                current[axis.intValue()] = current[axis] - lens[idx - 1];
            }
            Index index = (Index)indexList.get(idx);
            index.set(current);
            ii.setObjectCurrent(arrays.get(idx).getObject(index));
        }
        return r;
    }

    public static Array concatenate(Array a, Array b, Integer axis) throws InvalidRangeException {
        int n = a.getRank();
        int[] shape = a.getShape();
        if (axis == -1) {
            axis = n - 1;
        }
        int nn = shape[axis];
        int[] bshape = b.getShape();
        int[] nshape = new int[n];
        for (int i = 0; i < n; ++i) {
            nshape[i] = i == axis ? shape[i] + bshape[i] : shape[i];
        }
        Array r = Array.factory((DataType)a.getDataType(), (int[])nshape);
        Index indexr = r.getIndex();
        Index indexa = a.getIndex();
        Index indexb = b.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            if (current[axis] < nn) {
                indexa.set(current);
                r.setObject(indexr, a.getObject(indexa));
            } else {
                current[axis.intValue()] = current[axis - nn];
                indexb.set(current);
                r.setObject(indexr, b.getObject(indexb));
            }
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static Array sort(Array a, Integer axis) throws InvalidRangeException {
        int n = a.getRank();
        int[] shape = a.getShape();
        if (axis == null) {
            int[] nshape = new int[]{(int)a.getSize()};
            Array r = Array.factory((DataType)a.getDataType(), (int[])nshape);
            ArrayList<Object> tlist = new ArrayList<Object>();
            IndexIterator ii = a.getIndexIterator();
            while (ii.hasNext()) {
                tlist.add(ii.getObjectNext());
            }
            Collections.sort(tlist);
            int i = 0;
            while ((long)i < r.getSize()) {
                r.setObject(i, tlist.get(i));
                ++i;
            }
            return r;
        }
        if (axis == -1) {
            axis = n - 1;
        }
        int nn = shape[axis];
        Array r = Array.factory((DataType)a.getDataType(), (int[])shape);
        Index indexr = r.getIndex();
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (int i = 0; i < n; ++i) {
            if (i == axis) {
                ranges.add(new Range(0, 0, 1));
                continue;
            }
            ranges.add(new Range(0, shape[i] - 1, 1));
        }
        IndexIterator rii = r.sectionNoReduce(ranges).getIndexIterator();
        while (rii.hasNext()) {
            rii.next();
            int[] current = rii.getCurrentCounter();
            ranges = new ArrayList();
            for (int j = 0; j < n; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, shape[j] - 1, 1));
                    continue;
                }
                ranges.add(new Range(current[j], current[j], 1));
            }
            ArrayList<Object> tlist = new ArrayList<Object>();
            IndexIterator ii = a.getRangeIterator(ranges);
            while (ii.hasNext()) {
                tlist.add(ii.getObjectNext());
            }
            Collections.sort(tlist);
            for (int j = 0; j < nn; ++j) {
                indexr.set(current);
                r.setObject(indexr, tlist.get(j));
                current[axis.intValue()] = current[axis] + 1;
            }
        }
        return r;
    }

    public static Array argSort(Array a, Integer axis) throws InvalidRangeException {
        int n = a.getRank();
        int[] shape = a.getShape();
        if (axis == null) {
            int[] nshape = new int[]{(int)a.getSize()};
            Array r = Array.factory((DataType)DataType.INT, (int[])nshape);
            ArrayList<Object> stlist = new ArrayList<Object>();
            IndexIterator ii = a.getIndexIterator();
            while (ii.hasNext()) {
                Object v = ii.getObjectNext();
                stlist.add(v);
            }
            ListIndexComparator comparator = new ListIndexComparator(stlist);
            Integer[] indexes = comparator.createIndexArray();
            Arrays.sort(indexes, comparator);
            int i = 0;
            while ((long)i < r.getSize()) {
                r.setInt(i, indexes[i].intValue());
                ++i;
            }
            return r;
        }
        if (axis == -1) {
            axis = n - 1;
        }
        int nn = shape[axis];
        Array r = Array.factory((DataType)DataType.INT, (int[])shape);
        Index indexr = r.getIndex();
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (int i = 0; i < n; ++i) {
            if (i == axis) {
                ranges.add(new Range(0, 0, 1));
                continue;
            }
            ranges.add(new Range(0, shape[i] - 1, 1));
        }
        IndexIterator rii = r.sectionNoReduce(ranges).getIndexIterator();
        while (rii.hasNext()) {
            rii.next();
            int[] current = rii.getCurrentCounter();
            ranges = new ArrayList();
            for (int j = 0; j < n; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, shape[j] - 1, 1));
                    continue;
                }
                ranges.add(new Range(current[j], current[j], 1));
            }
            ArrayList<Object> stlist = new ArrayList<Object>();
            IndexIterator ii = a.getRangeIterator(ranges);
            while (ii.hasNext()) {
                Object v = ii.getObjectNext();
                stlist.add(v);
            }
            ListIndexComparator comparator = new ListIndexComparator(stlist);
            Integer[] indexes = comparator.createIndexArray();
            Arrays.sort(indexes, comparator);
            for (int j = 0; j < nn; ++j) {
                indexr.set(current);
                r.setObject(indexr, (Object)indexes[j]);
                current[axis.intValue()] = current[axis] + 1;
            }
        }
        return r;
    }

    public static Object copyToNDJavaArray(Array a, String dtype) {
        if (dtype == null) {
            return ArrayUtil.copyToNDJavaArray(a);
        }
        switch (dtype.toLowerCase()) {
            case "double": {
                return ArrayUtil.copyToNDJavaArray_Double(a);
            }
            case "long": {
                return ArrayUtil.copyToNDJavaArray_Long(a);
            }
        }
        return ArrayUtil.copyToNDJavaArray(a);
    }

    public static Object copyToNDJavaArray(Array a) {
        Object javaArray;
        try {
            javaArray = java.lang.reflect.Array.newInstance(Double.TYPE, a.getShape());
        }
        catch (IllegalArgumentException | NegativeArraySizeException e) {
            throw new IllegalArgumentException(e);
        }
        IndexIterator iter = a.getIndexIterator();
        ArrayUtil.reflectArrayCopyOut(javaArray, a, iter);
        return javaArray;
    }

    public static Object copyToNDJavaArray_Long(Array a) {
        Object javaArray;
        try {
            javaArray = java.lang.reflect.Array.newInstance(Long.TYPE, a.getShape());
        }
        catch (IllegalArgumentException | NegativeArraySizeException e) {
            throw new IllegalArgumentException(e);
        }
        IndexIterator iter = a.getIndexIterator();
        ArrayUtil.reflectArrayCopyOut(javaArray, a, iter);
        return javaArray;
    }

    public static Object copyToNDJavaArray_Double(Array a) {
        Object javaArray;
        try {
            javaArray = java.lang.reflect.Array.newInstance(Double.TYPE, a.getShape());
        }
        catch (IllegalArgumentException | NegativeArraySizeException e) {
            throw new IllegalArgumentException(e);
        }
        IndexIterator iter = a.getIndexIterator();
        ArrayUtil.reflectArrayCopyOut(javaArray, a, iter);
        return javaArray;
    }

    private static void reflectArrayCopyOut(Object jArray, Array aa, IndexIterator aaIter) {
        Class<?> cType = jArray.getClass().getComponentType();
        if (!cType.isArray()) {
            if (cType == Long.TYPE) {
                ArrayUtil.copyTo1DJavaArray_Long(aaIter, jArray);
            } else {
                ArrayUtil.copyTo1DJavaArray(aaIter, jArray);
            }
        } else {
            for (int i = 0; i < java.lang.reflect.Array.getLength(jArray); ++i) {
                ArrayUtil.reflectArrayCopyOut(java.lang.reflect.Array.get(jArray, i), aa, aaIter);
            }
        }
    }

    protected static void copyTo1DJavaArray(IndexIterator iter, Object javaArray) {
        double[] ja = (double[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            ja[i] = iter.getDoubleNext();
        }
    }

    protected static void copyTo1DJavaArray_Long(IndexIterator iter, Object javaArray) {
        long[] ja = (long[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            ja[i] = iter.getLongNext();
        }
    }

    public static Array delete(Array a, int idx, int axis) {
        int[] shape = a.getShape();
        int n = shape.length;
        int[] nshape = new int[n];
        for (int i = 0; i < n; ++i) {
            nshape[i] = i == axis ? shape[i] - 1 : shape[i];
        }
        Array r = Array.factory((DataType)a.getDataType(), (int[])nshape);
        IndexIterator ii = a.getIndexIterator();
        int i = 0;
        while (ii.hasNext()) {
            ii.next();
            int[] current = ii.getCurrentCounter();
            if (current[axis] == idx) continue;
            r.setObject(i, ii.getObjectCurrent());
            ++i;
        }
        return r;
    }

    public static Array delete(Array a, List<Integer> idx, int axis) {
        int[] shape = a.getShape();
        int n = shape.length;
        int[] nshape = new int[n];
        for (int i = 0; i < n; ++i) {
            nshape[i] = i == axis ? shape[i] - idx.size() : shape[i];
        }
        Array r = Array.factory((DataType)a.getDataType(), (int[])nshape);
        IndexIterator ii = a.getIndexIterator();
        int i = 0;
        while (ii.hasNext()) {
            ii.next();
            int[] current = ii.getCurrentCounter();
            if (idx.contains(current[axis])) continue;
            r.setObject(i, ii.getObjectCurrent());
            ++i;
        }
        return r;
    }

    public static List<Array> histogram(Array a, int nbins) {
        double min = ArrayMath.getMinimum(a);
        double max = ArrayMath.getMaximum(a);
        double interval = BigDecimalUtil.div(BigDecimalUtil.sub(max, min), nbins);
        double[] bins = new double[nbins + 1];
        for (int i = 0; i < nbins + 1; ++i) {
            bins[i] = min;
            min = BigDecimalUtil.add(min, interval);
        }
        Array ba = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{bins.length}, (Object)bins);
        return ArrayUtil.histogram(a, ba);
    }

    public static List<Array> histogram(Array a, Array bins) {
        int n = (int)bins.getSize();
        Array hist = Array.factory((DataType)DataType.INT, (int[])new int[]{n - 1});
        int i = 0;
        while ((long)i < a.getSize()) {
            double v = a.getDouble(i);
            for (int j = 0; j < n - 1; ++j) {
                if (j == n - 2) {
                    if (!(v >= bins.getDouble(j)) || !(v <= bins.getDouble(j + 1))) continue;
                    hist.setInt(j, hist.getInt(j) + 1);
                    break;
                }
                if (!(v >= bins.getDouble(j)) || !(v < bins.getDouble(j + 1))) continue;
                hist.setInt(j, hist.getInt(j) + 1);
                break;
            }
            ++i;
        }
        ArrayList<Array> r = new ArrayList<Array>();
        r.add(hist);
        r.add(bins);
        return r;
    }

    public static List<Array> histogram(Array a, double[] bins) {
        int n = bins.length;
        double delta = bins[1] - bins[0];
        int[] count = new int[n + 1];
        int i = 0;
        while ((long)i < a.getSize()) {
            double v = a.getDouble(i);
            if (v < bins[0]) {
                count[0] = count[0] + 1;
            } else if (v > bins[n - 1]) {
                int n2 = n;
                count[n2] = count[n2] + 1;
            } else {
                for (int j = 0; j < n - 1; ++j) {
                    if (!(v > bins[j]) || !(v < bins[j + 1])) continue;
                    int n3 = j + 1;
                    count[n3] = count[n3] + 1;
                    break;
                }
            }
            ++i;
        }
        Array x = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{count.length + 1});
        Array y = Array.factory((DataType)DataType.INT, (int[])new int[]{count.length});
        for (int i2 = 0; i2 < count.length; ++i2) {
            y.setInt(i2, count[i2]);
            if (i2 == 0) {
                x.setDouble(0, bins[0] - delta);
                x.setDouble(1, bins[0]);
                continue;
            }
            if (i2 == count.length - 1) {
                x.setDouble(i2 + 1, bins[i2 - 1] + delta);
                continue;
            }
            x.setDouble(i2 + 1, bins[i2]);
        }
        ArrayList<Array> r = new ArrayList<Array>();
        r.add(y);
        r.add(x);
        return r;
    }

    public static Array broadcast(Array a, int[] shape) {
        int i;
        int[] bshape = a.getShape();
        if (bshape.length > shape.length) {
            return null;
        }
        if (bshape.length < shape.length) {
            int miss = shape.length - a.getRank();
            bshape = new int[shape.length];
            for (i = 0; i < shape.length; ++i) {
                bshape[i] = i < miss ? 1 : a.getShape()[i - miss];
            }
            a = a.reshape(bshape);
        }
        boolean pass = true;
        for (i = 0; i < shape.length; ++i) {
            if (shape[i] == bshape[i] || bshape[i] == 1) continue;
            pass = false;
            break;
        }
        if (!pass) {
            return null;
        }
        Index aindex = a.getIndex();
        Array r = Array.factory((DataType)a.getDataType(), (int[])shape);
        Index index = r.getIndex();
        int i2 = 0;
        while ((long)i2 < r.getSize()) {
            int[] current = index.getCurrentCounter();
            for (int j = 0; j < shape.length; ++j) {
                if (bshape[j] == 1) {
                    aindex.setDim(j, 0);
                    continue;
                }
                aindex.setDim(j, current[j]);
            }
            r.setObject(index, a.getObject(aindex));
            index.incr();
            ++i2;
        }
        return r;
    }

    public static Array broadcast(Array a, List<Integer> shape) {
        int[] nshape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            nshape[i] = shape.get(i);
        }
        return ArrayUtil.broadcast(a, nshape);
    }

    public static Array[] meshgrid(Array x, Array y) {
        int xn = (int)x.getSize();
        int yn = (int)y.getSize();
        int[] shape = new int[]{yn, xn};
        Array rx = Array.factory((DataType)x.getDataType(), (int[])shape);
        Array ry = Array.factory((DataType)y.getDataType(), (int[])shape);
        for (int i = 0; i < yn; ++i) {
            for (int j = 0; j < xn; ++j) {
                rx.setObject(i * xn + j, x.getObject(j));
                ry.setObject(i * xn + j, y.getObject(i));
            }
        }
        return new Array[]{rx, ry};
    }

    public static Array[] meshgrid(Array ... xs) {
        Array x;
        int n = xs.length;
        int[] shape = new int[n];
        int i = 0;
        for (i = 0; i < n; ++i) {
            x = xs[i];
            shape[n - i - 1] = (int)x.getSize();
        }
        Array[] rs = new Array[n];
        for (int s = 0; s < n; ++s) {
            x = xs[s];
            Array r = Array.factory((DataType)xs[s].getDataType(), (int[])shape);
            Index index = r.getIndex();
            i = 0;
            while ((long)i < r.getSize()) {
                int idx = index.getCurrentCounter()[n - s - 1];
                r.setObject(index, x.getObject(idx));
                index.incr();
                ++i;
            }
            rs[s] = r;
        }
        return rs;
    }

    public static VectorLayer meshLayer(Array x_s, Array y_s, Array a, LegendScheme ls, double lonlim) {
        VectorLayer layer = new VectorLayer(ShapeTypes.Polygon);
        String fieldName = "Data";
        Field aDC = new Field(fieldName, DataTypes.Double);
        layer.editAddField(aDC);
        int[] shape = x_s.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        for (int i = 0; i < rowNum - 1; ++i) {
            for (int j = 0; j < colNum - 1; ++j) {
                double x1 = x_s.getDouble(i * colNum + j);
                double x2 = x_s.getDouble(i * colNum + j + 1);
                double x3 = x_s.getDouble((i + 1) * colNum + j);
                double x4 = x_s.getDouble((i + 1) * colNum + j + 1);
                if (lonlim > 0.0 && (Math.abs(x2 - x4) > lonlim || Math.abs(x1 - x4) > lonlim || Math.abs(x3 - x4) > lonlim || Math.abs(x1 - x2) > lonlim || Math.abs(x2 - x3) > lonlim)) continue;
                PolygonShape ps = new PolygonShape();
                ArrayList<PointD> points = new ArrayList<PointD>();
                points.add(new PointD(x1, y_s.getDouble(i * colNum + j)));
                points.add(new PointD(x3, y_s.getDouble((i + 1) * colNum + j)));
                points.add(new PointD(x4, y_s.getDouble((i + 1) * colNum + j + 1)));
                points.add(new PointD(x2, y_s.getDouble(i * colNum + j + 1)));
                points.add((PointD)((PointD)points.get(0)).clone());
                ps.setPoints(points);
                ps.highValue = ps.lowValue = a.getDouble(i * colNum + j);
                int shapeNum = layer.getShapeNum();
                try {
                    if (!layer.editInsertShape(ps, shapeNum)) continue;
                    layer.editCellValue(fieldName, shapeNum, (Object)ps.lowValue);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        layer.setLayerName("Mesh_Layer");
        ls.setFieldName(fieldName);
        layer.setLegendScheme(ls.convertTo(ShapeTypes.Polygon));
        return layer;
    }

    public static VectorLayer meshLayer(Array x_s, Array y_s, Array a, LegendScheme ls) {
        VectorLayer layer = new VectorLayer(ShapeTypes.Polygon);
        String fieldName = "Data";
        Field aDC = new Field(fieldName, DataTypes.Double);
        layer.editAddField(aDC);
        int[] shape = x_s.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        for (int i = 0; i < rowNum - 1; ++i) {
            for (int j = 0; j < colNum - 1; ++j) {
                double x1 = x_s.getDouble(i * colNum + j);
                double x2 = x_s.getDouble(i * colNum + j + 1);
                double x3 = x_s.getDouble((i + 1) * colNum + j);
                double x4 = x_s.getDouble((i + 1) * colNum + j + 1);
                PolygonShape ps = new PolygonShape();
                ArrayList<PointD> points = new ArrayList<PointD>();
                points.add(new PointD(x1, y_s.getDouble(i * colNum + j)));
                points.add(new PointD(x3, y_s.getDouble((i + 1) * colNum + j)));
                points.add(new PointD(x4, y_s.getDouble((i + 1) * colNum + j + 1)));
                points.add(new PointD(x2, y_s.getDouble(i * colNum + j + 1)));
                points.add((PointD)((PointD)points.get(0)).clone());
                ps.setPoints(points);
                ps.highValue = ps.lowValue = a.getDouble(i * colNum + j);
                int shapeNum = layer.getShapeNum();
                try {
                    if (!layer.editInsertShape(ps, shapeNum)) continue;
                    layer.editCellValue(fieldName, shapeNum, (Object)ps.lowValue);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        layer.setLayerName("Mesh_Layer");
        ls.setFieldName(fieldName);
        layer.setLegendScheme(ls.convertTo(ShapeTypes.Polygon));
        return layer;
    }

    public static Array smooth5(Array a, int rowNum, int colNum, double unDefData) {
        Array r = Array.factory((DataType)a.getDataType(), (int[])a.getShape());
        double s = 0.5;
        if (Double.isNaN(unDefData)) {
            for (int i = 0; i < rowNum; ++i) {
                for (int j = 0; j < colNum; ++j) {
                    if (i == 0 || i == rowNum - 1 || j == 0 || j == colNum - 1) {
                        r.setDouble(i * colNum + j, a.getDouble(i * colNum + j));
                        continue;
                    }
                    if (Double.isNaN(a.getDouble(i * colNum + j)) || Double.isNaN(a.getDouble((i + 1) * colNum + j)) || Double.isNaN(a.getDouble((i - 1) * colNum + j)) || Double.isNaN(a.getDouble(i * colNum + j + 1)) || Double.isNaN(a.getDouble(i * colNum + j - 1))) {
                        r.setDouble(i * colNum + j, a.getDouble(i * colNum + j));
                        continue;
                    }
                    r.setDouble(i * colNum + j, a.getDouble(i * colNum + j) + s / 4.0 * (a.getDouble((i + 1) * colNum + j) + a.getDouble((i - 1) * colNum + j) + a.getDouble(i * colNum + j + 1) + a.getDouble(i * colNum + j - 1) - 4.0 * a.getDouble(i * colNum + j)));
                }
            }
        } else {
            for (int i = 0; i < rowNum; ++i) {
                for (int j = 0; j < colNum; ++j) {
                    if (i == 0 || i == rowNum - 1 || j == 0 || j == colNum - 1) {
                        r.setDouble(i * colNum + j, a.getDouble(i * colNum + j));
                        continue;
                    }
                    if (a.getDouble(i * colNum + j) == unDefData || a.getDouble((i + 1) * colNum + j) == unDefData || a.getDouble((i - 1) * colNum + j) == unDefData || a.getDouble(i * colNum + j + 1) == unDefData || a.getDouble(i * colNum + j - 1) == unDefData) {
                        r.setDouble(i * colNum + j, a.getDouble(i * colNum + j));
                        continue;
                    }
                    r.setDouble(i * colNum + j, a.getDouble(i * colNum + j) + s / 4.0 * (a.getDouble((i + 1) * colNum + j) + a.getDouble((i - 1) * colNum + j) + a.getDouble(i * colNum + j + 1) + a.getDouble(i * colNum + j - 1) - 4.0 * a.getDouble(i * colNum + j)));
                }
            }
        }
        return r;
    }

    public static Array smooth5(Array a) {
        int[] shape = a.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        Array r = Array.factory((DataType)a.getDataType(), (int[])shape);
        Index2D index = new Index2D(shape);
        for (int i = 0; i < rowNum; ++i) {
            for (int j = 0; j < colNum; ++j) {
                double sum = 0.0;
                double wsum = 0.0;
                for (int ii = i - 1; ii <= i + 1; ++ii) {
                    if (ii < 0 || ii >= rowNum) continue;
                    for (int jj = j - 1; jj <= j + 1; ++jj) {
                        double v;
                        if (jj < 0 || jj >= colNum || (ii == i - 1 || ii == i + 1) && jj != j || Double.isNaN(v = a.getDouble(index.set(ii, jj)))) continue;
                        double w = ii == i && jj == j ? 1.0 : 0.5;
                        sum += v * w;
                        wsum += w;
                    }
                }
                index.set(i, j);
                if (wsum > 0.0) {
                    r.setDouble((Index)index, sum / wsum);
                    continue;
                }
                r.setDouble((Index)index, Double.NaN);
            }
        }
        return r;
    }

    public static Array smooth9(Array a) {
        int[] shape = a.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        Array r = Array.factory((DataType)a.getDataType(), (int[])shape);
        Index2D index = new Index2D(shape);
        for (int i = 0; i < rowNum; ++i) {
            for (int j = 0; j < colNum; ++j) {
                double sum = 0.0;
                double wsum = 0.0;
                for (int ii = i - 1; ii <= i + 1; ++ii) {
                    if (ii < 0 || ii >= rowNum) continue;
                    for (int jj = j - 1; jj <= j + 1; ++jj) {
                        double v;
                        if (jj < 0 || jj >= colNum || Double.isNaN(v = a.getDouble(index.set(ii, jj)))) continue;
                        double w = ii == i && jj == j ? 1.0 : (ii == i || jj == j ? 0.5 : 0.3);
                        sum += v * w;
                        wsum += w;
                    }
                }
                index.set(i, j);
                if (wsum > 0.0) {
                    r.setDouble((Index)index, sum / wsum);
                    continue;
                }
                r.setDouble((Index)index, Double.NaN);
            }
        }
        return r;
    }

    public static Array interpolation_IDW_Radius(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y, int neededPointNum, double radius) {
        int i;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        int n = 0;
        KDTree.Euclidean<Double> kdTree = new KDTree.Euclidean<Double>(2);
        for (i = 0; i < pNum; ++i) {
            if (Double.isNaN(a.getDouble(i))) continue;
            kdTree.addPoint(new double[]{x_s.get(i).doubleValue(), y_s.get(i).doubleValue()}, a.getDouble(i));
            ++n;
        }
        for (i = 0; i < rowNum; ++i) {
            double gy = Y.get(i).doubleValue();
            for (int j = 0; j < colNum; ++j) {
                double gx = X.get(j).doubleValue();
                ArrayList srs = kdTree.ballSearch_distance(new double[]{gx, gy}, radius * radius);
                if (srs == null || srs.size() < neededPointNum) {
                    r.setDouble(i * colNum + j, Double.NaN);
                    continue;
                }
                double v_sum = 0.0;
                double weight_sum = 0.0;
                boolean match = false;
                for (KDTree.SearchResult searchResult : srs) {
                    double v = (Double)searchResult.payload;
                    if (searchResult.distance == 0.0) {
                        r.setDouble(i * colNum + j, v);
                        match = true;
                        break;
                    }
                    double w = 1.0 / searchResult.distance;
                    weight_sum += w;
                    v_sum += v * w;
                }
                if (match) continue;
                r.setDouble(i * colNum + j, v_sum / weight_sum);
            }
        }
        return r;
    }

    public static Array interpolation_IDW_Radius_bak(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y, int NeededPointNum, double radius) {
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        for (int i = 0; i < rowNum; ++i) {
            for (int j = 0; j < colNum; ++j) {
                r.setDouble(i * colNum + j, Double.NaN);
                boolean ifPointGrid = false;
                double SV = 0.0;
                double SW = 0.0;
                int vNum = 0;
                for (int p = 0; p < pNum; ++p) {
                    double v = a.getDouble(p);
                    if (Double.isNaN(v)) continue;
                    double x = x_s.get(p).doubleValue();
                    double y = y_s.get(p).doubleValue();
                    if (x < X.get(j).doubleValue() - radius || x > X.get(j).doubleValue() + radius || y < Y.get(i).doubleValue() - radius || y > Y.get(i).doubleValue() + radius) continue;
                    if (Math.pow(X.get(j).doubleValue() - x, 2.0) + Math.pow(Y.get(i).doubleValue() - y, 2.0) == 0.0) {
                        r.setDouble(i * colNum + j, v);
                        ifPointGrid = true;
                        break;
                    }
                    if (!(Math.sqrt(Math.pow(X.get(j).doubleValue() - x, 2.0) + Math.pow(Y.get(i).doubleValue() - y, 2.0)) <= radius)) continue;
                    double w = 1.0 / (Math.pow(X.get(j).doubleValue() - x, 2.0) + Math.pow(Y.get(i).doubleValue() - y, 2.0));
                    SW += w;
                    SV += v * w;
                    ++vNum;
                }
                if (ifPointGrid || vNum < NeededPointNum) continue;
                r.setDouble(i * colNum + j, SV / SW);
            }
        }
        r = ArrayUtil.smooth5(r, rowNum, colNum, Double.NaN);
        return r;
    }

    public static Array interpolation_IDW_Neighbor(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y, Integer points) {
        int i;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        int n = 0;
        KDTree.Euclidean<Double> kdTree = new KDTree.Euclidean<Double>(2);
        for (i = 0; i < pNum; ++i) {
            if (Double.isNaN(a.getDouble(i))) continue;
            kdTree.addPoint(new double[]{x_s.get(i).doubleValue(), y_s.get(i).doubleValue()}, a.getDouble(i));
            ++n;
        }
        if (points == null) {
            points = n;
        }
        for (i = 0; i < rowNum; ++i) {
            double gy = Y.get(i).doubleValue();
            for (int j = 0; j < colNum; ++j) {
                double gx = X.get(j).doubleValue();
                ArrayList srs = kdTree.nearestNeighbours(new double[]{gx, gy}, points);
                double v_sum = 0.0;
                double weight_sum = 0.0;
                boolean match = false;
                for (KDTree.SearchResult searchResult : srs) {
                    double v = (Double)searchResult.payload;
                    if (searchResult.distance == 0.0) {
                        r.setDouble(i * colNum + j, v);
                        match = true;
                        break;
                    }
                    double w = 1.0 / searchResult.distance;
                    weight_sum += w;
                    v_sum += v * w;
                }
                if (match) continue;
                r.setDouble(i * colNum + j, v_sum / weight_sum);
            }
        }
        return r;
    }

    public static Array interpolation_IDW_Neighbor_bak(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y, int NumberOfNearestNeighbors) {
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        int points = NumberOfNearestNeighbors;
        double[] AllWeights = new double[pNum];
        double[][] NW = new double[2][points];
        for (int i = 0; i < rowNum; ++i) {
            for (int j = 0; j < colNum; ++j) {
                int l;
                double w;
                int p;
                r.setDouble(i * colNum + j, Double.NaN);
                double SV = 0.0;
                double SW = 0.0;
                int NWIdx = 0;
                for (p = 0; p < pNum; ++p) {
                    double v = a.getDouble(p);
                    if (Double.isNaN(v)) {
                        AllWeights[p] = -1.0;
                        continue;
                    }
                    double x = x_s.get(p).doubleValue();
                    double y = y_s.get(p).doubleValue();
                    if (X.get(j).doubleValue() == x && Y.get(i).doubleValue() == y) {
                        r.setDouble(i * colNum + j, v);
                        break;
                    }
                    AllWeights[p] = w = 1.0 / (Math.pow(X.get(j).doubleValue() - x, 2.0) + Math.pow(Y.get(i).doubleValue() - y, 2.0));
                    if (NWIdx < points) {
                        NW[0][NWIdx] = w;
                        NW[1][NWIdx] = p;
                    }
                    ++NWIdx;
                }
                double aMin = NW[0][0];
                int aP = 0;
                for (l = 1; l < points; ++l) {
                    if (!(NW[0][l] < aMin)) continue;
                    aMin = NW[0][l];
                    aP = l;
                }
                if (!Double.isNaN(r.getDouble(i * colNum + j))) continue;
                for (p = 0; p < pNum; ++p) {
                    w = AllWeights[p];
                    if (w == -1.0 || !(w > aMin)) continue;
                    NW[0][aP] = w;
                    NW[1][aP] = p;
                    aMin = NW[0][0];
                    aP = 0;
                    for (l = 1; l < points; ++l) {
                        if (!(NW[0][l] < aMin)) continue;
                        aMin = NW[0][l];
                        aP = l;
                    }
                }
                for (p = 0; p < points; ++p) {
                    SV += NW[0][p] * a.getDouble((int)NW[1][p]);
                    SW += NW[0][p];
                }
                r.setDouble(i * colNum + j, SV / SW);
            }
        }
        r = ArrayUtil.smooth5(r, rowNum, colNum, Double.NaN);
        return r;
    }

    public static Array interpolation_Nearest(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y, double radius) {
        int i;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array rdata = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        KDTree.Euclidean<Double> kdTree = new KDTree.Euclidean<Double>(2);
        for (i = 0; i < pNum; ++i) {
            if (Double.isNaN(a.getDouble(i))) continue;
            kdTree.addPoint(new double[]{x_s.get(i).doubleValue(), y_s.get(i).doubleValue()}, a.getDouble(i));
        }
        if (radius == Double.POSITIVE_INFINITY) {
            for (i = 0; i < rowNum; ++i) {
                double gy = Y.get(i).doubleValue();
                for (int j = 0; j < colNum; ++j) {
                    double gx = X.get(j).doubleValue();
                    KDTree.SearchResult r = kdTree.nearestNeighbours(new double[]{gx, gy}, 1).get(0);
                    rdata.setDouble(i * colNum + j, ((Double)r.payload).doubleValue());
                }
            }
        } else {
            for (i = 0; i < rowNum; ++i) {
                double gy = Y.get(i).doubleValue();
                for (int j = 0; j < colNum; ++j) {
                    double gx = X.get(j).doubleValue();
                    KDTree.SearchResult r = kdTree.nearestNeighbours(new double[]{gx, gy}, 1).get(0);
                    if (Math.sqrt(r.distance) <= radius) {
                        rdata.setDouble(i * colNum + j, ((Double)r.payload).doubleValue());
                        continue;
                    }
                    rdata.setDouble(i * colNum + j, Double.NaN);
                }
            }
        }
        return rdata;
    }

    public static Array[] extendHalfCell(Array x, Array y) {
        double dX = x.getDouble(1) - x.getDouble(0);
        double dY = y.getDouble(1) - y.getDouble(0);
        int nx = (int)x.getSize() + 1;
        int ny = (int)y.getSize() + 1;
        Array rx = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{nx});
        Array ry = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ny});
        int i = 0;
        while ((long)i < rx.getSize()) {
            if ((long)i == rx.getSize() - 1L) {
                rx.setDouble(i, x.getDouble(i - 1) + dX * 0.5);
            } else {
                rx.setDouble(i, x.getDouble(i) - dX * 0.5);
            }
            ++i;
        }
        i = 0;
        while ((long)i < ry.getSize()) {
            if ((long)i == ry.getSize() - 1L) {
                ry.setDouble(i, y.getDouble(i - 1) + dY * 0.5);
            } else {
                ry.setDouble(i, y.getDouble(i) - dY * 0.5);
            }
            ++i;
        }
        return new Array[]{rx, ry};
    }

    public static Array interpolation_Inside(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y) {
        int j;
        int i;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        double dX = X.get(1).doubleValue() - X.get(0).doubleValue();
        double dY = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int[][] pNums = new int[rowNum][colNum];
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
                r.setDouble(i * colNum + j, 0.0);
            }
        }
        for (int p = 0; p < pNum; ++p) {
            double v = a.getDouble(p);
            if (Double.isNaN(v)) continue;
            double x = x_s.get(p).doubleValue();
            double y = y_s.get(p).doubleValue();
            if (x < X.get(0).doubleValue() || x > X.get(colNum - 1).doubleValue() || y < Y.get(0).doubleValue() || y > Y.get(rowNum - 1).doubleValue()) continue;
            j = (int)((x - X.get(0).doubleValue()) / dX);
            int i2 = (int)((y - Y.get(0).doubleValue()) / dY);
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
            r.setDouble(i2 * colNum + j, r.getDouble(i2 * colNum + j) + v);
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                if (pNums[i][j] == 0) {
                    r.setDouble(i * colNum + j, Double.NaN);
                    continue;
                }
                r.setDouble(i * colNum + j, r.getDouble(i * colNum + j) / (double)pNums[i][j]);
            }
        }
        return r;
    }

    public static Array interpolation_Inside(Array x_s, Array y_s, Array a, Array X, Array Y, boolean center) {
        int j;
        int i;
        if (center) {
            Array[] xy = ArrayUtil.extendHalfCell(X, Y);
            X = xy[0];
            Y = xy[1];
        }
        int colNum = (int)X.getSize();
        int rowNum = (int)Y.getSize();
        if (center) {
            // empty if block
        }
        int pNum = (int)x_s.getSize();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{--rowNum, --colNum});
        double dX = X.getDouble(1) - X.getDouble(0);
        double dY = Y.getDouble(1) - Y.getDouble(0);
        int[][] pNums = new int[rowNum][colNum];
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
                r.setDouble(i * colNum + j, 0.0);
            }
        }
        for (int p = 0; p < pNum; ++p) {
            double v = a.getDouble(p);
            if (Double.isNaN(v)) continue;
            double x = x_s.getDouble(p);
            double y = y_s.getDouble(p);
            if (x < X.getDouble(0) || x > X.getDouble(colNum - 1) || y < Y.getDouble(0) || y > Y.getDouble(rowNum - 1)) continue;
            j = (int)((x - X.getDouble(0)) / dX);
            int i2 = (int)((y - Y.getDouble(0)) / dY);
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
            r.setDouble(i2 * colNum + j, r.getDouble(i2 * colNum + j) + v);
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                if (pNums[i][j] == 0) {
                    r.setDouble(i * colNum + j, Double.NaN);
                    continue;
                }
                r.setDouble(i * colNum + j, r.getDouble(i * colNum + j) / (double)pNums[i][j]);
            }
        }
        return r;
    }

    public static Array interpolation_Inside_Max(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y) {
        int j;
        int i;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        double dX = X.get(1).doubleValue() - X.get(0).doubleValue();
        double dY = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int[][] pNums = new int[rowNum][colNum];
        double min = Double.NEGATIVE_INFINITY;
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
                r.setDouble(i * colNum + j, min);
            }
        }
        for (int p = 0; p < pNum; ++p) {
            double v = a.getDouble(p);
            if (Double.isNaN(v)) continue;
            double x = x_s.get(p).doubleValue();
            double y = y_s.get(p).doubleValue();
            if (x < X.get(0).doubleValue() || x > X.get(colNum - 1).doubleValue() || y < Y.get(0).doubleValue() || y > Y.get(rowNum - 1).doubleValue()) continue;
            j = (int)((x - X.get(0).doubleValue()) / dX);
            int i2 = (int)((y - Y.get(0).doubleValue()) / dY);
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
            r.setDouble(i2 * colNum + j, Math.max(r.getDouble(i2 * colNum + j), v));
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                if (pNums[i][j] != 0 && !Double.isInfinite(r.getDouble(i * colNum + j))) continue;
                r.setDouble(i * colNum + j, Double.NaN);
            }
        }
        return r;
    }

    public static Array interpolation_Inside_Min(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y) {
        int j;
        int i;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{rowNum, colNum});
        double dX = X.get(1).doubleValue() - X.get(0).doubleValue();
        double dY = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int[][] pNums = new int[rowNum][colNum];
        double max = Double.MAX_VALUE;
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
                r.setDouble(i * colNum + j, max);
            }
        }
        for (int p = 0; p < pNum; ++p) {
            double v = a.getDouble(p);
            if (Double.isNaN(v)) continue;
            double x = x_s.get(p).doubleValue();
            double y = y_s.get(p).doubleValue();
            if (x < X.get(0).doubleValue() || x > X.get(colNum - 1).doubleValue() || y < Y.get(0).doubleValue() || y > Y.get(rowNum - 1).doubleValue()) continue;
            j = (int)((x - X.get(0).doubleValue()) / dX);
            int i2 = (int)((y - Y.get(0).doubleValue()) / dY);
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
            r.setDouble(i2 * colNum + j, Math.min(r.getDouble(i2 * colNum + j), v));
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                if (pNums[i][j] != 0 && r.getDouble(i * colNum + j) != Double.MAX_VALUE) continue;
                r.setDouble(i * colNum + j, Double.NaN);
            }
        }
        return r;
    }

    public static Object interpolation_Inside_Count(List<Number> x_s, List<Number> y_s, List<Number> X, List<Number> Y, boolean pointDensity) {
        double y;
        double x;
        int j;
        int i;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.INT, (int[])new int[]{rowNum, colNum});
        double dX = X.get(1).doubleValue() - X.get(0).doubleValue();
        double dY = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int[][] pNums = new int[rowNum][colNum];
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
            }
        }
        for (int p = 0; p < pNum; ++p) {
            x = x_s.get(p).doubleValue();
            y = y_s.get(p).doubleValue();
            if (x < X.get(0).doubleValue() || x > X.get(colNum - 1).doubleValue() || y < Y.get(0).doubleValue() || y > Y.get(rowNum - 1).doubleValue()) continue;
            j = (int)((x - X.get(0).doubleValue()) / dX);
            int i2 = (int)((y - Y.get(0).doubleValue()) / dY);
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                r.setInt(i * colNum + j, pNums[i][j]);
            }
        }
        if (pointDensity) {
            Array pds = Array.factory((DataType)DataType.INT, (int[])new int[]{pNum});
            for (int p = 0; p < pNum; ++p) {
                x = x_s.get(p).doubleValue();
                y = y_s.get(p).doubleValue();
                if (x < X.get(0).doubleValue() || x > X.get(colNum - 1).doubleValue() || y < Y.get(0).doubleValue() || y > Y.get(rowNum - 1).doubleValue()) continue;
                int j2 = (int)((x - X.get(0).doubleValue()) / dX);
                int i3 = (int)((y - Y.get(0).doubleValue()) / dY);
                pds.setInt(p, pNums[i3][j2]);
            }
            return new Array[]{r, pds};
        }
        return r;
    }

    private static List<int[]> getPointsIJ(List<Number> x_s, List<Number> y_s, List<Number> X, List<Number> Y) {
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        double dX = X.get(1).doubleValue() - X.get(0).doubleValue();
        double dY = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        ArrayList<int[]> pIndices = new ArrayList<int[]>();
        for (int p = 0; p < pNum; ++p) {
            double x = x_s.get(p).doubleValue();
            double y = y_s.get(p).doubleValue();
            if (x < X.get(0).doubleValue() || x > X.get(colNum - 1).doubleValue() || y < Y.get(0).doubleValue() || y > Y.get(rowNum - 1).doubleValue()) continue;
            int j = (int)((x - X.get(0).doubleValue()) / dX);
            int i = (int)((y - Y.get(0).doubleValue()) / dY);
            pIndices.add(new int[]{i, j});
        }
        return pIndices;
    }

    private static List<Integer> getPointsIdx(List<int[]> pIJ, int ii, int jj, int radius) {
        ArrayList<Integer> pIdx = new ArrayList<Integer>();
        for (int p = 0; p < pIJ.size(); ++p) {
            int[] ij = pIJ.get(p);
            int i = ij[0];
            int j = ij[1];
            if (Math.abs(i - ii) > radius || Math.abs(j - jj) > radius) continue;
            pIdx.add(p);
        }
        return pIdx;
    }

    public static Array interpolation_Surface_1(Array x_s, Array y_s, Array a, Array X, Array Y, double unDefData) {
        PolygonShape ps;
        int j;
        int i;
        int[] shape = x_s.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        int xn = (int)X.getSize();
        int yn = (int)Y.getSize();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{yn, xn});
        PolygonShape[][] polygons = new PolygonShape[rowNum - 1][colNum - 1];
        for (i = 0; i < rowNum - 1; ++i) {
            for (j = 0; j < colNum - 1; ++j) {
                ps = new PolygonShape();
                ArrayList<PointD> points = new ArrayList<PointD>();
                points.add(new PointD(x_s.getDouble(i * colNum + j), y_s.getDouble(i * colNum + j)));
                points.add(new PointD(x_s.getDouble((i + 1) * colNum + j), y_s.getDouble((i + 1) * colNum + j)));
                points.add(new PointD(x_s.getDouble((i + 1) * colNum + j + 1), y_s.getDouble((i + 1) * colNum + j + 1)));
                points.add(new PointD(x_s.getDouble(i * colNum + j + 1), y_s.getDouble(i * colNum + j + 1)));
                points.add((PointD)((PointD)points.get(0)).clone());
                ps.setPoints(points);
                polygons[i][j] = ps;
            }
        }
        for (i = 0; i < yn; ++i) {
            for (j = 0; j < xn; ++j) {
                r.setDouble(i * xn + j, unDefData);
            }
        }
        for (int i2 = 0; i2 < rowNum - 1; ++i2) {
            for (int j2 = 0; j2 < colNum - 1; ++j2) {
                ps = polygons[i2][j2];
                double v = a.getDouble(i2 * colNum + j2);
                for (int ii = 0; ii < yn; ++ii) {
                    double y = Y.getDouble(ii);
                    for (int jj = 0; jj < xn; ++jj) {
                        double x = X.getDouble(jj);
                        if (!Double.isNaN(r.getDouble(ii * xn + jj)) && r.getDouble(ii * xn + jj) != unDefData || !GeoComputation.pointInPolygon(ps, x, y)) continue;
                        r.setDouble(ii * xn + jj, v);
                    }
                }
            }
        }
        return r;
    }

    public static Array interpolation_Surface(Array x_s, Array y_s, Array a, Array X, Array Y) {
        int[] shape = x_s.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        int xn = (int)X.getSize();
        int yn = (int)Y.getSize();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{yn, xn});
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, Double.NaN);
            ++i;
        }
        double dX = X.getDouble(1) - X.getDouble(0);
        double dY = Y.getDouble(1) - Y.getDouble(0);
        for (int i2 = 0; i2 < rowNum - 1; ++i2) {
            for (int j = 0; j < colNum - 1; ++j) {
                double v = a.getDouble(i2 * colNum + j);
                if (Double.isNaN(v)) continue;
                double xll = x_s.getDouble(i2 * colNum + j);
                double xtl = x_s.getDouble((i2 + 1) * colNum + j);
                double xtr = x_s.getDouble((i2 + 1) * colNum + j + 1);
                double xlr = x_s.getDouble(i2 * colNum + j + 1);
                double yll = y_s.getDouble(i2 * colNum + j);
                double ytl = y_s.getDouble((i2 + 1) * colNum + j);
                double ytr = y_s.getDouble((i2 + 1) * colNum + j + 1);
                double ylr = y_s.getDouble(i2 * colNum + j + 1);
                if (Double.isNaN(xll) || Double.isNaN(xtl) || Double.isNaN(xtr) || Double.isNaN(xlr) || Double.isNaN(yll) || Double.isNaN(ytl) || Double.isNaN(ytr) || Double.isNaN(ylr)) continue;
                PolygonShape ps = new PolygonShape();
                ArrayList<PointD> points = new ArrayList<PointD>();
                points.add(new PointD(xll, yll));
                points.add(new PointD(xtl, ytl));
                points.add(new PointD(xtr, ytr));
                points.add(new PointD(xlr, ylr));
                points.add((PointD)((PointD)points.get(0)).clone());
                ps.setPoints(points);
                int minxi = (int)((ps.getExtent().minX - X.getDouble(0)) / dX);
                int maxxi = (int)((ps.getExtent().maxX - X.getDouble(0)) / dX);
                int minyi = (int)((ps.getExtent().minY - Y.getDouble(0)) / dY);
                int maxyi = (int)((ps.getExtent().maxY - Y.getDouble(0)) / dY);
                if (++maxxi < 0 || minxi >= xn || ++maxyi < 0 || minyi >= yn) continue;
                if (minxi < 0) {
                    minxi = 0;
                }
                if (maxxi >= xn) {
                    maxxi = xn - 1;
                }
                if (maxyi >= yn) {
                    maxyi = yn - 1;
                }
                for (int m = minyi; m <= maxyi; ++m) {
                    double y = Y.getDouble(m);
                    for (int n = minxi; n <= maxxi; ++n) {
                        double x = X.getDouble(n);
                        if (!GeoComputation.pointInPolygon(ps, x, y)) continue;
                        r.setDouble(m * xn + n, v);
                    }
                }
            }
        }
        return r;
    }

    public static Array interpolation_Surface_bak(Array x_s, Array y_s, Array a, Array X, Array Y) {
        int j;
        int i;
        int[] shape = x_s.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        int xn = (int)X.getSize();
        int yn = (int)Y.getSize();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{yn, xn});
        PolygonShape[][] polygons = new PolygonShape[rowNum - 1][colNum - 1];
        for (i = 0; i < rowNum - 1; ++i) {
            for (j = 0; j < colNum - 1; ++j) {
                PolygonShape ps = new PolygonShape();
                ArrayList<PointD> points = new ArrayList<PointD>();
                points.add(new PointD(x_s.getDouble(i * colNum + j), y_s.getDouble(i * colNum + j)));
                points.add(new PointD(x_s.getDouble((i + 1) * colNum + j), y_s.getDouble((i + 1) * colNum + j)));
                points.add(new PointD(x_s.getDouble((i + 1) * colNum + j + 1), y_s.getDouble((i + 1) * colNum + j + 1)));
                points.add(new PointD(x_s.getDouble(i * colNum + j + 1), y_s.getDouble(i * colNum + j + 1)));
                points.add((PointD)((PointD)points.get(0)).clone());
                ps.setPoints(points);
                polygons[i][j] = ps;
            }
        }
        for (i = 0; i < yn; ++i) {
            double y = Y.getDouble(i);
            for (j = 0; j < xn; ++j) {
                double x = X.getDouble(j);
                boolean isIn = false;
                for (int ii = 0; ii < rowNum - 1; ++ii) {
                    for (int jj = 0; jj < colNum - 1; ++jj) {
                        if (!GeoComputation.pointInPolygon(polygons[ii][jj], x, y)) continue;
                        r.setDouble(i * xn + j, a.getDouble(ii * colNum + jj));
                        isIn = true;
                        break;
                    }
                    if (isIn) break;
                }
                if (isIn) continue;
                r.setDouble(i * xn + j, Double.NaN);
            }
        }
        return r;
    }

    public static Array cressman(List<Number> x_s, List<Number> y_s, Array v_s, List<Number> X, List<Number> Y, List<Number> radList) {
        double syi;
        double sxi;
        double sy;
        double sx;
        double val;
        double sum;
        int j;
        double y;
        double x;
        int i;
        int xNum = X.size();
        int yNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{yNum, xNum});
        int irad = radList.size();
        double xMin = X.get(0).doubleValue();
        double xMax = X.get(xNum - 1).doubleValue();
        double yMin = Y.get(0).doubleValue();
        double yMax = Y.get(yNum - 1).doubleValue();
        double xDelt = X.get(1).doubleValue() - X.get(0).doubleValue();
        double yDelt = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int stNum = 0;
        double[][] stationData = new double[pNum][3];
        for (i = 0; i < pNum; ++i) {
            x = x_s.get(i).doubleValue();
            y = y_s.get(i).doubleValue();
            stationData[i][0] = (x - xMin) / xDelt;
            stationData[i][1] = (y - yMin) / yDelt;
            stationData[i][2] = v_s.getDouble(i);
            if (Double.isNaN(stationData[i][2])) continue;
            ++stNum;
        }
        double HITOP = -9.999E20;
        double HIBOT = 9.999E20;
        double[][] TOP = new double[yNum][xNum];
        double[][] BOT = new double[yNum][xNum];
        for (i = 0; i < yNum; ++i) {
            for (j = 0; j < xNum; ++j) {
                TOP[i][j] = HITOP;
                BOT[i][j] = HIBOT;
            }
        }
        double rad = radList.size() > 0 ? radList.get(0).doubleValue() : 4.0;
        for (i = 0; i < yNum; ++i) {
            y = Y.get(i).doubleValue();
            yMin = y - rad;
            yMax = y + rad;
            for (j = 0; j < xNum; ++j) {
                x = X.get(j).doubleValue();
                xMin = x - rad;
                xMax = x + rad;
                stNum = 0;
                sum = 0.0;
                for (int s = 0; s < pNum; ++s) {
                    double dis;
                    val = stationData[s][2];
                    sx = x_s.get(s).doubleValue();
                    sy = y_s.get(s).doubleValue();
                    sxi = stationData[s][0];
                    syi = stationData[s][1];
                    if (Double.isNaN(val) || sx < xMin || sx > xMax || sy < yMin || sy > yMax || (dis = Math.sqrt(Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0))) > rad) continue;
                    sum += val;
                    ++stNum;
                    if (TOP[i][j] < val) {
                        TOP[i][j] = val;
                    }
                    if (!(BOT[i][j] > val)) continue;
                    BOT[i][j] = val;
                }
                if (stNum == 0) {
                    r.setDouble(i * xNum + j, Double.NaN);
                    continue;
                }
                r.setDouble(i * xNum + j, sum / (double)stNum);
            }
        }
        for (int p = 0; p < irad; ++p) {
            rad = radList.get(p).doubleValue();
            for (i = 0; i < yNum; ++i) {
                y = Y.get(i).doubleValue();
                yMin = y - rad;
                yMax = y + rad;
                for (j = 0; j < xNum; ++j) {
                    if (Double.isNaN(r.getDouble(i * xNum + j))) continue;
                    x = X.get(j).doubleValue();
                    xMin = x - rad;
                    xMax = x + rad;
                    sum = 0.0;
                    double wSum = 0.0;
                    for (int s = 0; s < pNum; ++s) {
                        double calVal;
                        double dis;
                        val = stationData[s][2];
                        sx = x_s.get(s).doubleValue();
                        sy = y_s.get(s).doubleValue();
                        sxi = stationData[s][0];
                        syi = stationData[s][1];
                        if (Double.isNaN(val) || sx < xMin || sx > xMax || sy < yMin || sy > yMax || (dis = Math.sqrt(Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0))) > rad) continue;
                        int i1 = (int)syi;
                        int j1 = (int)sxi;
                        int i2 = i1 + 1;
                        int j2 = j1 + 1;
                        double a = r.getDouble(i1 * xNum + j1);
                        double b = r.getDouble(i1 * xNum + j2);
                        double c = r.getDouble(i2 * xNum + j1);
                        double d = r.getDouble(i2 * xNum + j2);
                        ArrayList<Double> dList = new ArrayList<Double>();
                        if (!Double.isNaN(a)) {
                            dList.add(a);
                        }
                        if (!Double.isNaN(b)) {
                            dList.add(b);
                        }
                        if (!Double.isNaN(c)) {
                            dList.add(c);
                        }
                        if (Double.isNaN(d)) {
                            dList.add(d);
                        }
                        if (dList.isEmpty()) continue;
                        if (dList.size() == 1) {
                            calVal = (Double)dList.get(0);
                        } else if (dList.size() <= 3) {
                            double aSum = 0.0;
                            Iterator iterator = dList.iterator();
                            while (iterator.hasNext()) {
                                double dd = (Double)iterator.next();
                                aSum += dd;
                            }
                            calVal = aSum / (double)dList.size();
                        } else {
                            double x1val = a + (c - a) * (syi - (double)i1);
                            double x2val = b + (d - b) * (syi - (double)i1);
                            calVal = x1val + (x2val - x1val) * (sxi - (double)j1);
                        }
                        double eVal = val - calVal;
                        double w = (rad * rad - dis * dis) / (rad * rad + dis * dis);
                        sum += eVal * w;
                        wSum += w;
                    }
                    if (!(wSum >= 1.0E-6)) continue;
                    double aData = r.getDouble(i * xNum + j) + sum / wSum;
                    r.setDouble(i * xNum + j, Math.max(BOT[i][j], Math.min(TOP[i][j], aData)));
                }
            }
        }
        return r;
    }

    public static Array cressman_bak(List<Number> x_s, List<Number> y_s, Array v_s, List<Number> X, List<Number> Y, List<Number> radList) {
        double sum;
        double xMax;
        double yMax;
        int j;
        double y;
        double x;
        int i;
        int xNum = X.size();
        int yNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{yNum, xNum});
        int irad = radList.size();
        double xMin = X.get(0).doubleValue();
        double yMin = Y.get(0).doubleValue();
        double xDelt = X.get(1).doubleValue() - X.get(0).doubleValue();
        double yDelt = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int stNum = 0;
        double[][] stationData = new double[pNum][3];
        for (i = 0; i < pNum; ++i) {
            x = x_s.get(i).doubleValue();
            y = y_s.get(i).doubleValue();
            stationData[i][0] = (x - xMin) / xDelt;
            stationData[i][1] = (y - yMin) / yDelt;
            stationData[i][2] = v_s.getDouble(i);
            if (Double.isNaN(stationData[i][2])) continue;
            ++stNum;
        }
        double HITOP = -9.999E20;
        double HIBOT = 9.999E20;
        double[][] TOP = new double[yNum][xNum];
        double[][] BOT = new double[yNum][xNum];
        for (i = 0; i < yNum; ++i) {
            for (j = 0; j < xNum; ++j) {
                TOP[i][j] = HITOP;
                BOT[i][j] = HIBOT;
            }
        }
        double rad = radList.size() > 0 ? radList.get(0).doubleValue() : 4.0;
        for (i = 0; i < yNum; ++i) {
            y = i;
            yMin = y - rad;
            yMax = y + rad;
            for (j = 0; j < xNum; ++j) {
                x = j;
                xMin = x - rad;
                xMax = x + rad;
                stNum = 0;
                sum = 0.0;
                for (int s = 0; s < pNum; ++s) {
                    double dis;
                    double val = stationData[s][2];
                    double sx = stationData[s][0];
                    double sy = stationData[s][1];
                    if (sx < 0.0 || sx >= (double)(xNum - 1) || sy < 0.0 || sy >= (double)(yNum - 1) || Double.isNaN(val) || sx < xMin || sx > xMax || sy < yMin || sy > yMax || (dis = Math.sqrt(Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0))) > rad) continue;
                    sum += val;
                    ++stNum;
                    if (TOP[i][j] < val) {
                        TOP[i][j] = val;
                    }
                    if (!(BOT[i][j] > val)) continue;
                    BOT[i][j] = val;
                }
                if (stNum == 0) {
                    r.setDouble(i * xNum + j, Double.NaN);
                    continue;
                }
                r.setDouble(i * xNum + j, sum / (double)stNum);
            }
        }
        for (int p = 0; p < irad; ++p) {
            rad = radList.get(p).doubleValue();
            for (i = 0; i < yNum; ++i) {
                y = i;
                yMin = y - rad;
                yMax = y + rad;
                for (j = 0; j < xNum; ++j) {
                    if (Double.isNaN(r.getDouble(i * xNum + j))) continue;
                    x = j;
                    xMin = x - rad;
                    xMax = x + rad;
                    sum = 0.0;
                    double wSum = 0.0;
                    for (int s = 0; s < pNum; ++s) {
                        double calVal;
                        double dis;
                        double val = stationData[s][2];
                        double sx = stationData[s][0];
                        double sy = stationData[s][1];
                        if (sx < 0.0 || sx >= (double)(xNum - 1) || sy < 0.0 || sy >= (double)(yNum - 1) || Double.isNaN(val) || sx < xMin || sx > xMax || sy < yMin || sy > yMax || (dis = Math.sqrt(Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0))) > rad) continue;
                        int i1 = (int)sy;
                        int j1 = (int)sx;
                        int i2 = i1 + 1;
                        int j2 = j1 + 1;
                        double a = r.getDouble(i1 * xNum + j1);
                        double b = r.getDouble(i1 * xNum + j2);
                        double c = r.getDouble(i2 * xNum + j1);
                        double d = r.getDouble(i2 * xNum + j2);
                        ArrayList<Double> dList = new ArrayList<Double>();
                        if (!Double.isNaN(a)) {
                            dList.add(a);
                        }
                        if (!Double.isNaN(b)) {
                            dList.add(b);
                        }
                        if (!Double.isNaN(c)) {
                            dList.add(c);
                        }
                        if (Double.isNaN(d)) {
                            dList.add(d);
                        }
                        if (dList.isEmpty()) continue;
                        if (dList.size() == 1) {
                            calVal = (Double)dList.get(0);
                        } else if (dList.size() <= 3) {
                            double aSum = 0.0;
                            Iterator iterator = dList.iterator();
                            while (iterator.hasNext()) {
                                double dd = (Double)iterator.next();
                                aSum += dd;
                            }
                            calVal = aSum / (double)dList.size();
                        } else {
                            double x1val = a + (c - a) * (sy - (double)i1);
                            double x2val = b + (d - b) * (sy - (double)i1);
                            calVal = x1val + (x2val - x1val) * (sx - (double)j1);
                        }
                        double eVal = val - calVal;
                        double w = (rad * rad - dis * dis) / (rad * rad + dis * dis);
                        sum += eVal * w;
                        wSum += w;
                    }
                    if (wSum < 1.0E-6) {
                        r.setDouble(i * xNum + j, Double.NaN);
                        continue;
                    }
                    double aData = r.getDouble(i * xNum + j) + sum / wSum;
                    r.setDouble(i * xNum + j, Math.max(BOT[i][j], Math.min(TOP[i][j], aData)));
                }
            }
        }
        return r;
    }

    public static Array linint2(Array a, Array X, Array Y, Array newX, Array newY) {
        int xn = (int)newX.getSize();
        int yn = (int)newY.getSize();
        int[] shape = a.getShape();
        int n = shape.length;
        shape[n - 1] = xn;
        shape[n - 2] = yn;
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])shape);
        Index index = r.getIndex();
        int k = 0;
        while ((long)k < r.getSize()) {
            int[] counter = index.getCurrentCounter();
            int yi = counter[n - 2];
            int xi = counter[n - 1];
            double y = newY.getDouble(yi);
            double x = newX.getDouble(xi);
            double v = ArrayUtil.bilinear(a, index, X, Y, x, y);
            r.setDouble(index, v);
            index.incr();
            ++k;
        }
        return r;
    }

    public static Array resample_Bilinear(Array a, List<Number> X, List<Number> Y, List<Number> newX, List<Number> newY) {
        int xn = newX.size();
        int yn = newY.size();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{yn, xn});
        for (int i = 0; i < yn; ++i) {
            double y = newY.get(i).doubleValue();
            for (int j = 0; j < xn; ++j) {
                double x = newX.get(j).doubleValue();
                if (x < X.get(0).doubleValue() || x > X.get(X.size() - 1).doubleValue()) {
                    r.setDouble(i * xn + j, Double.NaN);
                    continue;
                }
                if (y < Y.get(0).doubleValue() || y > Y.get(Y.size() - 1).doubleValue()) {
                    r.setDouble(i * xn + j, Double.NaN);
                    continue;
                }
                double v = ArrayUtil.toStation(a, X, Y, x, y);
                r.setDouble(i * xn + j, v);
            }
        }
        return r;
    }

    public static Array resample_Bilinear(Array a, Array X, Array Y, Array newX, Array newY) {
        int n = (int)newX.getSize();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])newX.getShape());
        for (int i = 0; i < n; ++i) {
            double x = newX.getDouble(i);
            double y = newY.getDouble(i);
            if (x < X.getDouble(0) || x > X.getDouble((int)X.getSize() - 1)) {
                r.setDouble(i, Double.NaN);
                continue;
            }
            if (y < Y.getDouble(0) || y > Y.getDouble((int)Y.getSize() - 1)) {
                r.setDouble(i, Double.NaN);
                continue;
            }
            double v = ArrayUtil.toStation(a, X, Y, x, y);
            r.setDouble(i, v);
        }
        return r;
    }

    public static Array resample_Neighbor(Array a, Array X, Array Y, Array newX, Array newY) {
        int n = (int)newX.getSize();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])newX.getShape());
        for (int i = 0; i < n; ++i) {
            double x = newX.getDouble(i);
            double y = newY.getDouble(i);
            if (x < X.getDouble(0) || x > X.getDouble((int)X.getSize() - 1)) {
                r.setDouble(i, Double.NaN);
                continue;
            }
            if (y < Y.getDouble(0) || y > Y.getDouble((int)Y.getSize() - 1)) {
                r.setDouble(i, Double.NaN);
                continue;
            }
            double v = ArrayUtil.toStation_Neighbor(a, X, Y, x, y);
            r.setDouble(i, v);
        }
        return r;
    }

    public Array interpolate(Array a, List<Number> X, List<Number> Y) {
        int i;
        int nxNum = X.size() * 2 - 1;
        int nyNum = Y.size() * 2 - 1;
        ArrayList<Number> newX = new ArrayList<Number>();
        ArrayList<Number> newY = new ArrayList<Number>();
        for (i = 0; i < nxNum; ++i) {
            if (i % 2 == 0) {
                newX.add(X.get(i / 2).doubleValue());
                continue;
            }
            newX.add((X.get((i - 1) / 2).doubleValue() + X.get((i - 1) / 2 + 1).doubleValue()) / 2.0);
        }
        for (i = 0; i < nyNum; ++i) {
            if (i % 2 == 0) {
                newY.add(Y.get(i / 2).doubleValue());
                continue;
            }
            newY.add((Y.get((i - 1) / 2).doubleValue() + Y.get((i - 1) / 2 + 1).doubleValue()) / 2.0);
        }
        return ArrayUtil.resample_Bilinear(a, X, Y, newX, newY);
    }

    public static double interpn_s(List<List<Number>> points, Array values, List<Number> xi) {
        Object[] r = ArrayUtil.findIndices(points, xi);
        boolean outBounds = (Boolean)r[2];
        if (outBounds) {
            return Double.NaN;
        }
        Index index = values.getIndex();
        int[] indices = (int[])r[0];
        double[] distances = (double[])r[1];
        double v = 0.0;
        ArrayList<Index> ii = new ArrayList<Index>();
        ArrayUtil.iterIndex(ii, index, indices, 0);
        int n = indices.length;
        for (Index idx : ii) {
            double weight = 1.0;
            for (int i = 0; i < n; ++i) {
                weight *= idx.getCurrentCounter()[i] == indices[i] ? 1.0 - distances[i] : distances[i];
            }
            v += values.getDouble(idx) * weight;
        }
        return v;
    }

    public static double interpn_s(List<Array> points, Array values, Array xi) {
        Object[] r = ArrayUtil.findIndices(points, xi);
        boolean outBounds = (Boolean)r[2];
        if (outBounds) {
            return Double.NaN;
        }
        Index index = values.getIndex();
        int[] indices = (int[])r[0];
        double[] distances = (double[])r[1];
        double v = 0.0;
        ArrayList<Index> ii = new ArrayList<Index>();
        ArrayUtil.iterIndex(ii, index, indices, 0);
        int n = indices.length;
        for (Index idx : ii) {
            double weight = 1.0;
            for (int i = 0; i < n; ++i) {
                weight *= idx.getCurrentCounter()[i] == indices[i] ? 1.0 - distances[i] : distances[i];
            }
            v += values.getDouble(idx) * weight;
        }
        return v;
    }

    public static Array interpn(List<Array> points, Array values, List<Array> xi) {
        int n = xi.size();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
        for (int i = 0; i < n; ++i) {
            Array x = xi.get(i);
            r.setDouble(i, ArrayUtil.interpn_s(points, values, x));
        }
        return r;
    }

    public static Object interpn(List<Array> points, Array values, Array xi) throws InvalidRangeException {
        if (xi.getRank() == 1) {
            return ArrayUtil.interpn_s(points, values, xi);
        }
        int n = xi.getShape()[0];
        int m = xi.getShape()[1];
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
        for (int i = 0; i < n; ++i) {
            Array x = xi.section(new int[]{i, 0}, new int[]{1, m});
            r.setDouble(i, ArrayUtil.interpn_s(points, values, x));
        }
        return r;
    }

    private static void iterIndex(List<Index> ii, Index index, int[] indices, int idx) {
        int n = indices.length;
        if (idx < n - 1) {
            index.setDim(idx, indices[idx]);
            ArrayUtil.iterIndex(ii, index, indices, idx + 1);
            index.setDim(idx, indices[idx] + 1);
            ArrayUtil.iterIndex(ii, index, indices, idx + 1);
        } else {
            index.setDim(idx, indices[idx]);
            ii.add((Index)index.clone());
            index.setDim(idx, indices[idx] + 1);
            ii.add((Index)index.clone());
        }
    }

    public static Object[] findIndices(List<List<Number>> points, List<Number> xi) {
        int n = points.size();
        int[] indices = new int[n];
        double[] distances = new double[n];
        boolean outBounds = false;
        for (int i = 0; i < n; ++i) {
            double x = xi.get(i).doubleValue();
            List<Number> a = points.get(i);
            int idx = ArrayUtil.searchSorted(a, x);
            if (idx < 0) {
                outBounds = true;
                idx = 0;
            }
            indices[i] = idx;
            distances[i] = (x - a.get(idx).doubleValue()) / (a.get(idx + 1).doubleValue() - a.get(idx).doubleValue());
        }
        return new Object[]{indices, distances, outBounds};
    }

    public static Object[] findIndices(List<Array> points, Array xi) {
        int n = points.size();
        int[] indices = new int[n];
        double[] distances = new double[n];
        boolean outBounds = false;
        for (int i = 0; i < n; ++i) {
            double x = xi.getDouble(i);
            Array a = points.get(i);
            int idx = ArrayUtil.searchSorted(a, x);
            if (idx < 0) {
                outBounds = true;
                idx = 0;
            }
            indices[i] = idx;
            distances[i] = (x - a.getDouble(idx)) / (a.getDouble(idx + 1) - a.getDouble(idx));
        }
        return new Object[]{indices, distances, outBounds};
    }

    public static int searchSorted(List<Number> a, double v) {
        int idx = -1;
        int n = a.size();
        if (a.get(1).doubleValue() > a.get(0).doubleValue()) {
            if (v < a.get(0).doubleValue()) {
                return idx;
            }
            if (v > a.get(n - 1).doubleValue()) {
                return idx;
            }
            for (int i = 1; i < n; ++i) {
                if (!(v < a.get(i).doubleValue())) continue;
                idx = i - 1;
                break;
            }
        } else {
            if (v > a.get(0).doubleValue()) {
                return idx;
            }
            if (v < a.get(n - 1).doubleValue()) {
                return idx;
            }
            for (int i = 1; i < n; ++i) {
                if (!(v > a.get(i).doubleValue())) continue;
                idx = i - 1;
                break;
            }
        }
        return idx;
    }

    public static int searchSorted(Array a, double v) {
        int idx = -1;
        int n = (int)a.getSize();
        if (a.getDouble(1) > a.getDouble(0)) {
            if (v < a.getDouble(0)) {
                return idx;
            }
            if (v > a.getDouble(n - 1)) {
                return idx;
            }
            for (int i = 1; i < n; ++i) {
                if (!(v < a.getDouble(i))) continue;
                idx = i - 1;
                break;
            }
        } else {
            if (v > a.getDouble(0)) {
                return idx;
            }
            if (v < a.getDouble(n - 1)) {
                return idx;
            }
            for (int i = 1; i < n; ++i) {
                if (!(v > a.getDouble(i))) continue;
                idx = i - 1;
                break;
            }
        }
        return idx;
    }

    public static Array interpolate_1d(double x, Array xp, Array a, int axis) throws InvalidRangeException {
        int[] dataShape = xp.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            if (i < axis) {
                shape[i] = dataShape[i];
                continue;
            }
            if (i <= axis) continue;
            shape[i - 1] = dataShape[i];
        }
        Array r = Array.factory((DataType)a.getDataType(), (int[])shape);
        Index indexr = r.getIndex();
        Index indexa = a.getIndex();
        int[] dcurrent = new int[dataShape.length];
        int i = 0;
        while ((long)i < r.getSize()) {
            int idx;
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
                dcurrent[j] = current[idx];
            }
            Array tArray = ArrayMath.section(xp, ranges);
            idx = ArrayUtil.searchSorted(tArray, x);
            if (idx < 0) {
                r.setDouble(i, Double.NaN);
            } else if (idx == dataShape[axis] - 1) {
                dcurrent[axis] = idx;
                r.setObject(i, a.getObject(indexa.set(dcurrent)));
            } else {
                dcurrent[axis] = idx;
                indexa.set(dcurrent);
                double belowp = xp.getDouble(indexa);
                double belowa = a.getDouble(indexa);
                dcurrent[axis] = idx + 1;
                indexa.set(dcurrent);
                double abovep = xp.getDouble(indexa);
                double abovea = a.getDouble(indexa);
                r.setDouble(i, (x - belowp) / (abovep - belowp) * (abovea - belowa) + belowa);
            }
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static Array interpolate_1d(Array xa, Array xp, Array a, int axis) throws InvalidRangeException {
        int[] dataShape = xp.getShape();
        int[] shape = new int[dataShape.length];
        int[] tshape = new int[shape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            if (i == axis) {
                shape[i] = xa.getShape()[0];
                continue;
            }
            shape[i] = dataShape[i];
            if (i < axis) {
                tshape[i] = dataShape[i];
                continue;
            }
            tshape[i - 1] = dataShape[i];
        }
        Array r = Array.factory((DataType)a.getDataType(), (int[])shape);
        Array rr = Array.factory((DataType)DataType.BYTE, (int[])tshape);
        Index indexrr = rr.getIndex();
        Index indexr = r.getIndex();
        Index indexa = a.getIndex();
        int[] currenta = new int[dataShape.length];
        int[] currentr = new int[shape.length];
        int i = 0;
        while ((long)i < rr.getSize()) {
            int idx;
            int j;
            int[] currentrr = indexrr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(currentrr[idx], currentrr[idx], 1));
                currenta[j] = currentrr[idx];
                currentr[j] = currentrr[idx];
            }
            Array tArray = ArrayMath.section(xp, ranges);
            j = 0;
            while ((long)j < xa.getSize()) {
                double x = xa.getDouble(j);
                idx = ArrayUtil.searchSorted(tArray, x);
                currentr[axis] = j;
                indexr.set(currentr);
                if (idx < 0) {
                    r.setDouble(indexr, Double.NaN);
                } else if (idx == dataShape[axis] - 1) {
                    currenta[axis] = idx;
                    r.setObject(indexr, a.getObject(indexa.set(currenta)));
                } else {
                    currenta[axis] = idx;
                    indexa.set(currenta);
                    double belowp = xp.getDouble(indexa);
                    double belowa = a.getDouble(indexa);
                    currenta[axis] = idx + 1;
                    indexa.set(currenta);
                    double abovep = xp.getDouble(indexa);
                    double abovea = a.getDouble(indexa);
                    r.setDouble(indexr, (x - belowp) / (abovep - belowp) * (abovea - belowa) + belowa);
                }
                ++j;
            }
            indexrr.incr();
            ++i;
        }
        return r;
    }

    public static Array[] reproject(Array x, Array y, ProjectionInfo toProj) {
        ProjectionInfo fromProj = KnownCoordinateSystems.geographic.world.WGS1984;
        return ArrayUtil.reproject(x, y, fromProj, toProj);
    }

    public static Array[] reproject(Array x, Array y, ProjectionInfo fromProj, ProjectionInfo toProj) {
        int i;
        Array rx = Array.factory((DataType)DataType.DOUBLE, (int[])x.getShape());
        Array ry = Array.factory((DataType)DataType.DOUBLE, (int[])x.getShape());
        int n = (int)x.getSize();
        double[][] points = new double[n][];
        for (i = 0; i < n; ++i) {
            points[i] = new double[]{x.getDouble(i), y.getDouble(i)};
        }
        Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
        for (i = 0; i < n; ++i) {
            rx.setDouble(i, points[i][0]);
            ry.setDouble(i, points[i][1]);
        }
        return new Array[]{rx, ry};
    }

    public static double toStation(Array data, List<Number> xArray, List<Number> yArray, double x, double y, double missingValue) {
        int i;
        double iValue = Double.NaN;
        int nx = xArray.size();
        int ny = yArray.size();
        if (x < xArray.get(0).doubleValue() || x > xArray.get(nx - 1).doubleValue() || y < yArray.get(0).doubleValue() || y > yArray.get(ny - 1).doubleValue()) {
            return iValue;
        }
        int xIdx = 0;
        int yIdx = 0;
        boolean isIn = false;
        for (i = 1; i < nx; ++i) {
            if (!(x < xArray.get(i).doubleValue())) continue;
            xIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            xIdx = nx - 2;
        }
        isIn = false;
        for (i = 1; i < ny; ++i) {
            if (!(y < yArray.get(i).doubleValue())) continue;
            yIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            yIdx = ny - 2;
        }
        int i1 = yIdx;
        int j1 = xIdx;
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        Index index = data.getIndex();
        double a = data.getDouble(index.set(i1, j1));
        double b = data.getDouble(index.set(i1, j2));
        double c = data.getDouble(index.set(i2, j1));
        double d = data.getDouble(index.set(i2, j2));
        ArrayList<Double> dList = new ArrayList<Double>();
        if (!Double.isNaN(a) && !MIMath.doubleEquals(a, missingValue)) {
            dList.add(a);
        }
        if (!Double.isNaN(b) && !MIMath.doubleEquals(b, missingValue)) {
            dList.add(b);
        }
        if (!Double.isNaN(c) && !MIMath.doubleEquals(c, missingValue)) {
            dList.add(c);
        }
        if (!Double.isNaN(d) && !MIMath.doubleEquals(d, missingValue)) {
            dList.add(d);
        }
        if (dList.isEmpty()) {
            return iValue;
        }
        if (dList.size() == 1) {
            iValue = (Double)dList.get(0);
        } else if (dList.size() <= 3) {
            double aSum = 0.0;
            Iterator iterator = dList.iterator();
            while (iterator.hasNext()) {
                double dd = (Double)iterator.next();
                aSum += dd;
            }
            iValue = aSum / (double)dList.size();
        } else {
            double dx = xArray.get(xIdx + 1).doubleValue() - xArray.get(xIdx).doubleValue();
            double dy = yArray.get(yIdx + 1).doubleValue() - yArray.get(yIdx).doubleValue();
            double x1val = a + (c - a) * (y - yArray.get(i1).doubleValue()) / dy;
            double x2val = b + (d - b) * (y - yArray.get(i1).doubleValue()) / dy;
            iValue = x1val + (x2val - x1val) * (x - xArray.get(j1).doubleValue()) / dx;
        }
        return iValue;
    }

    public static double toStation(Array data, List<Number> xArray, List<Number> yArray, double x, double y) {
        int i;
        double iValue = Double.NaN;
        int nx = xArray.size();
        int ny = yArray.size();
        if (x < xArray.get(0).doubleValue() || x > xArray.get(nx - 1).doubleValue() || y < yArray.get(0).doubleValue() || y > yArray.get(ny - 1).doubleValue()) {
            return iValue;
        }
        int xIdx = 0;
        int yIdx = 0;
        boolean isIn = false;
        for (i = 1; i < nx; ++i) {
            if (!(x < xArray.get(i).doubleValue())) continue;
            xIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            xIdx = nx - 2;
        }
        isIn = false;
        for (i = 1; i < ny; ++i) {
            if (!(y < yArray.get(i).doubleValue())) continue;
            yIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            yIdx = ny - 2;
        }
        int i1 = yIdx;
        int j1 = xIdx;
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        Index index = data.getIndex();
        double a = data.getDouble(index.set(i1, j1));
        double b = data.getDouble(index.set(i1, j2));
        double c = data.getDouble(index.set(i2, j1));
        double d = data.getDouble(index.set(i2, j2));
        ArrayList<Double> dList = new ArrayList<Double>();
        if (!Double.isNaN(a)) {
            dList.add(a);
        }
        if (!Double.isNaN(b)) {
            dList.add(b);
        }
        if (!Double.isNaN(c)) {
            dList.add(c);
        }
        if (!Double.isNaN(d)) {
            dList.add(d);
        }
        if (dList.isEmpty()) {
            return iValue;
        }
        if (dList.size() == 1) {
            iValue = (Double)dList.get(0);
        } else if (dList.size() <= 3) {
            double aSum = 0.0;
            Iterator iterator = dList.iterator();
            while (iterator.hasNext()) {
                double dd = (Double)iterator.next();
                aSum += dd;
            }
            iValue = aSum / (double)dList.size();
        } else {
            double dx = xArray.get(xIdx + 1).doubleValue() - xArray.get(xIdx).doubleValue();
            double dy = yArray.get(yIdx + 1).doubleValue() - yArray.get(yIdx).doubleValue();
            double x1val = a + (c - a) * (y - yArray.get(i1).doubleValue()) / dy;
            double x2val = b + (d - b) * (y - yArray.get(i1).doubleValue()) / dy;
            iValue = x1val + (x2val - x1val) * (x - xArray.get(j1).doubleValue()) / dx;
        }
        return iValue;
    }

    public static int getDimIndex(Array dim, double v) {
        int n = (int)dim.getSize();
        if (v < dim.getDouble(0) || v > dim.getDouble(n - 1)) {
            return -1;
        }
        int idx = n - 1;
        for (int i = 1; i < n; ++i) {
            if (!(v < dim.getDouble(i))) continue;
            idx = i - 1;
            break;
        }
        return idx;
    }

    private static int[] gridIndex(Array xdim, Array ydim, double x, double y) {
        int xn = (int)xdim.getSize();
        int yn = (int)ydim.getSize();
        int xIdx = ArrayUtil.getDimIndex(xdim, x);
        if (xIdx < 0) {
            return null;
        }
        int yIdx = ArrayUtil.getDimIndex(ydim, y);
        if (yIdx < 0) {
            return null;
        }
        if (xIdx == xn - 1) {
            xIdx = xn - 2;
        }
        if (yIdx == yn - 1) {
            yIdx = yn - 2;
        }
        int i1 = yIdx;
        int j1 = xIdx;
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        return new int[]{i1, j1, i2, j2};
    }

    private static double bilinear(Array data, Index dindex, Array xdim, Array ydim, double x, double y) {
        double iValue = Double.NaN;
        int[] xyIdx = ArrayUtil.gridIndex(xdim, ydim, x, y);
        if (xyIdx == null) {
            return iValue;
        }
        int i1 = xyIdx[0];
        int j1 = xyIdx[1];
        int i2 = xyIdx[2];
        int j2 = xyIdx[3];
        Index index = Index.factory((int[])data.getShape());
        int n = index.getRank();
        for (int i = 0; i < n - 2; ++i) {
            index.setDim(i, dindex.getCurrentCounter()[i]);
        }
        index.setDim(n - 2, i1);
        index.setDim(n - 1, j1);
        double a = data.getDouble(index);
        index.setDim(n - 1, j2);
        double b = data.getDouble(index);
        index.setDim(n - 2, i2);
        index.setDim(n - 1, j1);
        double c = data.getDouble(index);
        index.setDim(n - 2, i2);
        index.setDim(n - 1, j2);
        double d = data.getDouble(index);
        ArrayList<Double> dList = new ArrayList<Double>();
        if (!Double.isNaN(a)) {
            dList.add(a);
        }
        if (!Double.isNaN(b)) {
            dList.add(b);
        }
        if (!Double.isNaN(c)) {
            dList.add(c);
        }
        if (!Double.isNaN(d)) {
            dList.add(d);
        }
        if (dList.isEmpty()) {
            return iValue;
        }
        if (dList.size() == 1) {
            iValue = (Double)dList.get(0);
        } else if (dList.size() <= 3) {
            double aSum = 0.0;
            Iterator iterator = dList.iterator();
            while (iterator.hasNext()) {
                double dd = (Double)iterator.next();
                aSum += dd;
            }
            iValue = aSum / (double)dList.size();
        } else {
            double dx = xdim.getDouble(j1 + 1) - xdim.getDouble(j1);
            double dy = ydim.getDouble(i1 + 1) - ydim.getDouble(i1);
            double x1val = a + (c - a) * (y - ydim.getDouble(i1)) / dy;
            double x2val = b + (d - b) * (y - ydim.getDouble(i1)) / dy;
            iValue = x1val + (x2val - x1val) * (x - xdim.getDouble(j1)) / dx;
        }
        return iValue;
    }

    public static double toStation(Array data, Array xArray, Array yArray, double x, double y) {
        int i;
        double iValue = Double.NaN;
        int nx = (int)xArray.getSize();
        int ny = (int)yArray.getSize();
        if (x < xArray.getDouble(0) || x > xArray.getDouble(nx - 1) || y < yArray.getDouble(0) || y > yArray.getDouble(ny - 1)) {
            return iValue;
        }
        int xIdx = 0;
        int yIdx = 0;
        boolean isIn = false;
        for (i = 1; i < nx; ++i) {
            if (!(x < xArray.getDouble(i))) continue;
            xIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            xIdx = nx - 2;
        }
        isIn = false;
        for (i = 1; i < ny; ++i) {
            if (!(y < yArray.getDouble(i))) continue;
            yIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            yIdx = ny - 2;
        }
        int i1 = yIdx;
        int j1 = xIdx;
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        Index index = data.getIndex();
        double a = data.getDouble(index.set(i1, j1));
        double b = data.getDouble(index.set(i1, j2));
        double c = data.getDouble(index.set(i2, j1));
        double d = data.getDouble(index.set(i2, j2));
        ArrayList<Double> dList = new ArrayList<Double>();
        if (!Double.isNaN(a)) {
            dList.add(a);
        }
        if (!Double.isNaN(b)) {
            dList.add(b);
        }
        if (!Double.isNaN(c)) {
            dList.add(c);
        }
        if (!Double.isNaN(d)) {
            dList.add(d);
        }
        if (dList.isEmpty()) {
            return iValue;
        }
        if (dList.size() == 1) {
            iValue = (Double)dList.get(0);
        } else if (dList.size() <= 3) {
            double aSum = 0.0;
            Iterator iterator = dList.iterator();
            while (iterator.hasNext()) {
                double dd = (Double)iterator.next();
                aSum += dd;
            }
            iValue = aSum / (double)dList.size();
        } else {
            double dx = xArray.getDouble(xIdx + 1) - xArray.getDouble(xIdx);
            double dy = yArray.getDouble(yIdx + 1) - yArray.getDouble(yIdx);
            double x1val = a + (c - a) * (y - yArray.getDouble(i1)) / dy;
            double x2val = b + (d - b) * (y - yArray.getDouble(i1)) / dy;
            iValue = x1val + (x2val - x1val) * (x - xArray.getDouble(j1)) / dx;
        }
        return iValue;
    }

    public static double toStation_Neighbor(Array data, List<Number> xArray, List<Number> yArray, double x, double y, double missingValue) {
        int i;
        double iValue = Double.NaN;
        int nx = xArray.size();
        int ny = yArray.size();
        if (x < xArray.get(0).doubleValue() || x > xArray.get(nx - 1).doubleValue() || y < yArray.get(0).doubleValue() || y > yArray.get(ny - 1).doubleValue()) {
            return iValue;
        }
        int xIdx = 0;
        int yIdx = 0;
        boolean isIn = false;
        for (i = 1; i < nx; ++i) {
            if (!(x < xArray.get(i).doubleValue())) continue;
            xIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            xIdx = nx - 2;
        }
        isIn = false;
        for (i = 1; i < ny; ++i) {
            if (!(y < yArray.get(i).doubleValue())) continue;
            yIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            yIdx = ny - 2;
        }
        int i1 = yIdx;
        int j1 = xIdx;
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        Index index = data.getIndex();
        double a = data.getDouble(index.set(i1, j1));
        double b = data.getDouble(index.set(i1, j2));
        double c = data.getDouble(index.set(i2, j1));
        double d = data.getDouble(index.set(i2, j2));
        iValue = Math.abs(x - xArray.get(j1).doubleValue()) < Math.abs(xArray.get(j2).doubleValue() - x) ? (Math.abs(y - yArray.get(i1).doubleValue()) < Math.abs(yArray.get(i2).doubleValue() - y) ? a : c) : (Math.abs(y - yArray.get(i1).doubleValue()) < Math.abs(yArray.get(i2).doubleValue() - y) ? b : d);
        return iValue;
    }

    public static double toStation_Neighbor(Array data, List<Number> xArray, List<Number> yArray, double x, double y) {
        int i;
        int nx = xArray.size();
        int ny = yArray.size();
        if (x < xArray.get(0).doubleValue() || x > xArray.get(nx - 1).doubleValue() || y < yArray.get(0).doubleValue() || y > yArray.get(ny - 1).doubleValue()) {
            return Double.NaN;
        }
        int xIdx = 0;
        int yIdx = 0;
        boolean isIn = false;
        for (i = 1; i < nx; ++i) {
            if (!(x < xArray.get(i).doubleValue())) continue;
            xIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            xIdx = nx - 2;
        }
        isIn = false;
        for (i = 1; i < ny; ++i) {
            if (!(y < yArray.get(i).doubleValue())) continue;
            yIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            yIdx = ny - 2;
        }
        int i1 = yIdx;
        int j1 = xIdx;
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        Index index = data.getIndex();
        double a = data.getDouble(index.set(i1, j1));
        double b = data.getDouble(index.set(i1, j2));
        double c = data.getDouble(index.set(i2, j1));
        double d = data.getDouble(index.set(i2, j2));
        double iValue = Math.abs(x - xArray.get(j1).doubleValue()) < Math.abs(xArray.get(j2).doubleValue() - x) ? (Math.abs(y - yArray.get(i1).doubleValue()) < Math.abs(yArray.get(i2).doubleValue() - y) ? a : c) : (Math.abs(y - yArray.get(i1).doubleValue()) < Math.abs(yArray.get(i2).doubleValue() - y) ? b : d);
        return iValue;
    }

    public static double toStation_Neighbor(Array data, Array xArray, Array yArray, double x, double y) {
        int i;
        int nx = (int)xArray.getSize();
        int ny = (int)yArray.getSize();
        if (x < xArray.getDouble(0) || x > xArray.getDouble(nx - 1) || y < yArray.getDouble(0) || y > yArray.getDouble(ny - 1)) {
            return Double.NaN;
        }
        int xIdx = 0;
        int yIdx = 0;
        boolean isIn = false;
        for (i = 1; i < nx; ++i) {
            if (!(x < xArray.getDouble(i))) continue;
            xIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            xIdx = nx - 2;
        }
        isIn = false;
        for (i = 1; i < ny; ++i) {
            if (!(y < yArray.getDouble(i))) continue;
            yIdx = i - 1;
            isIn = true;
            break;
        }
        if (!isIn) {
            yIdx = ny - 2;
        }
        int i1 = yIdx;
        int j1 = xIdx;
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        Index index = data.getIndex();
        double a = data.getDouble(index.set(i1, j1));
        double b = data.getDouble(index.set(i1, j2));
        double c = data.getDouble(index.set(i2, j1));
        double d = data.getDouble(index.set(i2, j2));
        double iValue = Math.abs(x - xArray.getDouble(j1)) < Math.abs(xArray.getDouble(j2) - x) ? (Math.abs(y - yArray.getDouble(i1)) < Math.abs(yArray.getDouble(i2) - y) ? a : c) : (Math.abs(y - yArray.getDouble(i1)) < Math.abs(yArray.getDouble(i2) - y) ? b : d);
        return iValue;
    }

    public static Object[] reproject_back(Array data, List<Number> xx, List<Number> yy, ProjectionInfo fromProj, ProjectionInfo toProj) throws InvalidRangeException {
        int i;
        int xnum = xx.size();
        int ynum = yy.size();
        double xdelta = xx.get(1).doubleValue() - xx.get(0).doubleValue();
        double ydelta = yy.get(1).doubleValue() - yy.get(0).doubleValue();
        Extent aExtent = ProjectionUtil.getProjectionExtent(fromProj, toProj, xx, yy);
        double xDelt = (aExtent.maxX - aExtent.minX) / (double)(xnum - 1);
        double yDelt = (aExtent.maxY - aExtent.minY) / (double)(ynum - 1);
        Array rx = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{xnum});
        Array ry = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ynum});
        for (i = 0; i < xnum; ++i) {
            rx.setDouble(i, aExtent.minX + (double)i * xDelt);
        }
        for (i = 0; i < ynum; ++i) {
            ry.setDouble(i, aExtent.minY + (double)i * yDelt);
        }
        Array r = Array.factory((DataType)data.getDataType(), (int[])data.getShape());
        double[][] points = new double[1][];
        Number fill_value = Double.NaN;
        switch (data.getDataType()) {
            case INT: {
                fill_value = Integer.MIN_VALUE;
                break;
            }
            case FLOAT: {
                fill_value = Float.valueOf(Float.NaN);
            }
        }
        for (i = 0; i < ynum; ++i) {
            for (int j = 0; j < xnum; ++j) {
                points[0] = new double[]{rx.getDouble(j), ry.getDouble(i)};
                try {
                    Reproject.reprojectPoints(points, toProj, fromProj, 0, 1);
                    double x = points[0][0];
                    double y = points[0][1];
                    if (x < xx.get(0).doubleValue() || x > xx.get(xx.size() - 1).doubleValue()) {
                        r.setObject(i * xnum + j, (Object)fill_value);
                        continue;
                    }
                    if (y < yy.get(0).doubleValue() || y > yy.get(yy.size() - 1).doubleValue()) {
                        r.setObject(i * xnum + j, (Object)fill_value);
                        continue;
                    }
                    int xIdx = (int)((x - xx.get(0).doubleValue()) / xdelta);
                    int yIdx = (int)((y - yy.get(0).doubleValue()) / ydelta);
                    r.setObject(i * xnum + j, data.getObject(yIdx * xnum + xIdx));
                    continue;
                }
                catch (Exception e) {
                    r.setObject(i * xnum + j, (Object)fill_value);
                    ++j;
                }
            }
        }
        return new Object[]{r, rx, ry};
    }

    public static Object[] reproject(Array data, List<Number> xx, List<Number> yy, ProjectionInfo fromProj, ProjectionInfo toProj, ResampleMethods method) throws InvalidRangeException {
        int i;
        int xnum = xx.size();
        int ynum = yy.size();
        Extent aExtent = ProjectionUtil.getProjectionExtent(fromProj, toProj, xx, yy);
        double xDelt = (aExtent.maxX - aExtent.minX) / (double)(xnum - 1);
        double yDelt = (aExtent.maxY - aExtent.minY) / (double)(ynum - 1);
        Array rx = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{xnum});
        Array ry = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ynum});
        for (i = 0; i < xnum; ++i) {
            rx.setDouble(i, aExtent.minX + (double)i * xDelt);
        }
        for (i = 0; i < ynum; ++i) {
            ry.setDouble(i, aExtent.minY + (double)i * yDelt);
        }
        Array[] rr = ArrayUtil.meshgrid(rx, ry);
        Array r = ArrayUtil.reproject(data, xx, yy, rr[0], rr[1], fromProj, toProj, method);
        return new Object[]{r, rx, ry};
    }

    public static Object[] reproject(Array data, List<Number> xx, List<Number> yy, ProjectionInfo fromProj, ProjectionInfo toProj) throws InvalidRangeException {
        return ArrayUtil.reproject(data, xx, yy, fromProj, toProj, ResampleMethods.NearestNeighbor);
    }

    public static Array reproject(Array data, List<Number> x, List<Number> y, Array rx, Array ry, ProjectionInfo fromProj, ProjectionInfo toProj, double fill_value, ResampleMethods resampleMethod) throws InvalidRangeException {
        int[] shape;
        int n = (int)rx.getSize();
        int[] dshape = data.getShape();
        if (rx.getRank() == 1) {
            shape = new int[]{rx.getShape()[0]};
        } else {
            shape = new int[data.getRank()];
            for (int i = 0; i < shape.length; ++i) {
                shape[i] = i == shape.length - 2 ? rx.getShape()[0] : (i == shape.length - 1 ? rx.getShape()[1] : data.getShape()[i]);
            }
        }
        Array r = Array.factory((DataType)data.getDataType(), (int[])shape);
        double[][] points = new double[n][];
        for (int i = 0; i < n; ++i) {
            points[i] = new double[]{rx.getDouble(i), ry.getDouble(i)};
        }
        if (!fromProj.equals(toProj)) {
            Reproject.reprojectPoints(points, toProj, fromProj, 0, points.length);
        }
        if (resampleMethod == ResampleMethods.Bilinear) {
            if (shape.length <= 2) {
                for (int i = 0; i < n; ++i) {
                    double xx = points[i][0];
                    double yy = points[i][1];
                    if (Double.isNaN(xx) || Double.isNaN(yy)) {
                        r.setObject(i, (Object)Double.NaN);
                        continue;
                    }
                    r.setObject(i, (Object)ArrayUtil.toStation(data, x, y, xx, yy, fill_value));
                }
            } else {
                Index indexr = r.getIndex();
                int[] cc = null;
                Array ndata = null;
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = indexr.getCurrentCounter();
                    boolean isNew = true;
                    if (i > 0) {
                        for (int j = 0; j < shape.length - 2; ++j) {
                            if (cc[j] == current[j]) continue;
                            isNew = false;
                            break;
                        }
                    }
                    cc = Arrays.copyOf(current, current.length);
                    if (isNew) {
                        ArrayList<Range> ranges = new ArrayList<Range>();
                        for (int j = 0; j < shape.length - 2; ++j) {
                            ranges.add(new Range(current[j], current[j], 1));
                        }
                        ranges.add(new Range(0, dshape[dshape.length - 2] - 1, 1));
                        ranges.add(new Range(0, dshape[dshape.length - 1] - 1, 1));
                        ndata = data.section(ranges).reduce();
                    }
                    int k = current[shape.length - 2] * shape[shape.length - 1] + current[shape.length - 1];
                    double xx = points[k][0];
                    double yy = points[k][1];
                    if (Double.isNaN(xx) || Double.isNaN(yy)) {
                        r.setObject(i, (Object)Double.NaN);
                    } else {
                        r.setObject(i, (Object)ArrayUtil.toStation(ndata, x, y, xx, yy, fill_value));
                    }
                    indexr.incr();
                    ++i;
                }
            }
        } else if (shape.length <= 2) {
            for (int i = 0; i < n; ++i) {
                double xx = points[i][0];
                double yy = points[i][1];
                if (Double.isNaN(xx) || Double.isNaN(yy)) {
                    r.setObject(i, (Object)Double.NaN);
                    continue;
                }
                r.setObject(i, (Object)ArrayUtil.toStation_Neighbor(data, x, y, xx, yy, fill_value));
            }
        } else {
            Index indexr = r.getIndex();
            int[] cc = null;
            Array ndata = null;
            int i = 0;
            while ((long)i < r.getSize()) {
                int[] current = indexr.getCurrentCounter();
                boolean isNew = true;
                if (i > 0) {
                    for (int j = 0; j < shape.length - 2; ++j) {
                        if (cc[j] == current[j]) continue;
                        isNew = false;
                        break;
                    }
                }
                cc = Arrays.copyOf(current, current.length);
                if (isNew) {
                    ArrayList<Range> ranges = new ArrayList<Range>();
                    for (int j = 0; j < shape.length - 2; ++j) {
                        ranges.add(new Range(current[j], current[j], 1));
                    }
                    ranges.add(new Range(0, dshape[dshape.length - 2] - 1, 1));
                    ranges.add(new Range(0, dshape[dshape.length - 1] - 1, 1));
                    ndata = data.section(ranges).reduce();
                }
                int k = current[shape.length - 2] * shape[shape.length - 1] + current[shape.length - 1];
                double xx = points[k][0];
                double yy = points[k][1];
                if (Double.isNaN(xx) || Double.isNaN(yy)) {
                    r.setObject(i, (Object)Double.NaN);
                } else {
                    r.setObject(i, (Object)ArrayUtil.toStation_Neighbor(ndata, x, y, xx, yy, fill_value));
                }
                indexr.incr();
                ++i;
            }
        }
        return r;
    }

    public static Array reproject(Array data, List<Number> x, List<Number> y, Array rx, Array ry, ProjectionInfo fromProj, ProjectionInfo toProj, ResampleMethods resampleMethod) throws InvalidRangeException {
        int[] shape;
        int n = (int)rx.getSize();
        int[] dshape = data.getShape();
        if (rx.getRank() == 1) {
            shape = new int[]{rx.getShape()[0]};
        } else {
            shape = new int[data.getRank()];
            for (int i = 0; i < shape.length; ++i) {
                shape[i] = i == shape.length - 2 ? rx.getShape()[0] : (i == shape.length - 1 ? rx.getShape()[1] : data.getShape()[i]);
            }
        }
        Array r = Array.factory((DataType)data.getDataType(), (int[])shape);
        double[][] points = new double[n][];
        for (int i = 0; i < n; ++i) {
            points[i] = new double[]{rx.getDouble(i), ry.getDouble(i)};
        }
        if (!fromProj.equals(toProj)) {
            Reproject.reprojectPoints(points, toProj, fromProj, 0, points.length);
        }
        if (resampleMethod == ResampleMethods.Bilinear) {
            if (shape.length <= 2) {
                for (int i = 0; i < n; ++i) {
                    double xx = points[i][0];
                    double yy = points[i][1];
                    r.setObject(i, (Object)ArrayUtil.toStation(data, x, y, xx, yy));
                }
            } else {
                Index indexr = r.getIndex();
                int[] cc = null;
                Array ndata = null;
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = indexr.getCurrentCounter();
                    boolean isNew = true;
                    if (i > 0) {
                        for (int j = 0; j < shape.length - 2; ++j) {
                            if (cc[j] == current[j]) continue;
                            isNew = false;
                            break;
                        }
                    }
                    cc = Arrays.copyOf(current, current.length);
                    if (isNew) {
                        ArrayList<Range> ranges = new ArrayList<Range>();
                        for (int j = 0; j < shape.length - 2; ++j) {
                            ranges.add(new Range(current[j], current[j], 1));
                        }
                        ranges.add(new Range(0, dshape[dshape.length - 2] - 1, 1));
                        ranges.add(new Range(0, dshape[dshape.length - 1] - 1, 1));
                        ndata = data.section(ranges).reduce();
                    }
                    int k = current[shape.length - 2] * shape[shape.length - 1] + current[shape.length - 1];
                    double xx = points[k][0];
                    double yy = points[k][1];
                    r.setObject(i, (Object)ArrayUtil.toStation(ndata, x, y, xx, yy));
                    indexr.incr();
                    ++i;
                }
            }
        } else if (shape.length == 2) {
            for (int i = 0; i < n; ++i) {
                double xx = points[i][0];
                double yy = points[i][1];
                r.setObject(i, (Object)ArrayUtil.toStation_Neighbor(data, x, y, xx, yy));
            }
        } else {
            Index indexr = r.getIndex();
            int[] cc = null;
            Array ndata = null;
            int i = 0;
            while ((long)i < r.getSize()) {
                int[] current = indexr.getCurrentCounter();
                boolean isNew = true;
                if (i > 0) {
                    for (int j = 0; j < shape.length - 2; ++j) {
                        if (cc[j] == current[j]) continue;
                        isNew = false;
                        break;
                    }
                }
                cc = Arrays.copyOf(current, current.length);
                if (isNew) {
                    ArrayList<Range> ranges = new ArrayList<Range>();
                    for (int j = 0; j < shape.length - 2; ++j) {
                        ranges.add(new Range(current[j], current[j], 1));
                    }
                    ranges.add(new Range(0, dshape[dshape.length - 2] - 1, 1));
                    ranges.add(new Range(0, dshape[dshape.length - 1] - 1, 1));
                    ndata = data.section(ranges).reduce();
                }
                int k = current[shape.length - 2] * shape[shape.length - 1] + current[shape.length - 1];
                double xx = points[k][0];
                double yy = points[k][1];
                r.setObject(i, (Object)ArrayUtil.toStation_Neighbor(ndata, x, y, xx, yy));
                indexr.incr();
                ++i;
            }
        }
        return r;
    }

    public static Array reproject(Array data, List<Number> x, List<Number> y, List<Number> rx, List<Number> ry, ProjectionInfo fromProj, ProjectionInfo toProj, double fill_value, ResampleMethods resampleMethod) {
        int n = rx.size() * ry.size();
        int[] shape = new int[]{ry.size(), rx.size()};
        Array r = Array.factory((DataType)data.getDataType(), (int[])shape);
        double[][] points = new double[n][];
        for (int i = 0; i < ry.size(); ++i) {
            for (int j = 0; j < rx.size(); ++j) {
                points[i * rx.size() + j] = new double[]{rx.get(j).doubleValue(), ry.get(i).doubleValue()};
            }
        }
        if (!fromProj.equals(toProj)) {
            Reproject.reprojectPoints(points, toProj, fromProj, 0, points.length);
        }
        if (resampleMethod == ResampleMethods.Bilinear) {
            for (int i = 0; i < n; ++i) {
                double xx = points[i][0];
                double yy = points[i][1];
                r.setObject(i, (Object)ArrayUtil.toStation(data, x, y, xx, yy, fill_value));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                double xx = points[i][0];
                double yy = points[i][1];
                r.setObject(i, (Object)ArrayUtil.toStation_Neighbor(data, x, y, xx, yy, fill_value));
            }
        }
        return r;
    }

    public static PolygonShape convexHull(Array x, Array y) {
        int n = (int)x.getSize();
        Geometry[] geos = new Geometry[n];
        GeometryFactory factory = new GeometryFactory();
        for (int i = 0; i < n; ++i) {
            Coordinate c = new Coordinate(x.getDouble(i), y.getDouble(i));
            geos[i] = factory.createPoint(c);
        }
        GeometryCollection gs = factory.createGeometryCollection(geos);
        Geometry ch = gs.convexHull();
        return new PolygonShape(ch);
    }
}

