/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.meteodata.GridDataSetting;
import org.meteoinfo.geoprocess.GeoComputation;
import org.meteoinfo.geoprocess.analysis.InterpolationSetting;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.projection.Reproject;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.Shape;
import org.meteoinfo.shape.ShapeTypes;
import ucar.ma2.Array;
import wcontour.Interpolate;

public class StationData {
    public double[][] data;
    public List<String> stations;
    public Extent dataExtent;
    public double missingValue;
    public ProjectionInfo projInfo = null;

    public StationData() {
        this.data = new double[0][3];
        this.stations = new ArrayList<String>();
        this.dataExtent = new Extent();
        this.missingValue = -9999.0;
    }

    public StationData(Array a, Array x, Array y, Number missingv) {
        int n = (int)a.getSize();
        this.missingValue = missingv.doubleValue();
        this.stations = new ArrayList<String>();
        this.dataExtent = new Extent();
        this.data = new double[n][3];
        for (int i = 0; i < n; ++i) {
            this.stations.add("s_" + String.valueOf(i + 1));
            this.data[i][0] = x.getDouble(i);
            this.data[i][1] = y.getDouble(i);
            this.data[i][2] = a.getDouble(i);
            if (!Double.isNaN(this.data[i][2])) continue;
            this.data[i][2] = missingv.doubleValue();
        }
    }

    public StationData(StationData aStData) {
        this.projInfo = aStData.projInfo;
        this.stations = aStData.stations;
        this.dataExtent = aStData.dataExtent;
        this.missingValue = aStData.missingValue;
        this.data = new double[aStData.data.length][aStData.data[0].length];
        for (int i = 0; i < aStData.getStNum(); ++i) {
            this.data[i][0] = aStData.data[i][0];
            this.data[i][1] = aStData.data[i][1];
        }
    }

    public int getStNum() {
        return this.data.length;
    }

    public double[] getX() {
        double[] x = new double[this.getStNum()];
        for (int i = 0; i < this.getStNum(); ++i) {
            x[i] = this.data[i][0];
        }
        return x;
    }

    public List<Double> getXList() {
        ArrayList<Double> x = new ArrayList<Double>();
        for (int i = 0; i < this.getStNum(); ++i) {
            x.add(this.data[i][0]);
        }
        return x;
    }

    public double[] getY() {
        double[] y = new double[this.getStNum()];
        for (int i = 0; i < this.getStNum(); ++i) {
            y[i] = this.data[i][1];
        }
        return y;
    }

    public List<Double> getYList() {
        ArrayList<Double> y = new ArrayList<Double>();
        for (int i = 0; i < this.getStNum(); ++i) {
            y.add(this.data[i][1]);
        }
        return y;
    }

    public void setData(double[][] value) {
        this.data = value;
        this.updateExtent();
    }

    public StationData add(StationData bStData) {
        if (!MIMath.isExtentCross(this.dataExtent, bStData.dataExtent).booleanValue()) {
            return null;
        }
        StationData cStData = new StationData();
        cStData.projInfo = bStData.projInfo;
        for (int i = 0; i < this.stations.size(); ++i) {
            double bValue;
            int stIdx;
            double aValue;
            String aStid = this.stations.get(i);
            if (aStid.equals("99999") || (aValue = this.getValue(i)) == this.missingValue || (stIdx = bStData.stations.indexOf(aStid)) < 0 || (bValue = bStData.getValue(stIdx)) == bStData.missingValue) continue;
            double x = this.getX(i);
            double y = this.getY(i);
            cStData.addData(aStid, x, y, aValue + bValue);
        }
        return cStData;
    }

    public StationData add(double value) {
        StationData cStData = new StationData();
        cStData.projInfo = this.projInfo;
        for (int i = 0; i < this.stations.size(); ++i) {
            String aStid = this.stations.get(i);
            double aValue = this.getValue(i);
            double x = this.getX(i);
            double y = this.getY(i);
            if (MIMath.doubleEquals(aValue, this.missingValue)) {
                cStData.addData(aStid, x, y, aValue);
                continue;
            }
            cStData.addData(aStid, x, y, aValue + value);
        }
        return cStData;
    }

    public StationData sub(StationData bStData) {
        if (!MIMath.isExtentCross(this.dataExtent, bStData.dataExtent).booleanValue()) {
            return null;
        }
        StationData cStData = new StationData();
        for (int i = 0; i < this.stations.size(); ++i) {
            double bValue;
            int stIdx;
            double aValue;
            String aStid = this.stations.get(i);
            if (aStid.equals("99999") || (aValue = this.getValue(i)) == this.missingValue || (stIdx = bStData.stations.indexOf(aStid)) < 0 || (bValue = bStData.getValue(stIdx)) == bStData.missingValue) continue;
            double x = this.getX(i);
            double y = this.getY(i);
            cStData.addData(aStid, x, y, aValue - bValue);
        }
        return cStData;
    }

    public StationData sub(double value) {
        StationData cStData = new StationData();
        for (int i = 0; i < this.stations.size(); ++i) {
            String aStid = this.stations.get(i);
            double aValue = this.getValue(i);
            double x = this.getX(i);
            double y = this.getY(i);
            if (MIMath.doubleEquals(aValue, this.missingValue)) {
                cStData.addData(aStid, x, y, aValue);
                continue;
            }
            cStData.addData(aStid, x, y, aValue - value);
        }
        return cStData;
    }

    public StationData mul(StationData bStData) {
        if (!MIMath.isExtentCross(this.dataExtent, bStData.dataExtent).booleanValue()) {
            return null;
        }
        StationData cStData = new StationData();
        for (int i = 0; i < this.stations.size(); ++i) {
            double bValue;
            int stIdx;
            double aValue;
            String aStid = this.stations.get(i);
            if (aStid.equals("99999") || (aValue = this.getValue(i)) == this.missingValue || (stIdx = bStData.stations.indexOf(aStid)) < 0 || (bValue = bStData.getValue(stIdx)) == bStData.missingValue) continue;
            double x = this.getX(i);
            double y = this.getY(i);
            cStData.addData(aStid, x, y, aValue * bValue);
        }
        return cStData;
    }

    public StationData mul(double value) {
        StationData cStData = new StationData();
        for (int i = 0; i < this.stations.size(); ++i) {
            String aStid = this.stations.get(i);
            double aValue = this.getValue(i);
            double x = this.getX(i);
            double y = this.getY(i);
            if (MIMath.doubleEquals(aValue, this.missingValue)) {
                cStData.addData(aStid, x, y, aValue);
                continue;
            }
            cStData.addData(aStid, x, y, aValue * value);
        }
        return cStData;
    }

    public StationData div(StationData bStData) {
        if (!MIMath.isExtentCross(this.dataExtent, bStData.dataExtent).booleanValue()) {
            return null;
        }
        StationData cStData = new StationData();
        for (int i = 0; i < this.stations.size(); ++i) {
            double bValue;
            int stIdx;
            double aValue;
            String aStid = this.stations.get(i);
            if (aStid.equals("99999") || (aValue = this.getValue(i)) == this.missingValue || (stIdx = bStData.stations.indexOf(aStid)) < 0 || (bValue = bStData.getValue(stIdx)) == bStData.missingValue) continue;
            double x = this.getX(i);
            double y = this.getY(i);
            cStData.addData(aStid, x, y, aValue / bValue);
        }
        return cStData;
    }

    public StationData div(double value) {
        StationData cStData = new StationData();
        for (int i = 0; i < this.stations.size(); ++i) {
            String aStid = this.stations.get(i);
            double aValue = this.getValue(i);
            double x = this.getX(i);
            double y = this.getY(i);
            if (MIMath.doubleEquals(aValue, this.missingValue)) {
                cStData.addData(aStid, x, y, aValue);
                continue;
            }
            cStData.addData(aStid, x, y, aValue / value);
        }
        return cStData;
    }

    public StationData abs() {
        StationData stationData = new StationData(this);
        for (int i = 0; i < stationData.getStNum(); ++i) {
            if (MIMath.doubleEquals(this.getValue(i), this.missingValue)) {
                stationData.setValue(i, this.missingValue);
                continue;
            }
            stationData.setValue(i, Math.abs(this.getValue(i)));
        }
        return stationData;
    }

    public StationData acos() {
        StationData stationData = new StationData(this);
        for (int i = 0; i < stationData.getStNum(); ++i) {
            if (MIMath.doubleEquals(this.getValue(i), this.missingValue)) {
                stationData.setValue(i, this.missingValue);
                continue;
            }
            stationData.setValue(i, Math.acos(this.getValue(i)));
        }
        return stationData;
    }

    public StationData asin() {
        StationData stationData = new StationData(this);
        for (int i = 0; i < stationData.getStNum(); ++i) {
            if (MIMath.doubleEquals(this.getValue(i), this.missingValue)) {
                stationData.setValue(i, this.missingValue);
                continue;
            }
            stationData.setValue(i, Math.asin(this.getValue(i)));
        }
        return stationData;
    }

    public StationData atan() {
        StationData stationData = new StationData(this);
        for (int i = 0; i < stationData.getStNum(); ++i) {
            if (MIMath.doubleEquals(this.getValue(i), this.missingValue)) {
                stationData.setValue(i, this.missingValue);
                continue;
            }
            stationData.setValue(i, Math.atan(this.getValue(i)));
        }
        return stationData;
    }

    public StationData cos() {
        StationData stationData = new StationData(this);
        for (int i = 0; i < stationData.getStNum(); ++i) {
            if (MIMath.doubleEquals(this.getValue(i), this.missingValue)) {
                stationData.setValue(i, this.missingValue);
                continue;
            }
            stationData.setValue(i, Math.cos(this.getValue(i)));
        }
        return stationData;
    }

    public StationData sin() {
        StationData stationData = new StationData(this);
        for (int i = 0; i < stationData.getStNum(); ++i) {
            if (MIMath.doubleEquals(this.getValue(i), this.missingValue)) {
                stationData.setValue(i, this.missingValue);
                continue;
            }
            stationData.setValue(i, Math.sin(this.getValue(i)));
        }
        return stationData;
    }

    public StationData tan() {
        StationData stationData = new StationData(this);
        for (int i = 0; i < stationData.getStNum(); ++i) {
            if (MIMath.doubleEquals(this.getValue(i), this.missingValue)) {
                stationData.setValue(i, this.missingValue);
                continue;
            }
            stationData.setValue(i, Math.tan(this.getValue(i)));
        }
        return stationData;
    }

    public StationData exp() {
        StationData stationData = new StationData(this);
        for (int i = 0; i < stationData.getStNum(); ++i) {
            if (MIMath.doubleEquals(this.getValue(i), this.missingValue)) {
                stationData.setValue(i, this.missingValue);
                continue;
            }
            stationData.setValue(i, Math.exp(this.getValue(i)));
        }
        return stationData;
    }

    public StationData pow(double p) {
        StationData stationData = new StationData(this);
        for (int i = 0; i < stationData.getStNum(); ++i) {
            if (MIMath.doubleEquals(this.getValue(i), this.missingValue)) {
                stationData.setValue(i, this.missingValue);
                continue;
            }
            stationData.setValue(i, Math.pow(this.getValue(i), p));
        }
        return stationData;
    }

    public StationData sqrt() {
        StationData stationData = new StationData(this);
        for (int i = 0; i < stationData.getStNum(); ++i) {
            if (MIMath.doubleEquals(this.getValue(i), this.missingValue)) {
                stationData.setValue(i, this.missingValue);
                continue;
            }
            stationData.setValue(i, Math.sqrt(this.getValue(i)));
        }
        return stationData;
    }

    public StationData log() {
        StationData stationData = new StationData(this);
        for (int i = 0; i < stationData.getStNum(); ++i) {
            if (MIMath.doubleEquals(this.getValue(i), this.missingValue)) {
                stationData.setValue(i, this.missingValue);
                continue;
            }
            stationData.setValue(i, Math.log(this.getValue(i)));
        }
        return stationData;
    }

    public StationData log10() {
        StationData stationData = new StationData(this);
        for (int i = 0; i < stationData.getStNum(); ++i) {
            if (MIMath.doubleEquals(this.getValue(i), this.missingValue)) {
                stationData.setValue(i, this.missingValue);
                continue;
            }
            stationData.setValue(i, Math.log10(this.getValue(i)));
        }
        return stationData;
    }

    public void addData(String id, double x, double y, double value) {
        this.stations.add(id);
        int newSize = this.data.length + 1;
        this.data = this.data.length == 0 ? new double[1][3] : DataConvert.resizeArray2D(this.data, newSize);
        this.data[newSize - 1][0] = x;
        this.data[newSize - 1][1] = y;
        this.data[newSize - 1][2] = value;
        if (newSize == 1) {
            this.dataExtent.minX = x;
            this.dataExtent.maxX = x;
            this.dataExtent.minY = y;
            this.dataExtent.maxY = y;
        } else {
            if (x < this.dataExtent.minX) {
                this.dataExtent.minX = x;
            }
            if (x > this.dataExtent.maxX) {
                this.dataExtent.maxX = x;
            }
            if (y < this.dataExtent.minY) {
                this.dataExtent.minY = y;
            }
            if (y > this.dataExtent.maxY) {
                this.dataExtent.maxY = y;
            }
        }
    }

    public String getStid(int idx) {
        return this.stations.get(idx);
    }

    public void setStid(int idx, String value) {
        this.stations.set(idx, value);
    }

    public double getX(int idx) {
        return this.data[idx][0];
    }

    public double getY(int idx) {
        return this.data[idx][1];
    }

    public double getValue(int idx) {
        return this.data[idx][2];
    }

    public void setValue(int idx, double value) {
        this.data[idx][2] = value;
    }

    public List<Double> getValues() {
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i = 0; i < this.getStNum(); ++i) {
            double v = this.getValue(i);
            if (MIMath.doubleEquals(v, this.missingValue)) {
                values.add(Double.NaN);
                continue;
            }
            values.add(v);
        }
        return values;
    }

    public List<Double> getValidValues() {
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i = 0; i < this.getStNum(); ++i) {
            double v = this.getValue(i);
            if (MIMath.doubleEquals(v, this.missingValue)) continue;
            values.add(v);
        }
        return values;
    }

    public int indexOf(int stid) {
        return this.stations.indexOf(stid);
    }

    public void saveAsCSVFile(String fileName, String fieldName) {
        this.saveAsCSVFile(fileName, fieldName, false);
    }

    public void saveAsCSVFile(String fileName, String fieldName, boolean saveMissingData) {
        BufferedWriter sw = null;
        try {
            sw = new BufferedWriter(new FileWriter(new File(fileName)));
            String aStr = "Stid,Longitude,Latitude," + fieldName;
            sw.write(aStr);
            for (int i = 0; i < this.getStNum(); ++i) {
                if (!saveMissingData && MIMath.doubleEquals(this.getValue(i), this.missingValue)) continue;
                aStr = this.stations.get(i) + "," + String.valueOf(this.getX(i)) + "," + String.valueOf(this.getY(i)) + "," + String.valueOf(this.getValue(i));
                sw.newLine();
                sw.write(aStr);
            }
            sw.flush();
            sw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(StationData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public StationData maskout(PolygonShape polygonShape) {
        StationData stData = new StationData();
        stData.projInfo = this.projInfo;
        stData.missingValue = this.missingValue;
        for (int i = 0; i < this.getStNum(); ++i) {
            if (!GeoComputation.pointInPolygon(polygonShape, new PointD(this.getX(i), this.getY(i)))) continue;
            stData.addData(this.getStid(i), this.getX(i), this.getY(i), this.getValue(i));
        }
        return stData;
    }

    public StationData maskout(List<PolygonShape> polygonShapes) {
        StationData stData = new StationData();
        stData.projInfo = this.projInfo;
        stData.missingValue = this.missingValue;
        for (int i = 0; i < this.getStNum(); ++i) {
            if (!GeoComputation.pointInPolygons(polygonShapes, new PointD(this.getX(i), this.getY(i)))) continue;
            stData.addData(this.getStid(i), this.getX(i), this.getY(i), this.getValue(i));
        }
        return stData;
    }

    public StationData maskout(VectorLayer maskLayer) {
        if (maskLayer.getShapeType() != ShapeTypes.Polygon) {
            return this;
        }
        List<? extends Shape> polygons = maskLayer.getShapes();
        return this.maskout(polygons);
    }

    public StationData maskin(PolygonShape polygonShape) {
        StationData stData = new StationData();
        stData.projInfo = this.projInfo;
        stData.missingValue = this.missingValue;
        for (int i = 0; i < this.getStNum(); ++i) {
            if (GeoComputation.pointInPolygon(polygonShape, new PointD(this.getX(i), this.getY(i)))) continue;
            stData.addData(this.getStid(i), this.getX(i), this.getY(i), this.getValue(i));
        }
        return stData;
    }

    public StationData maskin(List<PolygonShape> polygonShapes) {
        StationData stData = new StationData();
        stData.projInfo = this.projInfo;
        stData.missingValue = this.missingValue;
        for (int i = 0; i < this.getStNum(); ++i) {
            if (GeoComputation.pointInPolygons(polygonShapes, new PointD(this.getX(i), this.getY(i)))) continue;
            stData.addData(this.getStid(i), this.getX(i), this.getY(i), this.getValue(i));
        }
        return stData;
    }

    public StationData maskin(VectorLayer maskLayer) {
        if (maskLayer.getShapeType() != ShapeTypes.Polygon) {
            return this;
        }
        List<? extends Shape> polygons = maskLayer.getShapes();
        return this.maskin(polygons);
    }

    public StationData filter(List<String> stations) {
        StationData stData = new StationData();
        stData.projInfo = this.projInfo;
        stData.missingValue = this.missingValue;
        for (int i = 0; i < this.getStNum(); ++i) {
            if (!stations.contains(this.getStid(i))) continue;
            stData.addData(this.getStid(i), this.getX(i), this.getY(i), this.getValue(i));
        }
        return stData;
    }

    public StationData join(StationData indata) {
        int i;
        StationData stData = new StationData(this);
        for (i = 0; i < this.getStNum(); ++i) {
            stData.addData(this.getStid(i), this.getX(i), this.getY(i), this.getValue(i));
        }
        for (i = 0; i < indata.getStNum(); ++i) {
            if (stData.stations.contains(indata.getStid(i))) continue;
            stData.addData(indata.getStid(i), indata.getX(i), indata.getY(i), indata.getValue(i));
        }
        return stData;
    }

    public StationData project(ProjectionInfo fromProj, ProjectionInfo toProj) {
        StationData nsData = new StationData();
        nsData.missingValue = this.missingValue;
        double[][] points = new double[1][];
        for (int i = 0; i < this.getStNum(); ++i) {
            points[0] = new double[]{this.getX(i), this.getY(i)};
            try {
                Reproject.reprojectPoints(points, fromProj, toProj, 0, 1);
                double x = points[0][0];
                double y = points[0][1];
                nsData.addData(this.getStid(i), x, y, this.getValue(i));
                continue;
            }
            catch (Exception e) {
                ++i;
            }
        }
        nsData.projInfo = toProj;
        return nsData;
    }

    public int getStidIndex(String stid) {
        int idx = -1;
        for (int i = 0; i < this.getStNum(); ++i) {
            if (!this.getStid(i).trim().equals(stid.trim())) continue;
            idx = i;
            break;
        }
        return idx;
    }

    public void updateExtent() {
        int stNum = this.getStNum();
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        for (int i = 0; i < stNum; ++i) {
            double lon = this.data[i][0];
            double lat = this.data[i][1];
            if (i == 0) {
                maxX = minX = lon;
                maxY = minY = lat;
                continue;
            }
            if (minX > lon) {
                minX = lon;
            } else if (maxX < lon) {
                maxX = lon;
            }
            if (minY > lat) {
                minY = lat;
                continue;
            }
            if (!(maxY < lat)) continue;
            maxY = lat;
        }
        this.dataExtent.minX = minX;
        this.dataExtent.maxX = maxX;
        this.dataExtent.minY = minY;
        this.dataExtent.maxY = maxY;
    }

    public GridData interpolateData(InterpolationSetting interSet) {
        GridData aGridData = null;
        List<double[]> values = this.createGridXY(interSet.getGridDataSetting());
        double[] X = values.get(0);
        double[] Y = values.get(1);
        switch (interSet.getInterpolationMethod()) {
            case IDW_Radius: {
                this.filterData_Radius(interSet.getRadius(), interSet.getGridDataSetting().dataExtent);
                aGridData = this.interpolate_Radius(this.data, X, Y, interSet.getMinPointNum(), interSet.getRadius(), this.missingValue);
                break;
            }
            case IDW_Neighbors: {
                this.filterData_Radius(interSet.getRadius(), interSet.getGridDataSetting().dataExtent);
                aGridData = this.interpolate_Neighbor(this.data, X, Y, interSet.getMinPointNum(), this.missingValue);
                break;
            }
            case Cressman: {
                this.filterData_Radius(0.0, interSet.getGridDataSetting().dataExtent);
                aGridData = this.interpolate_Cressman(this.data, X, Y, interSet.getRadiusList(), this.missingValue);
                break;
            }
            case AssignPointToGrid: {
                this.filterData_Radius(0.0, interSet.getGridDataSetting().dataExtent);
                aGridData = this.interpolate_Assign(this.data, X, Y, this.missingValue);
            }
        }
        return aGridData;
    }

    public GridData interpolate_Radius(double[][] S, double[] X, double[] Y, int minPNum, double radius, double missingValue) {
        double[][] dataArray = Interpolate.interpolation_IDW_Radius((double[][])S, (double[])X, (double[])Y, (int)minPNum, (double)radius, (double)missingValue);
        GridData gridData = new GridData();
        gridData.data = dataArray;
        gridData.missingValue = missingValue;
        gridData.xArray = X;
        gridData.yArray = Y;
        return gridData;
    }

    public GridData interpolate_Radius(List<Number> X, List<Number> Y, int minPNum, double radius, double missingValue) {
        int i;
        double[] nX = new double[X.size()];
        double[] nY = new double[Y.size()];
        for (i = 0; i < X.size(); ++i) {
            nX[i] = X.get(i).doubleValue();
        }
        for (i = 0; i < Y.size(); ++i) {
            nY[i] = Y.get(i).doubleValue();
        }
        return this.interpolate_Radius(this.data, nX, nY, minPNum, radius, missingValue);
    }

    public GridData interpolate_Neighbor(double[][] S, double[] X, double[] Y, int pNum, double missingValue) {
        double[][] dataArray = Interpolate.interpolation_IDW_Neighbor((double[][])S, (double[])X, (double[])Y, (int)pNum, (double)missingValue);
        GridData gridData = new GridData();
        gridData.data = dataArray;
        gridData.missingValue = missingValue;
        gridData.xArray = X;
        gridData.yArray = Y;
        return gridData;
    }

    public GridData interpolate_Neighbor(List<Number> X, List<Number> Y, int pNum, double missingValue) {
        int i;
        double[] nX = new double[X.size()];
        double[] nY = new double[Y.size()];
        for (i = 0; i < X.size(); ++i) {
            nX[i] = X.get(i).doubleValue();
        }
        for (i = 0; i < Y.size(); ++i) {
            nY[i] = Y.get(i).doubleValue();
        }
        return this.interpolate_Neighbor(this.data, nX, nY, pNum, missingValue);
    }

    public GridData interpolate_Cressman(double[][] S, double[] X, double[] Y, List<Double> radList, double missingValue) {
        double[][] dataArray = Interpolate.cressman((double[][])S, (double[])X, (double[])Y, (double)missingValue, radList);
        GridData gridData = new GridData();
        gridData.data = dataArray;
        gridData.missingValue = missingValue;
        gridData.xArray = X;
        gridData.yArray = Y;
        return gridData;
    }

    public GridData interpolate_Cressman(List<Number> X, List<Number> Y, List<Number> radList, double missingValue) {
        int i;
        double[] nX = new double[X.size()];
        double[] nY = new double[Y.size()];
        for (i = 0; i < X.size(); ++i) {
            nX[i] = X.get(i).doubleValue();
        }
        for (i = 0; i < Y.size(); ++i) {
            nY[i] = Y.get(i).doubleValue();
        }
        ArrayList<Double> rlist = new ArrayList<Double>();
        for (Number r : radList) {
            rlist.add(r.doubleValue());
        }
        return this.interpolate_Cressman(this.data, nX, nY, rlist, missingValue);
    }

    public GridData interpolate_Assign(double[][] S, double[] X, double[] Y, double missingValue) {
        double[][] dataArray = Interpolate.assignPointToGrid((double[][])S, (double[])X, (double[])Y, (double)missingValue);
        GridData gridData = new GridData();
        gridData.data = dataArray;
        gridData.missingValue = missingValue;
        gridData.xArray = X;
        gridData.yArray = Y;
        return gridData;
    }

    public GridData interpolate_Assign(List<Number> X, List<Number> Y, double missingValue) {
        int i;
        double[] nX = new double[X.size()];
        double[] nY = new double[Y.size()];
        for (i = 0; i < X.size(); ++i) {
            nX[i] = X.get(i).doubleValue();
        }
        for (i = 0; i < Y.size(); ++i) {
            nY[i] = Y.get(i).doubleValue();
        }
        return this.interpolate_Assign(this.data, nX, nY, missingValue);
    }

    public List<double[]> createGridXY(GridDataSetting gSet) {
        double xDelt = (gSet.dataExtent.maxX - gSet.dataExtent.minX) / (double)(gSet.xNum - 1);
        double yDelt = (gSet.dataExtent.maxY - gSet.dataExtent.minY) / (double)(gSet.yNum - 1);
        return Interpolate.createGridXY_Delt((double)gSet.dataExtent.minX, (double)gSet.dataExtent.minY, (double)gSet.dataExtent.maxX, (double)gSet.dataExtent.maxY, (double)xDelt, (double)yDelt);
    }

    public void filterData_Radius(double radius, Extent aExtent) {
        int i;
        ArrayList<double[]> disDataList = new ArrayList<double[]>();
        ArrayList<String> nstations = new ArrayList<String>();
        for (i = 0; i < this.getStNum(); ++i) {
            if (MIMath.doubleEquals(this.data[i][2], this.missingValue) || this.data[i][0] + radius < aExtent.minX || this.data[i][0] - radius > aExtent.maxX || this.data[i][1] + radius < aExtent.minY || this.data[i][1] - radius > aExtent.maxY) continue;
            disDataList.add(new double[]{this.data[i][0], this.data[i][1], this.data[i][2]});
            nstations.add(this.stations.get(i));
        }
        double[][] discretedData = new double[disDataList.size()][3];
        i = 0;
        for (double[] disData : disDataList) {
            discretedData[i][0] = disData[0];
            discretedData[i][1] = disData[1];
            discretedData[i][2] = disData[2];
            ++i;
        }
        this.setData(discretedData);
        this.stations = nstations;
    }

    public double getMinValue() {
        return (Double)this.getMinValueIndex()[0];
    }

    public double getMaxValue() {
        return (Double)this.getMaxValueIndex()[0];
    }

    public Object[] getMinValueIndex() {
        double min = 0.0;
        int vdNum = 0;
        int idx = 0;
        for (int i = 0; i < this.getStNum(); ++i) {
            if (MIMath.doubleEquals(this.data[i][2], this.missingValue)) continue;
            if (vdNum == 0) {
                min = this.data[i][2];
                idx = i;
            } else if (min > this.data[i][2]) {
                min = this.data[i][2];
                idx = i;
            }
            ++vdNum;
        }
        return new Object[]{min, idx};
    }

    public Object[] getMaxValueIndex() {
        double max = 0.0;
        int vdNum = 0;
        int idx = 0;
        for (int i = 0; i < this.getStNum(); ++i) {
            if (MIMath.doubleEquals(this.data[i][2], this.missingValue)) continue;
            if (vdNum == 0) {
                max = this.data[i][2];
                idx = i;
            } else if (max < this.data[i][2]) {
                max = this.data[i][2];
                idx = i;
            }
            ++vdNum;
        }
        return new Object[]{max, idx};
    }

    public boolean getMaxMinValue(double[] maxmin) {
        double max = 0.0;
        double min = 0.0;
        int vdNum = 0;
        boolean hasMissingValue = false;
        for (int i = 0; i < this.getStNum(); ++i) {
            if (MIMath.doubleEquals(this.data[i][2], this.missingValue)) {
                hasMissingValue = true;
                continue;
            }
            if (vdNum == 0) {
                min = max = this.data[i][2];
            } else {
                if (max < this.data[i][2]) {
                    max = this.data[i][2];
                }
                if (min > this.data[i][2]) {
                    min = this.data[i][2];
                }
            }
            ++vdNum;
        }
        maxmin[0] = max;
        maxmin[1] = min;
        return hasMissingValue;
    }

    public double average() {
        double ave = 0.0;
        int vdNum = 0;
        for (int i = 0; i < this.getStNum(); ++i) {
            double v = this.getValue(i);
            if (MIMath.doubleEquals(v, this.missingValue)) continue;
            ave += v;
            ++vdNum;
        }
        return ave /= (double)vdNum;
    }

    public double sum() {
        double sum = 0.0;
        for (int i = 0; i < this.getStNum(); ++i) {
            double v = this.getValue(i);
            if (MIMath.doubleEquals(v, this.missingValue)) continue;
            sum += v;
        }
        return sum;
    }
}

