/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data;

import java.util.List;
import org.meteoinfo.data.XYSeriesData;
import ucar.ma2.Array;

public class XYUVSeriesData
extends XYSeriesData {
    private double[] udata;
    private double[] vdata;
    private boolean uv = true;

    public XYUVSeriesData() {
    }

    public XYUVSeriesData(String key, double[] xdata, double[] ydata, double[] udata, double[] vdata, boolean isuv) {
        super(key, xdata, ydata);
        this.udata = udata;
        this.vdata = vdata;
        this.uv = isuv;
    }

    public XYUVSeriesData(String key, double[] xdata, double[] ydata, double[] udata, double[] vdata) {
        this(key, xdata, ydata, udata, vdata, true);
    }

    public double[] getUdata() {
        return this.udata;
    }

    public void setUdata(double[] value) {
        this.udata = value;
    }

    public void setUdata(List<Number> value) {
        this.udata = new double[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            double v = value.get(i).doubleValue();
            this.udata[i] = Double.isNaN(v) ? this.getMissingValue() : v;
        }
    }

    public void setUdata(Array value) {
        this.udata = new double[(int)value.getSize()];
        for (int i = 0; i < this.udata.length; ++i) {
            double v = value.getDouble(i);
            this.udata[i] = Double.isNaN(v) ? this.getMissingValue() : v;
        }
    }

    public double[] getVdata() {
        return this.vdata;
    }

    public void setVdata(double[] value) {
        this.vdata = value;
    }

    public void setVdata(List<Number> value) {
        this.vdata = new double[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            double v = value.get(i).doubleValue();
            this.vdata[i] = Double.isNaN(v) ? this.getMissingValue() : v;
        }
    }

    public void setVdata(Array value) {
        this.vdata = new double[(int)value.getSize()];
        for (int i = 0; i < this.vdata.length; ++i) {
            double v = value.getDouble(i);
            this.vdata[i] = Double.isNaN(v) ? this.getMissingValue() : v;
        }
    }

    public boolean isUV() {
        return this.uv;
    }

    public void setUV(boolean value) {
        this.uv = value;
    }
}

