/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.dataframe.impl;

import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Years;
import org.meteoinfo.data.dataframe.impl.Function;

public class WindowFunction
implements Function<DateTime, Object> {
    ReadablePeriod period;

    public WindowFunction(ReadablePeriod period) {
        this.period = period;
    }

    public ReadablePeriod getPeriod() {
        return this.period;
    }

    @Override
    public Object apply(DateTime value) {
        DateTime ndt = new DateTime();
        if (this.period instanceof Seconds) {
            ndt = new DateTime(value.getYear(), value.getMonthOfYear(), value.getDayOfMonth(), value.getHourOfDay(), value.getMinuteOfHour(), 0);
        } else if (this.period instanceof Minutes) {
            ndt = new DateTime(value.getYear(), value.getMonthOfYear(), value.getDayOfMonth(), value.getHourOfDay(), 0, 0);
        } else if (this.period instanceof Hours) {
            ndt = new DateTime(value.getYear(), value.getMonthOfYear(), value.getDayOfMonth(), 0, 0, 0);
        } else if (this.period instanceof Days) {
            ndt = new DateTime(value.getYear(), value.getMonthOfYear(), 1, 0, 0, 0);
        } else if (this.period instanceof Months) {
            ndt = new DateTime(value.getYear(), 1, 1, 0, 0, 0);
        } else if (this.period instanceof Years) {
            int n = ((Years)this.period).getYears();
            ndt = new DateTime(value.getYear() - n, 1, 1, 0, 0, 0);
        }
        while (ndt.isBefore((ReadableInstant)value)) {
            ndt = ndt.plus(this.period);
        }
        if (ndt.isAfter((ReadableInstant)value)) {
            ndt = ndt.minus(this.period);
        }
        return ndt;
    }
}

