/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.mapdata;

import org.meteoinfo.data.DataTypes;
import org.meteoinfo.table.DataColumn;

public class Field
extends DataColumn {
    private int fieldLen;
    private int fieldNumDec = 0;

    public Field(String fName, DataTypes type, int fLen, int fNumDec) {
        this.setColumnName(fName);
        this.setDataType(type);
        this.fieldLen = fLen;
        this.fieldNumDec = fNumDec;
    }

    public Field(String fName, DataTypes type) {
        this.setColumnName(fName);
        this.setDataType(type);
        switch (type) {
            case String: {
                this.fieldLen = 255;
                break;
            }
            case Date: {
                this.fieldLen = 8;
                break;
            }
            case Float: {
                this.fieldLen = 18;
                this.fieldNumDec = 6;
                break;
            }
            case Double: {
                this.fieldLen = 18;
                this.fieldNumDec = 9;
                break;
            }
            case Decimal: {
                this.fieldLen = 18;
                this.fieldNumDec = 9;
                break;
            }
            case Integer: {
                this.fieldLen = 11;
                break;
            }
            case Boolean: {
                this.fieldLen = 1;
            }
        }
    }

    public Field(String fName, char fType, int fLen, int fNumDec) {
        this.setColumnName(fName);
        this.fieldLen = fLen;
        this.fieldNumDec = fNumDec;
        switch (fType) {
            case 'D': 
            case 'T': {
                this.setDataType(DataTypes.Date);
                break;
            }
            case 'L': {
                this.setDataType(DataTypes.Boolean);
                break;
            }
            case 'F': {
                this.setDataType(DataTypes.Float);
                break;
            }
            case 'N': {
                if (fNumDec == 0 && fLen <= 11) {
                    this.setDataType(DataTypes.Integer);
                    break;
                }
                this.setDataType(DataTypes.Double);
                break;
            }
            default: {
                this.setDataType(DataTypes.String);
            }
        }
    }

    public Field(DataColumn inColumn) {
        this(inColumn.getColumnName(), inColumn.getDataType());
        this.setup_decimalCount();
    }

    public int getLength() {
        return this.fieldLen;
    }

    public void setLength(int len) {
        this.fieldLen = len;
    }

    public int getDecimalCount() {
        return this.fieldNumDec;
    }

    public void setDecimalCount(int value) {
        this.fieldNumDec = value;
    }

    public char getTypeCharacter() {
        switch (this.getDataType()) {
            case Boolean: {
                return 'L';
            }
            case Date: {
                return 'D';
            }
            case Float: {
                return 'F';
            }
            case Double: 
            case Decimal: 
            case Integer: {
                return 'N';
            }
        }
        return 'C';
    }

    public boolean isNumeric() {
        switch (this.getDataType()) {
            case Float: 
            case Double: 
            case Decimal: 
            case Integer: {
                return true;
            }
        }
        return false;
    }

    private void setup_decimalCount() {
        switch (this.getDataType()) {
            case Float: {
                this.fieldLen = 18;
                this.fieldNumDec = 6;
                break;
            }
            case Double: {
                this.fieldLen = 18;
                this.fieldNumDec = 9;
                break;
            }
            case Decimal: {
                this.fieldNumDec = 9;
                this.fieldLen = 18;
                break;
            }
            case Integer: {
                this.fieldNumDec = 0;
                this.fieldLen = 11;
                break;
            }
            case String: {
                this.fieldNumDec = 0;
                this.fieldLen = 255;
                break;
            }
            case Date: {
                this.fieldNumDec = 0;
                this.fieldLen = 8;
            }
        }
    }
}

