/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.mapdata.webmap;

import org.meteoinfo.data.mapdata.webmap.TileFactoryInfo;

public class BingSatelliteMapInfo
extends TileFactoryInfo {
    private String version = "1173";
    private String clientKey = null;

    public BingSatelliteMapInfo() {
        super("BingSatelliteMap", 1, 17, 19, 256, true, true, "http://ecn.t%1$d.tiles.virtualearth.net/tiles/a%2$s.jpeg?g=%3$s&mkt=%4$s&n=z%5$s", "x", "y", "z");
    }

    @Override
    public String getTileUrl(int x, int y, int zoom) {
        zoom = this.getTotalMapZoom() - zoom;
        int serverNum = this.getServerNum(x, y, 4);
        String key = this.tileXYToQuadKey(x, y, zoom);
        String ckey = this.clientKey;
        if (ckey == null) {
            ckey = "";
        }
        String url = String.format(this.baseURL, serverNum, key, this.version, this.getLanguage(), zoom, x, y);
        return url;
    }

    private String tileXYToQuadKey(long tileX, long tileY, int levelOfDetail) {
        StringBuilder quadKey = new StringBuilder();
        for (int i = levelOfDetail; i > 0; --i) {
            char digit = '0';
            int mask = 1 << i - 1;
            if ((tileX & (long)mask) != 0L) {
                digit = (char)(digit + 1);
            }
            if ((tileY & (long)mask) != 0L) {
                digit = (char)(digit + 1);
                digit = (char)(digit + '\u0001');
            }
            quadKey.append(digit);
        }
        return quadKey.toString();
    }
}

