/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.hysplit;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.Dimension;
import org.meteoinfo.data.meteodata.DimensionType;
import org.meteoinfo.data.meteodata.IStationDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.StationInfoData;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.util.DateUtil;
import ucar.ma2.Array;
import ucar.nc2.Attribute;

public class HYSPLITPartDataInfo
extends DataInfo
implements IStationDataInfo {
    private List<List<Integer>> _parameters = new ArrayList<List<Integer>>();

    public HYSPLITPartDataInfo() {
        this.setDataType(MeteoDataType.HYSPLIT_Particle);
    }

    @Override
    public void readDataInfo(String fileName) {
        try {
            this.setFileName(fileName);
            RandomAccessFile br = new RandomAccessFile(fileName, "r");
            ArrayList<Date> times = new ArrayList<Date>();
            this._parameters = new ArrayList<List<Integer>>();
            while (br.getFilePointer() < br.length() - 28L) {
                int pos = (int)br.getFilePointer();
                br.skipBytes(4);
                int particleNum = br.readInt();
                int pollutantNum = br.readInt();
                int year = br.readInt();
                int month = br.readInt();
                int day = br.readInt();
                int hour = br.readInt();
                year = year < 50 ? 2000 + year : 1900 + year;
                GregorianCalendar cal = new GregorianCalendar(year, month - 1, day, hour, 0, 0);
                times.add(cal.getTime());
                ArrayList<Integer> data = new ArrayList<Integer>();
                data.add(particleNum);
                data.add(pollutantNum);
                data.add(pos);
                this._parameters.add(data);
                int len = (8 + pollutantNum * 4 + 60) * particleNum + 4;
                br.skipBytes(len);
            }
            br.close();
            ArrayList<Double> values = new ArrayList<Double>();
            for (Date t : times) {
                values.add(DateUtil.toOADate(t));
            }
            Dimension tDim = new Dimension(DimensionType.T);
            tDim.setValues(values);
            this.setTimeDimension(tDim);
            Variable var = new Variable();
            var.setStation(true);
            var.setName("Particle");
            ArrayList<Variable> variables = new ArrayList<Variable>();
            variables.add(var);
            this.setVariables(variables);
        }
        catch (IOException ex) {
            Logger.getLogger(HYSPLITPartDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        String dataInfo = "File Name: " + this.getFileName();
        List<Date> times = this.getTimes();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:00");
        for (int i = 0; i < this.getTimeNum(); ++i) {
            dataInfo = dataInfo + System.getProperty("line.separator") + "Time: " + format.format(times.get(i));
            dataInfo = dataInfo + System.getProperty("line.separator") + "\tParticle Number: " + this._parameters.get(i).get(0);
            dataInfo = dataInfo + System.getProperty("line.separator") + "\tPollutant Number: " + this._parameters.get(i).get(1);
        }
        return dataInfo;
    }

    @Override
    public Array read(String varName) {
        return null;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        return null;
    }

    @Override
    public StationData getStationData(int timeIdx, int varIdx, int levelIdx) {
        try {
            StationData stationData = new StationData();
            ArrayList<String> stations = new ArrayList<String>();
            int particleNum = this._parameters.get(timeIdx).get(0);
            int pollutantNum = this._parameters.get(timeIdx).get(1);
            int pos = this._parameters.get(timeIdx).get(2);
            double[][] discreteData = new double[particleNum][3];
            RandomAccessFile br = new RandomAccessFile(this.getFileName(), "r");
            float minX = 0.0f;
            float maxX = 0.0f;
            float minY = 0.0f;
            float maxY = 0.0f;
            br.seek(pos);
            br.skipBytes(28);
            for (int i = 0; i < particleNum; ++i) {
                br.skipBytes(8);
                for (int j = 0; j < pollutantNum; ++j) {
                    br.skipBytes(4);
                }
                br.skipBytes(8);
                float lat = br.readFloat();
                float lon = br.readFloat();
                float alt = br.readFloat();
                discreteData[i][0] = lon;
                discreteData[i][1] = lat;
                discreteData[i][2] = alt;
                stations.add("P" + String.valueOf(i + 1));
                br.skipBytes(40);
                if (i == 0) {
                    maxX = minX = lon;
                    maxY = minY = lat;
                    continue;
                }
                if (minX > lon) {
                    minX = lon;
                } else if (maxX < lon) {
                    maxX = lon;
                }
                if (minY > lat) {
                    minY = lat;
                    continue;
                }
                if (!(maxY < lat)) continue;
                maxY = lat;
            }
            Extent dataExtent = new Extent();
            dataExtent.minX = minX;
            dataExtent.maxX = maxX;
            dataExtent.minY = minY;
            dataExtent.maxY = maxY;
            br.close();
            stationData.data = discreteData;
            stationData.dataExtent = dataExtent;
            stationData.stations = stations;
            return stationData;
        }
        catch (IOException ex) {
            Logger.getLogger(HYSPLITPartDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public StationInfoData getStationInfoData(int timeIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public StationModelData getStationModelData(int timeIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

