/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.hysplit;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.DataTypes;
import org.meteoinfo.data.XYListDataset;
import org.meteoinfo.data.mapdata.Field;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.Dimension;
import org.meteoinfo.data.meteodata.DimensionType;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.TrajDataInfo;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.hysplit.TrajectoryInfo;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.global.util.DateUtil;
import org.meteoinfo.layer.LayerDrawType;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.LegendManage;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.LegendType;
import org.meteoinfo.legend.PointStyle;
import org.meteoinfo.legend.PolylineBreak;
import org.meteoinfo.shape.PointZ;
import org.meteoinfo.shape.PointZShape;
import org.meteoinfo.shape.PolylineZShape;
import org.meteoinfo.shape.ShapeTypes;
import org.meteoinfo.table.ColumnData;
import org.meteoinfo.table.DataColumn;
import org.meteoinfo.table.DataTable;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;

public class HYSPLITTrajDataInfo
extends DataInfo
implements TrajDataInfo {
    public Integer meteoFileNum;
    public int trajNum;
    private int endPointNum;
    public String trajDirection;
    public String verticalMotion;
    public List<TrajectoryInfo> trajInfos;
    public int varNum;
    public List<String> varNames;
    private String[] inVarNames;
    private List<DataTable> dataTables;

    public HYSPLITTrajDataInfo() {
        this.dataType = MeteoDataType.HYSPLIT_Traj;
        this.initVariables();
    }

    private void initVariables() {
        this.trajInfos = new ArrayList<TrajectoryInfo>();
        this.varNames = new ArrayList<String>();
        this.trajNum = 0;
        this.inVarNames = new String[]{"time", "run_hour", "lat", "lon", "height"};
    }

    public List<DataTable> getDataTables() {
        return this.dataTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readDataInfo(String fileName) {
        BufferedReader sr = null;
        try {
            int i;
            this.setFileName(fileName);
            this.initVariables();
            ArrayList<Double> times = new ArrayList<Double>();
            sr = new BufferedReader(new FileReader(new File(fileName)));
            String aLine = sr.readLine().trim();
            String[] dataArray = aLine.split("\\s+");
            this.meteoFileNum = Integer.parseInt(dataArray[0]);
            for (i = 0; i < this.meteoFileNum; ++i) {
                sr.readLine();
            }
            aLine = sr.readLine().trim();
            dataArray = aLine.split("\\s+");
            this.trajNum = Integer.parseInt(dataArray[0]);
            this.trajDirection = dataArray[1];
            this.verticalMotion = dataArray[2];
            for (i = 0; i < this.trajNum; ++i) {
                aLine = sr.readLine().trim();
                dataArray = aLine.split("\\s+");
                int y = Integer.parseInt(dataArray[0]);
                if (y < 100) {
                    y = y > 50 ? 1900 + y : 2000 + y;
                }
                GregorianCalendar cal = new GregorianCalendar(y, Integer.parseInt(dataArray[1]) - 1, Integer.parseInt(dataArray[2]), Integer.parseInt(dataArray[3]), 0, 0);
                if (times.isEmpty()) {
                    times.add(DateUtil.toOADate(cal.getTime()));
                }
                TrajectoryInfo aTrajInfo = new TrajectoryInfo();
                aTrajInfo.startTime = cal.getTime();
                aTrajInfo.startLat = Float.parseFloat(dataArray[4]);
                aTrajInfo.startLon = Float.parseFloat(dataArray[5]);
                aTrajInfo.startHeight = Float.parseFloat(dataArray[6]);
                this.trajInfos.add(aTrajInfo);
            }
            Dimension tdim = new Dimension(DimensionType.T);
            tdim.setValues(times);
            aLine = sr.readLine().trim();
            dataArray = aLine.split("\\s+");
            this.varNum = Integer.parseInt(dataArray[0]);
            if (this.varNum > dataArray.length - 1) {
                this.varNum = dataArray.length - 1;
            }
            for (i = 0; i < this.varNum; ++i) {
                this.varNames.add(dataArray[i + 1]);
            }
            sr.close();
            this.dataTables = this.readTable();
            this.endPointNum = 0;
            for (DataTable table : this.dataTables) {
                if (this.endPointNum >= table.getRowCount()) continue;
                this.endPointNum = table.getRowCount();
            }
            Dimension trajDim = new Dimension(DimensionType.Other);
            trajDim.setName("trajectory");
            trajDim.setDimLength(this.trajNum);
            this.addDimension(trajDim);
            Dimension obsDim = new Dimension(DimensionType.Other);
            obsDim.setName("obs");
            obsDim.setDimLength(this.endPointNum);
            this.addDimension(obsDim);
            for (String vName : this.inVarNames) {
                Variable var = new Variable();
                var.setName(vName);
                var.addDimension(trajDim);
                var.addDimension(obsDim);
                var.addAttribute("long_name", vName);
                this.addVariable(var);
            }
            for (String vName : this.varNames) {
                Variable var = new Variable();
                var.setName(vName);
                var.addDimension(trajDim);
                var.addDimension(obsDim);
                var.addAttribute("long_name", vName);
                var.setStation(true);
                this.addVariable(var);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (sr != null) {
                    sr.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        String dataInfo = "";
        dataInfo = dataInfo + "File Name: " + this.getFileName();
        dataInfo = dataInfo + System.getProperty("line.separator") + "Trajectory number = " + String.valueOf(this.trajNum);
        dataInfo = dataInfo + System.getProperty("line.separator") + "Trajectory direction = " + this.trajDirection;
        dataInfo = dataInfo + System.getProperty("line.separator") + "Vertical motion =" + this.verticalMotion;
        dataInfo = dataInfo + System.getProperty("line.separator") + "Number of diagnostic output variables = " + String.valueOf(this.varNum);
        dataInfo = dataInfo + System.getProperty("line.separator") + "Variables:";
        for (int i = 0; i < this.varNum; ++i) {
            dataInfo = dataInfo + " " + this.varNames.get(i);
        }
        dataInfo = dataInfo + System.getProperty("line.separator") + System.getProperty("line.separator") + "Trajectories:";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:00");
        for (TrajectoryInfo aTrajInfo : this.trajInfos) {
            dataInfo = dataInfo + System.getProperty("line.separator") + "  " + format.format(aTrajInfo.startTime) + "  " + String.valueOf(aTrajInfo.startLat) + "  " + String.valueOf(aTrajInfo.startLon) + "  " + String.valueOf(aTrajInfo.startHeight);
        }
        dataInfo = dataInfo + System.getProperty("line.separator") + super.generateInfoText();
        return dataInfo;
    }

    @Override
    public Array read(String varName) {
        int[] origin = new int[]{0, 0};
        int[] size = new int[]{this.trajNum, this.endPointNum};
        int[] stride = new int[]{1, 1};
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        try {
            DataColumn col = this.dataTables.get(0).findColumn(varName);
            DataType dtype = DataType.FLOAT;
            switch (col.getDataType()) {
                case Date: {
                    dtype = DataType.DOUBLE;
                    break;
                }
                case Integer: {
                    dtype = DataType.INT;
                }
            }
            Section section = new Section(origin, size, stride);
            Array array = Array.factory((DataType)dtype, (int[])section.getShape());
            Range trajRange = section.getRange(0);
            Range obsRange = section.getRange(1);
            Index index = array.getIndex();
            for (int trajIdx = trajRange.first(); trajIdx <= trajRange.last(); trajIdx += trajRange.stride()) {
                DataTable dTable = this.dataTables.get(trajIdx);
                ColumnData colData = dTable.getColumnData(varName);
                for (int obsIdx = obsRange.first(); obsIdx <= obsRange.last(); obsIdx += obsRange.stride()) {
                    if (colData.size() > obsIdx) {
                        if (col.getDataType() == DataTypes.Date) {
                            array.setObject(index, (Object)DateUtil.toOADate((Date)colData.getValue(obsIdx)));
                        } else {
                            array.setObject(index, colData.getValue(obsIdx));
                        }
                    } else {
                        array.setObject(index, (Object)Double.NaN);
                    }
                    index.incr();
                }
            }
            return array;
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public VectorLayer createTrajLineLayer() {
        return this.createTrajLineLayer(false);
    }

    public VectorLayer createTrajLineLayer(boolean zPres) {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.PolylineZ);
        aLayer.editAddField("ID", DataTypes.Integer);
        aLayer.editAddField("Date", DataTypes.Date);
        aLayer.editAddField("Year", DataTypes.Integer);
        aLayer.editAddField("Month", DataTypes.Integer);
        aLayer.editAddField("Day", DataTypes.Integer);
        aLayer.editAddField("Hour", DataTypes.Integer);
        aLayer.editAddField("Height", DataTypes.Float);
        Calendar cal = Calendar.getInstance();
        int TrajNum = 0;
        try {
            String aLine;
            int i;
            BufferedReader sr = new BufferedReader(new FileReader(new File(this.getFileName())));
            sr.readLine();
            for (i = 0; i < this.meteoFileNum; ++i) {
                sr.readLine();
            }
            sr.readLine();
            for (i = 0; i < this.trajNum; ++i) {
                sr.readLine();
            }
            sr.readLine();
            ArrayList PointList = new ArrayList();
            for (i = 0; i < this.trajNum; ++i) {
                ArrayList pList = new ArrayList();
                PointList.add(pList);
            }
            int dn = 12 + this.varNum;
            while ((aLine = sr.readLine()) != null) {
                if (aLine.isEmpty()) continue;
                String[] dataArray = (aLine = aLine.trim()).split("\\s+");
                if (dataArray.length < dn) {
                    sr.readLine();
                }
                int TrajIdx = Integer.parseInt(dataArray[0]) - 1;
                PointZ aPoint = new PointZ();
                aPoint.X = Double.parseDouble(dataArray[10]);
                aPoint.Y = Double.parseDouble(dataArray[9]);
                if (dataArray.length >= 13) {
                    if (zPres) {
                        aPoint.M = Double.parseDouble(dataArray[11]);
                        aPoint.Z = Double.parseDouble(dataArray[12]);
                    } else {
                        aPoint.M = Double.parseDouble(dataArray[12]);
                        aPoint.Z = Double.parseDouble(dataArray[11]);
                    }
                } else {
                    aPoint.Z = Double.parseDouble(dataArray[11]);
                }
                if (((List)PointList.get(TrajIdx)).size() > 1) {
                    PointZ oldPoint = (PointZ)((List)PointList.get(TrajIdx)).get(((List)PointList.get(TrajIdx)).size() - 1);
                    if (Math.abs(aPoint.X - oldPoint.X) > 100.0) {
                        aPoint.X = aPoint.X > oldPoint.X ? (aPoint.X -= 360.0) : (aPoint.X += 360.0);
                    }
                }
                ((List)PointList.get(TrajIdx)).add(aPoint);
            }
            for (i = 0; i < this.trajNum; ++i) {
                PolylineZShape aPolyline = new PolylineZShape();
                aPolyline.setValue(++TrajNum);
                aPolyline.setPoints((List)PointList.get(i));
                aPolyline.setExtent(MIMath.getPointsExtent(aPolyline.getPoints()));
                int shapeNum = aLayer.getShapeNum();
                if (!aLayer.editInsertShape(aPolyline, shapeNum)) continue;
                cal.setTime(this.trajInfos.get((int)i).startTime);
                aLayer.editCellValue("ID", shapeNum, (Object)TrajNum);
                aLayer.editCellValue("Date", shapeNum, (Object)cal.getTime());
                aLayer.editCellValue("Year", shapeNum, (Object)cal.get(1));
                aLayer.editCellValue("Month", shapeNum, (Object)(cal.get(2) + 1));
                aLayer.editCellValue("Day", shapeNum, (Object)cal.get(5));
                aLayer.editCellValue("Hour", shapeNum, (Object)cal.get(11));
                aLayer.editCellValue("Height", shapeNum, (Object)Float.valueOf(this.trajInfos.get((int)i).startHeight));
            }
            sr.close();
        }
        catch (IOException ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        aLayer.setLayerName("Trajectory_Lines");
        aLayer.setLayerDrawType(LayerDrawType.TrajLine);
        aLayer.setVisible(true);
        aLayer.updateLegendScheme(LegendType.UniqueValue, "ID");
        LegendScheme ls = aLayer.getLegendScheme();
        int i = 0;
        for (ColorBreak cb : ls.getLegendBreaks()) {
            PolylineBreak plb = (PolylineBreak)cb;
            plb.setDrawSymbol(true);
            plb.setSymbolFillColor(plb.getSymbolColor());
            plb.setSymbolInterval(6);
            plb.setWidth(2.0f);
            if (i == PointStyle.values().length) {
                i = 0;
            }
            plb.setSymbolStyle(PointStyle.values()[i]);
            ++i;
        }
        return aLayer;
    }

    public List<DataTable> readTable() throws Exception {
        ArrayList<DataTable> tables = new ArrayList<DataTable>();
        for (int i = 0; i < this.trajNum; ++i) {
            DataTable table = new DataTable();
            table.addColumn("time", DataTypes.Date);
            table.addColumn("run_hour", DataTypes.Float);
            table.addColumn("lat", DataTypes.Float);
            table.addColumn("lon", DataTypes.Float);
            table.addColumn("height", DataTypes.Float);
            for (String vName : this.varNames) {
                table.addColumn(vName, DataTypes.Float);
            }
            tables.add(table);
        }
        try {
            String aLine;
            int i;
            BufferedReader sr = new BufferedReader(new FileReader(new File(this.getFileName())));
            sr.readLine();
            for (i = 0; i < this.meteoFileNum; ++i) {
                sr.readLine();
            }
            sr.readLine();
            for (i = 0; i < this.trajNum; ++i) {
                sr.readLine();
            }
            sr.readLine();
            int dn = 12 + this.varNum;
            while ((aLine = sr.readLine()) != null) {
                if (aLine.isEmpty()) continue;
                String[] dataArray = (aLine = aLine.trim()).split("\\s+");
                if (dataArray.length < dn) {
                    aLine = sr.readLine().trim();
                    String[] tempArray = aLine.split("\\s+");
                    dataArray = (String[])DataConvert.resizeArray(dataArray, dn);
                    for (i = 0; i < tempArray.length; ++i) {
                        dataArray[dn - tempArray.length + i] = tempArray[i];
                    }
                }
                int trajIdx = Integer.parseInt(dataArray[0]) - 1;
                DataTable table = (DataTable)tables.get(trajIdx);
                table.addRow();
                int rowIdx = table.getRowCount() - 1;
                int y = Integer.parseInt(dataArray[2]);
                if (y < 100) {
                    y = y > 50 ? 1900 + y : 2000 + y;
                }
                GregorianCalendar cal = new GregorianCalendar(y, Integer.parseInt(dataArray[3]) - 1, Integer.parseInt(dataArray[4]), Integer.parseInt(dataArray[5]), 0, 0);
                table.setValue(rowIdx, "time", (Object)cal.getTime());
                table.setValue(rowIdx, "run_hour", (Object)Float.valueOf(Float.parseFloat(dataArray[8])));
                table.setValue(rowIdx, "lat", (Object)Float.valueOf(Float.parseFloat(dataArray[9])));
                table.setValue(rowIdx, "lon", (Object)Float.valueOf(Float.parseFloat(dataArray[10])));
                table.setValue(rowIdx, "height", (Object)Float.valueOf(Float.parseFloat(dataArray[11])));
                for (i = 12; i < dataArray.length; ++i) {
                    table.setValue(rowIdx, i - 7, (Object)Float.valueOf(Float.parseFloat(dataArray[i])));
                }
            }
            sr.close();
        }
        catch (IOException ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return tables;
    }

    @Override
    public VectorLayer createTrajPointLayer() {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Point);
        aLayer.editAddField(new Field("TrajID", DataTypes.Integer));
        aLayer.editAddField(new Field("Date", DataTypes.String));
        aLayer.editAddField(new Field("Lon", DataTypes.Double));
        aLayer.editAddField(new Field("Lat", DataTypes.Double));
        aLayer.editAddField(new Field("Altitude", DataTypes.Double));
        aLayer.editAddField(new Field("Pressure", DataTypes.Double));
        boolean isMultiVar = false;
        if (this.varNum > 1) {
            isMultiVar = true;
            for (int v = 1; v < this.varNum; ++v) {
                aLayer.editAddField(new Field(this.varNames.get(v), DataTypes.Double));
            }
        }
        int TrajNum = 0;
        try {
            String aLine;
            int i;
            BufferedReader sr = new BufferedReader(new FileReader(new File(this.getFileName())));
            sr.readLine();
            for (i = 0; i < this.meteoFileNum; ++i) {
                sr.readLine();
            }
            sr.readLine();
            for (i = 0; i < this.trajNum; ++i) {
                sr.readLine();
            }
            sr.readLine();
            ArrayList PointList = new ArrayList();
            for (i = 0; i < this.trajNum; ++i) {
                ArrayList pList = new ArrayList();
                PointList.add(pList);
            }
            int dn = 12 + this.varNum;
            while ((aLine = sr.readLine()) != null) {
                if (aLine.isEmpty()) continue;
                String[] dataArray = (aLine = aLine.trim()).split("\\s+");
                if (dataArray.length < dn) {
                    aLine = sr.readLine().trim();
                    String[] tempArray = aLine.split("\\s+");
                    dataArray = (String[])DataConvert.resizeArray(dataArray, dn);
                    for (i = 0; i < tempArray.length; ++i) {
                        dataArray[dn - tempArray.length + i] = tempArray[i];
                    }
                }
                ArrayList<Object> dList = new ArrayList<Object>();
                int TrajIdx = Integer.parseInt(dataArray[0]) - 1;
                int y = Integer.parseInt(dataArray[2]);
                if (y < 100) {
                    y = y > 50 ? 1900 + y : 2000 + y;
                }
                GregorianCalendar cal = new GregorianCalendar(y, Integer.parseInt(dataArray[3]) - 1, Integer.parseInt(dataArray[4]), Integer.parseInt(dataArray[5]), 0, 0);
                PointZ aPoint = new PointZ();
                aPoint.X = Double.parseDouble(dataArray[10]);
                aPoint.Y = Double.parseDouble(dataArray[9]);
                double Height = Double.parseDouble(dataArray[11]);
                double Press = Double.parseDouble(dataArray[12]);
                aPoint.Z = Height;
                aPoint.M = Press;
                dList.add(aPoint);
                dList.add(cal.getTime());
                dList.add(Height);
                dList.add(Press);
                if (isMultiVar) {
                    for (i = 13; i < dataArray.length; ++i) {
                        dList.add(Double.parseDouble(dataArray[i]));
                    }
                }
                ((List)PointList.get(TrajIdx)).add(dList);
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHH");
            for (i = 0; i < this.trajNum; ++i) {
                ++TrajNum;
                for (int j = 0; j < ((List)PointList.get(i)).size(); ++j) {
                    PointZShape aPS = new PointZShape();
                    aPS.setValue(TrajNum);
                    aPS.setPoint((PointD)((List)((List)PointList.get(i)).get(j)).get(0));
                    int shapeNum = aLayer.getShapeNum();
                    if (!aLayer.editInsertShape(aPS, shapeNum)) continue;
                    aLayer.editCellValue("TrajID", shapeNum, (Object)TrajNum);
                    aLayer.editCellValue("Date", shapeNum, (Object)format.format((Date)((List)((List)PointList.get(i)).get(j)).get(1)));
                    aLayer.editCellValue("Lat", shapeNum, (Object)aPS.getPoint().Y);
                    aLayer.editCellValue("Lon", shapeNum, (Object)aPS.getPoint().X);
                    aLayer.editCellValue("Altitude", shapeNum, ((List)((List)PointList.get(i)).get(j)).get(2));
                    aLayer.editCellValue("Pressure", shapeNum, ((List)((List)PointList.get(i)).get(j)).get(3));
                    if (!isMultiVar) continue;
                    for (int v = 1; v < this.varNum; ++v) {
                        aLayer.editCellValue(this.varNames.get(v), shapeNum, ((List)((List)PointList.get(i)).get(j)).get(3 + v));
                    }
                }
            }
            sr.close();
        }
        catch (IOException ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        aLayer.setLayerName("Trajectory_Points");
        aLayer.setLayerDrawType(LayerDrawType.TrajLine);
        aLayer.setVisible(true);
        LegendScheme aLS = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Point, Color.red, 5.0f);
        aLS.setFieldName("TrajID");
        aLayer.setLegendScheme(aLS);
        return aLayer;
    }

    @Override
    public VectorLayer createTrajStartPointLayer() {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.PointZ);
        aLayer.editAddField(new Field("TrajID", DataTypes.Integer));
        aLayer.editAddField(new Field("StartDate", DataTypes.String));
        aLayer.editAddField(new Field("StartLon", DataTypes.Double));
        aLayer.editAddField(new Field("StartLat", DataTypes.Double));
        aLayer.editAddField(new Field("StartHeight", DataTypes.Double));
        int TrajNum = 0;
        try {
            String aLine;
            int i;
            BufferedReader sr = new BufferedReader(new FileReader(new File(this.getFileName())));
            sr.readLine();
            for (i = 0; i < this.meteoFileNum; ++i) {
                sr.readLine();
            }
            sr.readLine();
            for (i = 0; i < this.trajNum; ++i) {
                sr.readLine();
            }
            sr.readLine();
            ArrayList<PointZ> PointList = new ArrayList<PointZ>();
            PointZ aPoint = new PointZ();
            for (i = 0; i < this.trajNum; ++i) {
                PointList.add(aPoint);
            }
            int dn = 12 + this.varNum;
            while ((aLine = sr.readLine()) != null) {
                if (aLine.isEmpty()) continue;
                String[] dataArray = (aLine = aLine.trim()).split("\\s+");
                if (dataArray.length < dn) {
                    sr.readLine();
                }
                if (Float.parseFloat(dataArray[8]) != 0.0f) continue;
                int TrajIdx = Integer.parseInt(dataArray[0]) - 1;
                aPoint = new PointZ();
                aPoint.X = Double.parseDouble(dataArray[10]);
                aPoint.Y = Double.parseDouble(dataArray[9]);
                aPoint.Z = Double.parseDouble(dataArray[11]);
                aPoint.M = Double.parseDouble(dataArray[12]);
                PointList.set(TrajIdx, aPoint);
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHH");
            for (i = 0; i < this.trajNum; ++i) {
                PointZShape aPS = new PointZShape();
                aPS.setValue(++TrajNum);
                aPS.setPoint((PointZ)PointList.get(i));
                int shapeNum = aLayer.getShapeNum();
                if (!aLayer.editInsertShape(aPS, shapeNum)) continue;
                aLayer.editCellValue("TrajID", shapeNum, (Object)TrajNum);
                aLayer.editCellValue("StartDate", shapeNum, (Object)format.format(this.trajInfos.get((int)i).startTime));
                aLayer.editCellValue("StartLat", shapeNum, (Object)Float.valueOf(this.trajInfos.get((int)i).startLat));
                aLayer.editCellValue("StartLon", shapeNum, (Object)Float.valueOf(this.trajInfos.get((int)i).startLon));
                aLayer.editCellValue("StartHeight", shapeNum, (Object)Float.valueOf(this.trajInfos.get((int)i).startHeight));
            }
            sr.close();
        }
        catch (IOException ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        aLayer.setLayerName("Trajectory_Start_Points");
        aLayer.setLayerDrawType(LayerDrawType.TrajPoint);
        aLayer.setVisible(true);
        LegendScheme aLS = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Point, Color.black, 8.0f);
        aLS.setFieldName("TrajID");
        aLayer.setLegendScheme(aLS);
        return aLayer;
    }

    public XYListDataset getXYDataset(int varIndex) {
        XYListDataset dataset = new XYListDataset();
        Calendar cal = Calendar.getInstance();
        try {
            String aLine;
            int i;
            BufferedReader sr = new BufferedReader(new FileReader(new File(this.getFileName())));
            sr.readLine();
            for (i = 0; i < this.meteoFileNum; ++i) {
                sr.readLine();
            }
            sr.readLine();
            for (i = 0; i < this.trajNum; ++i) {
                sr.readLine();
            }
            sr.readLine();
            ArrayList PointList = new ArrayList();
            for (i = 0; i < this.trajNum; ++i) {
                ArrayList pList = new ArrayList();
                PointList.add(pList);
            }
            int dn = 12 + this.varNum;
            while ((aLine = sr.readLine()) != null) {
                if (aLine.isEmpty()) continue;
                String[] dataArray = (aLine = aLine.trim()).split("\\s+");
                if (dataArray.length < dn) {
                    aLine = sr.readLine().trim();
                    String[] tempArray = aLine.split("\\s+");
                    dataArray = (String[])DataConvert.resizeArray(dataArray, dn);
                    for (i = 0; i < tempArray.length; ++i) {
                        dataArray[dn - tempArray.length + i] = tempArray[i];
                    }
                }
                int TrajIdx = Integer.parseInt(dataArray[0]) - 1;
                int y = Integer.parseInt(dataArray[2]);
                if (y < 100) {
                    y = y > 50 ? 1900 + y : 2000 + y;
                }
                cal.set(y, Integer.parseInt(dataArray[3]) - 1, Integer.parseInt(dataArray[4]), Integer.parseInt(dataArray[5]), 0, 0);
                PointD aPoint = new PointD();
                aPoint.X = DateUtil.toOADate(cal.getTime());
                aPoint.Y = Double.parseDouble(dataArray[varIndex]);
                ((List)PointList.get(TrajIdx)).add(aPoint);
            }
            for (i = 0; i < this.trajNum; ++i) {
                int n = ((List)PointList.get(i)).size();
                double[] xvs = new double[n];
                double[] yvs = new double[n];
                for (int j = 0; j < n; ++j) {
                    xvs[j] = ((PointD)((List)PointList.get((int)i)).get((int)j)).X;
                    yvs[j] = ((PointD)((List)PointList.get((int)i)).get((int)j)).Y;
                }
                dataset.addSeries("Traj_" + String.valueOf(this.trajNum), xvs, yvs);
            }
            sr.close();
        }
        catch (IOException | NumberFormatException ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return dataset;
    }

    public XYListDataset getXYDataset_HourX(int varIndex) {
        XYListDataset dataset = new XYListDataset();
        Calendar cal = Calendar.getInstance();
        try {
            String aLine;
            int i;
            BufferedReader sr = new BufferedReader(new FileReader(new File(this.getFileName())));
            sr.readLine();
            for (i = 0; i < this.meteoFileNum; ++i) {
                sr.readLine();
            }
            sr.readLine();
            for (i = 0; i < this.trajNum; ++i) {
                sr.readLine();
            }
            sr.readLine();
            ArrayList PointList = new ArrayList();
            for (i = 0; i < this.trajNum; ++i) {
                ArrayList pList = new ArrayList();
                PointList.add(pList);
            }
            int dn = 12 + this.varNum;
            while ((aLine = sr.readLine()) != null) {
                if (aLine.isEmpty()) continue;
                String[] dataArray = (aLine = aLine.trim()).split("\\s+");
                if (dataArray.length < dn) {
                    aLine = sr.readLine().trim();
                    String[] tempArray = aLine.split("\\s+");
                    dataArray = (String[])DataConvert.resizeArray(dataArray, dn);
                    for (i = 0; i < tempArray.length; ++i) {
                        dataArray[dn - tempArray.length + i] = tempArray[i];
                    }
                }
                int TrajIdx = Integer.parseInt(dataArray[0]) - 1;
                int y = Integer.parseInt(dataArray[2]);
                if (y < 100) {
                    y = y > 50 ? 1900 + y : 2000 + y;
                }
                cal.set(y, Integer.parseInt(dataArray[3]) - 1, Integer.parseInt(dataArray[4]), Integer.parseInt(dataArray[5]), 0, 0);
                PointD aPoint = new PointD();
                aPoint.X = DateUtil.toOADate(cal.getTime());
                aPoint.Y = Double.parseDouble(dataArray[varIndex]);
                ((List)PointList.get(TrajIdx)).add(aPoint);
            }
            for (i = 0; i < this.trajNum; ++i) {
                int n = ((List)PointList.get(i)).size();
                double[] xvs = new double[n];
                double[] yvs = new double[n];
                Date sdate = new Date();
                for (int j = 0; j < n; ++j) {
                    Date cdate = DateUtil.fromOADate(((PointD)((List)PointList.get((int)i)).get((int)j)).X);
                    if (j == 0) {
                        sdate = cdate;
                        xvs[j] = 0.0;
                    } else {
                        xvs[j] = DateUtil.getHours(cdate, sdate);
                    }
                    yvs[j] = ((PointD)((List)PointList.get((int)i)).get((int)j)).Y;
                }
                dataset.addSeries("Traj_" + String.valueOf(this.trajNum), xvs, yvs);
            }
            sr.close();
        }
        catch (IOException | NumberFormatException ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return dataset;
    }
}

