/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.micaps;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.DataTypes;
import org.meteoinfo.data.mapdata.Field;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.Dimension;
import org.meteoinfo.data.meteodata.DimensionType;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.TrajDataInfo;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.hysplit.TrajectoryInfo;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.global.util.DateUtil;
import org.meteoinfo.layer.LayerDrawType;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.legend.LegendManage;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.LegendType;
import org.meteoinfo.shape.PointShape;
import org.meteoinfo.shape.PolylineShape;
import org.meteoinfo.shape.ShapeTypes;
import ucar.ma2.Array;
import ucar.nc2.Attribute;

public class MICAPS7DataInfo
extends DataInfo
implements TrajDataInfo {
    public List<String> FileNames;
    public List<Integer> MeteoFileNums;
    public int TrajeoryNumber;
    public List<Integer> TrajeoryNums;
    public List<String> TrajDirections;
    public List<String> VerticalMotions;
    public List<List<TrajectoryInfo>> TrajInfos;
    public List<Integer> VarNums;
    public List<List<String>> VarNames;

    public MICAPS7DataInfo() {
        this.setDataType(MeteoDataType.MICAPS_7);
        this.initVariables();
    }

    private void initVariables() {
        this.FileNames = new ArrayList<String>();
        this.MeteoFileNums = new ArrayList<Integer>();
        this.TrajeoryNums = new ArrayList<Integer>();
        this.TrajDirections = new ArrayList<String>();
        this.VerticalMotions = new ArrayList<String>();
        this.TrajInfos = new ArrayList<List<TrajectoryInfo>>();
        this.VarNums = new ArrayList<Integer>();
        this.VarNames = new ArrayList<List<String>>();
        this.TrajeoryNumber = 0;
    }

    @Override
    public void readDataInfo(String fileName) {
        String[] trajFiles = new String[]{fileName};
        try {
            this.readDataInfo(trajFiles);
        }
        catch (IOException ex) {
            Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void readDataInfo(String[] trajFiles) throws IOException {
        this.setFileName(trajFiles[0]);
        this.initVariables();
        ArrayList<Double> times = new ArrayList<Double>();
        for (int t = 0; t < trajFiles.length; ++t) {
            String aFile = trajFiles[t];
            this.FileNames.add(aFile);
            BufferedReader sr = new BufferedReader(new FileReader(new File(aFile)));
            TrajectoryInfo aTrajInfo = new TrajectoryInfo();
            ArrayList<TrajectoryInfo> trajInfoList = new ArrayList<TrajectoryInfo>();
            sr.readLine();
            String aLine = sr.readLine();
            int trajIdx = -1;
            int trajNum = 0;
            while (aLine != null) {
                if (aLine.trim().isEmpty()) {
                    aLine = sr.readLine();
                    continue;
                }
                String[] dataArray = aLine.split("\\s+");
                if (dataArray.length == 4) {
                    aTrajInfo = new TrajectoryInfo();
                    aTrajInfo.trajName = dataArray[0];
                    aTrajInfo.trajID = dataArray[1];
                    aTrajInfo.trajCenter = dataArray[2];
                    trajIdx = -1;
                    ++trajNum;
                } else if (dataArray.length == 13 && ++trajIdx == 0) {
                    int year = Integer.parseInt(dataArray[0]);
                    if (year < 100) {
                        year = year < 50 ? 2000 + year : 1900 + year;
                    }
                    GregorianCalendar cal = new GregorianCalendar(year, Integer.parseInt(dataArray[1]) - 1, Integer.parseInt(dataArray[2]), Integer.parseInt(dataArray[3]), 0, 0);
                    if (times.isEmpty()) {
                        times.add(DateUtil.toOADate(cal.getTime()));
                    }
                    aTrajInfo.startTime = cal.getTime();
                    aTrajInfo.startLat = Float.parseFloat(dataArray[6]);
                    aTrajInfo.startLon = Float.parseFloat(dataArray[5]);
                    trajInfoList.add(aTrajInfo);
                }
                aLine = sr.readLine();
            }
            this.TrajeoryNums.add(trajNum);
            this.TrajeoryNumber += this.TrajeoryNums.get(t).intValue();
            this.TrajInfos.add(trajInfoList);
            Dimension tdim = new Dimension(DimensionType.T);
            tdim.setValues(times);
            this.setTimeDimension(tdim);
            sr.close();
            Variable var = new Variable();
            var.setName("Traj");
            var.setStation(true);
            var.setDimension(tdim);
            ArrayList<Variable> variables = new ArrayList<Variable>();
            variables.add(var);
            this.setVariables(variables);
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        String dataInfo = "";
        for (int t = 0; t < this.FileNames.size(); ++t) {
            dataInfo = dataInfo + "File Name: " + this.FileNames.get(t);
            dataInfo = dataInfo + System.getProperty("line.separator") + "Typhoon number = " + String.valueOf(this.TrajeoryNums.get(t));
            dataInfo = dataInfo + System.getProperty("line.separator") + System.getProperty("line.separator") + "Typhoons:";
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:00");
            for (TrajectoryInfo aTrajInfo : this.TrajInfos.get(t)) {
                dataInfo = dataInfo + System.getProperty("line.separator") + "  " + aTrajInfo.trajName + " " + aTrajInfo.trajID + " " + aTrajInfo.trajCenter + " " + format.format(aTrajInfo.startTime) + "  " + String.valueOf(aTrajInfo.startLat) + "  " + String.valueOf(aTrajInfo.startLon) + "  " + String.valueOf(aTrajInfo.startHeight);
            }
            if (t >= this.FileNames.size() - 1) continue;
            dataInfo = dataInfo + System.getProperty("line.separator") + System.getProperty("line.separator") + "******************************" + System.getProperty("line.separator");
        }
        return dataInfo;
    }

    @Override
    public Array read(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VectorLayer createTrajLineLayer() {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Polyline);
        aLayer.editAddField(new Field("TrajIndex", DataTypes.Integer));
        aLayer.editAddField(new Field("TrajName", DataTypes.String));
        aLayer.editAddField(new Field("TrajID", DataTypes.String));
        aLayer.editAddField(new Field("TrajCenter", DataTypes.String));
        aLayer.editAddField(new Field("StartDate", DataTypes.String));
        aLayer.editAddField(new Field("StartLon", DataTypes.Double));
        aLayer.editAddField(new Field("StartLat", DataTypes.Double));
        aLayer.editAddField(new Field("StartHeight", DataTypes.Double));
        int TrajNum = 0;
        for (int t = 0; t < this.FileNames.size(); ++t) {
            BufferedReader sr = null;
            try {
                int i;
                String aFile = this.FileNames.get(t);
                sr = new BufferedReader(new FileReader(new File(aFile)));
                int TrajIdx = -1;
                ArrayList PointList = new ArrayList();
                for (i = 0; i < this.TrajeoryNums.get(t); ++i) {
                    ArrayList pList = new ArrayList();
                    PointList.add(pList);
                }
                sr.readLine();
                String aLine = sr.readLine();
                while (aLine != null) {
                    if (aLine.trim().isEmpty()) {
                        aLine = sr.readLine();
                        continue;
                    }
                    String[] dataArray = aLine.split("\\s+");
                    if (dataArray.length == 4) {
                        ++TrajIdx;
                    } else if (dataArray.length == 13) {
                        PointD aPoint = new PointD();
                        aPoint.X = Double.parseDouble(dataArray[5]);
                        aPoint.Y = Double.parseDouble(dataArray[6]);
                        ((List)PointList.get(TrajIdx)).add(aPoint);
                    }
                    aLine = sr.readLine();
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHH");
                for (i = 0; i < this.TrajeoryNums.get(t); ++i) {
                    PolylineShape aPolyline = new PolylineShape();
                    aPolyline.setValue(++TrajNum);
                    aPolyline.setPoints((List)PointList.get(i));
                    aPolyline.setExtent(MIMath.getPointsExtent(aPolyline.getPoints()));
                    int shapeNum = aLayer.getShapeNum();
                    if (!aLayer.editInsertShape(aPolyline, shapeNum)) continue;
                    aLayer.editCellValue("TrajIndex", shapeNum, (Object)TrajNum);
                    aLayer.editCellValue("TrajName", shapeNum, (Object)this.TrajInfos.get((int)t).get((int)i).trajName);
                    aLayer.editCellValue("TrajID", shapeNum, (Object)this.TrajInfos.get((int)t).get((int)i).trajID);
                    aLayer.editCellValue("TrajCenter", shapeNum, (Object)this.TrajInfos.get((int)t).get((int)i).trajCenter);
                    aLayer.editCellValue("StartDate", shapeNum, (Object)format.format(this.TrajInfos.get((int)t).get((int)i).startTime));
                    aLayer.editCellValue("StartLat", shapeNum, (Object)Float.valueOf(this.TrajInfos.get((int)t).get((int)i).startLat));
                    aLayer.editCellValue("StartLon", shapeNum, (Object)Float.valueOf(this.TrajInfos.get((int)t).get((int)i).startLon));
                    aLayer.editCellValue("StartHeight", shapeNum, (Object)Float.valueOf(this.TrajInfos.get((int)t).get((int)i).startHeight));
                }
                sr.close();
                continue;
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            finally {
                try {
                    sr.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        aLayer.setLayerName("Typhoon_Lines");
        aLayer.setLayerDrawType(LayerDrawType.TrajLine);
        aLayer.setVisible(true);
        aLayer.updateLegendScheme(LegendType.UniqueValue, "TrajID");
        return aLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VectorLayer createTrajPointLayer() {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Point);
        aLayer.editAddField(new Field("TrajID", DataTypes.Integer));
        aLayer.editAddField(new Field("Date", DataTypes.String));
        aLayer.editAddField(new Field("PreHour", DataTypes.Integer));
        aLayer.editAddField(new Field("Lon", DataTypes.Double));
        aLayer.editAddField(new Field("Lat", DataTypes.Double));
        aLayer.editAddField(new Field("WindSpeed", DataTypes.Double));
        aLayer.editAddField(new Field("Radius_W7", DataTypes.Double));
        aLayer.editAddField(new Field("Radius_W10", DataTypes.Double));
        aLayer.editAddField(new Field("MoveDir", DataTypes.Double));
        aLayer.editAddField(new Field("MoveSpeed", DataTypes.Double));
        int TrajNum = 0;
        for (int t = 0; t < this.FileNames.size(); ++t) {
            BufferedReader sr = null;
            try {
                int i;
                String aFile = this.FileNames.get(t);
                sr = new BufferedReader(new FileReader(new File(aFile)));
                int TrajIdx = -1;
                ArrayList PointList = new ArrayList();
                for (i = 0; i < this.TrajeoryNums.get(t); ++i) {
                    ArrayList pList = new ArrayList();
                    PointList.add(pList);
                }
                sr.readLine();
                String aLine = sr.readLine();
                while (aLine != null) {
                    if (aLine.trim().isEmpty()) {
                        aLine = sr.readLine();
                        continue;
                    }
                    String[] dataArray = aLine.split("\\s+");
                    if (dataArray.length == 4) {
                        ++TrajIdx;
                    } else if (dataArray.length == 13) {
                        ArrayList<Object> dList = new ArrayList<Object>();
                        GregorianCalendar cal = new GregorianCalendar(Integer.parseInt(dataArray[0]), Integer.parseInt(dataArray[1]) - 1, Integer.parseInt(dataArray[2]), Integer.parseInt(dataArray[3]), 0, 0);
                        PointD aPoint = new PointD();
                        aPoint.X = Double.parseDouble(dataArray[5]);
                        aPoint.Y = Double.parseDouble(dataArray[6]);
                        dList.add(aPoint);
                        dList.add(cal.getTime());
                        dList.add(Integer.parseInt(dataArray[4]));
                        for (int d = 0; d < 5; ++d) {
                            dList.add(Double.parseDouble(dataArray[d + 7]));
                        }
                        ((List)PointList.get(TrajIdx)).add(dList);
                    }
                    aLine = sr.readLine();
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHH");
                for (i = 0; i < this.TrajeoryNums.get(t); ++i) {
                    ++TrajNum;
                    for (int j = 0; j < ((List)PointList.get(i)).size(); ++j) {
                        PointShape aPS = new PointShape();
                        aPS.setValue(TrajNum);
                        aPS.setPoint((PointD)((List)((List)PointList.get(i)).get(j)).get(0));
                        int shapeNum = aLayer.getShapeNum();
                        if (!aLayer.editInsertShape(aPS, shapeNum)) continue;
                        aLayer.editCellValue("TrajID", shapeNum, (Object)TrajNum);
                        aLayer.editCellValue("Date", shapeNum, (Object)format.format(((List)((List)PointList.get(i)).get(j)).get(1)));
                        aLayer.editCellValue("PreHour", shapeNum, (Object)Integer.parseInt(((List)((List)PointList.get(i)).get(j)).get(2).toString()));
                        aLayer.editCellValue("Lat", shapeNum, (Object)aPS.getPoint().Y);
                        aLayer.editCellValue("Lon", shapeNum, (Object)aPS.getPoint().X);
                        aLayer.editCellValue("WindSpeed", shapeNum, (Object)Double.parseDouble(((List)((List)PointList.get(i)).get(j)).get(3).toString()));
                        aLayer.editCellValue("Radius_W7", shapeNum, (Object)Double.parseDouble(((List)((List)PointList.get(i)).get(j)).get(4).toString()));
                        aLayer.editCellValue("Radius_W10", shapeNum, (Object)Double.parseDouble(((List)((List)PointList.get(i)).get(j)).get(5).toString()));
                        aLayer.editCellValue("MoveDir", shapeNum, (Object)Double.parseDouble(((List)((List)PointList.get(i)).get(j)).get(6).toString()));
                        aLayer.editCellValue("MoveSpeed", shapeNum, (Object)Double.parseDouble(((List)((List)PointList.get(i)).get(j)).get(7).toString()));
                    }
                }
                sr.close();
                continue;
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            finally {
                try {
                    sr.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        aLayer.setLayerName("Typhoon_Points");
        aLayer.setLayerDrawType(LayerDrawType.TrajPoint);
        aLayer.setVisible(true);
        LegendScheme aLS = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Point, Color.red, 5.0f);
        aLS.setFieldName("TrajID");
        aLayer.setLegendScheme(aLS);
        return aLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VectorLayer createTrajStartPointLayer() {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Point);
        aLayer.editAddField(new Field("TrajID", DataTypes.Integer));
        aLayer.editAddField(new Field("StartDate", DataTypes.String));
        aLayer.editAddField(new Field("StartLon", DataTypes.Double));
        aLayer.editAddField(new Field("StartLat", DataTypes.Double));
        aLayer.editAddField(new Field("StartHeight", DataTypes.Double));
        int TrajNum = 0;
        for (int t = 0; t < this.FileNames.size(); ++t) {
            BufferedReader sr = null;
            try {
                int i;
                String aFile = this.FileNames.get(t);
                sr = new BufferedReader(new FileReader(new File(aFile)));
                int TrajIdx = -1;
                ArrayList<PointD> PointList = new ArrayList<PointD>();
                for (i = 0; i < this.TrajeoryNums.get(t); ++i) {
                    PointList.add(new PointD());
                }
                sr.readLine();
                String aLine = sr.readLine();
                boolean IsFirstTraj = false;
                while (aLine != null) {
                    if (aLine.trim().isEmpty()) {
                        aLine = sr.readLine();
                        continue;
                    }
                    String[] dataArray = aLine.split("\\s+");
                    if (dataArray.length == 4) {
                        ++TrajIdx;
                        IsFirstTraj = true;
                    } else if (dataArray.length == 13 && IsFirstTraj) {
                        PointD aPoint = new PointD();
                        aPoint.X = Double.parseDouble(dataArray[5]);
                        aPoint.Y = Double.parseDouble(dataArray[6]);
                        PointList.set(TrajIdx, aPoint);
                        IsFirstTraj = false;
                    }
                    aLine = sr.readLine();
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHH");
                for (i = 0; i < this.TrajeoryNums.get(t); ++i) {
                    PointShape aPS = new PointShape();
                    aPS.setValue(++TrajNum);
                    aPS.setPoint((PointD)PointList.get(i));
                    int shapeNum = aLayer.getShapeNum();
                    if (!aLayer.editInsertShape(aPS, shapeNum)) continue;
                    aLayer.editCellValue("TrajID", shapeNum, (Object)TrajNum);
                    aLayer.editCellValue("StartDate", shapeNum, (Object)format.format(this.TrajInfos.get((int)t).get((int)i).startTime));
                    aLayer.editCellValue("StartLat", shapeNum, (Object)Float.valueOf(this.TrajInfos.get((int)t).get((int)i).startLat));
                    aLayer.editCellValue("StartLon", shapeNum, (Object)Float.valueOf(this.TrajInfos.get((int)t).get((int)i).startLon));
                    aLayer.editCellValue("StartHeight", shapeNum, (Object)Float.valueOf(this.TrajInfos.get((int)t).get((int)i).startHeight));
                }
                sr.close();
                continue;
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            finally {
                try {
                    sr.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        aLayer.setLayerName("Typhoon_Start_Points");
        aLayer.setLayerDrawType(LayerDrawType.TrajPoint);
        aLayer.setVisible(true);
        LegendScheme aLS = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Point, Color.black, 8.0f);
        aLS.setFieldName("TrajID");
        aLayer.setLegendScheme(aLS);
        return aLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<Object>> getATrajData(int aTrajIdx) {
        ArrayList<List<Object>> trajPointsData = new ArrayList<List<Object>>();
        boolean ifExit = false;
        for (int t = 0; t < this.FileNames.size(); ++t) {
            BufferedReader sr = null;
            try {
                String aFile = this.FileNames.get(t);
                sr = new BufferedReader(new FileReader(new File(aFile)));
                int TrajIdx = -1;
                sr.readLine();
                String aLine = sr.readLine();
                while (aLine != null) {
                    if (aLine.trim().isEmpty()) {
                        aLine = sr.readLine();
                        continue;
                    }
                    String[] dataArray = aLine.split("\\s+");
                    switch (dataArray.length) {
                        case 4: {
                            if (++TrajIdx <= aTrajIdx) break;
                            ifExit = true;
                            break;
                        }
                        case 13: {
                            if (TrajIdx != aTrajIdx) break;
                            ArrayList<Object> dList = new ArrayList<Object>();
                            GregorianCalendar cal = new GregorianCalendar(Integer.parseInt(dataArray[0]), Integer.parseInt(dataArray[1]) - 1, Integer.parseInt(dataArray[2]), Integer.parseInt(dataArray[3]), 0, 0);
                            PointD aPoint = new PointD();
                            aPoint.X = Double.parseDouble(dataArray[5]);
                            aPoint.Y = Double.parseDouble(dataArray[6]);
                            dList.add(aPoint);
                            dList.add(cal.getTime());
                            dList.add(Double.parseDouble(dataArray[7]));
                            trajPointsData.add(dList);
                        }
                    }
                    if (ifExit) break;
                    aLine = sr.readLine();
                }
                sr.close();
                if (!ifExit) continue;
                break;
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            finally {
                try {
                    sr.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return trajPointsData;
    }
}

