/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.global.colors;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.colors.ColorMap;
import org.meteoinfo.global.colors.WebColor;
import org.meteoinfo.global.util.GlobalUtil;

public class ColorUtil {
    private static final Map colorNames = new HashMap();

    public static Color getCommonColor(int idx) {
        if (idx > 11) {
            idx %= 11;
        }
        switch (idx) {
            case 0: {
                return Color.red;
            }
            case 1: {
                return Color.blue;
            }
            case 2: {
                return Color.green;
            }
            case 3: {
                return Color.black;
            }
            case 4: {
                return Color.yellow;
            }
            case 5: {
                return Color.pink;
            }
            case 6: {
                return Color.gray;
            }
            case 7: {
                return Color.cyan;
            }
            case 8: {
                return Color.magenta;
            }
            case 9: {
                return Color.orange;
            }
            case 10: {
                return Color.darkGray;
            }
            case 11: {
                return Color.lightGray;
            }
        }
        return Color.red;
    }

    public static String toHexEncoding(Color color) {
        StringBuilder sb = new StringBuilder();
        String A = Integer.toHexString(color.getAlpha());
        String R = Integer.toHexString(color.getRed());
        String G = Integer.toHexString(color.getGreen());
        String B = Integer.toHexString(color.getBlue());
        A = A.length() == 1 ? "0" + A : A;
        R = R.length() == 1 ? "0" + R : R;
        G = G.length() == 1 ? "0" + G : G;
        B = B.length() == 1 ? "0" + B : B;
        sb.append("0x");
        sb.append(A);
        sb.append(R);
        sb.append(G);
        sb.append(B);
        return sb.toString();
    }

    public static Color parseToColor(String c) {
        Color convertedColor = Color.white;
        try {
            WebColor webColor = WebColor.valueOf(c.trim());
            convertedColor = WebColor.valueOf(c.trim()).getColor();
        }
        catch (IllegalArgumentException e) {
            try {
                if (c.length() == 10) {
                    String aStr = c.substring(2, 4);
                    String cStr = c.substring(0, 2) + c.substring(4);
                    int alpha = Integer.parseInt(aStr, 16);
                    convertedColor = Color.decode(cStr);
                    convertedColor = new Color(convertedColor.getRed(), convertedColor.getGreen(), convertedColor.getBlue(), alpha);
                } else {
                    convertedColor = Color.decode(c);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return convertedColor;
    }

    public static Color modifyBrightness(Color c, float brightness) {
        float[] hsbVals = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        return Color.getHSBColor(hsbVals[0], hsbVals[1], brightness * hsbVals[2]);
    }

    public static String toKMLColor(Color color) {
        StringBuilder sb = new StringBuilder();
        String A = Integer.toHexString(color.getAlpha()).toUpperCase();
        String R = Integer.toHexString(color.getRed()).toUpperCase();
        String G = Integer.toHexString(color.getGreen()).toUpperCase();
        String B = Integer.toHexString(color.getBlue()).toUpperCase();
        A = A.length() == 1 ? "0" + A : A;
        R = R.length() == 1 ? "0" + R : R;
        G = G.length() == 1 ? "0" + G : G;
        B = B.length() == 1 ? "0" + B : B;
        sb.append(A);
        sb.append(B);
        sb.append(G);
        sb.append(R);
        return sb.toString();
    }

    public static ColorMap[] getColorTables() throws IOException {
        String path;
        File pathDir;
        String fn = GlobalUtil.getAppPath(ColorUtil.class);
        boolean isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
        if (isDebug) {
            fn = "D:/MyProgram/java/MeteoInfoDev/MeteoInfoMap/";
        }
        if (!(pathDir = new File(path = (fn = fn.substring(0, fn.lastIndexOf("/"))) + File.separator + "colormaps")).isDirectory()) {
            return null;
        }
        File[] files = pathDir.listFiles();
        ArrayList<ColorMap> cts = new ArrayList<ColorMap>();
        for (File file : files) {
            ColorMap ct = new ColorMap();
            ct.readFromFile(file);
            if (ct.getColorCount() <= 0) continue;
            String name = file.getName();
            name = name.substring(0, name.lastIndexOf("."));
            ct.setName(name);
            cts.add(ct);
        }
        ColorMap[] ncts = new ColorMap[cts.size()];
        for (int i = 0; i < cts.size(); ++i) {
            ncts[i] = (ColorMap)cts.get(i);
        }
        return ncts;
    }

    public static ColorMap loadColorMap(String fn) throws IOException {
        File ctFile = new File(fn);
        if (!ctFile.isFile()) {
            return null;
        }
        ColorMap ct = new ColorMap();
        ct.readFromFile(fn);
        return ct;
    }

    public static ColorMap loadColorMap(String fn, int alpha) throws IOException {
        File ctFile = new File(fn);
        if (!ctFile.isFile()) {
            return null;
        }
        ColorMap ct = new ColorMap();
        ct.readFromFile(fn, alpha);
        return ct;
    }

    public static ColorMap findColorTable(ColorMap[] cts, String name) {
        for (ColorMap ct : cts) {
            if (!ct.getName().equalsIgnoreCase(name)) continue;
            return ct;
        }
        return null;
    }

    public static ColorMap[] getColorTables_old() throws IOException {
        String pdir = "/images/colortables";
        ArrayList<String> fns = new ArrayList<String>();
        fns.add("grads_rainbow.rgb");
        fns.add("GHRSST_anomaly.rgb");
        fns.add("amwg256.rgb");
        fns.add("cmp_b2r.rgb");
        fns.add("cmp_flux.rgb");
        fns.add("cmp_haxby.rgb");
        fns.add("matlab_hot.rgb");
        fns.add("matlab_hsv.rgb");
        fns.add("matlab_jet.rgb");
        fns.add("matlab_lines.rgb");
        fns.add("ncl_default.rgb");
        fns.add("ncview_default.ncmap");
        fns.add("rainbow+white+gray.gp");
        fns.add("rainbow.gp");
        fns.add("seaice_1.rgb");
        fns.add("seaice_2.rgb");
        ArrayList<ColorMap> cts = new ArrayList<ColorMap>();
        for (String fileName : fns) {
            InputStream is = ColorUtil.class.getResourceAsStream(pdir + "/" + fileName);
            ColorMap ct = new ColorMap();
            ct.readFromFile(is);
            cts.add(ct);
        }
        ColorMap[] ncts = new ColorMap[cts.size()];
        for (int i = 0; i < cts.size(); ++i) {
            ncts[i] = (ColorMap)cts.get(i);
        }
        return ncts;
    }

    public static Color[] createColors(Color sColor, Color eColor, int cNum) {
        Color[] colors = new Color[cNum];
        int sR = sColor.getRed();
        int sG = sColor.getGreen();
        int sB = sColor.getBlue();
        int eR = eColor.getRed();
        int eG = eColor.getGreen();
        int eB = eColor.getBlue();
        int rStep = (eR - sR) / cNum;
        int gStep = (eG - sG) / cNum;
        int bStep = (eB - sB) / cNum;
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = new Color(sR + i * rStep, sG + i * gStep, sB + i * bStep);
        }
        return colors;
    }

    public static Color[] createColors(ColorMap cm, double min, double max) {
        double[] values = MIMath.getIntervalValues(min, max);
        return cm.getColors(values.length + 1);
    }

    public static Color[] createColors(ColorMap cm, double min, double max, int n) {
        double[] values = MIMath.getIntervalValues(min, max, n);
        return cm.getColors(values.length + 1);
    }

    public static Color createColor(Color sColor, Color eColor, float p) {
        int sR = sColor.getRed();
        int sG = sColor.getGreen();
        int sB = sColor.getBlue();
        int eR = eColor.getRed();
        int eG = eColor.getGreen();
        int eB = eColor.getBlue();
        int r = (int)((float)sR + (float)(eR - sR) * p);
        int g = (int)((float)sG + (float)(eG - sG) * p);
        int b = (int)((float)sB + (float)(eB - sB) * p);
        return new Color(r, g, b);
    }

    public static Color[] createRainBowColors(int cNum) {
        if (cNum > 13) {
            return ColorUtil.getRainBowColors_HSV(cNum);
        }
        ArrayList<Color> colorList = new ArrayList<Color>();
        colorList.add(new Color(160, 0, 200));
        colorList.add(new Color(110, 0, 220));
        colorList.add(new Color(30, 60, 255));
        colorList.add(new Color(0, 160, 255));
        colorList.add(new Color(0, 200, 200));
        colorList.add(new Color(0, 210, 140));
        colorList.add(new Color(0, 220, 0));
        colorList.add(new Color(160, 230, 50));
        colorList.add(new Color(230, 220, 50));
        colorList.add(new Color(230, 175, 45));
        colorList.add(new Color(240, 130, 40));
        colorList.add(new Color(250, 60, 60));
        colorList.add(new Color(240, 0, 130));
        switch (cNum) {
            case 12: {
                colorList.remove(new Color(0, 210, 140));
                break;
            }
            case 11: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                break;
            }
            case 10: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                break;
            }
            case 9: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                break;
            }
            case 8: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                colorList.remove(new Color(110, 0, 220));
                break;
            }
            case 7: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                colorList.remove(new Color(110, 0, 220));
                colorList.remove(new Color(0, 200, 200));
                break;
            }
            case 6: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                colorList.remove(new Color(110, 0, 220));
                colorList.remove(new Color(0, 200, 200));
                colorList.remove(new Color(240, 130, 40));
                break;
            }
            case 5: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                colorList.remove(new Color(110, 0, 220));
                colorList.remove(new Color(0, 200, 200));
                colorList.remove(new Color(240, 130, 40));
                colorList.remove(new Color(160, 0, 200));
            }
        }
        Color[] colors = new Color[cNum];
        for (int i = 0; i < cNum; ++i) {
            colors[i] = (Color)colorList.get(i);
        }
        return colors;
    }

    public static Color[] getRainBowColors_HSV(int cNum) {
        double p = 360.0 / (double)cNum;
        Color[] colors = new Color[cNum];
        for (int i = 0; i < cNum; ++i) {
            colors[cNum - i - 1] = Color.getHSBColor((float)((double)i * p), 1.0f, 1.0f);
        }
        return colors;
    }

    public static Color createRandomColor() {
        Random randomColor = new Random();
        return new Color(randomColor.nextInt(256), randomColor.nextInt(256), randomColor.nextInt(256));
    }

    public static Color[] createRandomColors(int cNum) {
        Color[] colors = new Color[cNum];
        Random randomColor = new Random();
        for (int i = 0; i < cNum; ++i) {
            colors[i] = new Color(randomColor.nextInt(256), randomColor.nextInt(256), randomColor.nextInt(256));
        }
        return colors;
    }

    static {
        colorNames.put("aliceblue", new Color(0xF0F8FF));
        colorNames.put("antiquewhite", new Color(16444375));
        colorNames.put("black", new Color(0));
        colorNames.put("green", new Color(32768));
        colorNames.put("silver", new Color(0xC0C0C0));
        colorNames.put("lime", new Color(65280));
        colorNames.put("gray", new Color(0x808080));
        colorNames.put("darkgray", new Color(0xA9A9A9));
        colorNames.put("olive", new Color(0x808000));
        colorNames.put("white", new Color(0xFFFFFF));
        colorNames.put("yellow", new Color(0xFFFF00));
        colorNames.put("maroon", new Color(0x800000));
        colorNames.put("navy", new Color(128));
        colorNames.put("red", new Color(0xFF0000));
        colorNames.put("blue", new Color(255));
        colorNames.put("purple", new Color(0x800080));
        colorNames.put("teal", new Color(32896));
        colorNames.put("fuchsia", new Color(0xFF00FF));
        colorNames.put("aqua", new Color(65535));
        colorNames.put("transparent", new Color(0, 0, 0, 0));
    }
}

